/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.alarm.SMAlarmObjectData;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.utility.UcListUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.ImageIcon;

class AlarmData {
    static final int NO_ACTION = 0;
    static final int PENDING = 1;
    static final int EXECUTED = 2;
    final String[] actionStatus = new String[]{"no action", "pending", "executed"};
    Object alarmId;
    Object start;
    Object action;
    Object host;
    Object message;
    Object[] cell;
    private int sevIndex;
    int stateIndex;
    int actionStatusIndex = 0;
    String ruleId;
    String fixUser;
    String longMessage;
    private String Url;
    private String ackUser;
    long startTime;
    long endTime;
    long fixTime;
    private long ackTime;

    public AlarmData() {
        this.alarmId = "";
        this.start = "";
        this.action = "";
        this.host = "";
        this.message = "";
        this.ruleId = "";
        this.stateIndex = -1;
        this.sevIndex = -1;
        this.fixTime = 0L;
        this.ackTime = 0L;
        this.endTime = 0L;
        this.startTime = 0L;
    }

    public AlarmData(SMAlarmObjectData sMAlarmObjectData) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd  HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        this.start = simpleDateFormat.format(new Date(sMAlarmObjectData.getOpenTimestamp() * 1000L));
        this.alarmId = sMAlarmObjectData.getAlarmId();
        this.Url = sMAlarmObjectData.getMoURL();
        this.host = sMAlarmObjectData.getHost();
        this.action = sMAlarmObjectData.getActionName();
        this.actionStatusIndex = sMAlarmObjectData.getActionStatus();
        String string = sMAlarmObjectData.getAlarmShortText();
        this.message = UcListUtil.AsciiToUnicode((String)string);
        String string2 = sMAlarmObjectData.getSeverity();
        this.sevIndex = string2.compareTo("DWN") == 0 ? (sMAlarmObjectData.isAcked() ? 1 : 0) : (string2.compareTo("ERR") == 0 ? (sMAlarmObjectData.isAcked() ? 3 : 2) : (string2.compareTo("WRN") == 0 ? (sMAlarmObjectData.isAcked() ? 5 : 4) : (string2.compareTo("INF") == 0 ? (sMAlarmObjectData.isAcked() ? 7 : 6) : (sMAlarmObjectData.isAcked() ? 9 : 8))));
        this.stateIndex = sMAlarmObjectData.isClosed() ? 1 : 0;
        this.ruleId = sMAlarmObjectData.getAlarmRuleId();
        this.startTime = sMAlarmObjectData.getOpenTimestamp() * 1000L;
        this.endTime = sMAlarmObjectData.getCloseTimestamp() * 1000L;
        this.fixTime = sMAlarmObjectData.getFixTimestamp() * 1000L;
        this.fixUser = sMAlarmObjectData.getFixOperator();
        this.ackTime = sMAlarmObjectData.getAckTimestamp() * 1000L;
        this.ackUser = sMAlarmObjectData.getAckOperator();
    }

    public AlarmData(AlarmPanel alarmPanel, int n) {
        SMResourceAccess sMResourceAccess = new SMResourceAccess(alarmPanel.getRawRequestHandle());
        this.cell = new Object[n];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd  HH:mm:ss");
        this.cell[0] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev1Ack.gif"));
        this.cell[1] = simpleDateFormat.format(new Date());
        this.cell[2] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmOpen.gif"));
        this.cell[3] = " ";
        this.cell[4] = new String(new char[100]);
    }

    long getAckTime() {
        return this.ackTime;
    }

    String getAckUser() {
        return this.ackUser;
    }

    String getAction() {
        return (String)this.action;
    }

    String getActionStatus() {
        return this.actionStatus[this.actionStatusIndex];
    }

    int getActionStatusIndex() {
        return this.actionStatusIndex;
    }

    String getId() {
        return (String)this.alarmId;
    }

    String getMessage() {
        return (String)this.message;
    }

    int getSevIndex() {
        return this.sevIndex;
    }

    String getUrl() {
        return this.Url;
    }

    void setAckTime(long l) {
        this.ackTime = l;
    }

    void setAckUser(String string) {
        this.ackUser = string;
    }

    void setAction(String string) {
        this.action = string;
    }

    void setSevIndex(int n) {
        this.sevIndex = n;
    }
}

