/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.server.events.SvRequestListener;
import com.sun.symon.base.server.lookup.SlRMIRegistry;
import com.sun.symon.base.server.receptors.SrBaseReceptor;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMIServer;
import com.sun.symon.base.server.receptors.rmi.RMIServerException;
import com.sun.symon.base.server.receptors.rmi.RMIServerSession;
import com.sun.symon.base.server.receptors.rmi.SrRMIHttpReceptor;
import com.sun.symon.base.server.receptors.rmi.SrRMISecurity;
import com.sun.symon.base.server.receptors.rmi.SrRMISession;
import com.sun.symon.base.server.receptors.rmi.SrRMISessionService;
import com.sun.symon.base.utility.UcDDL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SrRMIReceptor
extends SrBaseReceptor {
    private String RmiHost = null;
    private int RmiPort = -1;
    private Vector alternateRmiHosts = new Vector();
    private SlRMIRegistry rmiRegistry;
    private Vector alternateRmiRegistries = new Vector();
    private SrRMIHttpReceptor ClassHandler = new SrRMIHttpReceptor();
    private SrRMISecurity rmiSecurity = null;
    public static SrRMIReceptor theReceptor;

    public SrRMIReceptor() throws RMIServerException {
        String string = this.ClassHandler.getCodeBase();
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("java.rmi.server.codebase", string);
        System.setProperties(properties);
        UcDDL.logInfoMessage((String)("RMI HTTP server listening at codebase " + string));
        theReceptor = this;
    }

    public void addSvRequestListener(SvRequestListener svRequestListener) {
        super.addSvRequestListener(svRequestListener);
        this.ClassHandler.addSvRequestListener(svRequestListener);
    }

    public RMIServerSession createSession(RMIResponseInterface rMIResponseInterface, String string) throws RemoteException {
        if (string != null) {
            return new SrRMISession(this.sySecurity, this, rMIResponseInterface, this.rmiSecurity, this.privateKey, string);
        }
        return new SrRMISession(this.sySecurity, this, rMIResponseInterface, this.rmiSecurity, this.privateKey);
    }

    public SrRMISessionService createSessionV3(RMIResponseInterface rMIResponseInterface, String string) throws RemoteException {
        if (string != null) {
            return new SrRMISessionService(this.sySecurity, this, rMIResponseInterface, this.rmiSecurity, this.privateKey, string);
        }
        return new SrRMISessionService(this.sySecurity, this, rMIResponseInterface, this.rmiSecurity, this.privateKey);
    }

    public Vector getAlternateRegistries() {
        return this.alternateRmiRegistries;
    }

    public Vector getAlternateRmiHosts() {
        return this.alternateRmiHosts;
    }

    public SlRMIRegistry getRegistry() {
        return this.rmiRegistry;
    }

    public static void init() throws Exception {
        new SrRMIReceptor().initialize();
    }

    public boolean isAlternateHostAvailable() {
        return this.alternateRmiHosts.size() > 0;
    }

    public void removeSvRequestListener(SvRequestListener svRequestListener) {
        super.removeSvRequestListener(svRequestListener);
        this.ClassHandler.removeSvRequestListener(svRequestListener);
    }

    protected void restart() {
        if (this.RmiHost != null && this.RmiPort != -1 && this.securityURL != null && this.securityFlag != -1 && this.privateKey != null && this.privatePassword != null) {
            this.startServer();
        }
    }

    public void setAlternateRmiHosts(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            if (stringTokenizer2.countTokens() != 2) {
                UcDDL.logErrorMessage((String)"SrRMIReceptor : Missing parameter in javaserver.properties.");
                continue;
            }
            this.alternateRmiHosts.addElement(stringTokenizer2.nextToken());
            try {
                int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                this.alternateRmiRegistries.addElement(new SlRMIRegistry((String)this.alternateRmiHosts.lastElement(), n2));
                UcDDL.logInfoMessage((String)("SrRMIReceptor: Created alternate RMIRegistry at host = " + this.alternateRmiHosts.lastElement() + "at port = " + n2));
            }
            catch (NumberFormatException numberFormatException) {
                UcDDL.logErrorMessage((String)"SrRMIReceptor : Incorrect port number specified");
                this.alternateRmiHosts.removeElementAt(this.alternateRmiHosts.size() - 1);
            }
        }
        this.restart();
    }

    public void setRmiHost(String string) {
        this.RmiHost = string;
        if (this.RmiHost != null && this.RmiPort != -1) {
            this.rmiRegistry = new SlRMIRegistry(this.RmiPort);
            UcDDL.logInfoMessage((String)"SrRMIReceptor: Created RMIRegistry");
        }
        this.restart();
    }

    public void setRmiPort(int n) {
        this.RmiPort = n;
        if (this.RmiHost != null && this.RmiPort != -1) {
            this.rmiRegistry = new SlRMIRegistry(this.RmiPort);
            UcDDL.logInfoMessage((String)("SrRMIReceptor: Created RMIRegistry at host " + this.RmiHost + " and at port = " + this.RmiPort));
        }
        this.restart();
    }

    protected void startServer() {
        try {
            new Server(this.RmiHost, this.RmiPort, this);
        }
        catch (RMIServerException rMIServerException) {
            UcDDL.logErrorMessage((String)("RMI host = " + this.RmiHost));
            UcDDL.logErrorMessage((String)("RMI port = " + this.RmiPort));
            UcDDL.logErrorMessage((String)"RMI init", (Throwable)rMIServerException);
        }
        if (this.securityURL.compareTo("") == 0) {
            this.securityURL = String.valueOf(this.getConfigurationBaseURL()) + "oid/1.3.6.1.4.1.42.2.12.2.2.34.1.0";
        }
        this.rmiSecurity = this.securityFlag == 0 ? new SrRMISecurity(this, "", this.privatePassword) : new SrRMISecurity(this, this.securityURL, this.privatePassword);
        if (this.sessionLimit == 0) {
            String string = null;
            try {
                string = System.getProperty("NUM_FDS");
                int n = Integer.parseInt(string);
                this.sessionLimit = (n - 30) / 4;
                if (this.sessionLimit < 1) {
                    this.sessionLimit = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                UcDDL.logErrorMessage((String)("can't parse NUM_FDS: '" + string + "'"), (Throwable)numberFormatException);
                this.sessionLimit = -1;
            }
        }
        UcDDL.logInfoMessage((String)("Number of client sessions that will be allowed to connect: " + (this.sessionLimit == -1 ? "unlimited" : String.valueOf(this.sessionLimit))));
    }

    private class Server
    extends RMIServer {
        Server(String string, int n, SrRMIReceptor srRMIReceptor2) throws RMIServerException {
            super(string, n, srRMIReceptor2);
        }

        protected RMIServerSession newSessionInterface(RMIResponseInterface rMIResponseInterface, String string) throws RemoteException {
            RMIServerSession rMIServerSession = SrRMIReceptor.this.addNewSession() ? SrRMIReceptor.this.createSession(rMIResponseInterface, string) : null;
            return rMIServerSession;
        }

        protected SrRMISessionService newSessionServiceInterface(RMIResponseInterface rMIResponseInterface, String string) throws RemoteException {
            SrRMISessionService srRMISessionService = SrRMIReceptor.this.addNewSession() ? SrRMIReceptor.this.createSessionV3(rMIResponseInterface, string) : null;
            return srRMISessionService;
        }
    }
}

