/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.local;

import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.receptors.SrReceptor;
import com.sun.symon.base.server.receptors.SrSessionByHandle;
import com.sun.symon.base.server.receptors.local.LocalClientLevel1;
import com.sun.symon.base.server.receptors.local.LocalReceptor;
import com.sun.symon.base.server.receptors.rmi.RMILoginException;
import com.sun.symon.base.server.receptors.rmi.RMISecurityException;
import com.sun.symon.base.server.receptors.rmi.SrRMISecurity;
import com.sun.symon.base.server.snmp.jni.SsPacket;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;

public class LocalSession {
    private LocalClientLevel1 originator;
    private SrRMISecurity security;
    private LocalReceptor receptor;
    private ScSecurityCredential userTicket;
    private String userId;
    private SessionHandle session;

    public LocalSession(ScSecurityCredential scSecurityCredential, LocalReceptor localReceptor) {
        this.userTicket = scSecurityCredential;
        this.receptor = localReceptor;
        this.session = new SessionHandle(localReceptor);
        String string = localReceptor.getPublicId();
        String string2 = localReceptor.getPrivateId();
        String string3 = scSecurityCredential.getGlobalKey();
        SsPacket.add(scSecurityCredential.getUser(), string3, scSecurityCredential.getAuthenticationProtocol(), scSecurityCredential.getPrivacyProtocol());
    }

    public LocalSession(SrRMISecurity srRMISecurity, LocalReceptor localReceptor) {
        this.security = srRMISecurity;
        this.receptor = localReceptor;
    }

    public synchronized void authenticate(String string, String string2) throws RMILoginException {
        this.userTicket = this.security.getCredentials(string, string2);
        this.security = null;
        this.userId = string;
        this.session = new SessionHandle(this.receptor);
    }

    public void clientDied() {
        this.session.died(new Exception("Client is disconnecting"));
    }

    protected void newRequest(int n, String[] stringArray, StObject[][] stObjectArray, String string, String string2) throws RMISecurityException {
        if (stringArray != null && stringArray.length == 1 && stringArray[0] != null && stringArray[0].equals("exit://clientIsExiting/") && stObjectArray != null && stObjectArray.length == 1 && stObjectArray[0].length == 1 && stObjectArray[0][0] != null && stObjectArray[0][0].toString().equals("goodbye")) {
            UcDDL.logInfoMessage((String)"Received disconnect signal from a client");
            this.session.died(new Exception("Client is disconnecting"));
        } else {
            this.session.requestCreateByHandle(string2, n, stringArray, stObjectArray, string).emit();
        }
    }

    public void requestDeleteByHandle(String string) {
        this.session.requestDeleteByHandle(string);
    }

    public void setOriginator(LocalClientLevel1 localClientLevel1) {
        this.originator = localClientLevel1;
    }

    private class SessionHandle
    extends SrSessionByHandle {
        private int retries = 0;
        private int MAX_RETRIES = 5;

        SessionHandle(SrReceptor srReceptor) {
            super(srReceptor);
        }

        public boolean died(Exception exception) {
            boolean bl = super.died(exception);
            if (bl) {
                LocalSession.this.clientDied();
            }
            return bl;
        }

        protected ScSecurityCredential getUserTicket() {
            return LocalSession.this.userTicket;
        }

        protected void requestResponse(String string, String string2, Exception exception) {
            if (LocalSession.this.originator != null) {
                LocalSession.this.originator.receiveException(string, string2, exception);
            }
        }

        protected void requestResponse(String string, StObject[][] stObjectArray) {
            if (LocalSession.this.originator != null) {
                LocalSession.this.originator.receiveDataResult(string, stObjectArray);
            }
        }
    }
}

