/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.framework;

import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseFactory;
import com.sun.symon.base.mgmtservice.framework.MSBaseServiceInterface;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.lookup.SlRMIClientSocket;
import com.sun.symon.base.server.lookup.SlRMIServerSocket;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Locale;

public class MSBaseService
extends UnicastRemoteObject
implements MSBaseServiceInterface {
    private String serviceName;
    private Locale locale = null;
    private String userSession = null;
    private ScSecurityCredential securityCredential = null;
    private static MSSecurity scService;
    private static MSLogPrintWriter errorWriter;

    static {
        errorWriter = MSLogPrintWriter.getErrorWriter();
        try {
            scService = MSSecurity.getInstance();
        }
        catch (SMSecurityException sMSecurityException) {
            errorWriter.println("Security service is not available.\nExiting...");
            System.exit(1);
        }
    }

    public MSBaseService(String string, ScSecurityCredential scSecurityCredential) throws RemoteException {
        this.init(string, scSecurityCredential);
    }

    public MSBaseService(String string, ScSecurityCredential scSecurityCredential, String string2) throws RemoteException {
        super(0, new SlRMIClientSocket(string2), new SlRMIServerSocket(string2));
        this.init(string, scSecurityCredential);
    }

    protected void checkAccess(String string) throws SMSecurityException {
        this.checkAccess(string, null);
    }

    protected void checkAccess(String string, SMDBObjectID sMDBObjectID) throws SMSecurityException {
        try {
            if (sMDBObjectID == null) {
                scService.checkAccess(this.serviceName, string, this.securityCredential);
            } else {
                scService.checkAccess(this.serviceName, string, this.securityCredential, sMDBObjectID);
            }
        }
        catch (SMSecurityException sMSecurityException) {
            errorWriter.println("User " + this.securityCredential.getUser() + " does not have priviliges to execute " + string);
            throw sMSecurityException;
        }
    }

    public void cleanup() {
    }

    public void close() throws RemoteException {
        this.closeService();
    }

    public void closeService() {
        MSBaseFactory.removeService(this);
    }

    public Locale getLocale() throws RemoteException {
        return this.locale;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ScSecurityCredential getUserSecurityCredential() {
        return this.securityCredential;
    }

    public String getUserSession() {
        return this.userSession;
    }

    public void init(String string, ScSecurityCredential scSecurityCredential) {
        this.serviceName = string;
        this.userSession = null;
        this.securityCredential = scSecurityCredential;
    }

    public void setLocale(Locale locale) throws RemoteException {
        this.locale = locale;
    }

    public void setUserSecurityCredential(ScSecurityCredential scSecurityCredential) {
        this.securityCredential = scSecurityCredential;
    }

    public void setUserSession(String string) {
        this.userSession = string;
    }
}

