/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.framework;

import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.framework.MSBaseServiceInterface;
import com.sun.symon.base.mgmtservice.framework.MSRemoteServiceFactory;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.lookup.SlServiceRegistry;
import com.sun.symon.base.utility.UcBeanIntrospector;
import com.sun.symon.base.utility.UcDDL;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class MSBaseFactory {
    private static int DEFREGISTRYPORT = 5600;
    private static int TRYINTERVAL = 5000;
    private static int TRYTIMES = 3600;
    private SlServiceRegistry lookupRegistry;
    private MSRemoteServiceFactory factoryStub;
    private HashSet serviceTable;
    private String registryHost = null;
    private int registryPort = 0;
    private RemoteFactory factoryHandle;
    private Hashtable serviceHostTable = new Hashtable();
    private static Hashtable sessionTable = new Hashtable();
    private static MSLogPrintWriter logError = MSLogPrintWriter.getErrorWriter();
    private static MSLogPrintWriter logInfo = MSLogPrintWriter.getInfoWriter();

    public MSBaseFactory() throws RemoteException {
        this.serviceTable = new HashSet();
        try {
            UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
            ucBeanIntrospector.readProperties("javaservice.properties");
            ucBeanIntrospector.apply((Object)this);
            MSProperties mSProperties = new MSProperties();
            mSProperties.load("com.sun.symon.base.mgmtservice.alternativeservice");
            String string = mSProperties.getProperty("AlternateServiceHost");
            if (string != null) {
                this.setAlternateServiceHost(string);
            }
        }
        catch (Exception exception) {
            logError.println("Factory init: " + exception.getMessage());
        }
        if (this.registryHost == null || this.registryHost == "") {
            try {
                this.registryHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                logError.println("Fail in gettting registryHost: " + exception.getMessage());
                System.exit(1);
            }
        }
        if (this.registryPort == 0) {
            this.registryPort = DEFREGISTRYPORT;
        }
        if (!this.init(this.registryHost, this.registryPort)) {
            logError.println("Factory: initiation fails");
            System.exit(1);
        }
    }

    synchronized void addSession(String string, MSBaseServiceInterface mSBaseServiceInterface) {
        Vector<MSBaseServiceInterface> vector = (Vector<MSBaseServiceInterface>)sessionTable.get(string);
        if (vector != null) {
            vector.add(mSBaseServiceInterface);
        } else {
            vector = new Vector<MSBaseServiceInterface>();
            vector.add(mSBaseServiceInterface);
            sessionTable.put(string, vector);
        }
    }

    private void doregister(String[] stringArray, int n) {
        if (n == 0) {
            return;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        while (true) {
            try {
                this.lookupRegistry.register(stringArray2, (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle));
                int n3 = 0;
                while (n3 < n) {
                    this.serviceTable.add(stringArray2[n3]);
                    ++n3;
                }
                return;
            }
            catch (Exception exception) {
                logError.println("service registry fails: try ..." + exception.getMessage());
                try {
                    Thread.sleep(TRYINTERVAL);
                    continue;
                }
                catch (Exception exception2) {
                    continue;
                }
            }
            break;
        }
    }

    public String getAlternateServiceHost(String string) {
        return (String)this.serviceHostTable.get(string);
    }

    protected abstract MSBaseServiceInterface getService(String var1, ScSecurityCredential var2, String var3) throws SMNoSuchObjectException;

    private boolean init(String string, int n) {
        Object object;
        Object object2 = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            block8: {
                Object object3;
                try {
                    object3 = new Socket(string, n);
                    object = ((Socket)object3).getInputStream();
                    ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                    object2 = objectInputStream.readObject();
                    if (object2 instanceof SlServiceRegistry) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    if (++n2 != 12) break block8;
                    object3 = "Fail in getting registry in " + ++n3 + " minutes!";
                    logError.println((String)object3);
                }
            }
            try {
                Thread.sleep(TRYINTERVAL);
            }
            catch (Exception exception) {}
        }
        this.lookupRegistry = (SlServiceRegistry)object2;
        try {
            this.factoryHandle = new RemoteFactory(this);
            this.factoryStub = (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle);
            return true;
        }
        catch (Exception exception) {
            object = "Fail in geneating remote factory stub: " + exception.getMessage();
            logError.println((String)object);
            return false;
        }
    }

    boolean isAvailable(String string) {
        return this.serviceTable.contains(string);
    }

    protected void register(String string) {
        if (this.serviceTable.contains(string)) {
            logError.println("register: service name is already bound");
            return;
        }
        while (true) {
            try {
                this.lookupRegistry.register(string, (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle));
                this.serviceTable.add(string);
                return;
            }
            catch (Exception exception) {
                logError.println("service registry fails: " + exception.getMessage());
                try {
                    Thread.sleep(TRYINTERVAL);
                    continue;
                }
                catch (Exception exception2) {
                    continue;
                }
            }
            break;
        }
    }

    protected void register(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length];
        String string = "";
        int n = 0;
        int n2 = 0;
        n2 = 0;
        n = 0;
        while (n2 < stringArray.length) {
            if (this.serviceTable.contains(stringArray[n2])) {
                string = String.valueOf(string) + stringArray[n2] + ", ";
            } else {
                stringArray2[n++] = stringArray[n2];
            }
            ++n2;
        }
        if (n != 0) {
            this.doregister(stringArray2, n);
        }
        if (!string.equals("")) {
            logError.println("register: service (" + string + ") are already bound");
        }
    }

    public static synchronized void removeService(MSBaseService mSBaseService) {
        String string = mSBaseService.getUserSession();
        if (string == null) {
            return;
        }
        Vector vector = (Vector)sessionTable.get(string);
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            MSBaseService mSBaseService2 = (MSBaseService)vector.elementAt(n);
            if (mSBaseService2.equals(mSBaseService)) {
                vector.remove(n);
                if (vector.size() == 0) {
                    sessionTable.remove(string);
                }
                mSBaseService2.cleanup();
                mSBaseService2 = null;
                logInfo.println("Factory: remove service instance: " + mSBaseService.getServiceName());
                return;
            }
            ++n;
        }
    }

    synchronized void removeSession(String string) throws RemoteException {
        Vector vector = (Vector)sessionTable.get(string);
        if (vector == null) {
            return;
        }
        MSBaseService mSBaseService = null;
        int n = 0;
        while (n < vector.size()) {
            mSBaseService = (MSBaseService)vector.elementAt(n);
            mSBaseService.cleanup();
            if (mSBaseService != null) {
                mSBaseService = null;
            }
            ++n;
        }
        vector.removeAllElements();
        sessionTable.remove(string);
    }

    protected void reregister(String string) {
        if (this.serviceTable.contains(string)) {
            return;
        }
        while (true) {
            try {
                this.lookupRegistry.register(string, (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle));
                this.serviceTable.add(string);
                return;
            }
            catch (Exception exception) {
                logError.println("service registry fails: " + exception.getMessage());
                try {
                    Thread.sleep(TRYINTERVAL);
                    continue;
                }
                catch (Exception exception2) {
                    continue;
                }
            }
            break;
        }
    }

    protected void reregister(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        int n2 = 0;
        n2 = 0;
        n = 0;
        while (n2 < stringArray.length) {
            if (!this.serviceTable.contains(stringArray[n2])) {
                stringArray2[n++] = stringArray[n2];
            }
            ++n2;
        }
        if (n != 0) {
            this.doregister(stringArray2, n);
        }
    }

    public void setAlternateServiceHost(String string) {
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            if (stringTokenizer2.countTokens() != 2) {
                UcDDL.logErrorMessage((String)"MSBaseFactory : Missing parameter in alternativerserver.properties. Please verify that all alternate javaservers have corresponding servicehosts specified");
                continue;
            }
            string2 = stringTokenizer2.nextToken();
            string3 = stringTokenizer2.nextToken();
            this.serviceHostTable.put(string2, string3);
        }
    }

    public void setServiceRegistryHost(String string) {
        this.registryHost = string;
    }

    public void setServiceRegistryPort(int n) {
        this.registryPort = n;
    }

    protected void unregister(String string) {
        if (!this.serviceTable.contains(string)) {
            String string2 = "service unregistry fails: no such service name bound";
            logInfo.println(string2);
        }
        try {
            this.lookupRegistry.unregister(string, (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle));
            this.serviceTable.remove(string);
        }
        catch (Exception exception) {
            String string3 = "service unregistry fails: " + exception.getMessage();
            logError.println(string3);
        }
    }

    private class RemoteFactory
    extends UnicastRemoteObject
    implements MSRemoteServiceFactory {
        MSBaseFactory svcFactory;

        public RemoteFactory(MSBaseFactory mSBaseFactory2) throws RemoteException {
            this.svcFactory = mSBaseFactory2;
        }

        public Remote getHandle(String string, ScSecurityCredential scSecurityCredential, String string2, String string3) throws RemoteException, SMNoSuchObjectException {
            Remote remote;
            if (!this.svcFactory.isAvailable(string)) {
                throw new SMNoSuchObjectException("Service not found: " + string);
            }
            MSBaseServiceInterface mSBaseServiceInterface = null;
            String string4 = null;
            try {
                if (string3 != null) {
                    string4 = this.svcFactory.getAlternateServiceHost(string3);
                    if (string4.equals(null)) {
                        UcDDL.logErrorMessage((String)"MSBaseFactory : Service Hashtable returned a null object");
                    }
                } else {
                    string4 = InetAddress.getLocalHost().getHostName();
                }
                mSBaseServiceInterface = this.svcFactory.getService(string, scSecurityCredential, string4);
                remote = (MSBaseService)mSBaseServiceInterface;
                remote.setUserSession(string2);
            }
            catch (Exception exception) {
                throw new SMNoSuchObjectException("Service not found: " + exception.getMessage());
            }
            try {
                remote = RemoteObject.toStub(mSBaseServiceInterface);
                this.svcFactory.addSession(string2, mSBaseServiceInterface);
                return remote;
            }
            catch (Exception exception) {
                throw new SMNoSuchObjectException("Service not found: " + exception.getMessage());
            }
        }

        public void ping() throws RemoteException {
        }

        public void removeSession(String string) throws RemoteException {
            this.svcFactory.removeSession(string);
        }
    }
}

