/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.common;

import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class MSSecurity {
    private static MSSecurity instance_;
    private static String ANYUSER;
    private static String ANYGROUP;
    private static String aclFile_;
    private MSProperties acl_;
    private long aclLastLoaded_ = 0L;
    static /* synthetic */ Class class$com$sun$symon$base$mgmtservice$common$MSSecurity;

    static {
        ANYUSER = "ANYUSER";
        ANYGROUP = "ANYGROUP";
        aclFile_ = "com.sun.symon.base.mgmtservice.service-acls";
    }

    private MSSecurity() throws SMSecurityException {
        this.checkForChangedAcl();
        MSLogPrintWriter.getDebugWriter().println("Security: initialized");
    }

    private boolean areGroupsInList(String[] stringArray, String string) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.indexOf("," + stringArray[n] + ",") >= 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void checkAccess(String string, String string2, ScSecurityCredential scSecurityCredential) throws SMSecurityException {
        this.checkAccess(string, string2, scSecurityCredential, null);
    }

    public void checkAccess(String string, String string2, ScSecurityCredential scSecurityCredential, SMDBObjectID sMDBObjectID) throws SMSecurityException {
        if (scSecurityCredential == null) {
            return;
        }
        this.checkForChangedAcl();
        String string3 = String.valueOf(string) + "." + string2;
        String string4 = "," + scSecurityCredential.getUser() + ",";
        String string5 = String.valueOf(string3) + ".denyUser";
        String string6 = this.acl_.getProperty(string5);
        if (string6 != null) {
            if (string6.equals(ANYUSER)) {
                throw new SMSecurityException("All users denied access on " + string3);
            }
            if (string6.indexOf(string4) >= 0) {
                throw new SMSecurityException("User access denied on " + string3);
            }
        }
        if ((string6 = this.acl_.getProperty(string5 = String.valueOf(string3) + ".denyGroup")) != null) {
            if (string6.equals(ANYGROUP)) {
                throw new SMSecurityException("All groups denied acces on " + string3);
            }
            if (this.areGroupsInList(scSecurityCredential.getGroupArray(), string6)) {
                throw new SMSecurityException("Group access denied on " + string3);
            }
        }
        if ((string6 = this.acl_.getProperty(string5 = String.valueOf(string3) + ".allowUser")) != null) {
            if (string6.equals(ANYUSER)) {
                return;
            }
            if (string6.indexOf(string4) >= 0) {
                return;
            }
        }
        if ((string6 = this.acl_.getProperty(string5 = String.valueOf(string3) + ".allowGroup")) != null) {
            if (string6.equals(ANYGROUP)) {
                return;
            }
            if (this.areGroupsInList(scSecurityCredential.getGroupArray(), string6)) {
                return;
            }
        }
        throw new SMSecurityException("User not allowed on " + string3);
    }

    private void checkForChangedAcl() throws SMSecurityException {
        long l = this.getTimeOfAcl();
        if (this.acl_ != null && l == this.aclLastLoaded_) {
            return;
        }
        this.loadAcl();
        this.aclLastLoaded_ = l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static MSSecurity getInstance() throws SMSecurityException {
        if (instance_ == null) {
            Class clazz = class$com$sun$symon$base$mgmtservice$common$MSSecurity != null ? class$com$sun$symon$base$mgmtservice$common$MSSecurity : (class$com$sun$symon$base$mgmtservice$common$MSSecurity = MSSecurity.class$("com.sun.symon.base.mgmtservice.common.MSSecurity"));
            synchronized (clazz) {
                if (instance_ == null) {
                    instance_ = new MSSecurity();
                }
            }
        }
        return instance_;
    }

    private long getTimeOfAcl() throws SMSecurityException {
        try {
            File file = MSProperties.getFile(aclFile_);
            return file.lastModified();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public static void init(String string) throws SMSecurityException {
        aclFile_ = string;
        instance_ = new MSSecurity();
    }

    private void loadAcl() throws SMSecurityException {
        this.acl_ = new MSProperties();
        try {
            this.acl_.load(aclFile_);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SMSecurityException("Unable to open " + aclFile_, (Throwable)iOException);
        }
        Enumeration<?> enumeration = this.acl_.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.acl_.getProperty(string).trim();
            if (string2.equals(ANYUSER) || string2.equals(ANYGROUP)) continue;
            if (!string2.startsWith(",")) {
                string2 = "," + string2;
            }
            if (!string2.endsWith(",")) {
                string2 = String.valueOf(string2) + ",";
            }
            ((Hashtable)this.acl_).put(string, string2);
        }
    }
}

