/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.task.SMTask;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.console.grouping.CgDialogContainer;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.table.CgCancelRowSaveEvent;
import com.sun.symon.base.console.grouping.table.CgCancelRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgComboBox;
import com.sun.symon.base.console.grouping.table.CgData;
import com.sun.symon.base.console.grouping.table.CgRowSaveEvent;
import com.sun.symon.base.console.grouping.table.CgRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgRowTransEvent;
import com.sun.symon.base.console.grouping.table.CgTblColumnFormat;
import com.sun.symon.base.console.grouping.table.CgTblPane;
import com.sun.symon.base.console.grouping.table.CgTblSelectEvent;
import com.sun.symon.base.console.grouping.table.CgTblSelectListener;
import com.sun.symon.base.console.grouping.table.CgTblUpdateEvent;
import com.sun.symon.base.console.grouping.table.CgTblUpdateListener;
import com.sun.symon.base.console.grouping.task.CgGlassPane;
import com.sun.symon.base.console.grouping.task.CgTaskTablePane;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcURL;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;

public class CgTaskManager
extends JDialog
implements SMDBChangeListener,
CgTblSelectListener,
CgRowSaveListener,
CgTblUpdateListener,
DocumentListener,
CgCancelRowSaveListener {
    final String[] types = new String[]{CgUtil.getI18nMsg((String)"TaskType.moduleLabel"), CgUtil.getI18nMsg((String)"TaskType.dataLabel"), CgUtil.getI18nMsg((String)"TaskType.mcpLabel")};
    CgData[] cgTypes = new CgData[]{new CgData(this.types[0], null, (Object)new Integer(0)), new CgData(this.types[1], null, (Object)new Integer(1)), new CgData(this.types[2], null, (Object)new Integer(2))};
    String[][] modInfo = null;
    private boolean afterGet = false;
    private boolean isSecurityLimited = false;
    private boolean isSelected = false;
    private boolean isModified = false;
    private boolean dbChanged = false;
    private boolean isChanged = true;
    private CgGlassPane appGlassPane;
    private JButton okButton;
    private JButton deleteButton;
    private JButton saveButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JPanel mainPanel;
    private JLabel stateLabel;
    private JTextArea textArea;
    private Toolkit toolkit;
    private String selName = null;
    private Vector taskVec = new Vector();
    private SMTaskData taskData;
    private SMTask taskHandle = null;
    private CgTblPane taskPanel;
    private CgTaskTablePane tablePane = null;
    private SMRawDataRequest handle;
    private int selItem = -1;
    private JFrame owner;

    public CgTaskManager(JFrame jFrame, boolean bl, SMRawDataRequest sMRawDataRequest, SMTask sMTask) throws SMAPIException {
        super((Frame)jFrame, false);
        this.setTitle(CgUtil.getI18nMsg((String)"TaskMgr.title"));
        this.taskHandle = sMTask;
        this.handle = sMRawDataRequest;
        this.isSecurityLimited = bl;
        this.owner = jFrame;
        this.registerTask();
        this.doGetModuleInfo();
        this.createGUI();
        this.initiateGUI();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.appGlassPane = new CgGlassPane();
        this.setGlassPane(this.appGlassPane);
        this.showGlassPane(false, null);
        ((Component)this).setSize(new Dimension(810, 560));
        ((Component)this).setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgTaskManager.this.cancelButton.doClick();
            }
        });
    }

    static /* synthetic */ boolean access$11(CgTaskManager cgTaskManager) {
        return cgTaskManager.afterGet;
    }

    static /* synthetic */ void access$14(CgTaskManager cgTaskManager, SMTaskInfo[] sMTaskInfoArray) {
        cgTaskManager.inputDataToModel(sMTaskInfoArray);
    }

    static /* synthetic */ String access$15(CgTaskManager cgTaskManager) {
        return cgTaskManager.selName;
    }

    private void addTablePane(int n, String string) {
        CgTaskManager cgTaskManager = this;
        this.setText(" ");
        if (this.tablePane != null) {
            this.tablePane.disposeDialog();
            this.mainPanel.remove(this.tablePane);
        }
        CgTaskTablePane cgTaskTablePane = new CgTaskTablePane(cgTaskManager, n, this.taskHandle, this.handle);
        if (string != null) {
            cgTaskTablePane.initiateModification(string);
        }
        cgTaskTablePane.setAlignmentX(0.0f);
        this.mainPanel.add(cgTaskTablePane);
        this.tablePane = cgTaskTablePane;
        this.invalidate();
        this.validate();
        this.repaint();
        if (this.getSize().height < 560) {
            ((Component)this).setSize(this.getSize().width, 560);
        }
    }

    public boolean cancelSaveOccured(CgCancelRowSaveEvent cgCancelRowSaveEvent) {
        this.taskPanel.resetWorkingRow();
        this.setModified(false);
        this.verifyDBChanged();
        return false;
    }

    public void changed(SMDBChangeEvent sMDBChangeEvent) throws SMAPIException {
        if (!this.isChanged) {
            this.isChanged = true;
        }
        this.dbChanged = false;
        this.loadTaskInfo();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    public void clearSelection() {
        this.isSelected = false;
        this.taskPanel.clearSelection();
        this.deleteButton.setEnabled(false);
    }

    public void close() {
        String string;
        int n;
        this.setText(" ");
        if (this.isModified && (n = UcDialog.showOkCancel((String)(string = CgUtil.getI18nMsg((String)"TaskManager.closeMsg")))) == 1) {
            return;
        }
        if (this.owner instanceof CgDialogContainer) {
            ((CgDialogContainer)this.owner).removeDialogFromPool("task");
        }
        try {
            this.taskHandle.removeDBChangeListener((SMDBChangeListener)this);
        }
        catch (SMAPIException sMAPIException) {}
        if (this.tablePane != null) {
            this.tablePane.disposeDialog();
        }
        this.dispose();
    }

    private void createGUI() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        JLabel jLabel = new JLabel(CgUtil.getI18nMsg((String)"TasksTable.labelString"));
        jLabel.setAlignmentX(0.0f);
        this.mainPanel.add(jLabel);
        JPanel jPanel = this.createTaskPanel();
        jPanel.setAlignmentX(0.0f);
        this.mainPanel.add(jPanel);
        this.mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 10, 12));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add(jSeparator);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 4, 5, 0));
        this.okButton = new JButton(CgUtil.getI18nMsg((String)"standard.ok"));
        this.saveButton = new JButton(CgUtil.getI18nMsg((String)"standard.apply"));
        this.cancelButton = new JButton(CgUtil.getI18nMsg((String)"standard.cancel"));
        this.helpButton = new JButton(CgUtil.getI18nMsg((String)"standard.help"));
        jPanel3.add(this.okButton);
        jPanel3.add(this.saveButton);
        jPanel3.add(this.cancelButton);
        jPanel3.add(this.helpButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        jPanel4.add(jPanel3);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        this.stateLabel = new JLabel("<status text string>");
        jPanel5.add(this.stateLabel);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel2.add(jPanel5);
        Container container = this.getContentPane();
        container.add((Component)this.mainPanel, "Center");
        container.add((Component)jPanel2, "South");
    }

    private JPanel createTaskPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        String[] stringArray = new String[]{CgUtil.getI18nMsg((String)"TasksTable.nameColumnLabel"), CgUtil.getI18nMsg((String)"TasksTable.typeColumnLabel")};
        int n = stringArray.length;
        CgTblColumnFormat[] cgTblColumnFormatArray = new CgTblColumnFormat[n];
        boolean[] blArray = new boolean[]{true, true};
        String[] stringArray2 = new String[]{CgUtil.getI18nMsg((String)"TasksToolTip.labelString"), null};
        DefaultCellEditor defaultCellEditor = this.createTypeEditor();
        DefaultCellEditor[] defaultCellEditorArray = new DefaultCellEditor[]{null, defaultCellEditor};
        int n2 = 0;
        while (n2 < n) {
            cgTblColumnFormatArray[n2] = new CgTblColumnFormat(stringArray[n2], blArray[n2], defaultCellEditorArray[n2]);
            cgTblColumnFormatArray[n2].setToolTip(stringArray2[n2]);
            ++n2;
        }
        this.taskPanel = new CgTblPane(cgTblColumnFormatArray, true);
        this.taskPanel.setAlignmentX(0.0f);
        jPanel2.add((Component)this.taskPanel);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel jLabel = new JLabel(CgUtil.getI18nMsg((String)"Description.labelString"));
        jLabel.setAlignmentX(0.0f);
        jPanel2.add(jLabel);
        JPanel jPanel3 = this.createTextPanel();
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel2.setAlignmentY(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.deleteButton = new JButton(CgUtil.getI18nMsg((String)"DeleteButton.labelString"));
        this.deleteButton.setAlignmentY(0.0f);
        jPanel.add(this.deleteButton);
        return jPanel;
    }

    private JPanel createTextPanel() {
        CgTaskManager cgTaskManager = this;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        PlainDocument plainDocument = new PlainDocument();
        plainDocument.addDocumentListener(cgTaskManager);
        this.textArea = new JTextArea(plainDocument);
        this.textArea.setRows(2);
        this.textArea.setBorder(BorderFactory.createLineBorder(Color.black));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setAlignmentY(0.0f);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(new Dimension(650, 90));
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private DefaultCellEditor createTypeEditor() {
        CgComboBox cgComboBox = new CgComboBox((Object[])this.cgTypes);
        cgComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                int n = jComboBox.getSelectedIndex();
                if (n > -1 && CgTaskManager.this.selItem != n) {
                    CgTaskManager.this.taskPanel.getTable().editingStopped(new ChangeEvent(this));
                    CgTaskManager.this.setModified(true);
                    CgTaskManager.this.addTablePane(n, null);
                    CgTaskManager.this.selItem = n;
                }
            }
        });
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)cgComboBox);
        defaultCellEditor.setClickCountToStart(1);
        return defaultCellEditor;
    }

    public void deleteTaskInfo(int n) {
        SMTaskInfo sMTaskInfo = (SMTaskInfo)this.taskVec.get(n);
        this.showGlassPane(true, CgUtil.getI18nMsg((String)"standard.deleting"));
        boolean bl = false;
        try {
            if (this.isModified) {
                bl = true;
                this.setModified(false);
            }
            this.taskHandle.delete(sMTaskInfo);
            this.taskVec.removeElementAt(n);
            this.clearSelection();
        }
        catch (SMSecurityException sMSecurityException) {
            if (bl) {
                this.setModified(true);
            }
            this.setSecurityLimit(true);
            CgUtil.handleAPIException((SMAPIException)((Object)sMSecurityException), (Component)this);
        }
        catch (SMNoSuchObjectException sMNoSuchObjectException) {
            if (this.dbChanged) {
                this.verifyDBChanged();
            } else {
                if (bl) {
                    this.setModified(true);
                }
                CgUtil.handleAPIException((SMAPIException)((Object)sMNoSuchObjectException), (Component)this);
            }
        }
        catch (SMAPIException sMAPIException) {
            if (bl) {
                this.setModified(true);
            }
            CgUtil.handleAPIException((SMAPIException)sMAPIException, (Component)this);
        }
        this.showGlassPane(false, null);
    }

    private void doGetModuleInfo() {
        CgTaskManager cgTaskManager = this;
        Runnable runnable = new Runnable(){

            public void run() {
                Object object;
                String string = String.valueOf(handle.getMDRBaseURL()) + "sym//base/mibman/modules";
                if (string == null && string.equals("")) {
                    afterGet = true;
                    CgTaskManager cgTaskManager = CgTaskManager.this;
                    synchronized (cgTaskManager) {
                        CgTaskManager.this.notify();
                    }
                    return;
                }
                UcURL ucURL = new UcURL(string);
                String string2 = ucURL.getHost();
                String string3 = ucURL.getPort();
                try {
                    object = new SMModuleRequest(handle);
                    modInfo = object.getLoadedModuleInfo(string2, Integer.parseInt(string3));
                }
                catch (SMAPIException sMAPIException) {
                    CgUtil.handleAPIException((SMAPIException)sMAPIException, (Component)CgTaskManager.this);
                    modInfo = null;
                }
                afterGet = true;
                object = CgTaskManager.this;
                synchronized (object) {
                    CgTaskManager.this.notify();
                }
            }
        };
        new Thread(runnable).start();
    }

    public String[][] getModuleInfo() {
        CgTaskManager cgTaskManager = this;
        if (!this.afterGet) {
            CgTaskManager cgTaskManager2 = cgTaskManager;
            synchronized (cgTaskManager2) {
                try {
                    cgTaskManager.wait();
                }
                catch (Exception exception) {}
            }
        }
        return this.modInfo;
    }

    private void initiateGUI() {
        this.registerListeners();
        this.loadTaskInfo();
        this.setText(" ");
        this.setModified(false);
    }

    private void inputDataToModel(SMTaskInfo[] sMTaskInfoArray) {
        this.taskVec.removeAllElements();
        if (sMTaskInfoArray == null || sMTaskInfoArray.length == 0) {
            this.taskPanel.setData(new Vector());
            return;
        }
        CgData cgData = null;
        Vector<CgData> vector = new Vector<CgData>();
        int n = 0;
        while (n < sMTaskInfoArray.length) {
            String string = sMTaskInfoArray[n].getName();
            int n2 = sMTaskInfoArray[n].getTaskType();
            vector.add(new CgData(string));
            switch (n2) {
                case 1: {
                    cgData = new CgData(this.types[0], null, (Object)new Integer(0));
                    break;
                }
                case 0: {
                    cgData = new CgData(this.types[1], null, (Object)new Integer(1));
                    break;
                }
                case 2: {
                    cgData = new CgData(this.types[2], null, (Object)new Integer(2));
                    break;
                }
            }
            cgData.setIsEditable(false);
            vector.add(cgData);
            this.taskVec.add(sMTaskInfoArray[n]);
            ++n;
        }
        if (vector.size() > 0) {
            this.taskPanel.setData(vector);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    public void loadTaskInfo() {
        if (!this.isSecurityLimited) {
            if (!this.isModified) {
                Thread thread = new Thread(new TaskLoader(this));
                thread.start();
            } else {
                this.dbChanged = true;
            }
        }
    }

    private Vector okForSave() {
        String string;
        if (this.tablePane != null && this.tablePane.isVisible()) {
            if (!this.tablePane.checkTables()) {
                this.setText(CgUtil.getI18nMsg((String)"SaveCheckInformation.itemMsg"));
                this.toolkit.beep();
                return null;
            }
            if (!this.tablePane.checkDupItems()) {
                this.setText(CgUtil.getI18nMsg((String)"SaveCheckInformation.itemDup"));
                this.toolkit.beep();
                return null;
            }
        } else {
            this.setText(CgUtil.getI18nMsg((String)"SaveCheckInformation.itemMsg"));
            this.toolkit.beep();
            return null;
        }
        String string2 = null;
        int n = this.taskPanel.getRowCount();
        int n2 = this.taskPanel.getSelectedRow();
        if (n2 != -1 && n != 0) {
            string = (CgData)this.taskPanel.getValueAt(n2, 0);
            if (string == null) {
                this.setText(CgUtil.getI18nMsg((String)"SaveCheckInformation.itemMsg"));
                return null;
            }
            string2 = string.getLabel();
            string2 = string2.trim();
        }
        string = null;
        string = this.textArea.getText();
        string = string.trim();
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        vector.addElement(string);
        return vector;
    }

    private void registerListeners() {
        CgTaskManager cgTaskManager = this;
        this.taskPanel.addCgTblUpdateListener((CgTblUpdateListener)cgTaskManager);
        this.taskPanel.addCgCancelRowSaveListener((CgCancelRowSaveListener)cgTaskManager);
        this.taskPanel.addCgRowSaveListener((CgRowSaveListener)cgTaskManager);
        this.taskPanel.addCgTblSelectListener((CgTblSelectListener)cgTaskManager);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.setText(" ");
                Vector vector = this.okForSave();
                if (vector != null) {
                    Thread thread = new Thread(new TaskSaver((String)vector.get(0), (String)vector.get(1), CgTaskManager.this, 1));
                    thread.start();
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.setText(" ");
                Vector vector = this.okForSave();
                if (vector != null) {
                    Thread thread = new Thread(new TaskSaver((String)vector.get(0), (String)vector.get(1), CgTaskManager.this, 0));
                    thread.start();
                }
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.setText(" ");
                CgTaskManager.this.isChanged = false;
                int n = CgTaskManager.this.taskPanel.getSelectedRow();
                int n2 = UcDialog.showYesNo((String)CgUtil.getI18nMsg((String)"DeleteConfirmation.msgLabel"));
                if (n2 == 0 && CgTaskManager.this.isSelected) {
                    if (!CgTaskManager.this.isChanged) {
                        CgTaskManager.this.isChanged = true;
                        int n3 = CgTaskManager.this.taskPanel.getRowCount();
                        if (n == n3 - 1) {
                            CgTaskManager.this.taskPanel.resetWorkingRow();
                            CgTaskManager.this.removeTablePane();
                        } else {
                            CgTaskManager.this.deleteTaskInfo(n);
                        }
                    } else {
                        CgTaskManager.this.setText(CgUtil.getI18nMsg((String)"TaskMgr.change"));
                    }
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.close();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.setText(" ");
                String string = "grouping-task-help";
                CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
                cmConsoleSession.launchHelp(string);
            }
        });
    }

    private void registerTask() throws SMAPIException {
        this.taskHandle.addDBChangeListener((SMDBChangeListener)this);
    }

    private void removeTablePane() {
        this.setText(" ");
        if (this.tablePane != null) {
            this.setDescriptionText("");
            this.setModified(false);
            this.tablePane.setVisible(false);
            this.tablePane.disposeDialog();
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setModified(true);
    }

    public boolean saveData(CgRowSaveEvent cgRowSaveEvent) {
        this.saveButton.doClick();
        return false;
    }

    public void selectionOccurred(CgTblSelectEvent cgTblSelectEvent) {
        this.selItem = -1;
        int n = cgTblSelectEvent.getEventType();
        if (n == CgTblSelectEvent.SELECT) {
            this.isSelected = true;
            this.deleteButton.setEnabled(true);
            int n2 = this.taskPanel.getRowCount();
            int n3 = this.taskPanel.getSelectedRow();
            if (n2 == 0) {
                return;
            }
            if (n3 == n2 - 1) {
                this.removeTablePane();
            } else {
                CgData cgData = (CgData)this.taskPanel.getValueAt(n3, 1);
                int n4 = (Integer)cgData.getUserData();
                this.selName = ((CgData)this.taskPanel.getValueAt(n3, 0)).getLabel();
                this.addTablePane(n4, this.selName);
            }
        } else {
            this.isSelected = false;
            this.selName = null;
            this.deleteButton.setEnabled(false);
            this.removeTablePane();
        }
    }

    public void setDescriptionText(String string) {
        this.textArea.setText(string);
    }

    public void setModified(boolean bl) {
        this.isModified = bl;
        this.taskPanel.setTableDataUpdated(bl);
    }

    private void setSecurityLimit(boolean bl) {
        this.isSecurityLimited = bl;
    }

    public void setTaskData(SMTaskData sMTaskData) {
        this.taskData = sMTaskData;
    }

    public void setText(String string) {
        this.stateLabel.setText(string);
    }

    public void showGlassPane(boolean bl, String string) {
        if (bl) {
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(new Cursor(0));
        }
        this.appGlassPane.setVisible(bl);
        if (string != null) {
            this.setText(string);
        } else {
            this.setText(" ");
        }
    }

    public boolean tblDataUpdated(CgTblUpdateEvent cgTblUpdateEvent) {
        this.okButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        return false;
    }

    private void verifyDBChanged() {
        if (this.dbChanged) {
            this.loadTaskInfo();
            this.dbChanged = false;
        }
    }

    class TaskLoader
    implements Runnable {
        CgTaskManager manager;

        public TaskLoader(CgTaskManager cgTaskManager2) {
            this.manager = cgTaskManager2;
        }

        static /* synthetic */ CgTaskManager access$0(TaskLoader taskLoader) {
            return taskLoader.CgTaskManager.this;
        }

        public void run() {
            Object object;
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ TaskLoader this$1;
                {
                    this.this$1 = taskLoader;
                }

                public void run() {
                    this.this$1.manager.showGlassPane(true, CgUtil.getI18nMsg((String)"loadTask"));
                }
            };
            SwingUtilities.invokeLater(runnable);
            try {
                object = CgTaskManager.this.taskHandle.getAll();
                Runnable runnable2 = new Runnable((SMTaskInfo[])object, this){
                    private final /* synthetic */ SMTaskInfo[] val$taskInfo;
                    private final /* synthetic */ TaskLoader this$1;
                    {
                        this.val$taskInfo = sMTaskInfoArray;
                        this.this$1 = taskLoader;
                    }

                    public void run() {
                        int n;
                        CgTaskManager.access$14(this.this$1.manager, this.val$taskInfo);
                        CgData cgData = null;
                        int n2 = -1;
                        if (CgTaskManager.access$15(TaskLoader.access$0(this.this$1)) != null) {
                            int n3 = 0;
                            while (n3 < CgTaskManager.access$4(TaskLoader.access$0(this.this$1)).getRowCount()) {
                                String string;
                                cgData = (CgData)CgTaskManager.access$4(TaskLoader.access$0(this.this$1)).getValueAt(n3, 0);
                                if (cgData != null && (n2 = (string = cgData.getLabel()).compareTo(CgTaskManager.access$15(TaskLoader.access$0(this.this$1)))) == 0) {
                                    CgTaskManager.access$4(TaskLoader.access$0(this.this$1)).setRowSelectionInterval(n3, n3);
                                    break;
                                }
                                ++n3;
                            }
                        }
                        if (CgTaskManager.access$15(TaskLoader.access$0(this.this$1)) == null) {
                            CgTaskManager.access$4(TaskLoader.access$0(this.this$1)).setRowSelectionInterval(0, 0);
                        }
                        if (n2 != 0 && (n = CgTaskManager.access$4(TaskLoader.access$0(this.this$1)).getSelectedRow()) <= CgTaskManager.access$4(TaskLoader.access$0(this.this$1)).getRowCount() - 1) {
                            CgTaskManager.access$4(TaskLoader.access$0(this.this$1)).setRowSelectionInterval(n, n);
                        }
                        this.this$1.manager.showGlassPane(false, null);
                    }
                };
                SwingUtilities.invokeLater(runnable2);
            }
            catch (SMSecurityException sMSecurityException) {
                this.manager.setSecurityLimit(true);
                CgUtil.handleAPIException((SMAPIException)((Object)sMSecurityException), (Component)this.manager);
            }
            catch (SMAPIException sMAPIException) {
                CgUtil.handleAPIException((SMAPIException)sMAPIException, (Component)this.manager);
            }
            object = new Runnable(this){
                private final /* synthetic */ TaskLoader this$1;
                {
                    this.this$1 = taskLoader;
                }

                public void run() {
                    this.this$1.manager.showGlassPane(false, null);
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
        }
    }

    class TaskSaver
    implements Runnable {
        String name;
        String description;
        CgTaskManager manager;
        int which;

        public TaskSaver(String string, String string2, CgTaskManager cgTaskManager2, int n) {
            this.name = string;
            this.description = string2;
            this.manager = cgTaskManager2;
            this.which = n;
        }

        public void run() {
            Object object;
            block18: {
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ TaskSaver this$1;
                    {
                        this.this$1 = taskSaver;
                    }

                    public void run() {
                        this.this$1.manager.showGlassPane(true, CgUtil.getI18nMsg((String)"standard.saving"));
                    }
                };
                SwingUtilities.invokeLater(runnable);
                SMTaskOperationData[] sMTaskOperationDataArray = CgTaskManager.this.tablePane.getOperationData();
                int n = CgTaskManager.this.taskPanel.getSelectedRow();
                int n2 = CgTaskManager.this.taskPanel.getRowCount();
                CgData cgData = (CgData)CgTaskManager.this.taskPanel.getValueAt(n, 1);
                int n3 = (Integer)cgData.getUserData();
                int n4 = -1;
                switch (n3) {
                    case 0: {
                        n4 = 1;
                        break;
                    }
                    case 1: {
                        n4 = 0;
                        break;
                    }
                    case 2: {
                        n4 = 2;
                        break;
                    }
                }
                if (n != n2 - 1) {
                    try {
                        CgTaskManager.this.taskData.setName(this.name);
                        CgTaskManager.this.taskData.setDescription(this.description);
                        CgTaskManager.this.taskData.setTaskType(n4);
                        CgTaskManager.this.taskData.setOperations(sMTaskOperationDataArray);
                        this.manager.setModified(false);
                        if (CgUtil.saveObj((SMHandle)CgTaskManager.this.taskHandle, (SMDBObject)CgTaskManager.this.taskData)) {
                            CgTaskManager.this.selName = this.name;
                            if (CgTaskManager.this.isSecurityLimited) {
                                object = new CgRowTransEvent((Object)this, 0);
                                CgTaskManager.this.taskPanel.transactionFinished((CgRowTransEvent)object);
                            }
                            if (this.which == 1) {
                                CgTaskManager.this.cancelButton.doClick();
                            }
                            break block18;
                        }
                        this.manager.setModified(true);
                    }
                    catch (SMAPIException sMAPIException) {
                        this.manager.setModified(true);
                        CgUtil.handleAPIException((SMAPIException)sMAPIException, (Component)this.manager);
                    }
                } else {
                    try {
                        object = new SMTaskData();
                        object.setName(this.name);
                        object.setTaskType(n4);
                        object.setDescription(this.description);
                        object.setOperations(sMTaskOperationDataArray);
                        this.manager.setModified(false);
                        if (CgUtil.saveObj((SMHandle)CgTaskManager.this.taskHandle, (SMDBObject)object)) {
                            CgTaskManager.this.selName = this.name;
                            CgTaskManager.this.taskData = object;
                            if (CgTaskManager.this.isSecurityLimited) {
                                CgRowTransEvent cgRowTransEvent = new CgRowTransEvent((Object)this, 0);
                                CgTaskManager.this.taskPanel.transactionFinished(cgRowTransEvent);
                            }
                            if (this.which == 1) {
                                CgTaskManager.this.cancelButton.doClick();
                            }
                        } else {
                            this.manager.setModified(true);
                        }
                    }
                    catch (SMAPIException sMAPIException) {
                        this.manager.setModified(true);
                        CgUtil.handleAPIException((SMAPIException)sMAPIException, (Component)this.manager);
                    }
                }
            }
            object = new Runnable(this){
                private final /* synthetic */ TaskSaver this$1;
                {
                    this.this$1 = taskSaver;
                }

                public void run() {
                    this.this$1.manager.showGlassPane(false, null);
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
        }
    }
}

