/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.request;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.task.SMTaskRequest;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.request.CgRequestUpdateDialog;
import com.sun.symon.base.console.grouping.request.ScheduledCellRenderer;
import com.sun.symon.base.console.grouping.request.StatusCellRenderer;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.views.table.CvBaseTable;
import com.sun.symon.base.console.views.table.CvBaseTableModel;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcConfirmDialog;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcThreadWorker;
import com.sun.symon.base.utility.UcToolTipCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CgRequestManagerDialog
extends JDialog
implements ActionListener,
SMDBChangeListener {
    private JButton suspendBtn;
    private JButton resumeBtn;
    private JButton addBtn;
    private JButton modifyBtn;
    private JButton deleteBtn;
    private JButton viewLogBtn;
    private JButton closeBtn;
    private JButton helpBtn;
    private CvBaseTable rqstTbl;
    private JLabel statusLbl;
    private RequestTableModel rqstTblModel;
    protected SMTaskRequest rqstHandle;
    private SMTaskRequestInfo[] values;
    private Vector ownedDlgs = new Vector();
    private static final int DELETE = 0;
    private static final int RESUME = 1;
    private static final int SUSPEND = 2;
    static /* synthetic */ Class class$com$sun$symon$base$console$grouping$request$CgRequestManagerDialog;
    static /* synthetic */ Class class$java$awt$Frame;

    public CgRequestManagerDialog(Frame frame) throws SMAPIException {
        super(frame);
        this.setTitle(CgUtil.getI18nMsg((String)"rqstMgr.title"));
        this.createGUI();
        this.installListeners();
        try {
            this.rqstHandle = new SMTaskRequest(SMConsoleContext.getInstance().getAPIHandle());
            UcCommon.isServiceLicenseAvailable((String)"Task_TaskRequest", (Component)frame);
        }
        catch (SMAPIException sMAPIException) {
            throw new SMAPIException(sMAPIException.getReasonCode(), CgUtil.getI18nMsg((String)"rqstMgr.requestErr"));
        }
        try {
            this.rqstHandle.addTaskRequestListener((SMDBChangeListener)this);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
            return;
        }
        this.rqstTblModel = new RequestTableModel();
        this.rqstTbl.setModel((TableModel)((Object)this.rqstTblModel));
        this.rqstTbl.setRowHeight(20);
        this.rqstTbl.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.initTableCellRenderer();
        CgUtil.addDialogToPool((String)"request manager", (JDialog)this);
        this.addWindowListener(new WindowAdapter(){

            public void WindowClosing(WindowEvent windowEvent) {
                CgRequestManagerDialog.this.close();
            }
        });
        Runnable runnable = new Runnable(){

            public void run() {
                CgRequestManagerDialog.this.changed(null);
            }
        };
        new Thread(runnable).start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addBtn) {
            this.showUpdateDlg(null);
        } else if (object == this.deleteBtn) {
            String[] stringArray = new String[]{CgUtil.getI18nMsg((String)"standard.delete"), CgUtil.getI18nMsg((String)"standard.cancel")};
            UcConfirmDialog ucConfirmDialog = new UcConfirmDialog((Dialog)this, CgUtil.getI18nMsg((String)"standard.warning"), CgUtil.getI18nMsg((String)"standard.deleteBoldMsg"), CgUtil.getI18nMsg((String)"rqstMgr.delPlainMsg"), stringArray);
            ucConfirmDialog.pack();
            ucConfirmDialog.setLocationRelativeTo(this);
            ucConfirmDialog.setVisible(true);
            if (ucConfirmDialog.getClicked() == 0) {
                int n = this.rqstTbl.getSelectedRow();
                n = this.rqstTblModel.getRealRow(n);
                this.statusLbl.setText(CgUtil.getI18nMsg((String)"standard.deleting"));
                this.threadWorkOnRequest(this.values[n], 0);
            }
        } else if (object == this.modifyBtn) {
            int n = this.rqstTbl.getSelectedRow();
            n = this.rqstTblModel.getRealRow(n);
            this.showUpdateDlg(this.values[n]);
        } else if (object == this.closeBtn) {
            this.close();
        } else if (object == this.suspendBtn) {
            int n = this.rqstTbl.getSelectedRow();
            n = this.rqstTblModel.getRealRow(n);
            this.statusLbl.setText(CgUtil.getI18nMsg((String)"rqstMgr.suspending"));
            this.threadWorkOnRequest(this.values[n], 2);
        } else if (object == this.resumeBtn) {
            int n = this.rqstTbl.getSelectedRow();
            n = this.rqstTblModel.getRealRow(n);
            this.statusLbl.setText(CgUtil.getI18nMsg((String)"rqstMgr.resuming"));
            this.threadWorkOnRequest(this.values[n], 1);
        } else if (object == this.viewLogBtn) {
            JDialog jDialog = CgUtil.getDialogFromPool((String)"request log");
            if (jDialog == null) {
                Class[] classArray = new Class[]{class$com$sun$symon$base$console$grouping$request$CgRequestManagerDialog != null ? class$com$sun$symon$base$console$grouping$request$CgRequestManagerDialog : (class$com$sun$symon$base$console$grouping$request$CgRequestManagerDialog = CgRequestManagerDialog.class$("com.sun.symon.base.console.grouping.request.CgRequestManagerDialog"))};
                Object[] objectArray = new Object[]{this};
                UcCommon.launchWindow((Window)this, (String)"com.sun.symon.base.console.grouping.request.CgRequestLogViewDialog", (Class[])classArray, (Object[])objectArray);
            } else {
                ((Component)jDialog).setVisible(true);
            }
        } else if (object == this.helpBtn) {
            CmConsoleSession.getInstance().launchHelp("grouping-request-manager-help");
        }
    }

    public void changed(SMDBChangeEvent sMDBChangeEvent) {
        this.statusLbl.setText(CgUtil.getI18nMsg((String)"rqstMgr.loadrqst"));
        final SMTaskRequestInfo[] sMTaskRequestInfoArray = this.getAllTaskRequests();
        Runnable runnable = new Runnable(){

            public void run() {
                int n = rqstTbl.getSelectedRow();
                values = sMTaskRequestInfoArray;
                ((AbstractTableModel)((Object)rqstTblModel)).fireTableDataChanged();
                rqstTbl.clearSelection();
                int n2 = rqstTbl.getRowCount();
                if (n != -1 && n2 != 0 && n2 > n) {
                    rqstTbl.setRowSelectionInterval(n, n);
                }
                rqstTbl.invalidate();
                statusLbl.setText(" ");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void close() {
        ((Component)this).setVisible(false);
        CgUtil.removeDialogFromPool((String)"request manager");
        int n = this.ownedDlgs.size();
        int n2 = 0;
        while (n2 < n) {
            JDialog jDialog = (JDialog)this.ownedDlgs.elementAt(n2);
            if (jDialog.isDisplayable()) {
                if (jDialog instanceof CgRequestUpdateDialog) {
                    ((CgRequestUpdateDialog)jDialog).close();
                } else {
                    jDialog.dispose();
                }
            }
            ++n2;
        }
        try {
            this.rqstHandle.close();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        this.dispose();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.rqstLbl"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.fill = 1;
        this.rqstTbl = new CvBaseTable();
        this.rqstTbl.setSelectionMode(0);
        this.rqstTbl.setCellSelectionEnabled(false);
        this.rqstTbl.setBackground(((Component)this).getBackground());
        this.rqstTbl.setPreferredScrollableViewportSize(new Dimension(400, 50));
        JScrollPane jScrollPane = new JScrollPane((Component)this.rqstTbl);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        this.suspendBtn = new JButton(CgUtil.getI18nMsg((String)"rqstMgr.suspendBtn"));
        this.suspendBtn.setEnabled(false);
        this.suspendBtn.addActionListener(this);
        gridBagLayout.setConstraints(this.suspendBtn, gridBagConstraints);
        jPanel2.add(this.suspendBtn);
        gridBagConstraints.gridy = 2;
        this.resumeBtn = new JButton(CgUtil.getI18nMsg((String)"rqstMgr.resumeBtn"));
        this.resumeBtn.setEnabled(false);
        this.resumeBtn.addActionListener(this);
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        gridBagLayout.setConstraints(this.resumeBtn, gridBagConstraints);
        jPanel2.add(this.resumeBtn);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.addBtn = new JButton(CgUtil.getI18nMsg((String)"rqstMgr.addRqstBtn"));
        this.addBtn.addActionListener(this);
        gridBagLayout.setConstraints(this.addBtn, gridBagConstraints);
        jPanel2.add(this.addBtn);
        gridBagConstraints.gridy = 4;
        this.modifyBtn = new JButton(CgUtil.getI18nMsg((String)"rqstMgr.modifyBtn"));
        this.modifyBtn.setEnabled(false);
        this.modifyBtn.addActionListener(this);
        gridBagLayout.setConstraints(this.modifyBtn, gridBagConstraints);
        jPanel2.add(this.modifyBtn);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.deleteBtn = new JButton(CgUtil.getI18nMsg((String)"rqstMgr.delBtn"));
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addActionListener(this);
        gridBagLayout.setConstraints(this.deleteBtn, gridBagConstraints);
        jPanel2.add(this.deleteBtn);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        this.viewLogBtn = new JButton(CgUtil.getI18nMsg((String)"rqstMgr.viewLogBtn"));
        this.viewLogBtn.addActionListener(this);
        gridBagLayout.setConstraints(this.viewLogBtn, gridBagConstraints);
        jPanel2.add(this.viewLogBtn);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JSeparator jSeparator = new JSeparator();
        jPanel3.add((Component)jSeparator, "North");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 2, 0));
        jPanel4.setBorder(new EmptyBorder(10, 0, 10, 10));
        this.closeBtn = new JButton(CgUtil.getI18nMsg((String)"rqstMgr.closeBtn"));
        this.closeBtn.addActionListener(this);
        jPanel4.add(this.closeBtn);
        this.helpBtn = new JButton(CgUtil.getI18nMsg((String)"rqstMgr.helpBtn"));
        this.helpBtn.addActionListener(this);
        jPanel4.add(this.helpBtn);
        jPanel3.add((Component)jPanel4, "East");
        this.statusLbl = new JLabel(" ");
        this.statusLbl.setForeground(Color.black);
        this.statusLbl.setBorder(new EmptyBorder(0, 10, 0, 0));
        jPanel3.add((Component)this.statusLbl, "South");
        jPanel.add((Component)jPanel3, "South");
    }

    SMTaskRequestInfo[] getAllTaskRequests() {
        SMTaskRequestInfo[] sMTaskRequestInfoArray = null;
        try {
            sMTaskRequestInfoArray = this.rqstHandle.getAll();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
        return sMTaskRequestInfoArray;
    }

    private JDialog getDlgWithName(boolean bl, String string) {
        int n = this.ownedDlgs.size();
        int n2 = 0;
        while (n2 < n) {
            JDialog jDialog = (JDialog)this.ownedDlgs.elementAt(n2);
            if (jDialog.isDisplayable() && jDialog instanceof CgRequestUpdateDialog) {
                CgRequestUpdateDialog cgRequestUpdateDialog = (CgRequestUpdateDialog)jDialog;
                if (bl ? cgRequestUpdateDialog.isAddDialog() : cgRequestUpdateDialog.getRequestName().equals(string) && !cgRequestUpdateDialog.isAddDialog()) {
                    return cgRequestUpdateDialog;
                }
            }
            ++n2;
        }
        return null;
    }

    void initTableCellRenderer() {
        TableColumnModel tableColumnModel = this.rqstTbl.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer((TableCellRenderer)new UcToolTipCellRenderer());
        tableColumnModel.getColumn(1).setCellRenderer((TableCellRenderer)new UcToolTipCellRenderer());
        tableColumnModel.getColumn(2).setCellRenderer(new ScheduledCellRenderer());
        tableColumnModel.getColumn(3).setCellRenderer(new StatusCellRenderer());
    }

    private void installListeners() {
        ListSelectionModel listSelectionModel = this.rqstTbl.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    CgRequestManagerDialog.this.suspendBtn.setEnabled(false);
                    CgRequestManagerDialog.this.resumeBtn.setEnabled(false);
                    CgRequestManagerDialog.this.modifyBtn.setEnabled(false);
                    CgRequestManagerDialog.this.deleteBtn.setEnabled(false);
                } else {
                    int n = CgRequestManagerDialog.this.rqstTbl.getSelectedRow();
                    n = CgRequestManagerDialog.this.rqstTblModel.getRealRow(n);
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        CgRequestManagerDialog.this.selectedRequestChanged(CgRequestManagerDialog.this.values[n]);
                    }
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = CgUtil.getDialogFromPool((String)"request manager");
        if (jDialog != null) {
            jDialog.show();
        } else {
            CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
            JFrame jFrame = cmConsoleSession.getMainWindowFrame();
            if (jFrame == null) {
                jFrame = (JFrame)JOptionPane.getRootFrame();
            }
            Class[] classArray = new Class[]{class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = CgRequestManagerDialog.class$("java.awt.Frame"))};
            Object[] objectArray = new Object[]{jFrame};
            UcCommon.launchWindow((Window)jFrame, (String)"com.sun.symon.base.console.grouping.request.CgRequestManagerDialog", (Class[])classArray, (Object[])objectArray);
        }
    }

    protected void selectedRequestChanged(SMTaskRequestInfo sMTaskRequestInfo) {
        boolean bl = sMTaskRequestInfo.isSuspended();
        boolean bl2 = sMTaskRequestInfo.isScheduled();
        this.deleteBtn.setEnabled(!bl2 || bl);
        this.modifyBtn.setEnabled(!bl2 || bl);
        this.suspendBtn.setEnabled(bl2 && !bl);
        this.resumeBtn.setEnabled(bl);
    }

    private void showUpdateDlg(final SMTaskRequestInfo sMTaskRequestInfo) {
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){

            public void doWork() {
                this.setCursor(new Cursor(3));
                JDialog jDialog = null;
                jDialog = sMTaskRequestInfo != null ? this.getDlgWithName(false, sMTaskRequestInfo.getName()) : this.getDlgWithName(true, null);
                if (jDialog == null) {
                    try {
                        jDialog = new CgRequestUpdateDialog(this, sMTaskRequestInfo);
                    }
                    catch (SMAPIException sMAPIException) {
                        UcDialog.showError((Component)this, (Object)CgUtil.getI18nMsg((String)"rqstMgr.serviceErr"));
                        this.setCursor(new Cursor(0));
                        return;
                    }
                    jDialog.pack();
                    jDialog.setLocationRelativeTo(this);
                    ownedDlgs.addElement(jDialog);
                }
                ((Component)jDialog).setVisible(true);
                this.setCursor(new Cursor(0));
            }
        };
        ucThreadWorker.start();
    }

    void threadWorkOnRequest(final SMTaskRequestInfo sMTaskRequestInfo, final int n) {
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){

            public void doWork() {
                try {
                    if (n == 0) {
                        rqstHandle.delete(sMTaskRequestInfo);
                    } else if (n == 1) {
                        rqstHandle.resume(sMTaskRequestInfo);
                    } else if (n == 2) {
                        rqstHandle.suspend(sMTaskRequestInfo);
                    }
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
                }
                statusLbl.setText(" ");
            }
        };
        ucThreadWorker.start();
    }

    class RequestTableModel
    extends CvBaseTableModel {
        final String[] columnNames = new String[]{CgUtil.getI18nMsg((String)"rqstMgr.rqstCol"), CgUtil.getI18nMsg((String)"description"), CgUtil.getI18nMsg((String)"rqstMgr.schCol"), CgUtil.getI18nMsg((String)"rqstMgr.stCol")};

        RequestTableModel() {
            this.reallocateIndexes();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRealRow(int n) {
            return this.indexes[n];
        }

        public Object getRealValueAt(int n, int n2) {
            Object object = null;
            SMTaskRequestInfo sMTaskRequestInfo = CgRequestManagerDialog.this.values[n];
            if (sMTaskRequestInfo != null) {
                object = n2 == 0 ? sMTaskRequestInfo.getName() : (n2 == 1 ? sMTaskRequestInfo.getDescription() : (n2 == 2 ? (Comparable<Boolean>)new Boolean(sMTaskRequestInfo.isScheduled()) : (Comparable<Boolean>)new Integer(sMTaskRequestInfo.getStatus())));
            }
            return object;
        }

        public int getRowCount() {
            int n = 0;
            if (CgRequestManagerDialog.this.values != null) {
                n = CgRequestManagerDialog.this.values.length;
            }
            return n;
        }
    }
}

