/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.objectgroup;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.group.SMObjectGroup;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.console.grouping.objectgroup.CgOGManagerDialog;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class CgOGPreviewDialog
extends JDialog
implements ActionListener,
Runnable {
    private JTextArea textArea;
    private JButton saveBtn;
    private JButton closeBtn;
    private JButton helpBtn;
    private JLabel statusLbl;
    JFileChooser chooser = new JFileChooser();
    SMObjectGroup handle = null;
    SMObjectGroupData objectGroup;

    public CgOGPreviewDialog(CgOGManagerDialog cgOGManagerDialog) {
        this(cgOGManagerDialog, null);
    }

    public CgOGPreviewDialog(CgOGManagerDialog cgOGManagerDialog, SMObjectGroupData sMObjectGroupData) {
        super((Frame)cgOGManagerDialog.getOwner());
        this.handle = cgOGManagerDialog.getOGHandle();
        this.createGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgOGPreviewDialog.this.close();
            }
        });
        if (sMObjectGroupData != null) {
            this.setObjectGroupData(sMObjectGroupData);
        }
        CgUtil.addDialogToPool((String)"og previewer", (JDialog)this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveBtn) {
            this.save();
        } else if (object == this.closeBtn) {
            this.close();
        } else if (object == this.helpBtn) {
            CmConsoleSession.getInstance().launchHelp("grouping-og-previewer-help");
        }
    }

    public void close() {
        CgUtil.removeDialogFromPool((String)"og previewer");
        ((Component)this).setVisible(false);
        this.dispose();
    }

    void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.textArea = new JTextArea(15, 40);
        this.textArea.setEditable(false);
        this.textArea.setBackground(jPanel.getBackground());
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.saveBtn = new JButton(CgUtil.getI18nMsg((String)"ogPreview.save"));
        this.saveBtn.addActionListener(this);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.saveBtn);
        this.closeBtn = new JButton(CgUtil.getI18nMsg((String)"standard.close"));
        this.closeBtn.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.closeBtn);
        this.helpBtn = new JButton(CgUtil.getI18nMsg((String)"standard.help"));
        this.helpBtn.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.helpBtn);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(jPanel);
        this.statusLbl = new JLabel(" ");
        this.statusLbl.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.statusLbl.setForeground(Color.black);
        jPanel3.add((Component)this.statusLbl, "South");
        this.setContentPane(jPanel3);
    }

    public void run() {
        String string = this.objectGroup.getName();
        this.setTitle(CgUtil.getI18nMsg((String)("ogPreview.title(" + string + ")")));
        this.statusLbl.setText(CgUtil.getI18nMsg((String)"ogPreview.resolving"));
        this.saveBtn.setEnabled(false);
        String[] stringArray = null;
        this.textArea.setText("");
        try {
            stringArray = this.handle.resolve(this.objectGroup);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
            this.statusLbl.setText(CgUtil.getI18nMsg((String)"ogPreview.fail"));
            return;
        }
        CgOGPreviewDialog cgOGPreviewDialog = this;
        synchronized (cgOGPreviewDialog) {
            this.textArea.setText("");
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    String string2 = stringArray[n];
                    if (n != stringArray.length - 1) {
                        string2 = String.valueOf(string2) + "\n";
                    }
                    this.textArea.append(string2);
                    ++n;
                }
            }
        }
        this.saveBtn.setEnabled(true);
        this.statusLbl.setText(" ");
    }

    void save() {
        int n = this.chooser.showSaveDialog(this);
        if (n == 0) {
            File file = this.chooser.getSelectedFile();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(this.textArea.getText().getBytes());
            }
            catch (IOException iOException) {
                UcDialog.showError((Component)this, (Object)iOException.getMessage());
                this.statusLbl.setText(CgUtil.getI18nMsg((String)"savefail"));
                return;
            }
            this.statusLbl.setText(CgUtil.getI18nMsg((String)"savesuc"));
        }
    }

    public void setObjectGroupData(SMObjectGroupData sMObjectGroupData) {
        this.objectGroup = sMObjectGroupData;
        new Thread(this).start();
    }
}

