/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMInvalidUserException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.mgmtservice.common.MSDBChangeMulticaster;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.mgmtservice.common.MSSecurityDBAccess;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.framework.MSBaseServiceInterface;
import com.sun.symon.base.mgmtservice.framework.MSServiceLocator;
import com.sun.symon.base.mgmtservice.framework.MSServiceProvider;
import com.sun.symon.base.mgmtservice.task.MtTaskConstants;
import com.sun.symon.base.mgmtservice.task.MtTaskRequest;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestDBAccess;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestQueue;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;

public class MtTaskRequestController
implements MSServiceLocator,
MSServiceProvider,
MtTaskConstants {
    private Hashtable securityMap;
    private MSProperties commands;
    private MSLogPrintWriter logWriter;
    private MSLogPrintWriter errorWriter;
    private MSDBChangeMulticaster multicaster;
    private static MtTaskRequestController theTaskRequestController;
    MtTaskRequestQueue queue;
    MtTaskRequestDBAccess dbAccess;
    MSSecurityDBAccess userAccess;

    public MtTaskRequestController(String string) {
        theTaskRequestController = this;
        this.securityMap = new Hashtable();
        this.commands = new MSProperties();
        this.multicaster = new MSDBChangeMulticaster();
        try {
            this.logWriter = MSLogPrintWriter.createChannel((String)"taskreq");
            this.logWriter.println("Task Request Controller started.");
            this.errorWriter = MSLogPrintWriter.getErrorWriter();
        }
        catch (IOException iOException) {
            System.out.println("Could not create request log");
            iOException.printStackTrace();
        }
        try {
            this.initialize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void addRequest(SMTaskRequestData sMTaskRequestData) {
        this.addRequest(new MtTaskRequest(sMTaskRequestData));
    }

    public void addRequest(MtTaskRequest mtTaskRequest) {
        this.queue.add(mtTaskRequest);
    }

    public void addTaskRequestListener(MSBaseService mSBaseService, SMDBRemoteChangeListener sMDBRemoteChangeListener) {
        this.multicaster.add(mSBaseService, sMDBRemoteChangeListener);
    }

    public synchronized void addUser(ScSecurityCredential scSecurityCredential) {
        block9: {
            ScSecurityCredential scSecurityCredential2 = (ScSecurityCredential)this.securityMap.get(scSecurityCredential.getUser());
            try {
                if (scSecurityCredential2 != null) {
                    if (!scSecurityCredential2.equals((Object)scSecurityCredential)) {
                        this.securityMap.put(scSecurityCredential.getUser(), scSecurityCredential);
                        this.userAccess.delete(scSecurityCredential.getUser());
                        this.userAccess.save(scSecurityCredential);
                    }
                    break block9;
                }
                this.securityMap.put(scSecurityCredential.getUser(), scSecurityCredential);
                try {
                    scSecurityCredential2 = this.userAccess.load(scSecurityCredential.getUser());
                }
                catch (SMNoSuchObjectException sMNoSuchObjectException) {}
                if (scSecurityCredential2 != null) {
                    if (!scSecurityCredential2.equals((Object)scSecurityCredential)) {
                        this.userAccess.delete(scSecurityCredential.getUser());
                        this.userAccess.save(scSecurityCredential);
                    }
                } else {
                    this.userAccess.save(scSecurityCredential);
                }
            }
            catch (SMDatabaseException sMDatabaseException) {
                this.errorWriter.println("Could not handle security information for user:" + scSecurityCredential.getUser(), (Throwable)sMDatabaseException);
            }
        }
    }

    public void deleteFromDatabase(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException {
        if (sMDBObjectID != null) {
            this.dbAccess.delete(sMDBObjectID);
        }
    }

    public void deleteRequest(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException {
        this.deleteFromDatabase(sMDBObjectID);
        this.queue.delete(sMDBObjectID);
        this.newEvent(sMDBObjectID, 3);
    }

    public String getClassName(String string) {
        return this.commands.getProperty(string);
    }

    public MSLogPrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public static MtTaskRequestController getInstance() {
        return theTaskRequestController;
    }

    public SMRawDataRequest getRequestHandle(String string) throws SMInvalidUserException {
        SMRawDataRequest sMRawDataRequest = new SMRawDataRequest(this.getSecurity(string));
        sMRawDataRequest.setGUIMode(false);
        return sMRawDataRequest;
    }

    public MSLogPrintWriter getRequestLogWriter() {
        return this.logWriter;
    }

    public synchronized ScSecurityCredential getSecurity(String string) throws SMInvalidUserException {
        ScSecurityCredential scSecurityCredential = null;
        scSecurityCredential = (ScSecurityCredential)this.securityMap.get(string);
        if (scSecurityCredential == null) {
            try {
                scSecurityCredential = this.userAccess.load(string);
            }
            catch (SMDatabaseException sMDatabaseException) {
                this.errorWriter.println("Could not retrieve security Info for:" + string, (Throwable)sMDatabaseException);
            }
        }
        if (scSecurityCredential == null) {
            throw new SMInvalidUserException();
        }
        return scSecurityCredential;
    }

    public MSBaseServiceInterface getService(ScSecurityCredential scSecurityCredential, String string) throws Exception {
        return new MtTaskRequestService(scSecurityCredential, string);
    }

    public static MtTaskRequestController getTaskRequestController() {
        return theTaskRequestController;
    }

    private void initialize() throws IOException {
        this.queue = MtTaskRequestQueue.getTimerQueue();
        this.dbAccess = MtTaskRequestDBAccess.getInstance();
        this.userAccess = MSSecurityDBAccess.getInstance();
        this.commands.load("com.sun.symon.base.mgmtservice.task.command");
        this.readDatabase();
    }

    public SMTaskRequestData load(SMDBObjectID sMDBObjectID) throws SMDatabaseException {
        return this.dbAccess.load(sMDBObjectID);
    }

    public SMTaskRequestData load(String string) throws SMDatabaseException {
        return this.dbAccess.load(string);
    }

    public SMTaskRequestInfo loadInfo(SMDBObjectID sMDBObjectID) throws SMDatabaseException {
        return this.dbAccess.loadInfo(sMDBObjectID);
    }

    public void newEvent(SMDBObjectID sMDBObjectID, int n) {
        this.notify(new SMDBChangeEvent(sMDBObjectID, n));
    }

    public void notify(SMDBChangeEvent sMDBChangeEvent) {
        this.multicaster.fireEvent(sMDBChangeEvent);
    }

    private void readDatabase() {
        try {
            SMTaskRequestInfo[] sMTaskRequestInfoArray = this.dbAccess.getAll();
            if (sMTaskRequestInfoArray != null && sMTaskRequestInfoArray.length != 0) {
                int n = 0;
                while (n < sMTaskRequestInfoArray.length) {
                    if ((sMTaskRequestInfoArray[n].getStatus() & 2) > 0) {
                        int n2 = sMTaskRequestInfoArray[n].getStatus() & 0xFFFFFFFD;
                        this.dbAccess.setStatus(sMTaskRequestInfoArray[n].getObjectID(), n2, "System");
                    }
                    if (sMTaskRequestInfoArray[n].isScheduled()) {
                        SMTaskRequestData sMTaskRequestData = this.dbAccess.load(sMTaskRequestInfoArray[n].getObjectID());
                        this.addRequest(sMTaskRequestData);
                    }
                    ++n;
                }
            }
        }
        catch (SMDatabaseException sMDatabaseException) {
            this.errorWriter.println("Could not read initial requests", (Throwable)sMDatabaseException);
        }
    }

    public MSServiceProvider register() {
        return this;
    }

    public void removeRequest(SMDBObjectID sMDBObjectID) {
        this.queue.remove(sMDBObjectID);
    }

    public void removeRequest(SMTaskRequestData sMTaskRequestData) {
        this.removeRequest(sMTaskRequestData.getObjectID());
    }

    public void removeSessionListeners(MSBaseService mSBaseService) {
        this.multicaster.remove(mSBaseService);
    }

    public void removeTaskRequestListener(MSBaseService mSBaseService, SMDBRemoteChangeListener sMDBRemoteChangeListener) {
        this.multicaster.remove(mSBaseService, sMDBRemoteChangeListener);
    }

    public void resume(SMDBObjectID sMDBObjectID) throws SMDatabaseException {
        SMTaskRequestData sMTaskRequestData;
        if (!this.queue.resume(sMDBObjectID) && (sMTaskRequestData = this.dbAccess.load(sMDBObjectID)) != null) {
            MtTaskRequest mtTaskRequest = new MtTaskRequest(sMTaskRequestData);
            Date date = mtTaskRequest.getStartDate();
            if (date == null) {
                mtTaskRequest.setStartDate(new Date());
            }
            mtTaskRequest.setScheduled(true);
            mtTaskRequest.resetSuspended(false);
            this.save(mtTaskRequest);
        }
    }

    public SMDBObject save(SMTaskRequestData sMTaskRequestData) throws SMDatabaseException {
        SMDBObjectID sMDBObjectID = sMTaskRequestData.getObjectID();
        if (sMDBObjectID == null) {
            sMTaskRequestData.setStatus(0);
        }
        SMDBObject sMDBObject = this.dbAccess.save(sMTaskRequestData);
        sMTaskRequestData.refresh(sMDBObject);
        if (sMDBObjectID != null) {
            this.removeRequest(sMDBObjectID);
        }
        if (sMDBObjectID == null) {
            this.newEvent(sMTaskRequestData.getObjectID(), 2);
        } else {
            this.newEvent(sMDBObjectID, 1);
        }
        if (sMTaskRequestData.isScheduled() && !sMTaskRequestData.isSuspended()) {
            this.addRequest(sMTaskRequestData);
        }
        return sMDBObject;
    }

    public void setScheduled(SMTaskRequestData sMTaskRequestData) {
        try {
            this.dbAccess.setScheduled(sMTaskRequestData.getObjectID(), sMTaskRequestData.isScheduled(), "System");
        }
        catch (SMDatabaseException sMDatabaseException) {
            this.errorWriter.println(" Database exception: " + (Object)((Object)sMDatabaseException));
        }
    }

    public void setStatus(SMTaskRequestData sMTaskRequestData) {
        try {
            this.dbAccess.setStatus(sMTaskRequestData.getObjectID(), sMTaskRequestData.getStatus(), "System");
        }
        catch (SMDatabaseException sMDatabaseException) {
            this.errorWriter.println(" Database exception: " + (Object)((Object)sMDatabaseException));
        }
        this.update(sMTaskRequestData.getObjectID());
    }

    public void suspend(SMDBObjectID sMDBObjectID) {
        this.queue.suspend(sMDBObjectID);
    }

    public void update(SMDBObjectID sMDBObjectID) {
        this.newEvent(sMDBObjectID, 1);
    }
}

