/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMInvalidTypeException;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.group.MgObjectGroupImpl;
import com.sun.symon.base.mgmtservice.group.MgObjectGroupService;
import com.sun.symon.base.mgmtservice.task.MtBaseCommand;
import com.sun.symon.base.mgmtservice.task.MtOperation;
import com.sun.symon.base.mgmtservice.task.MtTaskImpl;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestController;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestQueue;
import com.sun.symon.base.mgmtservice.task.MtTaskRunner;
import com.sun.symon.base.mgmtservice.task.MtTaskService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class MtTaskRequest
extends SMTaskRequestData {
    int testValue = 25;
    long executionTime;
    static final int LIMIT = 2000;
    boolean isMarkedForDeletion = false;
    boolean isCompleted;
    boolean isPerformed;
    Date completeDate;
    static MSLogPrintWriter logWriter = MtTaskRequestController.getInstance().getRequestLogWriter();
    static MSLogPrintWriter errorWriter;
    static MtTaskRequestController controller;
    static MtTaskRequestQueue queue;
    static final int THREAD_LIMIT = 3;
    static final int OP_NOT_INITIALIZED = 0;
    static final int OP_FAILURE = 1;
    static final int OP_SUCCESS = 2;
    static final int OP_FIRED = 3;
    static final int OP_SKIPPED = 4;
    SMRawDataRequest request;
    SMTaskData task;
    MtTaskRunner runner;
    MtOperation[] operations;
    String[] targets;
    boolean[] targetStatus;
    int[][] targetOperationStatus;
    SMTaskOperationData[] ops;

    static {
        controller = MtTaskRequestController.getInstance();
        queue = MtTaskRequestQueue.getTimerQueue();
        errorWriter = MSLogPrintWriter.getErrorWriter();
    }

    public MtTaskRequest(SMTaskRequestData sMTaskRequestData) {
        this.setObjectID(sMTaskRequestData.getObjectID());
        try {
            this.setName(sMTaskRequestData.getName());
            this.setDescription(sMTaskRequestData.getDescription());
            this.setObjectGroupName(sMTaskRequestData.getObjectGroupName());
            this.setTaskName(sMTaskRequestData.getTaskName());
            this.setScheduled(sMTaskRequestData.isScheduled());
            this.setPeriod(sMTaskRequestData.getPeriod());
            this.setPeriodUnits(sMTaskRequestData.getPeriodUnits());
            this.setStartDate(sMTaskRequestData.getStartDate());
            this.setStatus(sMTaskRequestData.getStatus());
            this.setOwner(sMTaskRequestData.getOwner());
            this.setObjectID(sMTaskRequestData.getObjectID());
            this.setUpdatedBy(sMTaskRequestData.getUpdatedBy());
            this.setTimestamp(sMTaskRequestData.getTimestamp());
            this.setCreatedDate(sMTaskRequestData.getCreatedDate());
        }
        catch (SMLengthException sMLengthException) {}
    }

    public MtTaskRequest(String string) {
        try {
            this.setName(string);
        }
        catch (SMLengthException sMLengthException) {}
        this.setScheduled(true);
    }

    void buildOperations() throws SMAPIException {
        this.ops = this.task.getOperations();
        Vector<MtOperation> vector = new Vector<MtOperation>();
        int n = 0;
        int n2 = 0;
        while (n2 < this.ops.length) {
            String string = this.ops[n2].getOperation();
            String string2 = controller.getClassName(string).trim();
            if (string2 == null) {
                throw new SMInvalidTypeException();
            }
            try {
                Class<?> clazz = Class.forName(string2);
                Object obj = clazz.newInstance();
                if (!(obj instanceof MtBaseCommand)) {
                    throw new SMInvalidTypeException("Class does not extend base command class");
                }
                MtBaseCommand mtBaseCommand = (MtBaseCommand)obj;
                MtOperation mtOperation = new MtOperation(mtBaseCommand);
                mtOperation.setIndex(n);
                mtOperation.setRequest(this);
                vector.addElement(mtOperation);
                n2 = mtBaseCommand.consume(this.ops, n2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SMInvalidTypeException((Exception)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new SMInvalidTypeException((Exception)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SMInvalidTypeException((Exception)illegalAccessException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SMInvalidTypeException((Exception)noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SMInvalidTypeException((Exception)invocationTargetException);
            }
            ++n;
        }
        int n3 = vector.size();
        this.operations = new MtOperation[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.operations[n4] = (MtOperation)vector.elementAt(n4);
            ++n4;
        }
    }

    synchronized void checkStatus() {
        int n = 0;
        while (n < this.targetStatus.length) {
            if (!this.targetStatus[n]) {
                return;
            }
            ++n;
        }
        this.isCompleted = true;
        if (this.isPerformed) {
            this.complete();
            this.runner.done();
            this.runner = null;
        }
    }

    public void clearMissed() {
        ((SMTaskRequestInfo)this).status ^= 0x20;
        controller.setStatus(this);
    }

    void complete() {
        this.setCompleteDate(new Date());
        this.isCompleted = true;
        queue.requestDone(this.getObjectID());
        if (this.request != null) {
            this.request.disconnect();
            this.request = null;
        }
        this.task = null;
        this.operations = null;
        this.ops = null;
        logWriter.print("Request " + this.getName() + " completed with status ");
        if (!this.isFailure()) {
            logWriter.println("- SUCCESS");
        } else {
            logWriter.println("- FAILURE");
        }
        try {
            this.resetRunning();
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println(" Database exception: " + (Object)((Object)sMDatabaseException));
        }
        if (this.isPeriodic()) {
            controller.addRequest(this);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof MtTaskRequest) {
            MtTaskRequest mtTaskRequest = (MtTaskRequest)((Object)object);
            return this.getObjectID().equals((Object)mtTaskRequest.getObjectID());
        }
        if (object instanceof SMDBObjectID) {
            return this.getObjectID().equals(object);
        }
        return false;
    }

    public void execute(MtTaskRunner mtTaskRunner) throws SMAPIException {
        Object object;
        int n;
        int n2;
        this.runner = mtTaskRunner;
        this.isCompleted = false;
        this.isPerformed = false;
        this.setRunning();
        logWriter.println("Request " + this.getName() + " started");
        try {
            this.instantiateRequest();
        }
        catch (SMAPIException sMAPIException) {
            logWriter.print("Request" + this.getName() + " has failed.");
            logWriter.print(" Exception was thrown: " + sMAPIException.getMessage());
            errorWriter.println("Could not construct request", (Throwable)sMAPIException);
            this.setFailure();
            this.complete();
            mtTaskRunner.done();
            mtTaskRunner = null;
            throw sMAPIException;
        }
        if (this.targets != null && this.targets.length != 0) {
            logWriter.print(" Result of resolve operation:\n");
            n2 = 0;
            while (n2 < this.targets.length) {
                logWriter.print("\t\t" + this.targets[n2]);
                ++n2;
            }
        } else {
            logWriter.print("Request" + this.getName() + " has no targets.");
            this.complete();
            mtTaskRunner.done();
            mtTaskRunner = null;
            return;
        }
        logWriter.println("");
        try {
            this.buildOperations();
        }
        catch (SMAPIException sMAPIException) {
            logWriter.print("Request" + this.getName() + " has failed.");
            logWriter.print(" Exception was thrown: " + sMAPIException.getMessage());
            errorWriter.println("Could not construct request", (Throwable)sMAPIException);
            this.setFailure();
            this.complete();
            mtTaskRunner.done();
            mtTaskRunner = null;
            throw sMAPIException;
        }
        this.targetStatus = new boolean[this.targets.length];
        this.targetOperationStatus = new int[this.targets.length][this.operations.length];
        n2 = 0;
        while (n2 < this.targets.length) {
            n = 0;
            while (n < this.operations.length) {
                this.targetOperationStatus[n2][n] = 0;
                ++n;
            }
            ++n2;
        }
        n = 3;
        if (this.targets.length < 3) {
            n = this.targets.length;
        }
        TargetThread[] targetThreadArray = new TargetThread[n];
        int n3 = 0;
        while (n3 < n) {
            targetThreadArray[n3] = new TargetThread(n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.targets.length) {
            String string = this.targets[n4];
            object = null;
            while (true) {
                int n5 = 0;
                while (n5 < n) {
                    if (targetThreadArray[n5].isAvailable()) {
                        object = targetThreadArray[n5];
                        break;
                    }
                    ++n5;
                }
                if (object != null) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ((TargetThread)object).exec(string, n4);
            ++n4;
        }
        int n6 = 0;
        while (n6 < n) {
            targetThreadArray[n6].markForDelete();
            ++n6;
        }
        object = this;
        synchronized (object) {
            this.isPerformed = true;
            if (this.isCompleted) {
                this.complete();
                mtTaskRunner.done();
                mtTaskRunner = null;
            }
        }
    }

    private void executeTarget(String string, int n) {
        int n2 = 0;
        while (this.operations != null && n2 < this.operations.length) {
            MtOperation mtOperation = this.operations[n2];
            try {
                if (this.isTargetError(n)) {
                    this.targetOperationStatus[n][n2] = 4;
                } else {
                    this.targetOperationStatus[n][n2] = 3;
                    mtOperation.doit(string, n);
                }
            }
            catch (Exception exception) {
                this.logOperationFailure(n2, n, exception);
            }
            ++n2;
        }
        this.verifyTarget(n);
    }

    public SMTaskRequestData export2Client() {
        SMTaskRequestData sMTaskRequestData = new SMTaskRequestData(this.getObjectID());
        try {
            sMTaskRequestData.setName(this.getName());
            sMTaskRequestData.setDescription(this.getDescription());
            sMTaskRequestData.setObjectGroupName(this.getObjectGroupName());
            sMTaskRequestData.setTaskName(this.getTaskName());
            sMTaskRequestData.setScheduled(this.isScheduled());
            sMTaskRequestData.setPeriod(this.getPeriod());
            sMTaskRequestData.setPeriodUnits(this.getPeriodUnits());
            sMTaskRequestData.setStartDate(this.getStartDate());
            sMTaskRequestData.setStatus(this.getStatus());
        }
        catch (SMLengthException sMLengthException) {}
        return sMTaskRequestData;
    }

    public Date getCompleteDate() {
        return this.completeDate;
    }

    public long getExecTime() {
        return this.executionTime;
    }

    public SMRawDataRequest getRawDataRequest() throws SMAPIException {
        if (this.request == null) {
            this.request = controller.getRequestHandle(this.getOwner());
        }
        return this.request;
    }

    public void initiate() {
        this.reschedule();
    }

    private void instantiateRequest() throws SMAPIException {
        logWriter.println("Start request:" + this.getName() + " task:" + this.getTaskName() + " objectGroup:" + this.getObjectGroupName() + " Owner:" + this.getOwner());
        ScSecurityCredential scSecurityCredential = controller.getSecurity(this.getOwner());
        try {
            MtTaskImpl mtTaskImpl = MtTaskService.getTaskImpl(scSecurityCredential);
            this.task = mtTaskImpl.load(this.getTaskName());
            MgObjectGroupImpl mgObjectGroupImpl = MgObjectGroupService.getObjectGroupImpl(scSecurityCredential);
            SMObjectGroupData sMObjectGroupData = mgObjectGroupImpl.load(this.getObjectGroupName());
            this.targets = mgObjectGroupImpl.resolve(sMObjectGroupData);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException("Could not resolve task/group", throwable);
        }
    }

    public boolean isCompleted() {
        if ((((SMTaskRequestInfo)this).status & 0x10) != 0) {
            return true;
        }
        return (((SMTaskRequestInfo)this).status & 8) != 0;
    }

    private boolean isTargetError(int n) {
        int n2 = 0;
        while (n2 < this.operations.length) {
            if (this.targetOperationStatus[n][n2] == 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void logOperationFailure(int n, int n2, Throwable throwable) {
        logWriter.print("Operation " + this.ops[n].getOperation());
        logWriter.print(" has failed on target:" + this.targets[n2]);
        String string = throwable.getMessage();
        logWriter.println(" Exception was thrown: " + throwable);
        if (string != null) {
            logWriter.println(" Exception message: " + string);
        }
        errorWriter.println("Operation failed on target:" + this.targets[n2], throwable);
        this.setFailure();
    }

    public synchronized void operationComplete(int n, int n2, SMAPIException sMAPIException) {
        if (sMAPIException != null) {
            this.targetOperationStatus[n2][n] = 1;
            this.logOperationFailure(n, n2, sMAPIException);
        } else {
            this.targetOperationStatus[n2][n] = 2;
        }
        this.verifyTarget(n2);
    }

    public boolean reschedule() {
        if (!this.isScheduled() || this.isSuspended() || this.isMarkedForDeletion) {
            return false;
        }
        Date date = this.getStartDate();
        if (date == null) {
            return false;
        }
        long l = date.getTime();
        long l2 = new Date().getTime();
        if (!this.isPeriodic()) {
            if (l < l2 - 2000L) {
                if (!this.isCompleted()) {
                    logWriter.println("Request:" + ((SMTaskRequestInfo)this).name + " was missed" + new Date(l));
                    this.setMissed();
                }
                return false;
            }
            this.setExecTime(l);
            if (this.isMissed()) {
                this.clearMissed();
            }
            logWriter.println("Request:" + ((SMTaskRequestInfo)this).name + " Next exec.time is:" + new Date(l));
            return true;
        }
        if (this.isMissed()) {
            this.clearMissed();
        }
        long l3 = this.getStartTime();
        int n = this.getPeriodUnits();
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 60000;
                break;
            }
            case 2: {
                n2 = 3600000;
                break;
            }
            case 3: {
                n2 = 86400000;
                break;
            }
            case 4: {
                n2 = 604800000;
                break;
            }
            case 5: {
                Date date2;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(this.getStartDate());
                while (true) {
                    if ((date2 = gregorianCalendar.getTime()).getTime() > l2) break;
                    gregorianCalendar.add(2, (int)this.getPeriod());
                }
                this.setExecTime(date2.getTime());
                logWriter.println("Request:" + ((SMTaskRequestInfo)this).name + " Next exec.time is:" + new Date(this.executionTime));
                return true;
            }
        }
        if (n2 > 0) {
            if (l2 > l3) {
                long l4 = (l2 - l3) / (this.getPeriod() * (long)n2) + 1L;
                this.setExecTime(l3 + l4 * this.getPeriod() * (long)n2);
            } else {
                this.setExecTime(l3);
            }
            logWriter.println("Request:" + ((SMTaskRequestInfo)this).name + " Next exec.time is:" + new Date(this.executionTime));
        }
        return true;
    }

    public void resetRunning() throws SMDatabaseException {
        if (!this.isFailure()) {
            ((SMTaskRequestInfo)this).status |= 8;
        }
        ((SMTaskRequestInfo)this).status ^= 2;
        if (!this.isPeriodic()) {
            this.setScheduled(false);
            controller.setScheduled(this);
        }
        controller.setStatus(this);
    }

    public void resetSuspended() {
        this.resetSuspended(true);
    }

    public void resetSuspended(boolean bl) {
        ((SMTaskRequestInfo)this).status &= 0xFFFFFFFB;
        if (bl) {
            controller.setStatus(this);
        }
    }

    public void setCompleteDate(Date date) {
        this.completeDate = date;
    }

    public void setExecTime(long l) {
        this.executionTime = l;
    }

    public void setExecTime(Date date) {
        this.executionTime = date.getTime();
    }

    public void setFailure() {
        ((SMTaskRequestInfo)this).status |= 0x10;
        controller.setStatus(this);
    }

    public void setMarkForDeletion() {
        this.isMarkedForDeletion = true;
    }

    public void setMissed() {
        ((SMTaskRequestInfo)this).status |= 0x20;
        this.setScheduled(false);
        controller.setScheduled(this);
        controller.setStatus(this);
    }

    public void setRunning() {
        ((SMTaskRequestInfo)this).status |= 2;
        ((SMTaskRequestInfo)this).status &= 0xFFFFFFE7;
        controller.setStatus(this);
    }

    public void setSuspended() {
        ((SMTaskRequestInfo)this).status |= 4;
        controller.setStatus(this);
    }

    void simulate() {
        try {
            this.task = new SMTaskData();
            this.task.setName("foo");
            this.task.setDescription("foo description");
            SMTaskOperationData[] sMTaskOperationDataArray = new SMTaskOperationData[2];
            int n = -1;
            sMTaskOperationDataArray[++n] = new SMTaskOperationData();
            sMTaskOperationDataArray[n].setOperation("set");
            sMTaskOperationDataArray[n].setValue(Integer.toString(this.testValue++));
            sMTaskOperationDataArray[n].setValueType("com.sun.symon.base.server.types.StString");
            sMTaskOperationDataArray[n].setOperand("/mod/kernel-reader/user/numUsers?alarmlimits.warning-gt#0");
            sMTaskOperationDataArray[++n] = new SMTaskOperationData();
            sMTaskOperationDataArray[n].setOperation("set");
            sMTaskOperationDataArray[n].setValue(Integer.toString(10 + this.testValue++));
            sMTaskOperationDataArray[n].setValueType("com.sun.symon.base.server.types.StString");
            sMTaskOperationDataArray[n].setOperand("/mod/mib2-simple/system/sysContact#0");
            this.task.setOperations(sMTaskOperationDataArray);
            this.targets = new String[1];
            this.targets[0] = "hermitage:161";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(" Exec.Time:" + this.executionTime + "\n");
        return stringBuffer.toString();
    }

    synchronized void verifyTarget(int n) {
        boolean bl = true;
        if (this.isCompleted) {
            return;
        }
        int n2 = 0;
        while (n2 < this.operations.length) {
            int n3 = this.targetOperationStatus[n][n2];
            if (n3 == 3 || n3 == 0) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            this.targetStatus[n] = true;
            this.checkStatus();
        }
    }

    class TargetThread
    extends Thread {
        boolean isAvailable = true;
        boolean isRunning = false;
        String target;
        int targetIndex;
        boolean isDeleted = false;

        TargetThread(int n) {
            super("Parallel:" + n);
        }

        void exec(String string, int n) {
            this.targetIndex = n;
            this.isAvailable = false;
            this.target = string;
            if (!this.isRunning) {
                this.start();
            }
        }

        boolean isAvailable() {
            return this.isAvailable;
        }

        void markForDelete() {
            this.isDeleted = true;
        }

        public void run() {
            this.isRunning = true;
            block2: while (true) {
                MtTaskRequest.this.executeTarget(this.target, this.targetIndex);
                this.target = null;
                this.isAvailable = true;
                do {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    if (!this.isAvailable) continue block2;
                } while (!this.isDeleted);
                break;
            }
        }
    }
}

