/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.mcp;

import com.sun.symon.base.client.mcp.SMMCPSyncException;
import com.sun.symon.base.client.mcp.SMParcelData;
import com.sun.symon.base.client.mcp.SMParcelInfo;
import com.sun.symon.base.client.mcp.SMRemoteMCP;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBConcurrencyTimestamp;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.mcp.MmMCPService;
import com.sun.symon.base.mgmtservice.mcp.MmMCPTrigger;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import oracle.jdbc.driver.OracleResultSet;

public class MmMCPImpl
extends MSBaseService
implements SMRemoteMCP {
    private static final String SP_DELETEPARCEL = "{call DELETEPARCEL(?)}";
    private static final int SP_DELETEPARCEL_MCP_PARCEL_ID = 1;
    private static final String SP_GETALLPARCELS = "{call GETALLPARCELS(?)}";
    private static final int SP_GETALLPARCELS_CSR = 1;
    private static final String SP_GETPARCEL = "{call GETPARCEL(?,?,?)}";
    private static final int SP_GETPARCEL_MCP_PARCEL_ID = 1;
    private static final int SP_GETPARCEL_MCP_PARCEL_NAME = 2;
    private static final int SP_GETPARCEL_CSR = 3;
    private static final String SP_UPDATEPARCEL = "{call UPDATEPARCEL(?,?,?,?,?,?,?,?,?,?)}";
    private static final int SP_UPDATEPARCEL_MCP_PARCEL_ID = 1;
    private static final int SP_UPDATEPARCEL_NAME = 2;
    private static final int SP_UPDATEPARCEL_DESCRIPTION = 3;
    private static final int SP_UPDATEPARCEL_PARCEL_TYPE = 4;
    private static final int SP_UPDATEPARCEL_HOST = 5;
    private static final int SP_UPDATEPARCEL_PORT = 6;
    private static final int SP_UPDATEPARCEL_UPDATED_BY = 7;
    private static final int SP_UPDATEPARCEL_SYNC_DATE = 8;
    private static final int SP_UPDATEPARCEL_TIMESTAMP = 9;
    private static final int SP_UPDATEPARCEL_CREATED_DATE = 10;
    private static final String SP_DELETEPARCELMODULE = "{call DELETEPARCELMODULE(?)}";
    private static final int SP_DELETEPARCELMODULE_MCP_PARCEL_ID = 1;
    private static final String SP_GETPARCELMODULE = "{call GETPARCELMODULE(?,?)}";
    private static final int SP_GETPARCELMODULE_MCP_PARCEL_ID = 1;
    private static final int SP_GETPARCELMODULE_CSR = 2;
    private static final String SP_UPDATEPARCELMODULE = "{call UPDATEPARCELMODULE(?,?)}";
    private static final int SP_UPDATEPARCELMODULE_MCP_PARCEL_ID = 1;
    private static final int SP_UPDATEPARCELMODULE_MODULE = 2;

    public MmMCPImpl(String string, ScSecurityCredential scSecurityCredential) throws RemoteException {
        super(string, scSecurityCredential);
    }

    public MmMCPImpl(String string, ScSecurityCredential scSecurityCredential, String string2) throws RemoteException {
        super(string, scSecurityCredential, string2);
    }

    public void addEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
        MmMCPService.getMCPChangeMulticaster().add((MSBaseService)this, sMDBRemoteChangeListener);
    }

    public void cleanup() {
        MmMCPService.getMCPChangeMulticaster().remove((MSBaseService)this);
    }

    public void delete(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        Object object;
        if (!"MCP_PARCEL".equals(sMDBObjectID.getType())) {
            throw new SMDatabaseException(String.valueOf(String.valueOf(sMDBObjectID)) + " is meant for another table");
        }
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "delete", this.getUserSecurityCredential(), sMDBObjectID);
        try {
            object = this.load(sMDBObjectID);
            MmMCPTrigger mmMCPTrigger = new MmMCPTrigger();
            mmMCPTrigger.delete((SMParcelData)object, this.getUserSecurityCredential());
        }
        catch (Exception exception) {
            MSLogPrintWriter.getErrorWriter().println((Throwable)exception);
        }
        object = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = object.prepareCall(SP_DELETEPARCEL);
                callableStatement.setLong(1, sMDBObjectID.getID());
                callableStatement.execute();
                callableStatement.close();
                object.commit();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)object);
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    throw new SMStaleDataException((Throwable)sQLException);
                }
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    throw new SMNoSuchObjectException((Throwable)sQLException);
                }
                throw new SMDatabaseException((Throwable)sQLException);
            }
            catch (Exception exception) {
                MSDB.rollback((Connection)object);
                throw new SMDatabaseException((Throwable)exception);
            }
            Object var4_9 = null;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            MSDB.closeConnection((Connection)object);
            throw throwable;
        }
        MSDB.closeConnection((Connection)object);
        MmMCPService.getMCPChangeMulticaster().fireEvent(new SMDBChangeEvent(sMDBObjectID, 3));
    }

    private void deleteParcelModules(Connection connection, SMDBObjectID sMDBObjectID) throws SQLException, SMDatabaseException {
        if (!"MCP_PARCEL".equals(sMDBObjectID.getType())) {
            throw new SMDatabaseException(String.valueOf(String.valueOf(sMDBObjectID)) + " is meant for another table");
        }
        CallableStatement callableStatement = connection.prepareCall(SP_DELETEPARCELMODULE);
        callableStatement.setLong(1, sMDBObjectID.getID());
        callableStatement.execute();
        callableStatement.close();
    }

    private void fireEventForSave(SMDBObject sMDBObject, SMDBObject sMDBObject2) {
        int n = sMDBObject.getObjectID() == null ? 2 : 1;
        MmMCPService.getMCPChangeMulticaster().fireEvent(new SMDBChangeEvent(sMDBObject2.getObjectID(), n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMParcelInfo[] getAll() throws RemoteException, SMSecurityException, SMDatabaseException {
        Object[] objectArray;
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "getAll", this.getUserSecurityCredential());
        Connection connection = MSDB.getConnection();
        Vector<SMParcelInfo> vector = new Vector<SMParcelInfo>();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETALLPARCELS);
                callableStatement.registerOutParameter(1, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(1);
                while (true) {
                    if (!oracleResultSet.next()) {
                        callableStatement.close();
                        Object[] objectArray2 = new SMParcelInfo[vector.size()];
                        vector.copyInto(objectArray2);
                        objectArray = objectArray2;
                        Object var5_10 = null;
                        break;
                    }
                    SMParcelInfo sMParcelInfo = new SMParcelInfo(new SMDBObjectID(oracleResultSet.getLong("MCP_PARCEL_ID"), "MCP_PARCEL"), oracleResultSet.getString("NAME"), oracleResultSet.getString("DESCRIPTION"), oracleResultSet.getInt("PARCEL_TYPE"), (Date)oracleResultSet.getTimestamp("SYNC_DATE"));
                    sMParcelInfo.setChanged(false);
                    vector.addElement(sMParcelInfo);
                }
            }
            catch (SQLException sQLException) {
                throw new SMDatabaseException((Throwable)sQLException);
            }
            catch (Exception exception) {
                throw new SMDatabaseException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public SMParcelData load(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        if (!"MCP_PARCEL".equals(sMDBObjectID.getType())) {
            throw new SMDatabaseException(String.valueOf(String.valueOf(sMDBObjectID)) + " is meant for another table");
        }
        return this.loadImpl(sMDBObjectID, null);
    }

    public SMParcelData load(String string) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        return this.loadImpl(null, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SMParcelData loadImpl(SMDBObjectID sMDBObjectID, String string) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        SMParcelData sMParcelData;
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "load", this.getUserSecurityCredential(), sMDBObjectID);
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETPARCEL);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)string);
                callableStatement.registerOutParameter(3, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                if (!oracleResultSet.next()) {
                    callableStatement.close();
                    throw new SMNoSuchObjectException("record not found: id=" + sMDBObjectID + ", name=" + string);
                }
                if (sMDBObjectID == null) {
                    sMDBObjectID = new SMDBObjectID(oracleResultSet.getLong("MCP_PARCEL_ID"), "MCP_PARCEL");
                }
                SMParcelData sMParcelData2 = new SMParcelData(sMDBObjectID);
                sMParcelData2.setName(oracleResultSet.getString("NAME"));
                sMParcelData2.setDescription(oracleResultSet.getString("DESCRIPTION"));
                sMParcelData2.setParcelType(oracleResultSet.getInt("PARCEL_TYPE"));
                sMParcelData2.setHost(oracleResultSet.getString("HOST"));
                sMParcelData2.setPort(oracleResultSet.getInt("PORT"));
                sMParcelData2.setUpdatedBy(oracleResultSet.getString("UPDATED_BY"));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(oracleResultSet.getTimestamp("SYNC_DATE"));
                sMParcelData2.setSyncDate(calendar.getTime());
                sMParcelData2.setTimestamp(new SMDBConcurrencyTimestamp(oracleResultSet.getTimestamp("TIMESTAMP")));
                sMParcelData2.setCreatedDate(oracleResultSet.getTimestamp("CREATED_DATE"));
                callableStatement.close();
                Vector<String> vector = new Vector<String>();
                callableStatement = connection.prepareCall(SP_GETPARCELMODULE);
                callableStatement.setLong(1, sMDBObjectID.getID());
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                while (true) {
                    if (!oracleResultSet.next()) {
                        callableStatement.close();
                        Object[] objectArray = new String[vector.size()];
                        vector.copyInto(objectArray);
                        sMParcelData2.setModules((String[])objectArray);
                        sMParcelData2.setChanged(false);
                        sMParcelData = sMParcelData2;
                        Object var6_14 = null;
                        break;
                    }
                    vector.addElement(oracleResultSet.getString("MODULE"));
                }
            }
            catch (SQLException sQLException) {
                throw new SMDatabaseException((Throwable)sQLException);
            }
            catch (SMDatabaseException sMDatabaseException) {
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                throw new SMDatabaseException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMParcelData;
    }

    public void removeEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
        MmMCPService.getMCPChangeMulticaster().remove((MSBaseService)this, sMDBRemoteChangeListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMParcelInfo save(SMParcelData sMParcelData, boolean bl) throws RemoteException, SMSecurityException, SMMCPSyncException, SMStaleDataException, SMNoSuchObjectException, SMDatabaseException, SMDuplicateException {
        SMParcelInfo sMParcelInfo;
        Connection connection;
        block11: {
            SMParcelInfo sMParcelInfo2;
            block10: {
                MSLogPrintWriter.getDebugWriter().println((Object)sMParcelData);
                MSSecurity.getInstance().checkAccess(this.getServiceName(), "save", this.getUserSecurityCredential());
                if (bl) {
                    MSSecurity.getInstance().checkAccess(this.getServiceName(), "sync", this.getUserSecurityCredential());
                }
                connection = MSDB.getConnection();
                try {
                    try {
                        SMParcelInfo sMParcelInfo3 = this.saveImpl(connection, sMParcelData);
                        if (!bl) {
                            connection.commit();
                            this.fireEventForSave((SMDBObject)sMParcelData, (SMDBObject)sMParcelInfo3);
                            sMParcelInfo2 = sMParcelInfo3;
                            Object var6_10 = null;
                            break block10;
                        }
                        MmMCPTrigger mmMCPTrigger = new MmMCPTrigger();
                        mmMCPTrigger.publish(sMParcelData, this.getUserSecurityCredential());
                        sMParcelData.setSyncDate(new Date());
                        sMParcelData.refresh((SMDBObject)sMParcelInfo3);
                        sMParcelInfo3 = this.saveImpl(connection, sMParcelData);
                        connection.commit();
                        this.fireEventForSave((SMDBObject)sMParcelData, (SMDBObject)sMParcelInfo3);
                        sMParcelInfo = sMParcelInfo3;
                        break block11;
                    }
                    catch (SMMCPSyncException sMMCPSyncException) {
                        MSLogPrintWriter.getErrorWriter().println((Throwable)sMMCPSyncException);
                        MSDB.rollback((Connection)connection);
                        throw sMMCPSyncException;
                    }
                    catch (SQLException sQLException) {
                        MSDB.rollback((Connection)connection);
                        if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                            throw new SMStaleDataException((Throwable)sQLException);
                        }
                        if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                            throw new SMNoSuchObjectException((Throwable)sQLException);
                        }
                        if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") < 0) throw new SMDatabaseException((Throwable)sQLException);
                        throw new SMDuplicateException((Throwable)sQLException);
                    }
                    catch (Exception exception) {
                        MSDB.rollback((Connection)connection);
                        throw new SMDatabaseException((Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    MSDB.closeConnection((Connection)connection);
                    throw throwable;
                }
            }
            MSDB.closeConnection((Connection)connection);
            return sMParcelInfo2;
        }
        Object var6_11 = null;
        MSDB.closeConnection((Connection)connection);
        return sMParcelInfo;
    }

    private SMParcelInfo saveImpl(Connection connection, SMParcelData sMParcelData) throws SQLException, SMLengthException, SMDatabaseException {
        CallableStatement callableStatement = connection.prepareCall(SP_UPDATEPARCEL);
        MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMParcelData.getObjectID());
        callableStatement.setString(2, sMParcelData.getName().trim());
        callableStatement.setString(3, sMParcelData.getDescription());
        callableStatement.setInt(4, sMParcelData.getParcelType());
        callableStatement.setString(5, sMParcelData.getHost());
        callableStatement.setInt(6, sMParcelData.getPort());
        MSDB.setNullable((PreparedStatement)callableStatement, (int)8, (Date)sMParcelData.getSyncDate());
        callableStatement.setString(7, this.getUserSecurityCredential().getUser());
        MSDB.setNullable((PreparedStatement)callableStatement, (int)9, (SMDBConcurrencyTimestamp)sMParcelData.getTimestamp());
        MSDB.setNullable((PreparedStatement)callableStatement, (int)10, (Timestamp)sMParcelData.getCreatedDate());
        callableStatement.registerOutParameter(1, 4);
        callableStatement.registerOutParameter(9, 93);
        callableStatement.registerOutParameter(10, 93);
        callableStatement.execute();
        SMParcelInfo sMParcelInfo = new SMParcelInfo(new SMDBObjectID(callableStatement.getLong(1), "MCP_PARCEL"), sMParcelData.getName(), sMParcelData.getDescription(), sMParcelData.getParcelType(), sMParcelData.getSyncDate());
        sMParcelInfo.setUpdatedBy(this.getUserSecurityCredential().getUser());
        sMParcelInfo.setTimestamp(new SMDBConcurrencyTimestamp(callableStatement.getTimestamp(9)));
        sMParcelInfo.setCreatedDate(callableStatement.getTimestamp(10));
        callableStatement.close();
        this.deleteParcelModules(connection, sMParcelInfo.getObjectID());
        this.updateParcelModules(connection, sMParcelInfo.getObjectID(), sMParcelData.getModules());
        return sMParcelInfo;
    }

    public Date sync(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMMCPSyncException, SMNoSuchObjectException, SMDatabaseException {
        if (!"MCP_PARCEL".equals(sMDBObjectID.getType())) {
            throw new SMDatabaseException(String.valueOf(String.valueOf(sMDBObjectID)) + " is meant for another table");
        }
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "sync", this.getUserSecurityCredential(), sMDBObjectID);
        SMParcelData sMParcelData = this.load(sMDBObjectID);
        MmMCPTrigger mmMCPTrigger = new MmMCPTrigger();
        try {
            mmMCPTrigger.publish(sMParcelData, this.getUserSecurityCredential());
        }
        catch (SMMCPSyncException sMMCPSyncException) {
            MSLogPrintWriter.getErrorWriter().println((Throwable)sMMCPSyncException);
            throw sMMCPSyncException;
        }
        Date date = new Date();
        sMParcelData.setSyncDate(date);
        try {
            this.save(sMParcelData, false);
        }
        catch (Exception exception) {}
        return date;
    }

    private void updateParcelModules(Connection connection, SMDBObjectID sMDBObjectID, String[] stringArray) throws SQLException, SMDatabaseException {
        if (!"MCP_PARCEL".equals(sMDBObjectID.getType())) {
            throw new SMDatabaseException(String.valueOf(String.valueOf(sMDBObjectID)) + " is meant for another table");
        }
        int n = 0;
        while (n < stringArray.length) {
            CallableStatement callableStatement = connection.prepareCall(SP_UPDATEPARCELMODULE);
            callableStatement.setLong(1, sMDBObjectID.getID());
            callableStatement.setString(2, stringArray[n]);
            callableStatement.execute();
            callableStatement.close();
            ++n;
        }
    }
}

