/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.security.SySecurity;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.license.SlLicService;
import com.sun.symon.base.server.lookup.SlLookupService;
import com.sun.symon.base.server.receptors.rmi.RMIProbeImpl;
import com.sun.symon.base.server.receptors.rmi.RMIProbeInterface;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMISessionServiceInterface;
import com.sun.symon.base.server.receptors.rmi.SrRMIReceptor;
import com.sun.symon.base.server.receptors.rmi.SrRMISecurity;
import com.sun.symon.base.server.receptors.rmi.SrRMISession;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.Vector;

public class SrRMISessionService
extends SrRMISession
implements RMISessionServiceInterface {
    boolean alternateFlag;
    String alternateHost = null;
    Vector probes = new Vector();
    private boolean sunHostOnly = true;

    SrRMISessionService(SySecurity sySecurity, SrRMIReceptor srRMIReceptor, RMIResponseInterface rMIResponseInterface, SrRMISecurity srRMISecurity, String string) throws RemoteException {
        super(sySecurity, srRMIReceptor, rMIResponseInterface, srRMISecurity, string);
        this.alternateFlag = false;
        this.sunHostOnly = this.Receptor.isSunHostOnly();
    }

    SrRMISessionService(SySecurity sySecurity, SrRMIReceptor srRMIReceptor, RMIResponseInterface rMIResponseInterface, SrRMISecurity srRMISecurity, String string, String string2) throws RemoteException {
        super(sySecurity, srRMIReceptor, rMIResponseInterface, srRMISecurity, string, string2);
        this.alternateFlag = true;
        this.alternateHost = string2;
        this.sunHostOnly = this.Receptor.isSunHostOnly();
    }

    protected void clientDied() {
        super.clientDied();
        this.removeSession();
        SrRMISessionService srRMISessionService = this;
        synchronized (srRMISessionService) {
            int n = this.probes.size();
            int n2 = 0;
            while (n2 < n) {
                try {
                    RMIProbeImpl rMIProbeImpl = (RMIProbeImpl)this.probes.elementAt(n2);
                    rMIProbeImpl.close();
                }
                catch (Throwable throwable) {}
                ++n2;
            }
            this.probes.clear();
        }
    }

    public String getAlternateHost() {
        return this.alternateHost;
    }

    public int getModuleLicense() throws RemoteException {
        try {
            return SlLicService.chkModuleLicense((ScSecurityCredential)this.getUserSecurityCredential());
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage());
        }
    }

    public Vector[] getPackLicenseInfo() throws RemoteException {
        try {
            return SlLicService.chkLicenseTable((ScSecurityCredential)this.getUserSecurityCredential());
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage());
        }
    }

    public RMIProbeInterface getProbeService() throws RemoteException {
        RMIProbeImpl rMIProbeImpl = null;
        rMIProbeImpl = !this.alternateFlag ? new RMIProbeImpl() : new RMIProbeImpl(this.alternateHost);
        this.probes.addElement(rMIProbeImpl);
        return (RMIProbeInterface)RemoteObject.toStub(rMIProbeImpl);
    }

    public Object getService(String string, String[] stringArray) throws RemoteException {
        Object object = null;
        try {
            this.checkSecurity();
            object = SlLookupService.lookup((String)string, (String[])stringArray, (SrRMISessionService)this);
        }
        catch (Exception exception) {
            throw new RemoteException("ServerSession: getService: " + exception.getMessage());
        }
        return object;
    }

    public int getServiceLicense(String string) throws RemoteException {
        try {
            return SlLicService.chkServiceLicense((ScSecurityCredential)this.getUserSecurityCredential());
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage());
        }
    }

    public String[] getServices() throws RemoteException {
        String[] stringArray = null;
        try {
            this.checkSecurity();
            stringArray = SlLookupService.listServices();
        }
        catch (Exception exception) {
            throw new RemoteException("ServerSession: getService: " + exception.getMessage());
        }
        return stringArray;
    }

    public ScSecurityCredential getUserSecurityInfo() {
        return this.getUserSecurityCredential();
    }

    public boolean isAlternateHostAvailable() {
        return this.alternateFlag;
    }

    public Boolean isLicenseAvailable(String string) throws RemoteException {
        try {
            this.checkSecurity();
            Boolean bl = SlLookupService.isLicenseAvailable((String)string);
            return bl;
        }
        catch (Exception exception) {
            throw new RemoteException("ServerSession: getService: " + exception.getMessage());
        }
    }

    public boolean isSunHostOnly() {
        return this.sunHostOnly;
    }

    public void removeSession() {
        try {
            SlLookupService.removeSession((SrRMISessionService)this);
        }
        catch (Exception exception) {
            System.out.println("removeSession(): " + exception.getMessage());
        }
    }
}

