#
# NOTE:   ORACLE_HOME must be either:
#               . set in the user's environment
#               . passed in on the command line
#               . defined in a modified version of this makefile
#
include $(ORACLE_HOME)/otrace/lib/env_otrace.mk

PRODLIBHOME=$(ORACLE_HOME)/otrace/lib/
RDBMSLIB=$(ORACLE_HOME)/rdbms/lib/
LDCCOM=$(LINK) $(LDFLAGS) $(EXOSFLAGS)

install: iotrcfmt iotrcrep iotrccref iotrccol

iotrcfmt: otrcfmt
	-mv -f $(ORACLE_HOME)/bin/otrcfmt $(ORACLE_HOME)/bin/otrcfmt0
	-mv otrcfmt $(ORACLE_HOME)/bin/otrcfmt
	-chmod 751 $(ORACLE_HOME)/bin/otrcfmt

otrcfmt:
	@echo " - Linking $@";
	$(RM) -f $@;
	$(LDCCOM) $(OTRCFMTMAI) $(LLIBEPCFE) $(LLIBEPC) $(LLIBRDBMS_CLT) \
	$(CORELIBS) $(LLIBEPCPT) $(CORELIBS) $(LDLIBS) $(DEF_OPT) $(TTLIBS) \
	$(RDBMSLIB)libknlopt.$(LIB_EXT) $(LINKEXSYSLIBS)

iotrcrep: otrcrep
	-mv -f $(ORACLE_HOME)/bin/otrcrep $(ORACLE_HOME)/bin/otrcrep0
	-mv otrcrep $(ORACLE_HOME)/bin/otrcrep
	-chmod 751 $(ORACLE_HOME)/bin/otrcrep

otrcrep:
	@-echo " - Linking $@";
	$(RM) -f $@;
	$(LDCCOM)  $(OTRCREPMAI) $(LLIBEPCFE) $(LLIBEPC) $(CORELIBS) \
	$(LLIBEPCPT) $(CORELIBS) $(LDLIBS) $(LINKEXSYSLIBS)

iotrccref: otrccref
	-mv -f $(ORACLE_HOME)/bin/otrccref $(ORACLE_HOME)/bin/otrccref0
	-mv otrccref $(ORACLE_HOME)/bin/otrccref
	-chmod 751 $(ORACLE_HOME)/bin/otrccref

otrccref:
	@-echo " - Linking $@";
	$(RM) -f $@;
	$(LDCCOM)  $(OTRCCREFMAI) $(LLIBEPCFE) $(LLIBEPC) $(CORELIBS) \
	$(LLIBEPCPT) $(CORELIBS) $(LDLIBS) $(LINKEXSYSLIBS)

iotrccol: otrccol
	-mv -f $(ORACLE_HOME)/bin/otrccol $(ORACLE_HOME)/bin/otrccol0
	-mv otrccol $(ORACLE_HOME)/bin/otrccol
	-chmod 751 $(ORACLE_HOME)/bin/otrccol

otrccol:
	@-echo " - Linking $@";
	$(RM) -f $@;
	$(LDCCOM)  $(OTRCCOLMAI) $(LLIBEPCFE) $(LLIBEPC) $(CORELIBS) \
	$(LDLIBS) $(LLIBEPCPT) $(CORELIBS) $(DEF_OPT) \
	$(TTLIBS) $(RDBMSLIB)libknlopt.$(LIB_EXT) $(LINKEXSYSLIBS)
