# cus_net_client.mk - "make" command file to reload  
# network client executables
#
# 
# NOTE:         ORACLE_HOME must be either:
#               . set in the user's environment
#               . passed in on the command line
#               . defined in a modified version of this makefile

include  $(ORACLE_HOME)/network/lib/env_network.mk 


RDBMSHOME = $(ORACLE_HOME)/rdbms/
RDBMSLIB  = $(ORACLE_HOME)/rdbms/lib/
RDBMSBIN  = $(ORACLE_HOME)/rdbms/bin/
LIBNET    = $(ORACLE_HOME)/lib/$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LDFLAGS   = -L$(LIBHOME) -L$(ORACLE_HOME)/rdbms/lib  -L$(ORACLE_HOME)/network/lib 
LDCCOM    = $(LINK) $(LDFLAGS) $(EXOSFLAGS) -o $@
ECHODO    = $(ORACLE_HOME)/bin/echodo
ECHO	  = echo
CATLDFLAGS= $(CAT) $(ORACLE_HOME)/network/install/ldflags.* | tr '\n' ' '

INSTALL_TARGS=clean itrcasst itrcroute ionrsd itnsping 

default: itrcasst itrcroute ionrsd itnsping itrcfmt

#
# targets for relinking executables
#

tnsping: $(S0NSPING) $(NSPING)
	$(ECHODO) $(LDCCOM) $(S0NSPING) $(NSPING) $(TTLIBS) $(LOCALNETLIBS) $(LINKEXSYSLIBS)

itnsping: tnsping
	-mv -f $(ORACLE_HOME)/bin/tnsping $(ORACLE_HOME)/bin/tnsping0
	-mv tnsping $(ORACLE_HOME)/bin/tnsping
	-chmod 751 $(ORACLE_HOME)/bin/tnsping

trcroute: $(S0NUR) $(LIBNULOCAL)
	$(ECHODO) $(LDCCOM) $(S0NUR) $(LLIBNULOCAL) \
	$(TTLIBS) $(LOCALNETLIBS) $(LINKEXSYSLIBS)

itrcroute: trcroute
	-mv -f $(ORACLE_HOME)/bin/trcroute $(ORACLE_HOME)/bin/trcroute0
	-mv trcroute $(ORACLE_HOME)/bin/trcroute
	-chmod 751 $(ORACLE_HOME)/bin/trcroute

trcasst: $(S0NUE) $(LIBNULOCAL)
	$(ECHODO) $(LDCCOM) $(S0NUE) $(LLIBNULOCAL) \
	$(TTLIBS) $(LOCALNETLIBS) $(LINKEXSYSLIBS)

itrcasst: trcasst
	-mv -f $(ORACLE_HOME)/bin/trcasst $(ORACLE_HOME)/bin/trcasst0
	-mv trcasst $(ORACLE_HOME)/bin/trcasst
	-chmod 751 $(ORACLE_HOME)/bin/trcasst

trcfmt: $(NETWORKBIN)trcfmt
	-cp $(NETWORKBIN)trcfmt trcfmt

itrcfmt: 
	echo "Do not relink 'trcfmt'"

onrsd:  $(S0NNOV) $(LIBNND) $(LLIBCLNT)
	$(ECHODO) $(LDCCOM) $(S0NNOV) $(LIBNND) \
	$(LLIBCLNT) $(TTLIBS) $(LOCALNETLIBS) $(SNMPAGENTLIB) $(LINKEXSYSLIBS)

ionrsd:  onrsd
	-mv -f $(ORACLE_HOME)/bin/onrsd $(ORACLE_HOME)/bin/onrsd0
	-mv onrsd $(ORACLE_HOME)/bin/onrsd
	-chmod 751 $(ORACLE_HOME)/bin/onrsd

# Target for relinking ntcontab.o

ntcontab.o:
	(if [ "$(GENNT)" = "compile" ] ; then \
	  $(ORACLE_HOME)/bin/gennttab > ntcontab.c ;\
	  $(CC) $(CFLAGS_SHIP) -c ntcontab.c ;\
	  rm -f $(ORACLE_HOME)/lib/ntcontab.o ;\
	  mv ntcontab.o $(ORACLE_HOME)/lib ;\
          $(AR) rv $(LIBNET) $(ORACLE_HOME)/lib/$@ ; fi)
	(if [ "$(GENNT)" = "assemble" ] ; then \
	  $(ORACLE_HOME)/bin/gennttab > ntcontab.s ;\
	  $(AS) $(ASFLAGS_SHIP) ntcontab.o ntcontab.s ;\
	  rm -f $(ORACLE_HOME)/lib/ntcontab.o ;\
	  mv ntcontab.o $(ORACLE_HOME)/lib ;\
          $(AR) rv $(LIBNET) $(ORACLE_HOME)/lib/$@ ; fi)
	(if [ "$(GENNT)" = "oratmp" ] ; then \
	  $(ORACLE_HOME)/bin/gennttab > ntcontab.c ;\
	  /lib/idcpp ntcontab.c oratmp.c ;\
	  $(COMP) -i oratmp.c -o oratmp.s -f ntcontab.c ;\
	  $(AS) -o ntcontab.o oratmp.s ;\
	  rm -f oratmp.c oratmp.s ;\
	  rm -f $(ORACLE_HOME)/lib/ntcontab.o ;\
	  mv ntcontab.o $(ORACLE_HOME)/lib ;\
          $(AR) rv $(LIBNET) $(ORACLE_HOME)/lib/$@ ; fi)
	(if [ "$(GENNT)" = "binary" ] ; then \
	  $(ORACLE_HOME)/bin/gennttab > ntcontab.c ;\
	  TARGET_BINARY_INTERFACE=$(BINARY_INTERFACE) ;\
	  export TARGET_BINARY_INTERFACE ;\
	  $(CC) $(CFLAGS_SHIP) -c ntcontab.c ;\
	  -rm -f $(ORACLE_HOME)/lib/ntcontab.o ;\
	  -mv ntcontab.o $(ORACLE_HOME)/lib ;\
          $(AR) rv $(LIBNET) $(ORACLE_HOME)/lib/$@ ; fi)
	  

nnfgt.o:
	(if [ "$(GENNT)" = "compile" ] ; then \
	  $(ORACLE_HOME)/bin/gennfgt > nnfgt.c ;\
	  $(CC) $(CFLAGS_SHIP) -c nnfgt.c ;\
	  rm -f $(ORACLE_HOME)/lib/nnfgt.o ;\
	  mv nnfgt.o $(ORACLE_HOME)/lib ;\
          $(AR) rv $(LIBNET) $(ORACLE_HOME)/lib/$@ ; fi)
	(if [ "$(GENNT)" = "assemble" ] ; then \
	  $(ORACLE_HOME)/bin/gennfgt > nnfgt.s ;\
	  $(AS) $(ASFLAGS_SHIP) nnfgt.o nnfgt.s ;\
	  rm -f $(ORACLE_HOME)/lib/nnfgt.o ;\
	  mv nnfgt.o $(ORACLE_HOME)/lib ;\
          $(AR) rv $(LIBNET) $(ORACLE_HOME)/lib/$@ ; fi)
	(if [ "$(GENNT)" = "oratmp" ] ; then \
	  $(ORACLE_HOME)/bin/gennfgt > nnfgt.c ;\
	  /lib/idcpp nnfgt.c oratmp.c ;\
	  $(COMP) -i oratmp.c -o oratmp.s -f nnfgt.c ;\
	  $(AS) -o nnfgt.o oratmp.s ;\
	  rm -f oratmp.c oratmp.s ;\
	  rm -f $(ORACLE_HOME)/lib/nnfgt.o ;\
	  mv nnfgt.o $(ORACLE_HOME)/lib ;\
          $(AR) rv $(LIBNET) $(ORACLE_HOME)/lib/$@ ; fi)
	(if [ "$(GENNT)" = "binary" ] ; then \
	  $(ORACLE_HOME)/bin/gennfgt > nnfgt.c ;\
	  TARGET_BINARY_INTERFACE=$(BINARY_INTERFACE) ;\
	  export TARGET_BINARY_INTERFACE ;\
	  $(CC) $(CFLAGS_SHIP) -c nnfgt.c ;\
	  -rm -f $(ORACLE_HOME)/lib/nnfgt.o ;\
	  -mv nnfgt.o $(ORACLE_HOME)/lib ;\
          $(AR) rv $(LIBNET) $(ORACLE_HOME)/lib/$@ ; fi)


preinstall:
	-chmod 755 $(ORACLE_HOME)/bin
 
install: preinstall $(INSTALL_TARGS)

 
clean:

client_sharedlib:
	$(GENCLNTSH)

mkldflags: empty_ldflags
	-$(SILENT) $(CATLDFLAGS) >> $(ORACLE_HOME)/lib/ldflags 
	-$(SILENT) $(ECHO) '\n' >> $(ORACLE_HOME)/lib/ldflags

empty_ldflags:
	-$(SILENT) $(RMF) $(ORACLE_HOME)/lib/ldflagsO
	-$(SILENT) $(MV) $(ORACLE_HOME)/lib/ldflags $(ORACLE_HOME)/lib/ldflagsO
	-$(SILENT) $(TOUCH) $(ORACLE_HOME)/lib/ldflags


