#!/bin/sh
# Copyright 11/16/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)install-java.sh	1.31 01/11/16 Sun Microsystems"

#
#This function takes one package as argument. If there is no
#argument passed to this function then it returns 0 if there
#is no java in /usr/java1.2/jre/bin else it returns 1.
#

check_for_jdk_package() {
    java_package=$1
    java_package_list=""
    java_package_available=0

    if [ -z "$java_package" ] ; then
         if [ -f "${RELOCATED_ROOT}/usr/java1.2/jre/bin/java" ] ; then
             return 1
         fi
         return 0
    fi

    java_package_list=`/usr/bin/pkginfo -R $RELOCATED_ROOT ${java_package}.*  2> /dev/null  | /usr/bin/awk ' { print $2 }' `

    if [ -z "$java_package_list" ] ; then
	JAVA_PKG_LIST="$JAVA_PKG_LIST $java_package"
    else
	for each_instance in $java_package_list
	do
	    #check if it is fully installed
	    /usr/bin/pkginfo -R $RELOCATED_ROOT -qi $each_instance > /dev/null 2>&1
	    if [ $? -eq 0 ] ; then
                java2_product_version=`/usr/bin/pkgparam -R $RELOCATED_ROOT $each_instance SUNW_PRODVERS | /usr/bin/cut -f 2 -d / `
		echo "$java2_product_version" | /usr/bin/grep -w "Solaris_JDK_1.2.2_06" >/dev/null 2>&1
		if [ $? -eq 0 ] ; then
		    base_dir=`/usr/bin/pkgparam -R $RELOCATED_ROOT $each_instance BASEDIR`
		    #JAVA_INSTALLED_PKG_LIST="$JAVA_INSTALLED_PKG_LIST $each_instance"
                    if [ "$base_dir" = "/usr" ] ; then
			java_package_available=1
			break
                    else
			#
			#Required version of java package is present but not in default location.
			#We will not use any java not installed in default location. But since this
			#instance is installed in different location, we can not install our java
			#in our location. So this instance must be removed before installing our java.
			#
			echolog '$2 package is installed in nondefault location. It must be removed' $each_instance
			echolog 'Sun Management Center installation. Please remove this package and'
			echolog 'run es-inst again.'
			exit 1
                    fi
		else
		    continue
		fi
	   fi
	done
        if [ $java_package_available -eq 0 ] ; then
	    JAVA_PKG_LIST="$JAVA_PKG_LIST $java_package"
        fi
	       
    fi
}

# Return: 0 - all packages are available
#	  1 - some packages are available; $JAVA_PKG_LIST = packages to be installed
#	  2 - has Java, but not the required version
#	  3 - no Java
check_jdk_for_ds() {
    check_for_jdk_package "SUNWj2rt"
    j2rt=$java_package_available
    check_for_jdk_package "SUNWj2dev"
    j2dev=$java_package_available
    check_for_jdk_package "SUNWj2dbg"
    j2dbg=$java_package_available
    check_for_jdk_package "SUNWj2dem"
    j2dem=$java_package_available
    check_for_jdk_package "SUNWj2man"
    j2man=$java_package_available
    
    if [ $j2rt -eq 1 -a $j2dev -eq 1 -a $j2dbg -eq 1 -a $j2dem -eq 1 -a $j2man -eq 1 ] ; then
          return 0
    else
          if [ $j2rt -eq 0 -a $j2dev -eq 0 -a $j2dbg -eq 0 -a $j2dem -eq 0 -a $j2man -eq 0 ] ; then
                check_for_jdk_package
                if [ $? -eq 1 ] ; then
                     return 2
                else
                     return 3
                fi
          else
                #some of the packages are there, JAVA_PKG_LIST
                #contains packages to be installed
                return 1
          fi 
    fi
}

# Return: 0 - package is available
#	  2 - has Java, but not the required version
#	  3 - no Java
check_jdk_for_ps() {
    check_for_jdk_package "SUNWj2rt"
    j2rt=$java_package_available
    check_for_jdk_package "SUNWj2dev"
    j2dev=$java_package_available
    
    if [ $j2rt -eq 1 -a $j2dev -eq 1 ] ; then
        return 0
    fi 

    if [ $j2rt -eq 0 -a $j2dev -eq 0 ]; then
	check_for_jdk_package
	if [ $? -eq 1 ]; then
	    return 2
	else
	    return 3
	fi
    fi
    return 1
}

add_java_packages() {
    if [ ! -d $JAVA_PKG_DIR ] ; then
	echolog 'Java packages are not in $2' "$JAVA_PKG_DIR"
        return 1
    fi

    for each_java_pkg in $JAVA_PKG_LIST
    do
	if [ ! -d "${JAVA_PKG_DIR}/$each_java_pkg" ] && [ ! -L "${JAVA_PKG_DIR}/$each_java_pkg" ]; then
	    echolog 'All required Java packages are not in $2' "$JAVA_PKG_DIR"
	    return 1
	fi
    done
    INSTALLED_PACKAGES_INSTANCE=""

    echolog 'Installing java packages $2' "$JAVA_PKG_LIST"
    echolog ""
    echolog ""
    JADMIN=/tmp/javaadmin$$
    /usr/bin/cat << !EOF > "$JADMIN"
mail=
instance="$install_mode"
partial=nocheck
runlevel=nocheck
idepend=quit
rdepend=nocheck
space=nocheck
setuid=nocheck
conflict="$conflict_res"
action=nocheck
basedir="$java_base_dir"
!EOF

    for each_pkg in $JAVA_PKG_LIST
    do

	/usr/sbin/pkgadd -a $JADMIN -d $JAVA_PKG_DIR -R $RELOCATED_ROOT $each_pkg 2>&1 | /usr/bin/tee -a $LOGFILE
	find_installed_package_instance $each_pkg
	if [ $? -eq 1 ] ; then
	    echolog ''
	    echolog 'Error installing package: $2' "$each_pkg"
	    echolog ''
	    exit 2
        else
	    /usr/bin/pkginfo -qi -R $RELOCATED_ROOT "$installed_instance" > /dev/null 2>&1
	    if [ $? -ne 0 ] ; then
		echolog ''
		echolog 'Error installing package: $2' "$installed_instance"
		echolog ''
		exit 2
	    fi
	fi
	INSTALLED_PACKAGES_INSTANCE="$INSTALLED_PACKAGES_INSTANCE $installed_instance"
    done
    /usr/bin/rm -f $JADMIN

    return 0
}
find_installed_package_instance () {
    java_package_name=$1
    java_package_list=""
    installed_instance=""
    local_java_base_dir=`echo $java_base_dir | /usr/bin/sed "s/^ *//" | /usr/bin/sed "s/ *$//"`
    java_package_list=`/usr/bin/pkginfo -R $RELOCATED_ROOT ${java_package_name}.*  2> /dev/null  | /usr/bin/awk ' { print $2 }' `

    if [ -z "$java_package_list" ] ; then
	return 1
    else
	for each_instance in $java_package_list
	do
	    #check the base directory of this instance
	    base_dir=`/usr/bin/pkgparam -R $RELOCATED_ROOT $each_instance BASEDIR`
	    if [ "$base_dir" = "$local_java_base_dir" ] ; then
		installed_instance=$each_instance
		break
	    fi
        done
	if [ -z "$installed_instance" ] ; then
	    return 1
        fi
	return 0
    fi
    
}
check_package_dependency () {
    rqrd_pkgs_for_java_pkgs="SUNWcar SUNWkvm SUNWcsr SUNWcsu SUNWcsd SUNWmfrun"
    incomp_pkgs_for_java_pkgs="SUNWjvthr"
    rqrd_pkgs_not_found=""
    
    for each_rqrd_pkgs in $rqrd_pkgs_for_java_pkgs
    do
	/usr/bin/pkginfo -R $java_root_dir -qi $each_rqrd_pkgs > /dev/null 2>&1
	if [ $? -ne 0 ]; then
	    rqrd_pkgs_not_found="$rqrd_pkgs_not_found $each_rqrd_pkgs"
	fi
    done
    if [ ! -z "$rqrd_pkgs_not_found" ] ; then
        echolog ""
	echolog "The following packages required by Java 2 are not installed on"
	echolog "the system. Please install them first and then install Sun Management Center."
        echolog 'Packages: $2' "$rqrd_pkgs_not_found"
	echolog ""
        return 1
    fi
    /usr/bin/pkginfo -R $java_root_dir -qi SUNWjvthr > /dev/null 2>&1 
    if [ $? -eq 0 ] ; then
        echolog 'Package $2 is installed on this system. This package is' "SUNWjvthr"
	echolog "incompatible with the java version required for Sun Management Center."
	echolog "This package needs to be uninstalled before installing java 2"

	tmp_auto=0
	if [ "$AUTOCONFIG_RUNFILE" != "" ] ; then # Run autoconfig
	    tmp_auto=`getAutoConfig "JAVA_UNINSTALL"`
	fi
	if [ $tmp_auto -eq 1 ] ; then
	    echolog 'Uninstalling the package.'
	else
	    ask_user "Do you want to uninstall it now"
	    if [ "$AUTOCONFIG_SAVEFILE" != "" ] ; then # Save autoconfig
		saveAutoConfig "JAVA_UNINSTALL" "$answer"
	    fi
	    [ $answer -eq 0 ] && return 1
	fi
	/usr/sbin/pkgrm -n -A -R $java_root_dir SUNWjvthr > /dev/null 2>&1
	if [ $? -ne 0 ] ; then
	    echolog 'Removal of the package $2 failed, please remove it' "SUNWjvthr"
	    echolog "manually and then install Sun Management Center."
	    return 1 
	fi 
    fi
   
    return 0
}

# Checks for Java packages and set up some settings.
# Return: 0 - Required version already installed in /usr/java1.2
#	  1 - Some packages exist in /usr/java1.2
#	  2 - Java exists with different version in /usr/java1.2
#	  3 - No Java in /usr/java1.2
#We care about java installed in only /usr. Even if some java is
#installed in some other directory, we ignore them. If we install
#java in the directory other then /usr, we will remove it at the
#time of uninstallation.

checkJava() {
    java_base_dir="/usr"
    java_root_dir="${RELOCATED_ROOT}/"

    check_package_dependency
    [ $? -ne 0 ] && return 4

    JAVA_HOME_FILE="$VAROPTDIR/.java_home"
    JAVA_CFG_FILE="$CFGINFOFILE"
    JAVA_PKG_DIR="${SRC_DIR}/jdk"

    [ ! -d "$JAVA_PKG_DIR" ] && JAVA_PKG_DIR="${SRC_DIR}/PE/Solaris_${OSVERS}/jdk"
    if [ ! -d "$JAVA_PKG_DIR" ] ; then
        echolog 'Java packages couldnot be found in directory $2' "${SRC_DIR}/PE/Solaris_${OSVERS}/jdk"
        return 4
    fi


    JAVA_PKG_LIST=""
    JAVA_INSTALLED_PKG_LIST=""
    [ ! -d "$VARDIR" ] && /usr/bin/mkdir -p "$VARDIR"

    symon_product="$1"
    if [ "$symon_product" = "ds" ]; then
	check_jdk_for_ds
	ret=$?
    else
	check_jdk_for_ps
	ret=$?
    fi

    return $ret
}

verifyDirectoryAndGetBaseDir () {
    local_target_dir=""
    local_root_dir=""
    local_target_dir=`/usr/bin/echo $1 | /usr/bin/sed -e 's|//*|/|g'`
    local_root_dir=`/usr/bin/echo $RELOCATED_ROOT | /usr/bin/sed -e 's|//*|/|g'`
    echo "$local_target_dir" | /usr/bin/grep "^$local_root_dir" > /dev/null 2>&1
    if [ $? -ne 0 ] ; then
        echolog 'The path entered is not located on $2' "$local_target_dir"
        return 1
    fi
    local_base_dir=`echo $local_target_dir | /usr/bin/sed -e "s|^$local_root_dir|/|"`
    echo "$local_base_dir" | /usr/bin/sed -e 's|//*|/|g'
    return 0
}


check_java_by_previous_installation () {
    /usr/bin/pkginfo -R $RELOCATED_ROOT -qi SUNWescom > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
	BASE_INSTALL_DIR=`/usr/bin/pkgparam -R $RELOCATED_ROOT SUNWescom BASEDIR `
    else
        return 1
    fi
    if [ -f "$RELOCATED_ROOT/$BASE_INSTALL_DIR/SUNWsymon/sbin/.cfginfo" ] ; then
        JAVA_FILE="$RELOCATED_ROOT/$BASE_INSTALL_DIR/SUNWsymon/sbin/.cfginfo"
	JAVADIR=`/usr/bin/grep "JAVADIR" $JAVA_FILE | /usr/bin/cut -f2 -d=`
	if [ -z "$JAVADIR" ] ; then
	    return 1
	else
	    return 0
	fi
    else
	return 1
    fi
}

# Installs Java
# $1 - "ds" | "ps"
install_java() {
    if [ -z "$RELOCATED_ROOT" ] ; then
	RELOCATED_ROOT="/"
    fi
    #
    #Check if java is already installed because of previous 
    #installation of some other component.
    #
    check_java_by_previous_installation
    if [ $? -eq 0 ] ; then
	return 0
    fi
    checkJava "$1"
    ret=$?
    install_mode="unique"
    conflict_res="nochange"
    case $ret in
	0)  echolog 'The required version of Java is already installed in $2' "${RELOCATED_ROOT}$java_base_dir/java1.2"
	    echo "/usr/java1.2" > "$JAVA_HOME_FILE"
            put_var_in_cfgfile "$JAVA_CFG_FILE" "JAVADIR" "/usr/java1.2" "="
            put_var_in_cfgfile "$JAVA_CFG_FILE" "INSTALLED" "0" "="
            put_var_in_cfgfile "$JAVA_CFG_FILE" "OVERWRITTEN" "0" "="
            put_var_in_cfgfile "$JAVA_CFG_FILE" "PKGLIST" " " "="
	    #echo "JAVADIR=/usr/java1.2" >> "$JAVA_CFG_FILE"
	    #echo "INSTALLED=0" >> "$JAVA_CFG_FILE"
	    #echo "OVERWRITTEN=0" >> "$JAVA_CFG_FILE"
	    #echo "PKGLIST= " >> "$JAVA_CFG_FILE"
	    return 0
	    ;;
	1)  # User has some of the required version java packages installed in /usr/java1.2
	    echolog "It seems some of the required packages are already present."
	    echolog 'You need to install the following packages $2' "$JAVA_PKG_LIST"
	    echolog "If you do not choose to install it now, the installation will abort."

	    tmp_auto=0
	    if [ "$AUTOCONFIG_RUNFILE" != "" ] ; then # Run autoconfig
		tmp_auto=`getAutoConfig "JAVA_INSTALL"`
	    fi
	    if [ "$tmp_auto" != "1" ] ; then
		ask_user "Do you want to install it now?"
		if [ "$AUTOCONFIG_SAVEFILE" != "" ] ; then # Save autoconfig
		    saveAutoConfig "JAVA_INSTALL" "$answer"
		fi
		[ $answer -ne 1 ] && return 1
	    fi
	    add_java_packages
	    [ $? -eq 1 ] && return 1
	    echo "/usr/java1.2" > $JAVA_HOME_FILE
	    put_var_in_cfgfile "$JAVA_CFG_FILE" "JAVADIR" "/usr/java1.2" "="
            put_var_in_cfgfile "$JAVA_CFG_FILE" "INSTALLED" "1" "="
            put_var_in_cfgfile "$JAVA_CFG_FILE" "OVERWRITTEN" "0" "="
            put_var_in_cfgfile "$JAVA_CFG_FILE" "PKGLIST" "$INSTALLED_PACKAGES_INSTANCE" "="
	    #echo "JAVADIR=/usr/java1.2" >> "$JAVA_CFG_FILE"
	    #echo "INSTALLED=1" >> "$JAVA_CFG_FILE"
	    #echo "OVERWRITTEN=0" >> "$JAVA_CFG_FILE"
	    #echo "PKGLIST=$INSTALLED_PACKAGES_INSTANCE" >> "$JAVA_CFG_FILE"
	    return 0
	    ;;
	2)  # User has java in /usr/java1.2 but not the required version
            echolog 'It seems some other version of java packages are present in $2' "${RELOCATED_ROOT}$java_base_dir/java1.2"
            echolog "You need to install Solaris_JDK_1.2.2_06 version of the following packages"
            echolog "$JAVA_PKG_LIST"
            echolog "You can either overwrite the existing java version or install the"
            echolog "required version in some other directory."

	    answer=0
	    if [ "$AUTOCONFIG_RUNFILE" != "" ] ; then # Run autoconfig
		answer=`getAutoConfig "JAVA_OVERWRITE"`
	    fi
	    if [ "$answer" = "1" ] ; then
		echolog 'Overwriting the existing Java packages.'
	    else
		ask_user "Do you want to overwrite the existing one?"
		if [ "$AUTOCONFIG_SAVEFILE" != "" ] ; then # Save autoconfig
		    saveAutoConfig "JAVA_OVERWRITE" "$answer"
		fi
	    fi
	    if [ "$answer" = "1" ] ; then
		install_mode="overwrite"
		conflict_res="nocheck"
		add_java_packages
		[ $? -eq 1 ] && return 1
		echo "/usr/java1.2" > $JAVA_HOME_FILE
		echo "JAVADIR=/usr/java1.2" >> "$JAVA_CFG_FILE"
		echo "INSTALLED=1" >> "$JAVA_CFG_FILE"
		echo "OVERWRITTEN=1" >> "$JAVA_CFG_FILE"
		echo "PKGLIST=$INSTALLED_PACKAGES_INSTANCE" >> "$JAVA_CFG_FILE"
		return 0
	    else
		echolog "You can enter any directory to install the required version of JAVA."
		java_base_dir=""
		if [ "$AUTOCONFIG_RUNFILE" != "" ] ; then # Run autoconfig
		    java_base_dir=`getAutoConfig "JAVA_BASEDIR"`
		    java_base_dir=`verifyDirectoryAndGetBaseDir "$java_base_dir"`
		    if [ $? -ne 0 ] ; then # Invalid
			java_base_dir=""
		    fi
		fi
		if [ "$java_base_dir" = "" ] ; then
		    while [ 1 ]
		    do
			get_input_from_user 'Enter the base directory for JDK installation [$2]' "$TARGET_DIR/SUNWsymon"
			if [ "$answer" != "" ] ; then
			    java_base_dir="$answer"
			else
			    java_base_dir="$TARGET_DIR/SUNWsymon"
			fi
			java_base_dir=`verifyDirectoryAndGetBaseDir "$java_base_dir"`
			if [ $? -eq 0 ] ; then
			    if [ "$AUTOCONFIG_SAVEFILE" != "" ] ; then # Save autoconfig
				saveAutoConfig "JAVA_BASEDIR" "$RELOCATED_ROOT/$java_base_dir"
			    fi
			    break
			fi
			echolog "Invalid directory"
		    done
		fi
		[ ! -d "$java_base_dir" ] && /usr/bin/mkdir -p "$java_base_dir"
		add_java_packages
		[ $? -eq 1 ] && return 1
 		echo "${java_base_dir}/java1.2" > $JAVA_HOME_FILE
                put_var_in_cfgfile "$JAVA_CFG_FILE" "JAVADIR" "${java_base_dir}/java1.2" "="
                put_var_in_cfgfile "$JAVA_CFG_FILE" "INSTALLED" "1" "="
                put_var_in_cfgfile "$JAVA_CFG_FILE" "OVERWRITTEN" "0" "="
                put_var_in_cfgfile "$JAVA_CFG_FILE" "PKGLIST" "$INSTALLED_PACKAGES_INSTANCE" "="
		#echo "JAVADIR=${java_base_dir}/java1.2" >> "$JAVA_CFG_FILE"
		#echo "INSTALLED=1" >> "$JAVA_CFG_FILE"
		#echo "OVERWRITTEN=0" >> "$JAVA_CFG_FILE"
		#echo "PKGLIST=$INSTALLED_PACKAGES_INSTANCE" >> "$JAVA_CFG_FILE"
		return 0
	    fi
	    ;;
	3)  # User doesn't have any version os java in /usr/java1.2
	    add_java_packages
	    [ $? -eq 1 ] && return 1
            echo "/usr/java1.2" > $JAVA_HOME_FILE
            put_var_in_cfgfile "$JAVA_CFG_FILE" "JAVADIR" "/usr/java1.2" "="
            put_var_in_cfgfile "$JAVA_CFG_FILE" "INSTALLED" "1" "="
            put_var_in_cfgfile "$JAVA_CFG_FILE" "OVERWRITTEN" "0" "="
            put_var_in_cfgfile "$JAVA_CFG_FILE" "PKGLIST" "$INSTALLED_PACKAGES_INSTANCE" "="
	    #echo "JAVADIR=/usr/java1.2" >> "$JAVA_CFG_FILE"
	    #echo "INSTALLED=1" >> "$JAVA_CFG_FILE"
	    #echo "OVERWRITTEN=0" >> "$JAVA_CFG_FILE"
	    #echo "PKGLIST=$INSTALLED_PACKAGES_INSTANCE" >> "$JAVA_CFG_FILE"
	    return 0
	    ;;
	4)  
	    #Either java package dependency was not satisfied or java
	    #packages are not available in source directory.
            return 1
            ;;

    esac
}

parse_java_cfg_file () {
    if [ -f "$BASEDIR/sbin/.cfginfo" ] ; then
         JAVA_CFG_FILE="$BASEDIR/sbin/.cfginfo"
    else
         return 0
    fi

    JAVADIR=`get_value_from_cfgfile "$JAVA_CFG_FILE" "JAVADIR" "=" `
    INSTALLED=`get_value_from_cfgfile "$JAVA_CFG_FILE" "INSTALLED" "="`
    OVERWRITTEN=`get_value_from_cfgfile "$JAVA_CFG_FILE" "OVERWRITTEN" "=" `
    JAVA_PKGLIST_TBR=`get_value_from_cfgfile "$JAVA_CFG_FILE" "PKGLIST" "=" `
    
    #JAVADIR=`/usr/bin/grep "JAVADIR" $JAVA_CFG_FILE | /usr/bin/cut -f2 -d=`
    #INSTALLED=`/usr/bin/grep "INSTALLED" $JAVA_CFG_FILE | /usr/bin/cut -f2 -d=`
    #OVERWRITTEN=`/usr/bin/grep "OVERWRITTEN" $JAVA_CFG_FILE | /usr/bin/cut -f2 -d=`
    #JAVA_PKGLIST_TBR=`/usr/bin/grep "PKGLIST" $JAVA_CFG_FILE | /usr/bin/cut -f2 -d=`

    [ -z "$INSTALLED" ] && INSTALLED=0
    [ -z "$OVERWRITTEN" ] && OVERWRITTEN=0
    
    [ $INSTALLED -eq 0 ] && return 0
    [ $INSTALLED -eq 1 -a $OVERWRITTEN -eq 0 ] && return 1
    [ $INSTALLED -eq 1 -a $OVERWRITTEN -eq 1 ] && return 2
}

remove_java_packages () {

   if [ -z "$JAVA_PKGLIST_TBR" ] ; then
      echolog "No java packages to be removed."
      return 0
   fi

echolog ""
JADMIN=/tmp/javaadmin$$
/usr/bin/cat << !EOF > "$JADMIN"
mail=
instance=overwrite
partial=nocheck
runlevel=nocheck
idepend=nocheck
rdepend=nocheck
space=nocheck
setuid=nocheck
conflict=nocheck
action=nocheck
basedir=default
!EOF

   /usr/sbin/pkgrm  -n -A -a $JADMIN $JAVA_PKGLIST_TBR
   /usr/bin/rm -f $JADMIN
}

remove_java() {
   parse_java_cfg_file

   # 
   # Talked to raju and chandra about java uninstallation. Finaly
   # it was decided that java installed in non default location 
   # will be uninstalled at the time of uninstallation. Any java
   # installed or overwritten in default location by SunMC will
   # not be uninstalled. 01-08-2001.
   #

   case $? in
	0) 
	    # We didn't install java on users machine
	    return 0
	    ;;
	1)
	    # We had either installed in /usr or in the directory provided by user
            # Here remove java only if its base directory is not /usr. This means
            # java was installed in non default location.

             for java_pkg in "$JAVA_PKGLIST_TBR"
             do
                 java_pkg_basedir=`/usr/bin/pkgparam $java_pkg BASEDIR`
                 if [ "$java_pkg_basedir" = "/usr" ] ; then
                     return 0
                 else
                     break
                 fi
             done
	     remove_java_packages
	     return 0
	    ;;
	2)
	    # We overwrote the user's installation
	    #echolog "Sun Management Center installation had overwritten your previous java installation."
            #echolog "You can either keep the current installation or remove it."
	    #ask_user "Do you want to remove it?"
	    #if [ "$answer" = "1" ] ; then
		 #remove_java_packages
            #fi
	    return 0
	    ;;
    esac
}


# Returns: $required_space_for_java
calculate_required_space_for_java() {
    component="$1"
    if [ "$component" = "ds" ] ; then 
	java_packages="SUNWj2rt SUNWj2dev SUNWj2dem SUNWj2dbg SUNWj2man"
    else
	java_packages="SUNWj2rt SUNWj2dev"
    fi 
    required_space_for_java=0 
    for each_jdk_pkg in $java_packages
    do
        /usr/bin/pkginfo -R $java_root_dir -qi "$each_jdk_pkg" > /dev/null 2>&1
        if [ $? -eq 0 ] ; then
	    /usr/bin/pkgparam -R $java_root_dir $each_jdk_pkg SUNW_PRODVERS | /usr/bin/grep "Solaris_JDK_1.2.2_06" >/dev/null 2>&1
	    if [ $? -eq 0 ] ; then
		continue
	    fi
        fi

        JDKMAPFILE="$SRC_DIR/PE/Solaris_${OSVERS}/jdk/$each_jdk_pkg/pkgmap"
        if [ ! -f "$JDKMAPFILE" ] ; then
            echolog 'Warning - Could not find pkgmap file for $2' "$each_jdk_pkg"
            echolog "  Space calculations will be wrong."
            continue
        fi
        #  Assume that the package total will be in the first 10 lines
        #  of the pkgmap file.
        jdkpkg_size=`/usr/bin/head -10 "$JDKMAPFILE" | /usr/bin/grep '^:' | /usr/bin/nawk '{print $3}'`

       required_space_for_java=`expr $required_space_for_java + $jdkpkg_size`
    done
}

calculate_available_space_for_java() {
    available_space_for_java=0
    available_space_for_java=`/usr/sbin/df -k "$1" | /usr/bin/tail -1 | /usr/bin/awk '{ print $4 }'`
    available_space_for_java=`expr $available_space_for_java \* 2`
}

# $1 - relocated root (optional)
perform_space_check_for_java() {
    total_required_space=0
    total_available_space=0
    calculate_required_space_for_java
    calculate_available_space_for_java "$java_base_dir"
    java_install_dev=`/usr/bin/df -k "$java_base_dir" | /usr/bin/tail -1 | /usr/bin/cut -f1 -d" "`

    if [ $same_partition -eq 1 ] ; then
         
         if [ "$java_install_dev" = "$install_dev" ] ; then
               #java is on same partition
               total_required_space=`expr $required_space_for_java + $opt_space_required`
               total_available_space=$available_space_for_java 
         else
               #java is on different partition
               total_required_space=$required_space_for_java
               total_available_space=$available_space_for_java
         fi
    else
         #java can be either on etc partition or install partition
         if [ "$java_install_dev" = "$install_dev" ] ; then 
             #java will be on install partition
             total_required_space=`expr $required_space_for_java + $opt_space_required`
             total_available_space=$available_space_for_java
         else
            if [ "$java_install_dev" = "$etc_dev" ] ; then
                 total_required_space=`expr $required_space_for_java + $etc_space_required`
                 total_available_space=$available_space_for_java
            else
                 total_required_space=$required_space_for_java
                 total_available_space=$available_space_for_java
            fi
         fi
    fi

    echolog ''
    echolog 'Java installation:'
    echolog '=================='
    echolog 'Space required \\\(in $2\\\):  $3 blocks.' "$java_install_dev" "$required_space_for_java"
    echolog 'Space available \\\(in $2\\\): $3 blocks.' "$java_base_dir" "$total_available_space"
    echolog ''

    if [ $total_required_space -gt $total_available_space ] ; then
	echolog ''
	/usr/bin/echo "  \c"
	echolog 'Insufficient disk space to install Java components'
	echolog ''
	return 1
     fi
     return 0
}
