#   Copyright (c) 2000 Sun Microsystems
#   All rights reserved.
#
#
#   File:    em-models-d.x
#   Version: 1.0 
#
#   The models file for event module
#

type = reference
em-object = { [ use MANAGED-OBJECT]

	consoleHint:hidden = true
	mediumDesc = Event Module

	#This module should be loaded first in the base-modules-d.dat
	#file as other modules will have their refreshTrigger set on some 
	#nodes of this module.
	#The module is serverSupport module and will not be seen on the
	#console and so the user cannot load/unload it.

	#Node which creates an object of type em. The object em creates
	#a socket and registers the socketfd with MEL and when something
	#needs to be read from the socket, MEL calls the appropriate
	#callback in this object. The object is like a daemon, always
	#running.. till the agent is brought down.
	starteventsd = { [use STRING MANAGED-PROPERTY ]
		mediumDesc = Starts the events daemon..
		access = r
	}

	listenfd = { [use STRING MANAGED-PROPERTY ]
		mediumDesc = value of listening socket handle 
		access = r
	}


	connectfd = { [use STRING MANAGED-PROPERTY ]
		mediumDesc = value of connected socket handle
		access = r
	}

	dr-class = { [use STRING MANAGED-OBJECT ]

		mediumDesc = dr events get set here

		#DR module interested in  DR class events will base its refresh triggers
		#ON THIS NODE dr-class.apid:set
		statechange  = { [use STRING MANAGED-PROPERTY-CLASS ]
			mediumDesc = ap state change event
			apid = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = ap_id where the change occured
				access = r
			}
			hint  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = hint about the change in ap_id state
				access = r
			}
		}
	}


	env-class = { [use STRING MANAGED-OBJECT ]

		mediumDesc = environmental  events get set here

		#NOTE IMP IMP IMP All the Managed properties which are of type
		#fruid, resourceid and device are RESERVED FOR FUTURE USE
		#They MAY NOT BE available in Serengeti time frame!
		temp  = { [use STRING MANAGED-PROPERTY-CLASS ]
			mediumDesc = Temperature change  events
			fruid = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = PICL fru name
				access = r
			}
			resourceid = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = resource id
				access = r
			}
			device  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = device path of sensor
				access = r
			}
			state = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = current state
				access = r
			}
			message = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = message passed by env monitor
				access = r
			}
		}

		#Will not get this in serengeti time frame
		fan  = { [use STRING MANAGED-PROPERTY-CLASS ]
			mediumDesc = Fan speed change events
			fruid = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = PICL fru name
				access = r
			}
			resourceid = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = resource id
				access = r
			}
			device  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = device path of sensor
				access = r
			}
			state = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = current state
				access = r
			}
			message = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = message passed by env monitor
				access = r
			}
		}

		power  = { [use STRING MANAGED-PROPERTY-CLASS ]
			mediumDesc = Power change  events
			fruid = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = PICL fru name
				access = r
			}
			resourceid = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = resource id
				access = r
			}
			device  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = device path of sensor
				access = r
			}
			state = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = current state
				access = r
			}
			message = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = message passed by env monitor
				access = r
			}
		}
	}

	info-class = { [use STRING MANAGED-OBJECT ]

		mediumDesc = Information events get set here

		domain-state-change  = { [use STRING MANAGED-PROPERTY-CLASS ]
			mediumDesc = Domain state  change  events
			change = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = what changed
				access = r
			}
		}

		domain-loghost-change  = { [use STRING MANAGED-PROPERTY-CLASS ]
			mediumDesc = Domain Loghosts  change events
			loghosts = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = new domain loghost names
				access = r
			}
		}
	}

	wrsm-class = { [use STRING MANAGED-OBJECT ]

		mediumDesc = WRSM events get set here
	

		linkUp  = { [use STRING MANAGED-PROPERTY-CLASS ]

			mediumDesc = Link Enable events

			controller_id = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Controller ID
				access = r
			}
			port_id = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Port ID
				access = r
			}
			link_number  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Link Number
				access = r
			}

		}

		linkDown  = { [use STRING MANAGED-PROPERTY-CLASS ]

			mediumDesc = Link Down events

			controller_id = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Controller ID
				access = r
			}
			port_id = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Port ID
				access = r
			}
			link_number  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Link Number
				access = r
			}
			reason  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Link Down Reason
				access = r
			}

		}

		newNodeRoute  = { [use STRING MANAGED-PROPERTY-CLASS ]

			mediumDesc = New Route events

			controller_id = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Controller ID
				access = r
			}
			node_id = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Node ID
				access = r
			}
			stripe_count  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Stripe Count
				access = r
			}
			wci_0_port  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = WCI 0 Port ID
				access = r
			}
			wci_1_port = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = WCI 1 Port ID
				access = r
			}
			wci_2_port = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = WCI 2 Port ID
				access = r
			}
			wci_3_port = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = WCI 3 Port ID
				access = r
			}
			link_mask = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Link Mask
				access = r
			}

		}

		lostNodeRoute  = { [use STRING MANAGED-PROPERTY-CLASS ]

			mediumDesc = Lost Route events

			controller_id = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Controller ID
				access = r
			}
			node_id = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Node ID
				access = r
			}
			reason  = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Lost Route Reason
				access = r
			}

		}

		configurationChange  = { [use STRING MANAGED-PROPERTY-CLASS ]

			mediumDesc = Configuration Change events

			controller_id = { [use STRING MANAGED-PROPERTY ]
				mediumDesc = Controller ID
				access = r
			}
	
		}

	}

}

