/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.pv.console.presentation;

import com.sun.symon.apps.hardview.console.presentation.SMHvBean;
import com.sun.symon.apps.hardview.console.presentation.SMHvUpdateBean;
import com.sun.symon.apps.hardview.console.presentation.SMHvUpdateListener;
import com.sun.symon.apps.pv.console.presentation.SMPvCreateViewRunnable;
import com.sun.symon.apps.pv.console.presentation.SMPvDRListener;
import com.sun.symon.apps.pv.console.presentation.SMPvData;
import com.sun.symon.apps.pv.console.presentation.SMPvDataTree;
import com.sun.symon.apps.pv.console.presentation.SMPvException;
import com.sun.symon.apps.pv.console.presentation.SMPvGlobals;
import com.sun.symon.apps.pv.console.presentation.SMPvHisCombo;
import com.sun.symon.apps.pv.console.presentation.SMPvHisObject;
import com.sun.symon.apps.pv.console.presentation.SMPvUpListener;
import com.sun.symon.apps.pv.console.presentation.SMPvViewPnt;
import com.sun.symon.apps.pv.console.presentation.SMPvViewPointListener;
import com.sun.symon.apps.pv.console.tool.SMPvCompDetailPanel;
import com.sun.symon.apps.pv.console.tool.SMPvLocFileLoader;
import com.sun.symon.base.client.SMLogin;
import com.sun.symon.base.client.SMPropertyData;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.console.awx.AwxBusyPanel;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SMPvBean
extends JPanel
implements SMHvUpdateListener {
    int agentPort;
    String hostName;
    String moduleName;
    String elementName = "system";
    int elementInstance = 1;
    SMRawDataRequest dReq = null;
    SMResourceAccess resAcc = null;
    JPanel main;
    JLabel errorMsg;
    JLabel statusMsg = null;
    JPanel displayArea;
    JPanel imageDisplayArea;
    JLabel pathLabel;
    JComboBox viewPointMenu;
    SMPvViewPointListener menuListener = null;
    Vector views;
    int viewIndex = 0;
    Vector navViews;
    int navIndex;
    JPanel navPanel;
    JPanel navControl;
    JButton upBtn;
    JButton dr = null;
    SMPvViewPnt currentViewPnt;
    SMPvHisCombo historyCmb;
    JCheckBox refreshDetails;
    SMPvCompDetailPanel compDetail = null;
    boolean compDetailsShowing = false;
    SMHvUpdateBean updateBean;
    SMPvCreateViewRunnable viewCreateRunnable = new SMPvCreateViewRunnable(this);
    SMPvDataTree dataTree = null;
    SMHvBean hvbean = null;
    Hashtable treeDataCache;
    Hashtable compDataCache;
    Hashtable propCache;
    Hashtable treePropOrderCache;
    Hashtable rawTreePropCache;

    public void activateUp() {
        this.upBtn.setEnabled(true);
    }

    public SMPvCompDetailPanel addComponentDetailPanel() {
        this.createComponentDetail();
        return this.compDetail;
    }

    public void addPhysicalView(SMPvViewPnt sMPvViewPnt) {
        if (sMPvViewPnt == null) {
            return;
        }
        if (this.viewExists(sMPvViewPnt)) {
            return;
        }
        if (this.viewIndex > 1 && this.navIndex != this.navViews.size()) {
            this.navViews.addElement(this.navViews.elementAt(this.navIndex - 1));
        }
        this.views.addElement(sMPvViewPnt);
        this.viewIndex = this.views.size();
        this.navViews.addElement(sMPvViewPnt);
        this.navIndex = this.navViews.size();
        this.addView();
    }

    public void addView() {
        String string;
        boolean bl = true;
        this.removeView();
        if (this.currentViewPnt != null && this.currentViewPnt.getPvData() == ((SMPvViewPnt)this.navViews.elementAt(this.navIndex - 1)).getPvData()) {
            bl = false;
        }
        this.currentViewPnt = (SMPvViewPnt)this.navViews.elementAt(this.navIndex - 1);
        this.getDisplayArea().add(this.currentViewPnt.getPvNodeTree().getImagePanel());
        if (bl) {
            this.populateMenuOptions();
        }
        int n = 0;
        while (n < this.currentViewPnt.getPvData().getViewNum()) {
            string = this.currentViewPnt.getPvData().getVpStr(n);
            if (string.equals(this.currentViewPnt.getVpStr())) {
                this.viewPointMenu.setSelectedIndex(n);
            }
            ++n;
        }
        this.updateUpControls();
        this.getParent().validate();
        this.getParent().invalidate();
        this.setVisible(true);
        string = this.viewPointMenu.getSelectedItem().toString();
        this.historyCmb.insertItemAt(new SMPvHisObject(string.trim(), this.navIndex - 1), 0);
    }

    public SMPvViewPnt addViewPnt(SMPvData sMPvData, int n) throws Exception {
        this.busyProcessStart();
        SMPvViewPnt sMPvViewPnt = sMPvData.getPvViewPnt(n);
        if (!sMPvViewPnt.viewPntTreeExists()) {
            sMPvViewPnt.createPvViewPnt();
        }
        this.busyProcessEnd();
        if (sMPvViewPnt.getPvNodeTree() == null || sMPvViewPnt.getPvNodeTree().getImagePanel() == null) {
            this.postStatus(this.getI18NString("pvNoViewPoint"));
            return null;
        }
        return sMPvViewPnt;
    }

    public SMPvViewPnt addViewPnt(SMPvData sMPvData, int n, SMPvViewPnt sMPvViewPnt) throws Exception {
        this.busyProcessStart();
        SMPvViewPnt sMPvViewPnt2 = sMPvData.getPvViewPnt(n);
        if (!sMPvViewPnt2.viewPntTreeExists()) {
            sMPvViewPnt2.createPvViewPnt(sMPvViewPnt);
        }
        this.busyProcessEnd();
        if (sMPvViewPnt2.getPvNodeTree() == null || sMPvViewPnt2.getPvNodeTree().getImagePanel() == null) {
            this.postStatus(this.getI18NString("pvNoViewPoint"));
            return null;
        }
        return sMPvViewPnt2;
    }

    public void busyProcessEnd() {
        JFrame jFrame = this.getRootFrame(this);
        jFrame.getGlassPane().setVisible(false);
        Toolkit.getDefaultToolkit().sync();
    }

    public void busyProcessStart() {
        JFrame jFrame = this.getRootFrame(this);
        if (!(jFrame.getGlassPane() instanceof AwxBusyPanel)) {
            jFrame.setGlassPane(new AwxBusyPanel());
            jFrame.validate();
        }
        jFrame.getGlassPane().setVisible(true);
        Toolkit.getDefaultToolkit().sync();
    }

    public void cleanup() {
        if (this.updateBean != null) {
            this.updateBean.removeDataUpdateListener();
            this.updateBean.removeAlarmUpdateListener();
        }
        if (this.dr != null && this.getModuleName().equals("Config-Reader4u")) {
            this.dr.setVisible(false);
        }
    }

    public JPanel createActionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 20, 10));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.upBtn = new JButton("Up", new ImageIcon(this.resAcc.getImage("topoimages/up32x32-j.gif")));
        this.upBtn.setToolTipText(this.getI18NString("pvUpTip"));
        this.upBtn.addActionListener(new SMPvUpListener(this));
        jPanel2.add(this.upBtn);
        jPanel2.add(new JLabel(this.getI18NString("pvViewPoint")));
        JComboBox jComboBox = new JComboBox();
        jComboBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        jComboBox.setEditable(false);
        jComboBox.setLightWeightPopupEnabled(false);
        this.setViewPointMenu(jComboBox);
        jPanel2.add(jComboBox);
        this.dr = new JButton(this.getI18NString("pvDR"));
        this.dr.addActionListener(new SMPvDRListener(this));
        this.dr.setAlignmentY(0.5f);
        this.hvbean.getCbPanel().add(this.dr);
        this.dr.setVisible(false);
        if (this.getModuleName().equals("Config-Reader4u")) {
            this.dr.setVisible(true);
        }
        jPanel2.add(new JLabel(this.getI18NString("pvHistory ")));
        this.historyCmb = new SMPvHisCombo();
        this.historyCmb.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.historyCmb.setEditable(false);
        this.historyCmb.setLightWeightPopupEnabled(false);
        this.historyCmb.setPvBean(this);
        jPanel2.add(this.historyCmb);
        this.refreshDetails = new JCheckBox(this.getI18NString("pvRefreshDetails"), false);
        this.refreshDetails.setToolTipText(this.getI18NString("pvRefreshTip"));
        this.refreshDetails.setVisible(false);
        jPanel2.add(this.refreshDetails);
        jPanel.add("West", jPanel2);
        return jPanel;
    }

    public void createComponentDetail() {
        if (this.compDetail == null) {
            this.compDetail = new SMPvCompDetailPanel(this.getModuleName());
            this.compDetail.setVisible(false);
        }
    }

    private void createMainPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.main = new JPanel();
        this.main.setLayout(new BorderLayout());
        this.main.setForeground(Color.black);
        this.main.add("North", this.createActionPanel());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10), BorderFactory.createLoweredBevelBorder()));
        this.displayArea = new JPanel(new FlowLayout());
        this.imageDisplayArea = new JPanel(new FlowLayout());
        this.displayArea.add(this.imageDisplayArea);
        jPanel.add("Center", this.displayArea);
        this.main.add("West", jPanel);
        this.main.add("Center", this.addComponentDetailPanel());
        this.main.add("South", this.createNodePathPanel());
    }

    public JPanel createNodePathPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 10));
        JLabel jLabel = new JLabel(this.getI18NString("pvComponent"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        jPanel.add("West", jLabel);
        JLabel jLabel2 = new JLabel(this.getI18NString("pvComponentPath"));
        jLabel2.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        this.setPathLabel(jLabel2);
        jLabel2.setForeground(Color.blue);
        jPanel.add((Component)jLabel2, "Center");
        return jPanel;
    }

    public void deactivateUp() {
        this.upBtn.setEnabled(false);
    }

    public String determineModuleName() {
        return new String("Config-Reader4u");
    }

    private void displayErrorMsg(String string) {
        this.errorMsg.setText(this.getI18NString(string));
        this.revalidate();
        this.add(this.errorMsg);
        this.getParent().validate();
        this.getParent().setVisible(true);
    }

    private void displayMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.revalidate();
        this.add((Component)this.main, gridBagConstraints);
        this.getParent().validate();
        this.getParent().setVisible(true);
        if (this.getComponentDetailPanel() != null) {
            this.showComponentDetails();
        }
    }

    public boolean fileExists(String string) {
        return this.resAcc.fileExists("xfile:/pvimages/" + string);
    }

    public String getAgentHost() {
        return this.hostName;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public Vector getComponentDetail(SMPvData sMPvData) {
        Object object;
        Vector vector;
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector<String> vector5 = new Vector<String>();
        Vector vector6 = new Vector();
        String string = null;
        if (sMPvData.getCompInfoDB() != null && !this.refreshNow()) {
            return sMPvData.getCompInfoDB();
        }
        this.postStatus(this.getI18NString("pvLoadingComponentDetails"));
        String string2 = sMPvData.getManagedObjectName();
        string = this.rawTreePropCache.get(this.moduleName) != null ? new String(String.valueOf(string2) + "." + sMPvData.getNodeInstance()) : string2;
        vector4 = (Vector)this.propCache.get(String.valueOf(this.moduleName) + "." + string2);
        if (vector4 == null) {
            return null;
        }
        String string3 = this.dataTree.getBaseUrl();
        int n = 0;
        while (n < vector4.size()) {
            String string4 = ((SMPropertyData)vector4.elementAt(n)).getPropertyName();
            try {
                vector = SMRawDataRequest.createURL((String)string3, (String)string2, (String)string4, (String)"", (String)"");
                if (((SMPropertyData)vector4.elementAt(n)).getPropertyType()) {
                    vector5.addElement(String.valueOf(vector) + "#0");
                } else if (this.rawTreePropCache.get(this.moduleName) != null) {
                    object = this.rawTreePropCache.get(String.valueOf(this.moduleName) + "." + string + ".SNMP").toString();
                    if (object == null) {
                        return null;
                    }
                    vector5.addElement(String.valueOf(vector) + "#" + (String)object);
                } else {
                    vector5.addElement((String)((Object)vector));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            vector3.addElement(vector4.elementAt(n));
            ++n;
        }
        vector6 = (Vector)this.compDataCache.get(String.valueOf(this.moduleName) + "." + string);
        if (vector6 == null || this.refreshNow()) {
            if (this.refreshNow()) {
                this.compDataCache.remove(String.valueOf(this.moduleName) + "." + string);
                sMPvData.resetCompInfoDB();
            }
            try {
                vector2 = this.dReq.getURLValue(vector5);
            }
            catch (Exception exception) {
                return null;
            }
            if (vector2 == null || vector2.size() != vector3.size()) {
                return null;
            }
            vector6 = new Vector();
            int n2 = 0;
            while (n2 < vector3.size()) {
                vector = (Vector)vector2.elementAt(n2);
                if (vector != null) {
                    object = vector.elementAt(0).toString();
                    if (object != null && !((String)object).equals("") && !((String)object).equals(" ")) {
                        vector = new Vector();
                        UcListUtil.decomposeList((String)object, vector);
                        vector6.addElement(vector);
                    } else {
                        vector = new Vector();
                        vector.addElement("");
                        vector6.addElement(vector);
                    }
                }
                ++n2;
            }
            this.compDataCache.put(String.valueOf(this.moduleName) + "." + string, vector6);
        }
        int n3 = 0;
        while (n3 < vector6.size()) {
            int n4;
            vector = ((SMPropertyData)vector3.elementAt(n3)).getPropertyName();
            object = (Vector)vector6.elementAt(n3);
            boolean bl = true;
            if (((SMPropertyData)vector3.elementAt(n3)).getPropertyType()) {
                n4 = 0;
            } else {
                n4 = Integer.parseInt(sMPvData.getNodeInstance()) - 1;
                bl = false;
            }
            Vector<String> vector7 = new Vector<String>();
            vector7.addElement(String.valueOf(sMPvData.getManagedObjectName()) + "." + vector);
            if (bl) {
                String string5 = new String("");
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    string5 = string5.concat(enumeration.nextElement().toString()).concat(" ");
                }
                vector7.addElement(string5);
            } else if (this.rawTreePropCache.get(this.moduleName) != null) {
                vector7.addElement(((Vector)object).elementAt(0).toString());
            } else {
                vector7.addElement(((Vector)object).elementAt(n4).toString());
            }
            sMPvData.compInfoDB.addElement(vector7);
            ++n3;
        }
        return sMPvData.compInfoDB;
    }

    public SMPvCompDetailPanel getComponentDetailPanel() {
        return this.compDetail;
    }

    public Image getComponentImage(String string) {
        return this.resAcc.getImage("pvimages/" + string);
    }

    public Vector getComponentLocations(String string) {
        if (!this.resAcc.fileExists("xfile:/pvimages/" + string)) {
            return null;
        }
        String string2 = this.resAcc.getLocationFile("pvimages/" + string);
        if (string2 == null) {
            return null;
        }
        SMPvLocFileLoader sMPvLocFileLoader = new SMPvLocFileLoader();
        return sMPvLocFileLoader.loadLocations(string2);
    }

    public SMPvViewPnt getCurrentViewPnt() {
        return this.currentViewPnt;
    }

    public SMPvDataTree getDataTreeRef() {
        return this.dataTree;
    }

    protected boolean getDetailsFlag() {
        return this.compDetailsShowing;
    }

    public JPanel getDisplayArea() {
        return this.imageDisplayArea;
    }

    public int getElementInstance() {
        return this.elementInstance;
    }

    public String getElementName() {
        return this.elementName;
    }

    public Frame getFrame(Component component) {
        Frame frame = new Frame();
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
            break;
        }
        return frame;
    }

    public String getI18NString(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.apps.pv.console.presentation.PhysicalView:" + string));
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public JPanel getNavControls() {
        return this.navControl;
    }

    public JLabel getPathLabel() {
        return this.pathLabel;
    }

    public SMRawDataRequest getRawDataRequestHandle() {
        return this.dReq;
    }

    private SMResourceAccess getResourceHandle() {
        return this.resAcc;
    }

    public JFrame getRootFrame(Component component) {
        JFrame jFrame = new JFrame();
        while ((component = component.getParent()) != null) {
            if (!(component instanceof JFrame)) continue;
            jFrame = (JFrame)component;
            break;
        }
        return jFrame;
    }

    public JComboBox getViewPointMenu() {
        return this.viewPointMenu;
    }

    public JLabel getWindowStatusField() {
        return this.statusMsg;
    }

    public void hideComponentDetails() {
        this.compDetailsShowing = false;
        this.getComponentDetailPanel().setVisible(false);
        this.refreshDetails.setVisible(false);
        this.validate();
    }

    public synchronized void init() {
        this.updateBean = new SMHvUpdateBean(this.hvbean, this.moduleName);
        this.createMainPanel();
        this.errorMsg = new JLabel();
        SMModuleRequest sMModuleRequest = new SMModuleRequest(this.dReq);
        try {
            if (!sMModuleRequest.isModuleLoaded(this.getAgentHost(), this.getAgentPort(), this.getModuleName())) {
                this.postStatus(this.getI18NString("pvNoModule"));
                this.displayErrorMsg("pvNoPV");
                return;
            }
        }
        catch (Exception exception) {
            this.postStatus(exception.getMessage());
            this.displayErrorMsg("pvNoPV");
            return;
        }
        this.postStatus(this.getI18NString("pvLoadingHierarchy"));
        if (!this.initDataTree()) {
            this.postStatus(this.getI18NString("pvLoadingHierarchyFailed"));
            return;
        }
        this.postStatus(this.getI18NString("pvLoadingConsole"));
        if (!this.initSMPvBean()) {
            this.postStatus(this.getI18NString("pvLoadingConsoleFailed"));
            return;
        }
        this.postStatus("");
        this.displayMainPanel();
        try {
            this.updateBean.setModuleName(this.moduleName);
            this.updateBean.addDataUpdateListener(this);
            this.updateBean.addAlarmUpdateListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean initDataTree() {
        try {
            if (this.dataTree == null && (this.dataTree = new SMPvDataTree()) == null) {
                return false;
            }
            this.dataTree.setRawDataRequestHandle(this.dReq);
            this.dataTree.setAgentHost(this.hostName);
            this.dataTree.setAgentPort(this.agentPort);
            this.dataTree.setModuleName(this.getModuleName());
            this.dataTree.setBeanReference(this);
            this.dataTree.setElementName(this.getElementName());
            this.dataTree.setElementInstance(this.getElementInstance());
            this.dataTree.initTree();
        }
        catch (Exception exception) {
            this.postStatus(this.getI18NString(exception.getMessage()));
            this.displayErrorMsg("pvNoPV");
            return false;
        }
        return true;
    }

    public boolean initSMPvBean() {
        this.views = null;
        this.views = new Vector();
        this.viewIndex = 0;
        this.navViews = new Vector();
        this.navIndex = 0;
        this.currentViewPnt = null;
        try {
            if (this.historyCmb.getItemCount() > 0) {
                this.historyCmb.removeAllItems();
            }
            this.addPhysicalView(this.addViewPnt(this.dataTree.rootPvData, 0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof SMPvException) {
                this.postStatus(this.getI18NString(exception.getMessage()));
                this.displayErrorMsg("pvNoPV");
                this.updateBean.removeDataUpdateListener();
                this.updateBean.removeAlarmUpdateListener();
            }
            return false;
        }
        return true;
    }

    public boolean isComponentDetailShowing() {
        return this.compDetailsShowing;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Usage: SMPvBean agentHost agentPort serverHost");
            System.exit(1);
        }
        Frame frame = new Frame("Symon Physical View");
        SMPvBean sMPvBean = new SMPvBean();
        try {
            String string = "687a8398ad4a85077d33b72a94e16ffde0c4ba023e9c9ba77b247cc25bd3cd0015bc24b7429916751e681fd02e5ad6eb5345eb7c75b39a1c304e0f000846aa470b755b0640af974e7fc70daa6191dff6efa31a09431bb5e9848b7dc4cf4b97e1dbca31792d2860ca5a5990dfb369e1bcf296274a4e4984c8089329679dd304cd";
            SMLogin sMLogin = new SMLogin();
            sMLogin.connect(stringArray[2], 0, "adetti", "hello", string);
            sMPvBean.setRawDataRequestHandle(sMLogin.getRawDataRequest());
            sMPvBean.setAgentHost(stringArray[0]);
            sMPvBean.setAgentPort(Integer.parseInt(stringArray[1]));
        }
        catch (Exception exception) {}
        sMPvBean.init();
        frame.add(sMPvBean);
        frame.pack();
        frame.validate();
        frame.show();
    }

    public void populateComponentDetails(Object object) {
        if (this.compDetail != null && this.compDetail.isShowing()) {
            this.compDetail.populateDetailsTable(object);
        }
    }

    private void populateMenuOptions() {
        try {
            this.viewPointMenu.removeAllItems();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        if (this.menuListener != null) {
            this.viewPointMenu.removeItemListener(this.menuListener);
            this.menuListener = null;
        }
        if (this.currentViewPnt != null) {
            SMPvData sMPvData = this.currentViewPnt.getPvData();
            int n = 0;
            while (n < sMPvData.getViewNum()) {
                String string = sMPvData.getVpStr(n);
                this.viewPointMenu.addItem(String.valueOf(sMPvData.getNodeName()) + " - " + this.getI18NString(string));
                ++n;
            }
            this.viewPointMenu.validate();
            this.menuListener = new SMPvViewPointListener(this, sMPvData);
            this.viewPointMenu.addItemListener(this.menuListener);
        }
    }

    public void postStatus(String string) {
        if (this.statusMsg != null) {
            this.statusMsg.setText(string);
            this.statusMsg.validate();
        }
    }

    public void processOneAlarm(Vector vector) {
        String string;
        String string2 = SMPvGlobals.getAlarmNodeName(vector.elementAt(7).toString());
        String string3 = vector.elementAt(0).toString();
        String string4 = vector.lastElement().toString();
        SMPvData sMPvData = SMPvData.findAlarmNode(this.dataTree.getRoot(), string2);
        if (sMPvData == null) {
            return;
        }
        String string5 = sMPvData.getNodeInstance();
        Object v = this.rawTreePropCache.get(String.valueOf(this.moduleName) + "." + sMPvData.getManagedObjectName() + "." + string5 + ".SNMP");
        if (v != null) {
            string5 = v.toString();
        }
        if ((string = SMPvGlobals.getAlarmNodeInstance(vector.elementAt(8).toString())) != null && v != null && !string5.equals(string)) {
            return;
        }
        if (string4.equals("alarm_closed")) {
            if (string3.indexOf("ERR") != -1) {
                sMPvData.decRedCnt();
            } else if (string3.indexOf("WRN") != -1) {
                sMPvData.decYellowCnt();
            } else if (string3.indexOf("INF") != -1) {
                sMPvData.decBlueCnt();
            }
            this.compDataCache.remove(String.valueOf(this.moduleName) + "." + sMPvData.getManagedObjectName());
            sMPvData.resetCompInfoDB();
        } else if (!string4.equals("alarm_unchanged")) {
            if (string3.indexOf("ERR") != -1) {
                sMPvData.incRedCnt();
            } else if (string3.indexOf("WRN") != -1) {
                sMPvData.incYellowCnt();
            } else if (string3.indexOf("INF") != -1) {
                sMPvData.incBlueCnt();
            }
            this.compDataCache.remove(String.valueOf(this.moduleName) + "." + sMPvData.getManagedObjectName());
            sMPvData.resetCompInfoDB();
        }
    }

    protected boolean refreshNow() {
        return this.refreshDetails.isSelected();
    }

    public synchronized void reinit() {
        this.updateBean.removeDataUpdateListener();
        this.updateBean.removeAlarmUpdateListener();
        this.updateBeanDataTree();
        try {
            this.updateBean.setModuleName(this.moduleName);
            this.updateBean.addDataUpdateListener(this);
            this.updateBean.addAlarmUpdateListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeView() {
        this.setVisible(false);
        this.getDisplayArea().removeAll();
    }

    public void setAgentHost(String string) {
        this.hostName = new String(string);
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    public void setCaches(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4, Hashtable hashtable5) {
        this.treeDataCache = hashtable;
        this.compDataCache = hashtable2;
        this.propCache = hashtable3;
        this.treePropOrderCache = hashtable4;
        this.rawTreePropCache = hashtable5;
    }

    public void setElementInstance(int n) {
        this.elementInstance = n;
    }

    public void setElementName(String string) {
        this.elementName = new String(string);
    }

    public void setHvBean(SMHvBean sMHvBean) {
        this.hvbean = sMHvBean;
    }

    public void setModuleName(String string) {
        this.moduleName = new String(string);
    }

    public void setPath(String string) {
        this.pathLabel.setText(string);
    }

    protected void setPathLabel(JLabel jLabel) {
        this.pathLabel = jLabel;
    }

    public SMRawDataRequest setRawDataRequestHandle() {
        return this.dReq;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.dReq = sMRawDataRequest;
        this.resAcc = new SMResourceAccess(this.dReq);
    }

    public void setSize() {
        Dimension dimension = new Dimension(this.getDisplayArea().getSize());
        dimension.height += 200;
        super.setSize(dimension);
    }

    protected void setViewPointMenu(JComboBox jComboBox) {
        this.viewPointMenu = jComboBox;
    }

    public void setWindowStatusField(Object object) {
        this.statusMsg = (JLabel)object;
    }

    public void showComponentDetails() {
        this.compDetailsShowing = true;
        this.getComponentDetailPanel().setVisible(true);
        this.refreshDetails.setVisible(true);
        this.validate();
    }

    public void startViewCreateThread(SMPvData sMPvData, int n) {
        this.viewCreateRunnable.setThreadParam(sMPvData, n);
        Thread thread = new Thread((Runnable)this.viewCreateRunnable, "ViewCreateThread");
        thread.start();
    }

    public void startViewCreateThread(SMPvData sMPvData, int n, SMPvViewPnt sMPvViewPnt) {
        this.viewCreateRunnable.setThreadParam(sMPvData, n, sMPvViewPnt);
        Thread thread = new Thread((Runnable)this.viewCreateRunnable, "ViewCreateThread");
        thread.start();
    }

    protected void toggleDetailsFlag() {
        this.compDetailsShowing ^= true;
    }

    public void updateAlarm(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            Vector vector = (Vector)arrayList.get(n);
            this.processOneAlarm(vector);
            ++n;
        }
    }

    public void updateBeanDataTree() {
        this.getParent().setVisible(false);
        this.removeAll();
        this.getParent().validate();
        this.dataTree = null;
        if (this.compDetail != null) {
            this.compDetail.setModuleName(this.moduleName);
        }
        this.postStatus(this.getI18NString("pvReloadingHierarchy"));
        if (!this.initDataTree()) {
            this.postStatus(this.getI18NString("pvLoadingHierarchyFailed"));
            this.getParent().setVisible(true);
            return;
        }
        this.postStatus(this.getI18NString("pvReloadingConsole"));
        if (!this.initSMPvBean()) {
            this.postStatus(this.getI18NString("pvLoadingConsoleFailed"));
            this.getParent().setVisible(true);
            return;
        }
        this.postStatus("");
        if (this.getModuleName().equals("Config-Reader4u")) {
            this.dr.setVisible(true);
        }
        this.displayMainPanel();
        this.populateComponentDetails(new Vector());
    }

    public synchronized void updateDataTree() {
        this.treeDataCache.clear();
        this.compDataCache.clear();
        this.propCache.clear();
        this.treePropOrderCache.clear();
        this.rawTreePropCache.clear();
        this.updateBeanDataTree();
        try {
            this.updateBean.addAlarmUpdateListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateUpControls() {
        SMPvViewPnt sMPvViewPnt = this.currentViewPnt.getParent();
        if (sMPvViewPnt == null) {
            this.deactivateUp();
        } else {
            this.activateUp();
        }
    }

    public boolean viewExists(SMPvViewPnt sMPvViewPnt) {
        int n = this.views.size();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.navViews.size()) {
            if (sMPvViewPnt == (SMPvViewPnt)this.navViews.elementAt(n2)) {
                this.navIndex = n2 + 1;
                this.addView();
                return true;
            }
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        return false;
    }
}

