/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.bootstrap;

import com.sun.symon.base.bootstrap.BsRMIBootstrapException;
import com.sun.symon.base.bootstrap.BsRMIClassLoader;
import com.sun.symon.base.bootstrap.RMIDHCPConfigurator;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1Exception;
import com.sun.symon.base.server.receptors.rmi.RMILoginException;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;

public class BsRMIBootstrap {
    public RMIClientLevel1 ServerConn;

    public BsRMIBootstrap(String string, int n) throws BsRMIBootstrapException {
        new RMIDHCPConfigurator(string);
        try {
            this.ServerConn = new RMIClientLevel1(string, n);
        }
        catch (IOException iOException) {
            this.bootLogError(iOException);
            throw new BsRMIBootstrapException(1, iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.bootLogError(classNotFoundException);
            throw new BsRMIBootstrapException(9, classNotFoundException.getMessage());
        }
        catch (RMIClientLevel1Exception rMIClientLevel1Exception) {
            this.bootLogError(rMIClientLevel1Exception);
            switch (rMIClientLevel1Exception.getReason()) {
                case 0: {
                    throw new BsRMIBootstrapException(2, rMIClientLevel1Exception.getMessage());
                }
                case 1: {
                    throw new BsRMIBootstrapException(3, rMIClientLevel1Exception.getMessage());
                }
                case 2: {
                    throw new BsRMIBootstrapException(4, rMIClientLevel1Exception.getMessage());
                }
                case 3: {
                    throw new BsRMIBootstrapException(5, rMIClientLevel1Exception.getMessage());
                }
                case 4: {
                    throw new BsRMIBootstrapException(17, rMIClientLevel1Exception.getMessage());
                }
            }
        }
    }

    public void authenticate(String string, String string2, String string3, String string4, boolean bl) throws BsRMIBootstrapException {
        try {
            this.ServerConn.authenticate(string, string2, string3, string4, bl);
        }
        catch (RemoteException remoteException) {
            this.bootLogError(remoteException);
            throw new BsRMIBootstrapException(1, remoteException.getMessage());
        }
        catch (RMILoginException rMILoginException) {
            this.bootLogError(rMILoginException);
            switch (rMILoginException.getReason()) {
                case 1: {
                    throw new BsRMIBootstrapException(6, rMILoginException.getMessage());
                }
                case 2: {
                    throw new BsRMIBootstrapException(7, rMILoginException.getMessage());
                }
                case 3: {
                    throw new BsRMIBootstrapException(8, rMILoginException.getMessage());
                }
                case 4: {
                    throw new BsRMIBootstrapException(12, rMILoginException.getMessage());
                }
                case 5: {
                    throw new BsRMIBootstrapException(13, rMILoginException.getMessage());
                }
                case 6: {
                    throw new BsRMIBootstrapException(14, rMILoginException.getMessage());
                }
                case 7: {
                    throw new BsRMIBootstrapException(15, rMILoginException.getMessage());
                }
                case 8: {
                    throw new BsRMIBootstrapException(16, rMILoginException.getMessage());
                }
            }
        }
    }

    private void bootLogError(Exception exception) {
        try {
            InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
            UcDDL.logDebugMessage((String)("Bootstrap Error: " + exception));
            UcDDL.logDebugMessage((String)("Target Exception: " + invocationTargetException.getTargetException()), (Throwable)invocationTargetException);
        }
        catch (Exception exception2) {
            UcDDL.logDebugMessage((String)("Bootstrap Error: " + exception), (Throwable)exception);
        }
    }

    public RMIClientLevel1 getServerConn() {
        return this.ServerConn;
    }

    public void launch(String string) throws BsRMIBootstrapException {
        Object[] objectArray;
        Method method;
        Class[] classArray;
        BsRMIClassLoader bsRMIClassLoader = BsRMIClassLoader.getClassLoader(this.ServerConn);
        UcInternationalizer.setLoader((ClassLoader)bsRMIClassLoader);
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        try {
            clazz = bsRMIClassLoader.loadClass("com.sun.symon.base.xobject.XObjectBase");
            clazz2 = bsRMIClassLoader.loadClass("com.sun.symon.base.bootstrap.BsRMIBootLoader");
            clazz3 = bsRMIClassLoader.loadClass("com.sun.symon.base.client.SMRawDataRequest");
        }
        catch (Exception exception) {
            this.bootLogError(exception);
            throw new BsRMIBootstrapException(9, "Error loading dynamic classes.");
        }
        Object object = null;
        try {
            classArray = new Class[]{this.ServerConn.getClass(), bsRMIClassLoader.getClass()};
            method = clazz2.getMethod("initialize", classArray);
            objectArray = new Object[]{this.ServerConn, bsRMIClassLoader};
            object = method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            this.bootLogError(exception);
            throw new BsRMIBootstrapException(10, "Error initializing object loading system.");
        }
        try {
            classArray = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.Object")};
            method = object.getClass().getMethod("setProperty", classArray);
            objectArray = new Object[]{"ServerLevel1Connection", this.ServerConn};
            method.invoke(object, objectArray);
            Class[] classArray2 = new Class[]{this.ServerConn.getClass()};
            Constructor<?> constructor = clazz3.getConstructor(classArray2);
            Object[] objectArray2 = new Object[]{this.ServerConn};
            objectArray[0] = "ClientAPIInstance";
            objectArray[1] = constructor.newInstance(objectArray2);
            method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            this.bootLogError(exception);
            throw new BsRMIBootstrapException(10, "Error initializing data sources.");
        }
        try {
            classArray = new Class[]{Class.forName("java.lang.String")};
            method = clazz.getMethod("importBootstrap", classArray);
            objectArray = new Object[]{string};
            method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            this.bootLogError(exception);
            throw new BsRMIBootstrapException(11, "Could not load " + string);
        }
    }
}

