/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration;

import com.sun.symon.tools.migration.datasource.MdDataSource;
import com.sun.symon.tools.migration.datasource.MdDataSourceProperties;
import com.sun.symon.tools.migration.datasource.MdTable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public abstract class TmFileDataSource
extends MdDataSource {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private String directory;
    private String fileName;
    protected BufferedReader in;
    protected BufferedWriter out;

    protected TmFileDataSource(MdTable mdTable, MdDataSourceProperties mdDataSourceProperties) throws Exception {
        super(mdTable, mdDataSourceProperties);
        this.parseProperties();
    }

    public Object clone() {
        TmFileDataSource tmFileDataSource = (TmFileDataSource)super.clone();
        tmFileDataSource.in = null;
        tmFileDataSource.out = null;
        return tmFileDataSource;
    }

    protected void closeImpl() throws IOException {
        block4: {
            try {
                if (this.out == null) break block4;
                this.out.close();
                this.out = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                throw throwable;
            }
        }
        Object var2_1 = null;
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void openAppendImpl() throws IOException {
        this.out = new BufferedWriter(new FileWriter(String.valueOf(this.directory) + this.fileName, true));
    }

    protected void openReadImpl() throws IOException {
        this.in = new BufferedReader(new FileReader(String.valueOf(this.directory) + this.fileName));
    }

    protected void openWriteImpl() throws IOException {
        this.out = new BufferedWriter(new FileWriter(String.valueOf(this.directory) + this.fileName, false));
    }

    protected void parsePropertiesImpl(MdDataSourceProperties mdDataSourceProperties) {
        this.directory = mdDataSourceProperties.getProperty("directory");
        this.fileName = mdDataSourceProperties.getProperty("file");
        if (this.directory == null) {
            this.directory = ".";
        }
        this.directory = this.directory.replace('/', FILE_SEPARATOR.charAt(0));
        if (!this.directory.endsWith(FILE_SEPARATOR) && this.directory.length() > 0) {
            this.directory = String.valueOf(this.directory) + FILE_SEPARATOR;
        }
        this.setName(String.valueOf(this.directory) + this.fileName);
    }
}

