/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration;

import com.sun.symon.tools.migration.TmFileDataSource;
import com.sun.symon.tools.migration.datasource.MdDataSourceProperties;
import com.sun.symon.tools.migration.datasource.MdRecord;
import com.sun.symon.tools.migration.datasource.MdTable;
import com.sun.symon.tools.migration.util.MuUtil;
import java.io.IOException;

public class TmCSVDataSource
extends TmFileDataSource {
    protected char fieldSeparator = (char)44;
    protected char stringDelimeter = (char)34;

    public TmCSVDataSource(MdTable mdTable, MdDataSourceProperties mdDataSourceProperties) throws Exception {
        super(mdTable, mdDataSourceProperties);
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public char getStringDelimeter() {
        return this.stringDelimeter;
    }

    protected MdRecord readImpl() throws IOException {
        String string = this.in.readLine();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        MdTable mdTable = this.getMdTable();
        int n = mdTable.attributes();
        String[] stringArray = MuUtil.parseCSV(string, this.fieldSeparator, this.stringDelimeter);
        if (stringArray.length > n) {
            throw new RuntimeException("Too many values in: [" + string + "] expected " + n);
        }
        if (stringArray.length < n) {
            throw new RuntimeException("Too few values in: [" + string + "] expected " + n);
        }
        return this.readImpl(stringArray);
    }

    protected MdRecord readImpl(String[] stringArray) throws IOException {
        MdRecord mdRecord = this.getMdTable().newMdRecord();
        int n = this.getMdTable().attributes();
        int n2 = 0;
        while (n2 < n) {
            mdRecord.getMdValue(n2).set(stringArray[n2]);
            ++n2;
        }
        return mdRecord;
    }

    public void setFieldSeparator(char c) {
        this.fieldSeparator = c;
    }

    public void setStringDelimeter(char c) {
        this.stringDelimeter = c;
    }

    protected void writeImpl(MdRecord mdRecord) throws IOException {
        int n = this.getMdTable().attributes();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                this.out.write(this.fieldSeparator);
                this.out.write(32);
            }
            this.out.write(this.stringDelimeter);
            String string = mdRecord.getMdValue(n2).toString();
            if (string == null) {
                this.out.write("");
            } else {
                this.out.write(string);
            }
            this.out.write(this.stringDelimeter);
            ++n2;
        }
        this.out.write(10);
    }
}

