/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ssl;

import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.SocketConnectionFactory;
import com.visigenic.vbroker.orb.TcpConnection;
import org.omg.CORBA.INTERNAL;

public class AuroraSSLConnectionFactory
implements SocketConnectionFactory {
    private ORB _orb;
    IiopProtocol _protocol;
    String _sslSocketClass = "oracle.aurora.ssl.AuroraSSLSocket";

    AuroraSSLConnectionFactory(ORB orb, IiopProtocol protocol) {
        this._orb = orb;
        this._protocol = protocol;
    }

    public Connection connect(TaggedProfile profile) {
        if (this._orb.debug) {
            ProfileBody profileBody = this._protocol.profileBody(profile);
            this._orb.println("SSLConnectionFactory trying to connect to " + profileBody.host + ":" + this._protocol.port(profileBody));
        }
        Object[] args = new Object[]{this._protocol, this.doCreate(this._sslSocketClass, new Boolean(true)), this};
        TcpConnection connection = (TcpConnection)this._orb.create(27, args);
        connection.connect(profile);
        return connection;
    }

    public Connection connect(String localHostName, int localPort, TaggedProfile profile) {
        if (this._orb.debug) {
            ProfileBody profileBody = this._protocol.profileBody(profile);
            this._orb.println("SSLConnectionFactory trying to connect to " + profileBody.host + ":" + this._protocol.port(profileBody) + " from " + localHostName + ":" + localPort);
        }
        Object[] args = new Object[]{this._protocol, this.doCreate(this._sslSocketClass, new Boolean(true)), this};
        TcpConnection connection = (TcpConnection)this._orb.create(27, args);
        connection.connect(localHostName, localPort, profile);
        return connection;
    }

    private Object doCreate(String className, Object arg) {
        try {
            Object result = Class.forName(className).newInstance();
            Object[] args = new Object[]{arg};
            if (result instanceof OrbObject) {
                ((OrbObject)result).init(this._orb, args);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new INTERNAL(e.toString());
        }
    }

    public Object hashEndpoint(TaggedProfile profile) {
        return new TcpEndpoint(profile);
    }

    public ConnectionFactory.Listener listen(TaggedProfile profile) {
        return null;
    }

    class TcpEndpoint {
        private String _host;
        private int _port;

        public TcpEndpoint(TaggedProfile profile) {
            ProfileBody pb = AuroraSSLConnectionFactory.this._protocol.profileBody(profile);
            this._host = pb.host;
            this._port = AuroraSSLConnectionFactory.this._protocol.port(pb);
        }

        public boolean equals(Object object) {
            if (object instanceof TcpEndpoint) {
                TcpEndpoint rhs = (TcpEndpoint)object;
                if (this._port == rhs._port && this._host.equals(rhs._host)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this._host.hashCode() + this._port;
        }

        public String toString() {
            return String.valueOf(this._host) + ":" + this._port;
        }
    }
}

