/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import md5.MD5InputStream;
import oracle.aurora.AuroraServices.ActivatableObject;
import oracle.aurora.AuroraServices.LoadJavaOperations;
import oracle.aurora.AuroraServices._tie_LoadJava;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.server.utilities.RedirectIO;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OraclePreparedStatement;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class LoadJavaImpl
implements LoadJavaOperations,
ActivatableObject {
    private boolean initialized = false;
    private Connection conn;
    byte[] md5;
    private static final String MD5TableName = "JAVA$CLASS$MD5$TABLE";
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final String loadLobsPackage = "create package loadlobs is   column blob;   end_of_lob binary_integer;   function beginload (classfile varchar2) return varchar2;   procedure appendpiece (piece raw, len binary_integer);   function endload (classfile varchar2) return varchar2;   function beginread (classfile varchar2, len out binary_integer)          return varchar2;   function getpiece (piece out raw, len in out binary_integer)          return varchar2;   function endread (classfile varchar2) return varchar2; end loadlobs;";
    private static final String loadLobsBody = "create package body loadlobs is   function beginload (classfile varchar2) return varchar2 is   begin      column := null;      end_of_lob := 1;          delete from CREATE$JAVA$LOB$TABLE where name = classfile;     insert into CREATE$JAVA$LOB$TABLE (name, lob, loadtime)         values (classfile, empty_blob(), sysdate);     select lob into column from CREATE$JAVA$LOB$TABLE          where name = classfile;     return '';   exception when others then return sqlerrm;   end;   procedure appendpiece (piece raw, len binary_integer) is   begin      dbms_lob.write(column, len, end_of_lob, piece);      end_of_lob := end_of_lob + len;   end;   function endload (classfile varchar2) return varchar2 is   begin     if end_of_lob - 1 != dbms_lob.getlength(column)    then return 'length mismatch: sum of piece lengths = ' ||          end_of_lob - 1 ||          ', while dbms_lob.getlength = ' || dbms_lob.getlength(column);    end if;    return '';    exception when others then return sqlerrm;   end;   function beginread (classfile varchar2, len out binary_integer)          return varchar2 is   begin     end_of_lob := 1;          select lob into column from CREATE$JAVA$LOB$TABLE          where name = classfile;     len := dbms_lob.getlength(column);     return '';   exception when others then return sqlerrm;   end;   function getpiece (piece out raw, len in out binary_integer)          return varchar2 is   begin     dbms_lob.read(column, len, end_of_lob, piece);      end_of_lob := end_of_lob + len;     return '';   exception when others then return sqlerrm;   end;   function endread (classfile varchar2) return varchar2 is   begin    if end_of_lob - 1 != dbms_lob.getlength(column)    then return 'length mismatch: sum of piece lengths = ' ||          end_of_lob - 1 ||          ', while dbms_lob.getlength = ' || dbms_lob.getlength(column);    end if;    return '';   exception when others then return sqlerrm;   end; end loadlobs;";

    public Object _initializeAuroraObject() {
        return new _tie_LoadJava(this);
    }

    private void close(CallableStatement cs) {
        if (cs == null) {
            return;
        }
        try {
            cs.close();
        }
        catch (SQLException sQLException) {}
    }

    private void close(Statement s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (SQLException sQLException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compile(StringHolder errors, String className) {
        int n;
        PrintStream err;
        PrintStream out;
        ByteArrayOutputStream output;
        block6: {
            int n2;
            block5: {
                output = new ByteArrayOutputStream(500);
                out = System.out;
                err = System.err;
                PrintStream redirected = new PrintStream(output);
                AccessController.doPrivileged(new RedirectIO(redirected, redirected));
                try {
                    try {
                        if (this.resolve(className)) {
                            n2 = 1;
                            java.lang.Object var9_10 = null;
                            errors.value = output.toString();
                            break block5;
                        }
                        n = 0;
                        break block6;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        int n3 = 0;
                        java.lang.Object var9_12 = null;
                        errors.value = output.toString();
                        AccessController.doPrivileged(new RedirectIO(out, err));
                        return n3;
                    }
                }
                catch (Throwable throwable) {
                    java.lang.Object var9_13 = null;
                    errors.value = output.toString();
                    AccessController.doPrivileged(new RedirectIO(out, err));
                    throw throwable;
                }
            }
            AccessController.doPrivileged(new RedirectIO(out, err));
            return n2;
        }
        java.lang.Object var9_11 = null;
        errors.value = output.toString();
        AccessController.doPrivileged(new RedirectIO(out, err));
        return n;
    }

    private boolean createClass(String classname, String resolver, String schema, String rights) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        this.msg("creating : " + classname);
        try {
            try {
                stmt = conn.createStatement();
                stmt.execute("create or replace java class " + resolver + schema + rights + " using '" + classname + "'");
            }
            finally {
                java.lang.Object var8_7 = null;
                this.close(stmt);
            }
        }
        catch (SQLException e) {
            this.msg("SQL error during creation of: " + classname);
            this.msg(e.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {}
            return false;
        }
        return true;
    }

    private void createMD5Table() {
        try {
            Statement stmt = null;
            try {
                stmt = this.conn.createStatement();
                stmt.execute("create table JAVA$CLASS$MD5$TABLE (name varchar2(200) unique, md5 raw(16))");
            }
            finally {
                java.lang.Object var3_2 = null;
                this.close(stmt);
            }
        }
        catch (SQLException sQLException) {}
    }

    private boolean createResource(String resourceName) {
        Connection conn = this.getConnection();
        this.msg("creating : " + resourceName);
        try {
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                stmt.execute("create or replace java resource named \"" + resourceName + "\"  using '" + resourceName + "'");
            }
            finally {
                java.lang.Object var5_5 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.msg("SQLException when creating resource: " + resourceName);
            this.msg(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean createSource(String classname, String encoding, String resolver, String schema, String bound, boolean compile, String classSource) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String _compile = null;
        if (compile) {
            _compile = " and compile ";
            this.msg("compiling: " + classname);
        } else {
            _compile = " ";
            this.msg("creating : " + classname);
        }
        try {
            try {
                stmt = conn.createStatement();
                if (!this.isNullString(encoding)) {
                    stmt.execute("call dbms_java.set_compiler_option('" + classname + "'," + " 'encoding', " + "'" + encoding + "')");
                }
                stmt.execute("create or replace " + _compile + " java source named \"" + classname + "\" " + resolver + schema + bound + " using '" + classname + "'");
                this.getErrors(classname);
            }
            finally {
                java.lang.Object var12_11 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.msg("SQL error during creation of: " + classname);
            this.msg(e.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {}
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int create_class(StringHolder errors, String classname, String resolver, String schema, String grant, String bound, byte[] classBits) {
        int n;
        PrintStream err;
        PrintStream out;
        ByteArrayOutputStream output;
        block16: {
            int n2;
            block15: {
                int n3;
                block14: {
                    int n4;
                    block13: {
                        int n5;
                        block12: {
                            int n6;
                            block11: {
                                int n7;
                                block10: {
                                    output = new ByteArrayOutputStream(500);
                                    out = System.out;
                                    err = System.err;
                                    PrintStream redirected = new PrintStream(output);
                                    AccessController.doPrivileged(new RedirectIO(redirected, redirected));
                                    try {
                                        try {
                                            if (!this.init()) {
                                                n7 = 0;
                                                java.lang.Object var14_20 = null;
                                                errors.value = output.toString();
                                                break block10;
                                            }
                                            ByteArrayInputStream is = new ByteArrayInputStream(classBits);
                                            if (!this.isClassDifferent(classname, is)) {
                                                if (!this.grantExecute(classname, grant)) {
                                                    n6 = 0;
                                                    break block11;
                                                }
                                                n5 = 1;
                                                break block12;
                                            }
                                            is = new ByteArrayInputStream(classBits);
                                            if (!this.load(classname, is)) {
                                                n4 = 0;
                                                break block13;
                                            }
                                            if (!this.createClass(classname, resolver, schema, bound)) {
                                                n3 = 0;
                                                break block14;
                                            }
                                            this.updateMD5(classname);
                                            if (!this.grantExecute(classname, grant)) {
                                                n2 = 0;
                                                break block15;
                                            }
                                            n = 1;
                                            break block16;
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                            int n8 = 0;
                                            java.lang.Object var14_27 = null;
                                            errors.value = output.toString();
                                            AccessController.doPrivileged(new RedirectIO(out, err));
                                            return n8;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        java.lang.Object var14_28 = null;
                                        errors.value = output.toString();
                                        AccessController.doPrivileged(new RedirectIO(out, err));
                                        throw throwable;
                                    }
                                }
                                AccessController.doPrivileged(new RedirectIO(out, err));
                                return n7;
                            }
                            java.lang.Object var14_21 = null;
                            errors.value = output.toString();
                            AccessController.doPrivileged(new RedirectIO(out, err));
                            return n6;
                        }
                        java.lang.Object var14_22 = null;
                        errors.value = output.toString();
                        AccessController.doPrivileged(new RedirectIO(out, err));
                        return n5;
                    }
                    java.lang.Object var14_23 = null;
                    errors.value = output.toString();
                    AccessController.doPrivileged(new RedirectIO(out, err));
                    return n4;
                }
                java.lang.Object var14_24 = null;
                errors.value = output.toString();
                AccessController.doPrivileged(new RedirectIO(out, err));
                return n3;
            }
            java.lang.Object var14_25 = null;
            errors.value = output.toString();
            AccessController.doPrivileged(new RedirectIO(out, err));
            return n2;
        }
        java.lang.Object var14_26 = null;
        errors.value = output.toString();
        AccessController.doPrivileged(new RedirectIO(out, err));
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int create_resource(StringHolder errors, String resourcename, String grant, byte[] resourceBits) {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream(500);
        PrintStream out = System.out;
        PrintStream err = System.err;
        PrintStream redirected = new PrintStream(output);
        AccessController.doPrivileged(new RedirectIO(redirected, redirected));
        try {
            try {
                n = 0;
                java.lang.Object var11_11 = null;
                errors.value = output.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
                int n2 = 0;
                java.lang.Object var11_12 = null;
                errors.value = output.toString();
                AccessController.doPrivileged(new RedirectIO(out, err));
                return n2;
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var11_13 = null;
            errors.value = output.toString();
            AccessController.doPrivileged(new RedirectIO(out, err));
            throw throwable;
        }
        AccessController.doPrivileged(new RedirectIO(out, err));
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int create_source(StringHolder errors, String classname, String encoding, String resolver, String schema, String grant, String bound, int compile, String classSource) {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream(500);
        PrintStream out = System.out;
        PrintStream err = System.err;
        PrintStream redirected = new PrintStream(output);
        AccessController.doPrivileged(new RedirectIO(redirected, redirected));
        try {
            try {
                n = 0;
                java.lang.Object var16_16 = null;
                errors.value = output.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
                int n2 = 0;
                java.lang.Object var16_17 = null;
                errors.value = output.toString();
                AccessController.doPrivileged(new RedirectIO(out, err));
                return n2;
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var16_18 = null;
            errors.value = output.toString();
            AccessController.doPrivileged(new RedirectIO(out, err));
            throw throwable;
        }
        AccessController.doPrivileged(new RedirectIO(out, err));
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int create_synonym(StringHolder errors, String resourceName) {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream(500);
        PrintStream out = System.out;
        PrintStream err = System.err;
        PrintStream redirected = new PrintStream(output);
        AccessController.doPrivileged(new RedirectIO(redirected, redirected));
        try {
            try {
                n = 0;
                java.lang.Object var9_9 = null;
                errors.value = output.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
                int n2 = 0;
                java.lang.Object var9_10 = null;
                errors.value = output.toString();
                AccessController.doPrivileged(new RedirectIO(out, err));
                return n2;
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var9_11 = null;
            errors.value = output.toString();
            AccessController.doPrivileged(new RedirectIO(out, err));
            throw throwable;
        }
        AccessController.doPrivileged(new RedirectIO(out, err));
        return n;
    }

    private Connection getConnection() {
        if (this.conn != null) {
            return this.conn;
        }
        try {
            this.conn = new OracleDriver().defaultConnection();
            this.conn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {}
        return this.conn;
    }

    private void getErrors(String classname) {
        Connection conn = this.getConnection();
        try {
            CallableStatement call = null;
            try {
                call = conn.prepareCall("{ ? = call get_error$.error_lines (?)}");
                call.registerOutParameter(1, -10);
                call.setString(2, classname);
                call.execute();
                ResultSet rset = (ResultSet)call.getObject(1);
                boolean firstMsg = true;
                while (rset.next()) {
                    if (firstMsg) {
                        firstMsg = false;
                        this.msg("Errors in " + classname + ":");
                    }
                    this.msg(rset.getString(1));
                }
            }
            finally {
                java.lang.Object var5_7 = null;
                if (call != null) {
                    call.close();
                }
            }
        }
        catch (SQLException e) {
            this.msg("SQL error in retrieving errors for : " + classname);
            this.msg(e.getMessage());
        }
    }

    private boolean grantExecute(String classname, String grant) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            block6: {
                try {
                    stmt = conn.createStatement();
                    if (this.isNullString(grant)) break block6;
                    this.msg("granting : " + grant + " execute on: " + classname);
                    stmt.execute("grant execute on \"" + classname + "\" to " + grant);
                }
                catch (Throwable throwable) {
                    java.lang.Object var6_6 = null;
                    this.close(stmt);
                    throw throwable;
                }
            }
            java.lang.Object var6_5 = null;
            this.close(stmt);
        }
        catch (SQLException e) {
            this.msg("SQL error during grant of execute rights to: " + grant + " on: " + classname);
            this.msg(e.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {}
            return false;
        }
        return true;
    }

    public int has_changed(String className, byte[] md5) {
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean init() {
        if (this.initialized) {
            return true;
        }
        Connection conn = this.getConnection();
        try {
            block12: {
                Statement stmt = null;
                try {
                    stmt = conn.createStatement();
                    try {
                        stmt.execute("create table CREATE$JAVA$LOB$TABLE (name varchar2(200) unique, lob blob, loadtime date)");
                    }
                    catch (SQLException sQLException) {}
                    try {
                        stmt.execute(loadLobsPackage);
                        stmt.execute(loadLobsBody);
                    }
                    catch (SQLException sQLException) {}
                    try {
                        stmt.execute("create table JAVA$CLASS$MD5$TABLE (name varchar2(200) unique, md5 raw(16))");
                    }
                    catch (SQLException sQLException) {
                    }
                    java.lang.Object var4_4 = null;
                    if (stmt == null) break block12;
                }
                catch (Throwable throwable) {
                    java.lang.Object var4_5 = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                stmt.close();
            }
            this.initialized = true;
            return true;
        }
        catch (SQLException e) {
            this.msg("SQL error when loading the LOADLOBS package");
            this.msg(e.getMessage());
            return false;
        }
    }

    private boolean isClassDifferent(String className, InputStream inputStream) {
        boolean result = true;
        this.md5 = this.md5OfStream(inputStream);
        try {
            Statement stmt;
            block5: {
                stmt = null;
                try {
                    stmt = this.conn.createStatement();
                    stmt.execute("SELECT MD5 FROM JAVA$CLASS$MD5$TABLE WHERE NAME = '" + className + "'");
                    ResultSet rs = stmt.getResultSet();
                    if (!rs.next()) break block5;
                    result = this.md5IsEqual(rs.getBytes(1), this.md5) ^ true;
                }
                catch (Throwable throwable) {
                    java.lang.Object var6_8 = null;
                    this.close(stmt);
                    throw throwable;
                }
            }
            java.lang.Object var6_7 = null;
            this.close(stmt);
        }
        catch (SQLException e) {
            this.msg(String.valueOf(String.valueOf(e)) + "accessing MD5 table");
        }
        if (!result) {
            this.msg("identical: " + className + " is unchanged from previously loaded file");
        }
        return result;
    }

    private boolean isNullString(String string) {
        if (string == null) {
            return true;
        }
        return string.equals("");
    }

    private boolean load(String name, InputStream inputStream) {
        byte[] buf = new byte[4096];
        Connection conn = this.getConnection();
        CallableStatement cs = null;
        try {
            block11: {
                try {
                    long byte_count;
                    this.msg("loading  : " + name);
                    cs = conn.prepareCall("begin ? := loadlobs.beginload( ? ); end;");
                    cs.registerOutParameter(1, 12);
                    cs.setString(2, name);
                    cs.execute();
                    String err = cs.getString(1);
                    if (!cs.wasNull()) {
                        System.out.println(err);
                    }
                    cs.close();
                    ((OracleConnection)conn).setDefaultExecuteBatch(100);
                    cs = conn.prepareCall("begin loadlobs.appendpiece(?, ?); end;");
                    int loop_count = 0;
                    while ((byte_count = (long)inputStream.read(buf, 0, buf.length)) >= 1L) {
                        cs.setBytes(1, buf);
                        cs.setLong(2, byte_count);
                        cs.execute();
                        ++loop_count;
                    }
                    int rows_updated = ((OraclePreparedStatement)cs).sendBatch();
                    cs.close();
                    cs = conn.prepareCall("begin ? := loadlobs.endload( ? ); end;");
                    cs.registerOutParameter(1, 12);
                    cs.setString(2, name);
                    cs.execute();
                    err = cs.getString(1);
                    if (cs.wasNull()) break block11;
                    this.msg(err);
                }
                catch (Throwable throwable) {
                    java.lang.Object var11_11 = null;
                    this.close(cs);
                    throw throwable;
                }
            }
            java.lang.Object var11_10 = null;
            this.close(cs);
        }
        catch (SQLException e) {
            this.msg("SQL Error in loading: " + name);
            this.msg(e.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {}
            return false;
        }
        catch (IOException e) {
            this.msg("IO Error in loading: " + name);
            this.msg(e.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {}
            return false;
        }
        return true;
    }

    private boolean md5IsEqual(byte[] a1, byte[] a2) {
        int i = 0;
        while (i < 16) {
            if (a1[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private byte[] md5OfStream(InputStream in) {
        int l;
        MD5InputStream md5in = new MD5InputStream(in);
        do {
            try {
                l = md5in.read();
            }
            catch (IOException iOException) {
                l = -1;
            }
        } while (l >= 0);
        return md5in.hash();
    }

    private void msg(String msg) {
        System.err.println(msg);
    }

    private boolean resolve(String classname) {
        Connection conn = this.getConnection();
        if (Handle.lookupClass((String)classname).status() == 1) {
            this.msg(String.valueOf(classname) + " already resolved");
            return true;
        }
        try {
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                System.out.println("resolving: " + classname);
                stmt.execute("alter java class \"" + classname + "\" compile");
                this.getErrors(classname);
            }
            finally {
                java.lang.Object var5_5 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.msg("SQL error in resolving class: " + classname);
            this.msg(e.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {}
            return false;
        }
        return true;
    }

    private void updateMD5(String classname) {
        Connection conn = this.getConnection();
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = conn.prepareStatement("DELETE FROM JAVA$CLASS$MD5$TABLE WHERE NAME = ? ");
                pstmt.setString(1, classname);
                pstmt.executeUpdate();
                pstmt.close();
                pstmt = conn.prepareStatement("INSERT INTO JAVA$CLASS$MD5$TABLE (NAME, MD5) VALUES(?, ?)");
                pstmt.setString(1, classname);
                pstmt.setBytes(2, this.md5);
                pstmt.executeUpdate();
            }
            finally {
                java.lang.Object var5_4 = null;
                if (pstmt != null) {
                    pstmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.msg(String.valueOf(e.getMessage()) + " : updating MD5 of: " + classname);
        }
    }
}

