/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.publishing;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import oracle.aurora.AuroraServices.ctxAttribs;
import oracle.aurora.AuroraServices.objAttribs;
import oracle.aurora.jts.util.TS;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.server.publishing.Binding;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import org.omg.CosNaming.NameComponent;
import org.omg.CosTransactions.Control;

class NamespaceRDBMS {
    static String bindings = "aurora$sns$bindings$";
    static String inode = "aurora$sns$inode$";
    static String permissions = "aurora$sns$permissions$";
    static int READ = 0;
    static int WRITE = 1;
    static int EXECUTE = 2;
    static Connection con;
    private Control control;

    static {
        try {
            con = new OracleDriver().defaultConnection();
            con.setAutoCommit(false);
        }
        catch (SQLException sQLException) {}
    }

    NamespaceRDBMS() {
    }

    NamespaceRDBMS(Connection c) {
        con = c;
    }

    void abortTxn() {
        try {
            if (TS.getXAFlag()) {
                TS.getTS().getCurrent().rollback();
                if (this.control != null) {
                    TS.getTS().getCurrent().resume(this.control);
                }
            } else {
                con.rollback();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void beginTxn() {
        try {
            if (TS.getXAFlag() || ((OracleConnection)con).getXAErrorFlag()) {
                if (!((OracleConnection)con).getXAErrorFlag()) {
                    this.control = TS.getTS().getCurrent().suspend();
                }
                TS.getTS().getCurrent().begin();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void bind(Binding binding) throws SQLException {
        CallableStatement call = null;
        try {
            call = con.prepareCall("begin dbms_orb_context.link(:1, :2, :3, :4, :5); end;");
            call.setLong(1, binding.parent);
            call.setLong(2, binding.child);
            call.setString(3, binding.id);
            call.setString(4, binding.kind.equals("") ? "." : binding.kind);
            call.setInt(5, binding.binding_type);
            call.execute();
        }
        finally {
            Object var4_3 = null;
            this.close(call);
        }
    }

    private void close(CallableStatement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {}
    }

    void close(PreparedStatement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {}
    }

    void close(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    private void close(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {}
    }

    void commitROTxn() {
        try {
            if (TS.getXAFlag()) {
                TS.getTS().getCurrent().rollback();
                if (this.control != null) {
                    TS.getTS().getCurrent().resume(this.control);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void commitTxn() {
        try {
            if (TS.getXAFlag()) {
                TS.getTS().getCurrent().commit(true);
                if (this.control != null) {
                    TS.getTS().getCurrent().resume(this.control);
                }
            } else {
                con.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    long create_object(String className, int schema, String helper, int owner) throws SQLException {
        CallableStatement call = null;
        try {
            call = con.prepareCall("begin :1 := dbms_orb_context.mkobject(:2, :3, :4, :5); end;");
            call.registerOutParameter(1, 2);
            call.setInt(2, owner);
            call.setInt(3, schema);
            call.setString(4, className);
            call.setString(5, helper);
            call.execute();
            long node = call.getLong(1);
            this.close(call);
            call = con.prepareCall("begin dbms_orb_context.addperm(:1, :2, :3); end;");
            call.setLong(1, node);
            call.setInt(2, READ);
            call.setInt(3, owner);
            call.execute();
            this.close(call);
            call = con.prepareCall("begin dbms_orb_context.addperm(:1, :2, :3); end;");
            call.setLong(1, node);
            call.setInt(2, WRITE);
            call.setInt(3, owner);
            call.execute();
            this.close(call);
            call = con.prepareCall("begin dbms_orb_context.addperm(:1, :2, :3); end;");
            call.setLong(1, node);
            call.setInt(2, EXECUTE);
            call.setInt(3, owner);
            call.execute();
            long l = node;
            Object var9_8 = null;
            this.close(call);
            return l;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.close(call);
            throw throwable;
        }
    }

    void delete(long node) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement("delete from " + inode + " where node = ?");
            pstmt.setLong(1, node);
            pstmt.execute();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.close(pstmt);
            throw throwable;
        }
        Object var5_3 = null;
        this.close(pstmt);
    }

    ResultSet execute(PreparedStatement stmt) throws SQLException {
        stmt.execute();
        return stmt.getResultSet();
    }

    boolean exists(long parent, NameComponent name) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement("select child from " + bindings + " where parent = ? and id = ? and kind = ? for update");
            pstmt.setLong(1, parent);
            pstmt.setString(2, name.id);
            pstmt.setString(3, name.kind.equals("") ? "." : name.kind);
            pstmt.execute();
            rs = pstmt.getResultSet();
            return rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    Binding get_binding(long parent, NameComponent name) throws SQLException {
        Binding binding;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement("select child, binding_type from " + bindings + " where parent = ? and id = ? and kind = ?");
            pstmt.setLong(1, parent);
            pstmt.setString(2, name.id);
            pstmt.setString(3, name.kind.equals("") ? "." : name.kind);
            pstmt.execute();
            rs = pstmt.getResultSet();
            if (!rs.next()) {
                Binding binding2 = null;
                Object var8_7 = null;
                this.close(pstmt);
                this.close(rs);
                return binding2;
            }
            binding = new Binding(parent, rs.getLong(1), name.id, name.kind, rs.getInt(2));
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.close(pstmt);
            this.close(rs);
            throw throwable;
        }
        Object var8_8 = null;
        this.close(pstmt);
        this.close(rs);
        return binding;
    }

    ctxAttribs get_context_attributes(long node) throws SQLException {
        ctxAttribs ctxAttribs2;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement("select owner, creation_ts from " + inode + " where node = ?");
            pstmt.setLong(1, node);
            pstmt.execute();
            rs = pstmt.getResultSet();
            if (!rs.next()) {
                ctxAttribs ctxAttribs3 = null;
                Object var7_6 = null;
                this.close(pstmt);
                this.close(rs);
                return ctxAttribs3;
            }
            ctxAttribs attribs = new ctxAttribs();
            attribs.owner = NamespaceRDBMS.lookup_schema(rs.getInt(1));
            attribs.creation_ts = rs.getTimestamp(2).toString();
            attribs.read = this.get_rights(node, READ);
            attribs.write = this.get_rights(node, WRITE);
            attribs.execute = this.get_rights(node, EXECUTE);
            ctxAttribs2 = attribs;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(pstmt);
            this.close(rs);
            throw throwable;
        }
        Object var7_7 = null;
        this.close(pstmt);
        this.close(rs);
        return ctxAttribs2;
    }

    Date get_last_modified(long node) throws SQLException {
        Timestamp timestamp;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement("select last_modified from " + inode + " where node = ?");
            pstmt.setLong(1, node);
            pstmt.execute();
            rs = pstmt.getResultSet();
            if (!rs.next()) {
                Date date = null;
                Object var7_6 = null;
                this.close(pstmt);
                this.close(rs);
                return date;
            }
            timestamp = rs.getTimestamp(1);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(pstmt);
            this.close(rs);
            throw throwable;
        }
        Object var7_7 = null;
        this.close(pstmt);
        this.close(rs);
        return timestamp;
    }

    objAttribs get_object_attributes(long node) throws SQLException {
        objAttribs objAttribs2;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement("select owner, class, schema, helper, creation_ts, last_modified from " + inode + " where node = ?");
            pstmt.setLong(1, node);
            pstmt.execute();
            rs = pstmt.getResultSet();
            if (!rs.next()) {
                objAttribs objAttribs3 = null;
                Object var7_6 = null;
                this.close(pstmt);
                this.close(rs);
                return objAttribs3;
            }
            objAttribs attribs = new objAttribs();
            attribs.owner = NamespaceRDBMS.lookup_schema(rs.getInt(1));
            attribs.class_name = rs.getString(2);
            attribs.schema = NamespaceRDBMS.lookup_schema(rs.getInt(3));
            attribs.helper = rs.getString(4);
            attribs.creation_ts = rs.getTimestamp(5).toString();
            attribs.last_modified = rs.getTimestamp(6).toString();
            attribs.read = this.get_rights(node, READ);
            attribs.write = this.get_rights(node, WRITE);
            attribs.execute = this.get_rights(node, EXECUTE);
            objAttribs2 = attribs;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(pstmt);
            this.close(rs);
            throw throwable;
        }
        Object var7_7 = null;
        this.close(pstmt);
        this.close(rs);
        return objAttribs2;
    }

    Object[] get_object_class_and_schema(long node) throws SQLException {
        Object[] objectArray;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement("select class, schema from " + inode + " where node = ?");
            pstmt.setLong(1, node);
            pstmt.execute();
            rs = pstmt.getResultSet();
            if (!rs.next()) {
                Object[] objectArray2 = null;
                Object var7_6 = null;
                this.close(pstmt);
                this.close(rs);
                return objectArray2;
            }
            Object[] rslt = new Object[]{rs.getString(1), new Integer(rs.getInt(2))};
            objectArray = rslt;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(pstmt);
            this.close(rs);
            throw throwable;
        }
        Object var7_7 = null;
        this.close(pstmt);
        this.close(rs);
        return objectArray;
    }

    String get_object_helper(long node) throws SQLException {
        String string;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement("select helper from " + inode + " where node = ?");
            pstmt.setLong(1, node);
            pstmt.execute();
            rs = pstmt.getResultSet();
            if (!rs.next()) {
                String string2 = null;
                Object var7_6 = null;
                this.close(pstmt);
                this.close(rs);
                return string2;
            }
            string = rs.getString(1);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(pstmt);
            this.close(rs);
            throw throwable;
        }
        Object var7_7 = null;
        this.close(pstmt);
        this.close(rs);
        return string;
    }

    private String[] get_rights(long node, int type) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            Vector<String> rights = new Vector<String>();
            pstmt = con.prepareStatement("select schema from " + permissions + " where node = :1 and type = :2");
            pstmt.setLong(1, node);
            pstmt.setInt(2, type);
            pstmt.execute();
            rs = pstmt.getResultSet();
            while (rs.next()) {
                String schema = NamespaceRDBMS.lookup_schema(rs.getInt(1));
                if (schema == null) continue;
                rights.addElement(schema);
            }
            Object[] schemas = new String[rights.size()];
            rights.copyInto(schemas);
            Object[] objectArray = schemas;
            Object var8_8 = null;
            this.close(pstmt);
            this.close(rs);
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.close(pstmt);
            this.close(rs);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isContext(long node) throws SQLException {
        boolean bl;
        ResultSet rs;
        PreparedStatement pstmt;
        block5: {
            boolean bl2;
            block4: {
                pstmt = null;
                rs = null;
                try {
                    pstmt = con.prepareStatement("select type from " + inode + " where node = ?");
                    pstmt.setLong(1, node);
                    pstmt.execute();
                    rs = pstmt.getResultSet();
                    if (!rs.next()) {
                        boolean bl3 = false;
                        Object var7_7 = null;
                        this.close(pstmt);
                        this.close(rs);
                        return bl3;
                    }
                    if (rs.getInt(1) == 1) {
                        bl2 = true;
                        break block4;
                    }
                    bl = false;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.close(pstmt);
                    this.close(rs);
                    throw throwable;
                }
            }
            Object var7_8 = null;
            this.close(pstmt);
            this.close(rs);
            return bl2;
        }
        Object var7_9 = null;
        this.close(pstmt);
        this.close(rs);
        return bl;
    }

    Enumeration list_context(long parent) throws SQLException {
        Vector<Binding> b = new Vector<Binding>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement("select child, id, kind, binding_type from " + bindings + " where parent = ?");
            pstmt.setLong(1, parent);
            pstmt.execute();
            rs = pstmt.getResultSet();
            while (rs.next()) {
                b.addElement(new Binding(parent, rs.getLong(1), rs.getString(2), rs.getString(3), rs.getInt(4)));
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.close(pstmt);
            this.close(rs);
            throw throwable;
        }
        Object var7_5 = null;
        this.close(pstmt);
        this.close(rs);
        return b.elements();
    }

    protected static String lookup_schema(int id) {
        try {
            return Schema.lookupOwnerName((int)id, (boolean)true, (boolean)false, (boolean)false, null);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return "PUBLIC";
        }
    }

    protected static int lookup_schema(String id) {
        try {
            return Schema.lookupOwnerNumber((String)id.toUpperCase(), (boolean)true, (boolean)false, (boolean)false, null);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 1;
        }
    }

    long new_context(int owner) throws SQLException {
        CallableStatement call = null;
        try {
            call = con.prepareCall("begin :1 := dbms_orb_context.mkcontext(:2); end;");
            call.registerOutParameter(1, 2);
            call.setInt(2, owner);
            call.execute();
            long node = call.getLong(1);
            this.close(call);
            call = con.prepareCall("begin dbms_orb_context.addperm(:1, :2, :3); end;");
            call.setLong(1, node);
            call.setInt(2, READ);
            call.setInt(3, owner);
            call.execute();
            this.close(call);
            call = con.prepareCall("begin dbms_orb_context.addperm(:1, :2, :3); end;");
            call.setLong(1, node);
            call.setInt(2, WRITE);
            call.setInt(3, owner);
            call.execute();
            this.close(call);
            call = con.prepareCall("begin dbms_orb_context.addperm(:1, :2, :3); end;");
            call.setLong(1, node);
            call.setInt(2, EXECUTE);
            call.setInt(3, owner);
            call.execute();
            long l = node;
            Object var6_5 = null;
            this.close(call);
            return l;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.close(call);
            throw throwable;
        }
    }

    void rebind(Binding binding) throws SQLException {
        CallableStatement call = null;
        try {
            call = con.prepareCall("begin dbms_orb_context.relink(:1, :2, :3, :4); end;");
            call.setLong(1, binding.parent);
            call.setString(2, binding.id);
            call.setString(3, binding.kind.equals("") ? "." : binding.kind);
            call.setLong(4, binding.child);
            call.execute();
        }
        finally {
            Object var4_3 = null;
            this.close(call);
        }
    }

    void republish(long node, String className, int schema, String helper) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement("update " + inode + " set last_modified = SYSDATE, class = ?, schema = ?, helper = ? where node = ?");
            pstmt.setString(1, className);
            pstmt.setInt(2, schema);
            pstmt.setString(3, helper);
            pstmt.setLong(4, node);
            pstmt.execute();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.close(pstmt);
            throw throwable;
        }
        Object var8_6 = null;
        this.close(pstmt);
    }

    void republish(long node, String className, String helper) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement("update " + inode + " set last_modified = SYSDATE, class = ?, helper = ? where node = ?");
            pstmt.setString(1, className);
            pstmt.setString(2, helper);
            pstmt.setLong(3, node);
            pstmt.execute();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.close(pstmt);
            throw throwable;
        }
        Object var7_5 = null;
        this.close(pstmt);
    }

    void set_execute_rights(long node, String[] schemaNames) throws SQLException {
        int[] schemas = new int[schemaNames.length];
        int i = 0;
        while (i < schemaNames.length) {
            schemas[i] = NamespaceRDBMS.lookup_schema(schemaNames[i]);
            ++i;
        }
        this.set_rights(node, EXECUTE, schemas);
    }

    void set_owner(long node, int schema) throws SQLException {
        PreparedStatement pstmt = null;
        if (schema == -1) {
            return;
        }
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement("update " + inode + " set owner = ? where node = ?");
            pstmt.setInt(1, schema);
            pstmt.setLong(2, node);
            pstmt.execute();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.close(pstmt);
            this.close(rs);
            throw throwable;
        }
        Object var7_5 = null;
        this.close(pstmt);
        this.close(rs);
    }

    void set_read_rights(long node, String[] schemaNames) throws SQLException {
        int[] schemas = new int[schemaNames.length];
        int i = 0;
        while (i < schemaNames.length) {
            schemas[i] = NamespaceRDBMS.lookup_schema(schemaNames[i]);
            ++i;
        }
        this.set_rights(node, READ, schemas);
    }

    private void set_rights(long node, int right, int[] schemas) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement("delete from " + permissions + " where node = :1 and type = :2");
            pstmt.setLong(1, node);
            pstmt.setInt(2, right);
            pstmt.execute();
            this.close(pstmt);
            pstmt = con.prepareStatement("insert into " + permissions + " (node, schema, type) values (:1, :2, :3)");
            int i = 0;
            while (i < schemas.length) {
                if (schemas[i] != -1) {
                    pstmt.setLong(1, node);
                    pstmt.setInt(2, schemas[i]);
                    pstmt.setInt(3, right);
                    pstmt.execute();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.close(pstmt);
            throw throwable;
        }
        Object var7_6 = null;
        this.close(pstmt);
    }

    void set_write_rights(long node, String[] schemaNames) throws SQLException {
        int[] schemas = new int[schemaNames.length];
        int i = 0;
        while (i < schemaNames.length) {
            schemas[i] = NamespaceRDBMS.lookup_schema(schemaNames[i]);
            ++i;
        }
        this.set_rights(node, WRITE, schemas);
    }

    void unbind(long parent, NameComponent name) throws SQLException {
        CallableStatement call = null;
        try {
            call = con.prepareCall("begin dbms_orb_context.unlink(:1, :2, :3); end;");
            call.setLong(1, parent);
            call.setString(2, name.id);
            call.setString(3, name.kind.equals("") ? "." : name.kind);
            call.execute();
        }
        finally {
            Object var6_4 = null;
            this.close(call);
        }
    }
}

