/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jts.util;

import java.util.Hashtable;
import oracle.aurora.jts.util.NoORBException;
import oracle.aurora.jts.util.NoTransactionServiceException;
import oracle.aurora.jts.util.TransactionService;
import org.omg.CORBA.ORB;

public class TS {
    static Hashtable ts;
    static Hashtable orb;
    static TransactionService tsS;
    static ORB orbS;
    static boolean inServer;
    static boolean initialized;
    private static boolean XAFlag;

    static {
        inServer = false;
        initialized = false;
        XAFlag = false;
    }

    public static synchronized ORB getORB() throws NoORBException {
        if (TS.inServer()) {
            if (orbS == null) {
                throw new NoORBException();
            }
            return orbS;
        }
        if (orb == null) {
            throw new NoORBException();
        }
        ORB a = (ORB)orb.get(Thread.currentThread());
        if (a == null) {
            throw new NoORBException();
        }
        return a;
    }

    public static synchronized TransactionService getTS() throws NoTransactionServiceException {
        if (TS.inServer()) {
            if (tsS == null) {
                throw new NoTransactionServiceException();
            }
            return tsS;
        }
        if (ts == null) {
            throw new NoTransactionServiceException();
        }
        TransactionService a = (TransactionService)ts.get(Thread.currentThread());
        if (a == null) {
            throw new NoTransactionServiceException();
        }
        return a;
    }

    public static boolean getXAFlag() {
        return XAFlag;
    }

    public static boolean inServer() {
        if (initialized) {
            return inServer;
        }
        initialized = true;
        if (System.getProperty("oracle.server.version") != null) {
            inServer = true;
        }
        return inServer;
    }

    public static synchronized void setORB(ORB _orb) throws SecurityException {
        if (TS.inServer()) {
            orbS = _orb;
            return;
        }
        if (orb == null) {
            orb = new Hashtable();
        }
        orb.put(Thread.currentThread(), _orb);
    }

    public static synchronized void setTS(TransactionService service) throws SecurityException {
        if (TS.inServer()) {
            tsS = service;
            return;
        }
        if (ts == null) {
            ts = new Hashtable();
        }
        ts.put(Thread.currentThread(), service);
    }

    public static void setXAFlag() {
        XAFlag = true;
    }
}

