/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jts.server;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.aurora.jts.CurrentImpl;
import oracle.aurora.jts.util.NoTransactionServiceException;
import oracle.aurora.jts.util.TS;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.server.OracleXAResource;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions._ResourceImplBase;

public class XA_JTSResource
extends _ResourceImplBase {
    private boolean prepared = false;
    private TransIdentity tid;
    private OracleXid xid;
    private static final boolean DEBUG = false;
    private short timeout;
    private static final Hashtable openResources = new Hashtable();
    private static final OracleXAResource databaseResource = new OracleXAResource();
    private static Connection conn = null;

    public XA_JTSResource(TransIdentity transId, short timeout) throws XAException {
        this.tid = transId;
        this.createXID();
        this.remember();
        this.timeout = timeout;
    }

    public void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        if (!this.prepared) {
            throw new NotPrepared();
        }
        try {
            try {
                this.end(true);
                databaseResource.commit((Xid)this.xid, false);
            }
            catch (XAException e) {
                e.printStackTrace();
                switch (e.errorCode) {
                    case 5: {
                        throw new HeuristicMixed();
                    }
                    case 6: {
                        throw new HeuristicRollback();
                    }
                    case 8: {
                        throw new HeuristicHazard();
                    }
                }
                throw new HeuristicHazard();
            }
            Object var2_4 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.release();
            try {
                ((CurrentImpl)TS.getTS().getCurrent()).popContext();
            }
            catch (NoTransactionServiceException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            ((CurrentImpl)TS.getTS().getCurrent()).popContext();
        }
        catch (NoTransactionServiceException e) {
            e.printStackTrace();
        }
    }

    public void commit_one_phase() throws HeuristicHazard {
        try {
            try {
                this.end(true);
                databaseResource.commit((Xid)this.xid, true);
            }
            catch (XAException e) {
                e.printStackTrace();
                throw new HeuristicHazard();
            }
            Object var2_4 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.release();
            try {
                ((CurrentImpl)TS.getTS().getCurrent()).popContext();
            }
            catch (NoTransactionServiceException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            ((CurrentImpl)TS.getTS().getCurrent()).popContext();
        }
        catch (NoTransactionServiceException e) {
            e.printStackTrace();
        }
    }

    private synchronized void createXID() throws XAException {
        int gtrid_length = this.tid.otid.tid.length - this.tid.otid.bqual_length;
        byte[] gtrid = new byte[gtrid_length];
        byte[] bqual = new byte[this.tid.otid.bqual_length];
        System.arraycopy(this.tid.otid.tid, 0, gtrid, 0, gtrid_length);
        System.arraycopy(this.tid.otid.tid, gtrid_length, bqual, 0, this.tid.otid.bqual_length);
        byte[] txnctx = databaseResource.newTxnCtx();
        this.xid = new OracleXid(this.tid.otid.formatID, gtrid, bqual, txnctx);
    }

    public void end(boolean success) throws XAException {
        try {
            if (success) {
                databaseResource.end((Xid)this.xid, 0x4000000);
            } else {
                databaseResource.end((Xid)this.xid, 0x20000000);
            }
        }
        catch (XAException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void endTxn(PropagationContext cxt, boolean success) {
        block2: {
            XA_JTSResource xjr = (XA_JTSResource)openResources.get(XA_JTSResource.gtridKeyOf(cxt.current.otid.tid));
            if (xjr == null) break block2;
            try {
                xjr.end(success);
            }
            catch (XAException e) {
                e.printStackTrace();
            }
        }
    }

    public void forget() {
        try {
            databaseResource.forget((Xid)this.xid);
        }
        catch (XAException xAException) {}
        this.release();
    }

    private Connection getDefaultConnection() {
        if (conn != null) {
            return conn;
        }
        try {
            conn = new OracleDriver().defaultConnection();
            return conn;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    static String gtridKeyOf(byte[] tid) {
        return new String(tid, 0, tid.length > 64 ? 64 : tid.length);
    }

    public void join() {
        try {
            databaseResource.join((Xid)this.xid, (int)this.timeout);
        }
        catch (XAException xAException) {}
    }

    public static void joinTxn(PropagationContext cxt) {
        TransIdentity tid = cxt.current;
        if (openResources.get(XA_JTSResource.gtridKeyOf(tid.otid.tid)) != null) {
            return;
        }
        try {
            new XA_JTSResource(tid, (short)cxt.timeout).join();
        }
        catch (XAException xAException) {}
    }

    public Vote prepare() {
        int ret;
        try {
            this.end(true);
            ret = databaseResource.prepare((Xid)this.xid);
        }
        catch (XAException xAException) {
            return Vote.VoteRollback;
        }
        switch (ret) {
            case 0: {
                this.prepared = true;
                return Vote.VoteCommit;
            }
            case 3: {
                this.prepared = true;
                return Vote.VoteReadOnly;
            }
        }
        return Vote.VoteRollback;
    }

    private synchronized void release() {
        openResources.remove(XA_JTSResource.gtridKeyOf(this.tid.otid.tid));
    }

    private synchronized void remember() {
        openResources.put(XA_JTSResource.gtridKeyOf(this.tid.otid.tid), this);
    }

    public void resume() throws XAException {
        try {
            databaseResource.resume((Xid)this.xid, (int)this.timeout);
        }
        catch (XAException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void resumeTxn(PropagationContext cxt) throws XAException {
        XA_JTSResource xjr = (XA_JTSResource)openResources.get(XA_JTSResource.gtridKeyOf(cxt.current.otid.tid));
        if (xjr != null) {
            xjr.resume();
        }
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        try {
            try {
                databaseResource.rollback((Xid)this.xid);
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 5: {
                        throw new HeuristicMixed();
                    }
                    case 6: {
                        throw new HeuristicHazard();
                    }
                    case 7: {
                        throw new HeuristicCommit();
                    }
                }
            }
            Object var2_2 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.release();
            throw throwable;
        }
        try {
            ((CurrentImpl)TS.getTS().getCurrent()).popContext();
        }
        catch (NoTransactionServiceException e) {
            e.printStackTrace();
        }
    }

    public void start() throws XAException {
        databaseResource.setTransactionTimeout((int)this.timeout);
        databaseResource.start((Xid)this.xid, 0);
        TS.setXAFlag();
        ((OracleConnection)this.getDefaultConnection()).setUsingXAFlag(true);
    }

    public void suspend() throws XAException {
        try {
            databaseResource.suspend((Xid)this.xid);
        }
        catch (XAException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void suspendTxn(PropagationContext cxt) throws XAException {
        XA_JTSResource xjr = (XA_JTSResource)openResources.get(XA_JTSResource.gtridKeyOf(cxt.current.otid.tid));
        if (xjr != null) {
            xjr.suspend();
        }
    }
}

