/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ssl;

import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.TaggedComponent;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.Delegate;
import com.visigenic.vbroker.orb.GiopConnectionFactory;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ProtocolAdapter;
import com.visigenic.vbroker.orb.ProtocolManager;
import java.util.Properties;
import oracle.aurora.ssl.AuroraSSLConnectionFactory;
import oracle.aurora.ssl.SSLComponentBody;
import oracle.aurora.ssl.SSLComponentBodyHelper;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;

public class AuroraSSLComponent
implements ProtocolManager.Profile.Component,
IiopProtocol {
    protected IiopProtocol _protocol;
    protected ORB _orb;
    protected ConnectionFactory _factory;

    protected AuroraSSLComponent() {
    }

    protected AuroraSSLComponent(ORB orb, Properties props) {
        this._orb = orb;
        ProtocolManager.Profile profile = this._orb.protocolManager().profile(0);
        if (!(profile instanceof IiopProtocol)) {
            throw new INITIALIZE("Could not initialize SSL, no IIOP Protocol support found");
        }
        this._protocol = (IiopProtocol)profile;
        this._factory = new AuroraSSLConnectionFactory(this._orb, this);
    }

    public ConnectionFactory connectionFactory() {
        return this._factory;
    }

    public ProtocolAdapter createProtocolAdapter(Adapter adapter) {
        return this._protocol.createProtocolAdapter(adapter);
    }

    public Delegate createStubDelegate(Object object, IOR ior) {
        return this._protocol.createStubDelegate(object, ior);
    }

    public ProtocolManager.Protocol getProtocol(TaggedProfile profile) {
        return this;
    }

    public GiopConnectionFactory giopConnectionFactory() {
        return this._protocol.giopConnectionFactory();
    }

    public byte[] objectKey(TaggedProfile profile) {
        return this._protocol.objectKey(profile);
    }

    public int port(ProfileBody profileBody) {
        if (profileBody.components != null) {
            int i = 0;
            while (i < profileBody.components.length) {
                if (profileBody.components[i].tag == 20) {
                    return this.port(profileBody.components[i]);
                }
                ++i;
            }
        }
        return this._protocol.port(profileBody);
    }

    private int port(TaggedComponent component) {
        GiopInputStream input = this._orb.newGiopInputStream(component.component_data);
        input.byteOrder(input.read_boolean());
        SSLComponentBody body = SSLComponentBodyHelper.read((InputStream)input);
        int port = body.port;
        if (port < 0) {
            port += 65536;
        }
        return port;
    }

    public String prettyPrint(TaggedComponent component) {
        if (component.tag == 20) {
            return "SSL component : port = " + this.port(component);
        }
        return "unknown component";
    }

    public ProfileBody profileBody(TaggedProfile taggedProfile) {
        return this._protocol.profileBody(taggedProfile);
    }

    public boolean supports(int componentId) {
        return componentId == 20;
    }

    public TaggedProfile taggedProfile(ProfileBody profileBody) {
        return this._protocol.taggedProfile(profileBody);
    }
}

