/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class BigEndianStream
extends InputStream {
    Reader reader;
    boolean must_read;
    boolean return_high_byte;
    int char_read;

    public BigEndianStream(Reader reader) {
        this.reader = reader;
        this.must_read = true;
        this.return_high_byte = true;
        this.char_read = 0;
    }

    public int read() throws IOException {
        int result = 0;
        if (this.must_read) {
            this.char_read = this.reader.read();
            this.must_read = false;
        }
        if (this.char_read == -1) {
            result = -1;
        } else if (this.return_high_byte) {
            this.return_high_byte = false;
            result = this.char_read >> 8 & 0xFF;
        } else {
            this.return_high_byte = true;
            this.must_read = true;
            result = this.char_read & 0xFF;
        }
        return result;
    }
}

