Rem
Rem $Header: c0801050.sql 10-nov-99.14:41:22 rshaikh Exp $
Rem
Rem c0801050.sql
Rem
Rem  Copyright (c) Oracle Corporation 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      c0801050.sql - upgrade Oracle RDBMS from 8.1.5 to the new release
Rem
Rem    DESCRIPTION
Rem
Rem	 Put any dictionary related changes here (ie-create, alter, 
Rem    	 update,...).  DO NOT put PL/SQL modules in this script.  
Rem	 If you must upgrade using PL/SQL, put the module in a0801050.sql
Rem	 as catalog.sql and catproc.sql will be run before a0801050.sql
Rem	 is invoked.
Rem
Rem	 This script is called from u0801050.sql and c0801040.sql
Rem
Rem
Rem      This script performs the upgrade in the following stages:
Rem        STAGE 1: upgrade from 8.1.5 to 8.1.6
Rem        STAGE 2: call catalog.sql and catproc.sql
Rem
Rem    NOTES
Rem
Rem      * This script needs to be run in the new release's environment
Rem        (after installing the release to which you want to upgrade).
Rem
Rem      * You must be connected as INTERNAL to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rshaikh     11/10/99 - add commit
Rem    rshaikh     09/14/99 - move PLS_TYPE to i0801050.sql
Rem    kosinski    08/16/99 - Bug 822440: Add PLS_TYPE to ARGUMENT$
Rem    rshaikh     07/14/99 - set sql_version                                  
Rem    nvishnub    04/19/99 - Add index on expdepobj$ for parent object.
Rem    susingh     03/05/99 - Add new indexes for bug570499
Rem    arrajara    03/01/99 - add index on sys.reg_snap$(snapshot_id)
Rem    rshaikh     02/12/99 -
Rem    rshaikh     02/12/99 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: upgrade from 8.1.5 to 8.1.6
Rem =========================================================================
REM Add upgrade here!!!!
Rem Bug 570499 - Add Index on partition dictionary tables to improve performance
create index i_tabpart$_bopart$ on tabpart$(bo#, part#)
/
create index i_indpart$_bopart$ on indpart$(bo#, part#)
/
create index i_tabsubpart$_pobjsubpart$ on tabsubpart$(pobj#, subpart#)
/
create index i_indsubpart$_pobjsubpart$ on indsubpart$(pobj#, subpart#)
/
create index i_tabcompart$_bopart$ on tabcompart$(bo#, part#)
/
create index i_indcompart$_bopart$ on indcompart$(bo#, part#)
/
create index i_lobfrag$_parentobjfrag$ on lobfrag$(parentobj#, frag#)
/
create index i_lobcomppart$_partlobj$ on lobcomppart$(lobj#, part#)
/
create index i_parentobj on expdepobj$(p_obj#)
/

Rem Performace improvement (Bug#836622)
create index i_reg_snap2 on reg_snap$(snapshot_id)
/

REM create the sql version table and initialize sql version field to pre 8.1.6
create table sql_version$
(
  version#          number not null,                           /* see kpul.h */
  sql_version       varchar2(30)            /* sql version string identifier */
)
/
create unique index i_sql_version$_version# on sql_version$(version#)
/

insert into sql_version$ values (0, '8.1.5');    
insert into sql_version$ values (2, '8.1.5');    
insert into sql_version$ values (5, '8.1.5');
insert into sql_version$ values (6, '8.1.6')
/
commit
/

update obj$ set spare1=5
/
commit
/
update cdef$ set spare1=5
/
commit
/

Rem =========================================================================
Rem END STAGE 1: upgrade from 8.1.5 to 8.1.6
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: run the current release version of catalog and catproc
Rem =========================================================================

@@catalog
commit
/
@@catblock
commit
/
@@catproc
commit
/
@@utlraw
@@prvtrawb.plb 
grant execute on utl_raw to public ; 
@@catoctk
set echo off;
@@utlpg
set echo off;
@@prvtpgb.plb 
set echo off;
grant execute on utl_pg to public ; 
@@caths
set echo off;

Rem For the next release, we'll need to create a file called c0801060.sql,
Rem which should call catalog and catproc.
Rem When updating this script for the next release, delete the calls to
Rem the scripts above and uncomment the call to c0801060.sql below.
Rem
Rem @@c0801060

Rem =========================================================================
Rem END STAGE 2: upgrade from 8.1.5 to the new release
Rem =========================================================================

Rem *************************************************************************
Rem END c0801050.sql
Rem *************************************************************************
