# Entering /vobs/oracle/precomp/install/cus_precomp.mk
include $(ORACLE_HOME)/precomp/lib/env_precomp.mk

PRECOMPBIN=

relink:	$(PRECOMPBIN)$(EXENAME)
	$(RMF) $(BINHOME)$(EXENAME)
	$(MV) $(PRECOMPBIN)$(EXENAME) $(BINHOME)

rmlinks:
	($(CD) $(ORACLE_HOME)/precomp/public ; $(RMF) SQLCA.H)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(RMF) ORACA.H)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(RMF) SQLDA.H)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(RMF) SQLCA.COB)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(RMF) ORACA.COB)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(RMF) SQLCA.FOR)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(RMF) ORACA.FOR)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(RMF) BNDDSC.FOR)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(RMF) SELDSC.FOR) 

links:	rmlinks
	($(CD) $(ORACLE_HOME)/precomp/public ; $(LNS) sqlca.h SQLCA.H)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(LNS) oraca.h ORACA.H)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(LNS) sqlda.h SQLDA.H)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(LNS) sqlca.cob SQLCA.COB)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(LNS) oraca.cob ORACA.COB)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(LNS) sqlca.for SQLCA.FOR)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(LNS) oraca.for ORACA.FOR)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(LNS) bnddsc.for BNDDSC.FOR)
	($(CD) $(ORACLE_HOME)/precomp/public ; $(LNS) seldsc.for SELDSC.FOR) 

comp_adalib:
	($(CD) $(PRECOMPADALIB) ; $(RMF) ins_precomp.mk )
	($(CD) $(PRECOMPADALIB) ; $(LNS) $(PRECOMPLIB)/ins_precomp.mk . )
	($(CD) $(PRECOMPADALIB) ; $(MAKE) -f ins_precomp.mk compile )

dei_adalib:
	($(CD) $(PRECOMPADALIB) ; $(MAKE) -f ins_precomp.mk clean )
	($(CD) $(PRECOMPADALIB) ; $(RMF) ins_precomp.mk )

.SUFFIXES: .a .ada

ADASRC= sqaqss.ada sqaosl.ada sqaoslb.ada

DEC_UN= sql_standard oracle_sqllib

compile: compile_$(ADAPORT)
clean:	clean_$(ADAPORT)



compile_verdix: GVAS_table
	a.make -e -v -f $(ADASRC)

clean_verdix:
	a.rmlib -f

GVAS_table:	
	echo 1 | a.mklib -i > /dev/null


alsys_prereq:
	-ada.mkfam $(ALSYS_FAMILY)
	-ada.mklib $(ALSYS_FAMILY) $(ALSYS_LIB)

compile_alsys: alsys_prereq
	ada.protect -u $(ALSYS_LIB)
	$(ADAMAKE) $(ALSYS_LIB) $(ADASRC)

clean_alsys:
	-ada.rmlib -f $(ALSYS_LIB)
	-ada.rmfam -f $(ALSYS_FAMLIY)


compile_dec:	adalib
	ada -A@adalib $(CDEBUG) -v -y $(ADASRC)
	amake -A@adalib -C "$(CDEBUG)" -v $(DEC_UN)

clean_dec:
	$(RMRF) adalib

adalib:
	amklib adalib
# Exiting /vobs/oracle/precomp/install/cus_precomp.mk
# Entering link.mk
$(LOC_MODADA): $(LIBMOD) $(LIBPGP) $(PLSQLLIBS)
	$(SILENT)$(ECHO) "Linking $@"; \
	$(RMF) $@; \
	$(MODADA_LINKLINE); \
	$(CHMOD) $(EXE_PROT) $@

$(LOC_OTT): $(LIBOTT) $(LIBPGP) $(PLSQLLIBS)
	$(SILENT)$(ECHO) "Linking $@"; \
	$(RMF) $@; \
	$(OTT_LINKLINE); \
	$(CHMOD) $(EXE_PROT) $@

$(LOC_PROC): $(LIBPROC2) $(LIBPGP) $(LIBOTT) $(PLSQLLIBS)
	$(SILENT)$(ECHO) "Linking $@"; \
	$(RMF) $@; \
	$(PROC_LINKLINE); \
	$(CHMOD) $(EXE_PROT) $@

$(LOC_PROCOB): $(LIBPROCOB2) $(LIBPGP) $(PLSQLLIBS)
	$(SILENT)$(ECHO) "Linking $@"; \
	$(RMF) $@; \
	$(PROCOB_LINKLINE); \
	$(CHMOD) $(EXE_PROT) $@

$(LOC_PROCOB18): $(LIBPCO) $(LIBPCC) $(LIBPGP) $(PLSQLLIBS)
	$(SILENT)$(ECHO) "Linking $@"; \
	$(RMF) $@; \
	$(PROCOB18_LINKLINE); \
	$(CHMOD) $(EXE_PROT) $@

$(LOC_PROFOR): $(LIBPFO) $(LIBPCC) $(LIBPGP) $(PLSQLLIBS)
	$(SILENT)$(ECHO) "Linking $@"; \
	$(RMF) $@; \
	$(PROFOR_LINKLINE); \
	$(CHMOD) $(EXE_PROT) $@

$(LOC_PROPLI): $(LIBPPL) $(LIBPCC) $(LIBPGP) $(PLSQLLIBS)
	$(SILENT)$(ECHO) "Linking $@"; \
	$(RMF) $@; \
	$(PROPLI_LINKLINE); \
	$(CHMOD) $(EXE_PROT) $@

$(LOC_RTSORA): $(LIBSQL)
	$(SILENT)$(ECHO) "Linking $@"; \
	$(RMF) $@; \
	$(RTSORA_LINKLINE); \
	$(CHMOD) $(EXE_PROT) $@

# Exiting link.mk
