#
# Copyright (c) 1998 Sun Microsystems Inc.,
# All rights reserved.
#
# File         : ipv6-d.x
# Version      : 1.2
# Last Checkin : 09/21/01
#
#
# This file is best viewed with tab stop = 4.
#


# Tell that you need this package.

# Because we are making calls to funcs. inside mib2 pkgs like
# mibopen, mibfree etc.
[ requires package mib2 ]
[ requires package ipv6 ]

[ use MANAGED-MODULE ]
[ load ipv6-m.x ]
[ requires template ipv6-models-d ]


    userAccess(%generalUsers,read) = noauth
    groupAccess(%generalGroups,read) = noauth

ipv6Ip = { [ use templates.ipv6-models-d.ipv6Ip ]

	family = ipv6.ipv6Ip

#
# oid within IPv6
#

	oid = 198

	initInterval	= 5
	refreshInterval	= 120

	ipv6Forwarding = {

		#
		# oid within ip
		#

		oid = 1

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6Forwarding
	}
	ipv6DefaultHopLimit = {

		#
		# oid within ip
		#

		oid = 2

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6DefaultHopLimit
	}
	ipv6Interfaces = {

		#
		# oid within ip
		#

		oid = 3

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6Interfaces
	}
	ipv6IfTable = {

		#
		# oid within ip
		#

		oid = 5

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6IfTable
	}
	ipv6IfStatsTable = {

		#
		# oid within ip
		#

		oid = 6

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6IfStatsTable
	}
	ipv6AddrPrefixTable = {

		#
		# oid within ip
		#

		oid = 7

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6AddrPrefixTable
	}
	ipv6AddrTable = {

		#
		# oid within ip
		#

		oid = 8

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6AddrTable
	}
	ipv6RouteNumber = {

		#
		# oid within ip
		#

		oid = 9

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6RouteNumber
	}
	ipv6RouteTable = {

		#
		# oid within ip
		#

		oid = 11

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6RouteTable
	}
	ipv6NetToMediaTable = {

		#
		# oid within ip
		#

		oid = 12

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6NetToMediaTable
	}
}


ipv6Tcp = { [ use templates.ipv6-models-d.ipv6Tcp ]

#	family = ipv6.ipv6Tcp
#
# oid within IPv6
#
	oid = 199

	initInterval	= 5
	refreshInterval	= 120


	tcp6ConnTable = {

		#
		# oid within tcp
		#

		oid = 1

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getTcp6ConnTable
	}

}

ipv6Udp = { [ use templates.ipv6-models-d.ipv6Udp ]

#	family = ipv6.ipv6Udp
#
# oid within IPv6
#
	oid = 200

	initInterval	= 5
	refreshInterval	= 120


	ipv6UdpTable = {

		#
		# oid within udp
		#

		oid = 1

		type = active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6UdpTable
	}

}

ipv6Icmp = { [ use templates.ipv6-models-d.ipv6Icmp ]

#	family = ipv6.ipv6Icmp

#
# oid within IPv6
#
	oid = 201

	initInterval	= 5
	refreshInterval	= 120

	ipv6IfIcmpTable = {

		#
		# oid within icmp
		#

		oid =  1

		type	= active
		refreshMode	= sync
		refreshService	= _internal
		refreshInterval	= 300
		refreshCommand	= getIpv6IfIcmpTable
	}
}

#[ load ipv6-d.def ]

