/*
 * Decompiled with CFR 0.152.
 */
package com.sun.entdiag.ui;

import com.sun.entdiag.ui.MsgTranslator;
import com.sun.entdiag.ui.TestingEvent;
import com.sun.entdiag.ui.TestingListener;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class ControlPanel {
    public JPanel panel;
    private JPanel controlPanel;
    Font boldFont = new Font("Dialog", 1, 12);
    private GridBagLayout panelBag = new GridBagLayout();
    private GridBagLayout controlBag = new GridBagLayout();
    private JMenuBar menuBar;
    private JMenu testing;
    private JMenu logs;
    private JMenuItem resetItem;
    private JMenuItem suspendItem;
    private JMenuItem resumeItem;
    private JMenuItem reprobeItem;
    private JButton startButton = null;
    private JButton stopButton;
    private JButton schedButton;
    private JButton checkButton;
    private JButton diagButton;
    private Vector listeners = new Vector();
    private Vector hasDiag = new Vector();
    private boolean testingHost = false;
    private boolean testingNow = false;
    private MsgTranslator rb = null;
    private boolean debug = true;

    public ControlPanel(MsgTranslator msgTranslator) {
        this.panel = new JPanel(true);
        this.rb = msgTranslator;
        this.controlPanel = new JPanel(this.controlBag){

            public Dimension getPreferredSize() {
                return new Dimension(450, 45);
            }
        };
        this.controlPanel.repaint();
        this.createControl();
        this.panel.setLayout(new FlowLayout(5, 2, 2));
        this.panel.add(this.menuBar);
        this.panel.add(this.controlPanel);
        this.panel.validate();
        this.panel.repaint();
    }

    public void addTestingListener(TestingListener testingListener) {
        this.listeners.addElement(testingListener);
    }

    public void connectionCheck() {
        this.startButtons();
        this.notifyTestingEvent(3, null, 0, null);
    }

    private void createControl() {
        this.menuBar = new JMenuBar();
        this.testing = this.menuBar.add(new JMenu(this.rb.getString("Test_menu")));
        this.resetItem = new JMenuItem(this.rb.getString("Reset"));
        this.resetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.notifyTestingEvent(10, null, 0, null);
            }
        });
        this.testing.add(this.resetItem);
        this.suspendItem = new JMenuItem(this.rb.getString("Suspend"));
        this.suspendItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.suspendItem.setEnabled(false);
                ControlPanel.this.resumeItem.setEnabled(true);
                ControlPanel.this.notifyTestingEvent(11, null, 0, null);
            }
        });
        this.testing.add(this.suspendItem);
        this.resumeItem = new JMenuItem(this.rb.getString("Resume"));
        this.resumeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.suspendItem.setEnabled(true);
                ControlPanel.this.resumeItem.setEnabled(false);
                ControlPanel.this.notifyTestingEvent(12, null, 0, null);
            }
        });
        this.testing.add(this.resumeItem);
        this.reprobeItem = new JMenuItem(this.rb.getString("Reprobe"));
        this.reprobeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.notifyTestingEvent(15, null, 0, null);
            }
        });
        this.testing.add(this.reprobeItem);
        this.logs = this.menuBar.add(new JMenu(this.rb.getString("Log_menu")));
        JMenuItem jMenuItem = new JMenuItem(this.rb.getString("Infolog"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.notifyTestingEvent(13, null, 0, null);
            }
        });
        this.logs.add(jMenuItem);
        jMenuItem = new JMenuItem(this.rb.getString("Errorlog"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.notifyTestingEvent(14, null, 0, null);
            }
        });
        this.logs.add(jMenuItem);
        this.startButton = new JButton(this.rb.getString("Fulltest"));
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.startTesting();
            }
        });
        this.stopButton = new JButton(this.rb.getString("Stoptest"));
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.stopTesting();
            }
        });
        this.schedButton = new JButton(this.rb.getString("Schedule"));
        this.schedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.scheduleTesting();
            }
        });
        this.checkButton = new JButton(this.rb.getString("Quick"));
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.connectionCheck();
            }
        });
        this.diagButton = new JButton(this.rb.getString("Diaghost"));
        this.diagButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.selectHost();
            }
        });
        this.suspendItem.setEnabled(false);
        this.resumeItem.setEnabled(false);
    }

    protected void notifyTestingEvent(int n, String string, int n2, String string2) {
        Vector vector;
        TestingEvent testingEvent = new TestingEvent(this, n, string, n2, string2);
        ControlPanel controlPanel = this;
        synchronized (controlPanel) {
            vector = (Vector)this.listeners.clone();
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            TestingListener testingListener = (TestingListener)vector.elementAt(n3);
            testingListener.testingAction(testingEvent);
            ++n3;
        }
    }

    public void removeTestingListener(TestingListener testingListener) {
        this.listeners.removeElement(testingListener);
    }

    public void resetButtons() {
        block2: {
            try {
                this.stopButton.setEnabled(false);
                this.stopButton.repaint();
                this.startButton.setEnabled(true);
                this.startButton.repaint();
                this.schedButton.setEnabled(true);
                this.schedButton.repaint();
                this.checkButton.setEnabled(true);
                this.checkButton.repaint();
                this.testing.setEnabled(true);
                this.testing.repaint();
                this.resetItem.setEnabled(true);
                this.suspendItem.setEnabled(false);
                this.resumeItem.setEnabled(false);
                this.reprobeItem.setEnabled(true);
                this.logs.setEnabled(true);
                this.logs.repaint();
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.out.println("resetButtons: " + exception);
            }
        }
    }

    public void scheduleTesting() {
        block2: {
            try {
                this.testing.setEnabled(false);
                this.testing.repaint();
                this.logs.setEnabled(false);
                this.logs.repaint();
                this.stopButton.setEnabled(false);
                this.stopButton.repaint();
                this.startButton.setEnabled(false);
                this.startButton.repaint();
                this.schedButton.setEnabled(false);
                this.schedButton.repaint();
                this.checkButton.setEnabled(false);
                this.checkButton.repaint();
                this.notifyTestingEvent(2, null, 0, null);
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.out.println("scheduleTesting: " + exception);
            }
        }
    }

    public void selectHost() {
        this.notifyTestingEvent(6, null, 0, null);
    }

    public void setControl(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            this.controlPanel.remove(this.diagButton);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.controlBag.setConstraints(this.startButton, gridBagConstraints);
            this.startButton.setEnabled(true);
            this.controlPanel.add(this.startButton);
            gridBagConstraints.gridx = -1;
            this.controlBag.setConstraints(this.stopButton, gridBagConstraints);
            this.stopButton.setEnabled(false);
            this.controlPanel.add(this.stopButton);
            gridBagConstraints.gridx = -1;
            this.controlBag.setConstraints(this.schedButton, gridBagConstraints);
            this.schedButton.setEnabled(true);
            this.controlPanel.add(this.schedButton);
            gridBagConstraints.gridx = -1;
            this.controlBag.setConstraints(this.checkButton, gridBagConstraints);
            this.checkButton.setEnabled(true);
            this.controlPanel.add(this.checkButton);
        } else {
            if (this.startButton != null) {
                this.controlPanel.remove(this.startButton);
                this.controlPanel.remove(this.stopButton);
                this.controlPanel.remove(this.schedButton);
                this.controlPanel.remove(this.checkButton);
            }
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.controlBag.setConstraints(this.diagButton, gridBagConstraints);
            this.controlPanel.add(this.diagButton);
        }
        Dimension dimension = this.controlPanel.getSize();
    }

    public void setDiagButton(String string) {
        if (this.hasDiag.contains(string)) {
            this.diagButton.setEnabled(true);
            this.diagButton.repaint();
        } else {
            this.diagButton.setEnabled(false);
            this.diagButton.repaint();
        }
    }

    public void startButtons() {
        block2: {
            try {
                this.stopButton.setEnabled(true);
                this.stopButton.repaint();
                this.startButton.setEnabled(false);
                this.startButton.repaint();
                this.schedButton.setEnabled(false);
                this.schedButton.repaint();
                this.checkButton.setEnabled(false);
                this.checkButton.repaint();
                this.resetItem.setEnabled(false);
                this.suspendItem.setEnabled(true);
                this.reprobeItem.setEnabled(false);
                this.logs.setEnabled(false);
                this.logs.repaint();
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.out.println("startButtons: " + exception);
            }
        }
    }

    public void startTesting() {
        block2: {
            try {
                this.startButtons();
                this.testingNow = true;
                this.notifyTestingEvent(0, null, 0, null);
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.out.println("startTesting: " + exception);
            }
        }
    }

    public void stopTesting() {
        block2: {
            try {
                this.notifyTestingEvent(1, null, 0, null);
                this.testingNow = false;
                this.resetButtons();
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.out.println("stopTesting: " + exception);
            }
        }
    }
}

