/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.topology.console;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.client.topology.SMUserDomainResponse;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.tools.topology.console.TCImport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class TCImportDomainChooser
extends JPanel
implements SMUserDomainResponse,
AwxServiceManager {
    private final String BROWSE = "browse";
    private final String OK = "ok";
    private final String CANCEL = "cancel";
    private final String HELP = "help";
    private final String IMPORT_FILE_NAME = "importFileName";
    private final String IMPORT_TITLE = "importTitle";
    private final String TO_DOMAIN = "toDomain";
    private final String NAME = "name";
    private final String IMPORT_MODE = "importMode";
    private final String FOLLOW_MODE = "followMode";
    private final String IGNORE_MODE = "ignoreMode";
    private final String NO_LIC = "noLic";
    private final String REQ_PERIOD = "600";
    private JTextField fileTF;
    private JFileChooser fc;
    private ButtonGroup btnGrp;
    private Frame owner;
    private SMRawDataRequest req;
    private SMUserDomainRequest domainRequest;
    private JComboBox targetDomainCB;
    private Object handle;
    private AwxServiceProvider SvcProvider = null;

    public TCImportDomainChooser() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 12, 12));
        JLabel jLabel = new JLabel(this.translate("importFileName"));
        jPanel.add(jLabel);
        this.fileTF = new JTextField(25);
        jPanel.add(this.fileTF);
        JButton jButton = new JButton(this.translate("browse"));
        this.fc = new JFileChooser();
        this.fc.setDialogTitle(this.translate("importTitle"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TCImportDomainChooser.this.fc.showDialog(((JButton)actionEvent.getSource()).getRootPane().getParent(), TCImportDomainChooser.this.translate("ok")) == 0) {
                    File file = TCImportDomainChooser.this.fc.getSelectedFile();
                    TCImportDomainChooser.this.fileTF.setText(file.getPath());
                }
            }
        });
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        jPanel2.add((Component)new JLabel(this.translate("toDomain")), gridBagConstraints);
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 12);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)new JSeparator(), gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 50));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setAlignmentY(0.0f);
        jPanel3.add((Component)new JLabel(this.translate("name")), "West");
        jPanel3.add(Box.createHorizontalStrut(100), "East");
        this.targetDomainCB = new JComboBox();
        this.targetDomainCB.setEditable(false);
        this.targetDomainCB.setEnabled(false);
        this.targetDomainCB.setAlignmentX(0.0f);
        jPanel3.add((Component)this.targetDomainCB, "Center");
        Dimension dimension = this.targetDomainCB.getPreferredSize();
        this.targetDomainCB.setPreferredSize(new Dimension((int)dimension.getWidth(), 26));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setAlignmentY(0.0f);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel jLabel2 = new JLabel(this.translate("importMode"));
        jLabel2.setAlignmentY(0.0f);
        jPanel4.add(jLabel2);
        jPanel4.add(Box.createRigidArea(new Dimension(12, 0)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setAlignmentY(0.0f);
        JRadioButton jRadioButton = new JRadioButton(this.translate("followMode"));
        jRadioButton.setSelected(true);
        jRadioButton.setActionCommand("Follow");
        jRadioButton.setAlignmentX(0.0f);
        jPanel5.add(jRadioButton);
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TCImportDomainChooser.this.targetDomainCB.setEnabled(false);
            }
        });
        JRadioButton jRadioButton2 = new JRadioButton(this.translate("ignoreMode"));
        jRadioButton2.setActionCommand("Ignore");
        jRadioButton2.setAlignmentX(0.0f);
        jPanel5.add(jRadioButton2);
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TCImportDomainChooser.this.targetDomainCB.setEnabled(true);
            }
        });
        this.btnGrp = new ButtonGroup();
        this.btnGrp.add(jRadioButton);
        this.btnGrp.add(jRadioButton2);
        jPanel4.add(jPanel5);
        JButton jButton2 = new JButton(this.translate("cancel"));
        JButton jButton3 = new JButton(this.translate("ok"));
        JButton jButton4 = new JButton(this.translate("help"));
        jButton2.setActionCommand("Cancel");
        jButton3.setActionCommand("OK");
        jButton4.setActionCommand("Help");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TCImportDomainChooser.this.doImport();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TCImportDomainChooser.this.closeWin();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "import-help";
                CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
                cmConsoleSession.launchHelp(string);
            }
        });
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 12));
        jPanel6.add(Box.createHorizontalGlue());
        jPanel6.add(jButton3);
        jPanel6.add(Box.createRigidArea(new Dimension(12, 0)));
        jPanel6.add(jButton2);
        jPanel6.add(Box.createRigidArea(new Dimension(12, 0)));
        jPanel6.add(jButton4);
        this.setLayout(new BoxLayout(this, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel6.setAlignmentX(0.0f);
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
        this.add(jPanel4);
        this.add(jPanel6);
        this.setPreferredSize(new Dimension(520, 242));
    }

    private void closeWin() {
        Container container = this.getParent();
        while (true) {
            if (container instanceof Window) break;
            container = container.getParent();
        }
        ((Window)container).dispose();
    }

    public void doImport() {
        int n = this.btnGrp.getSelection().getActionCommand() == "Follow" ? 0 : 1;
        new TCImport(this.owner, this.fileTF.getText(), (String)this.targetDomainCB.getSelectedItem(), this.SvcProvider, this, n, this.req).doIt();
    }

    public void getDomainDataResponse(SMRequestStatus sMRequestStatus, SMUserDomainData[] sMUserDomainDataArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDDL.logErrorMessage((String)("Domain list request unsuccessful: " + sMRequestStatus.getMessageText()));
            if (sMRequestStatus.getReturnCode() == 4) {
                this.req.launchTimeoutNotification("both");
            }
            return;
        }
        int n = this.targetDomainCB.getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        this.targetDomainCB.removeAllItems();
        int n2 = 1;
        while (n2 < sMUserDomainDataArray.length) {
            this.targetDomainCB.addItem(sMUserDomainDataArray[n2].getDomainName());
            ++n2;
        }
        this.targetDomainCB.setSelectedIndex(n);
        this.targetDomainCB.revalidate();
    }

    public void init() {
        block4: {
            Container container = this;
            while (container != null) {
                if (container instanceof Frame) {
                    this.owner = (Frame)container;
                    break;
                }
                container = container.getParent();
            }
            UcCommon.isServiceLicenseAvailable((String)"Export_Import_Service", (Component)this.owner);
            if (this.req == null) break block4;
            try {
                this.handle = this.domainRequest.getUserDomainsRequest("", "600", (SMUserDomainResponse)this, null);
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)("Failed to send get user domains request with exception " + (Object)((Object)sMAPIException)));
            }
        }
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void setRequestHandle(SMRawDataRequest sMRawDataRequest) {
        if (sMRawDataRequest == null) {
            System.out.println("RawDataRequest is empty");
        }
        this.req = sMRawDataRequest;
        this.domainRequest = new SMUserDomainRequest(sMRawDataRequest);
    }

    private String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.tools.topology.console.TopologyBundle:" + string));
    }
}

