/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.topology;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMInvalidNameException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMUtility;
import com.sun.symon.base.client.module.SMModuleData;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.topology.SMTopologyData;
import com.sun.symon.base.client.topology.SMTopologyException;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainResponse;
import com.sun.symon.base.client.topology.SMUserDomainTxltr;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class SMUserDomainRequest {
    private SMRawDataRequest handle;
    private String topoBaseUrl = null;
    private String cfgBaseUrl = null;
    private ResourceBundle rbundle;
    private Locale locale;

    public SMUserDomainRequest(SMRawDataRequest sMRawDataRequest) {
        this.handle = sMRawDataRequest;
        this.topoBaseUrl = this.handle.getTopologyBaseURL();
        this.cfgBaseUrl = this.handle.getConfigurationBaseURL();
        this.rbundle = this.handle.getResourceBundle();
        this.locale = this.handle.getLocale();
    }

    public SMUserDomainData createDomain(String string) throws SMAPIException, SMTopologyException {
        if (string == null || string == "") {
            throw new SMAPIException(this.rbundle.getString("UserDomainRequest.InvalidUserDomainName"));
        }
        int n = SMUtility.validate(string);
        if (n != -1) {
            throw new SMInvalidNameException(this.locale, n);
        }
        try {
            String[] stringArray = new String[]{String.valueOf(this.topoBaseUrl) + "mod/domain-control/domainCreate#0"};
            StObject[][] stObjectArray = new StObject[1][1];
            StringBuffer stringBuffer = new StringBuffer();
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)this.handle.getUserId());
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)UcListUtil.UnicodeToAscii((String)string));
            stObjectArray[0][0] = new StString(stringBuffer.toString());
            StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
            if (stObjectArray2 == null || stObjectArray2.length != 1) {
                UcDDL.logErrorMessage((String)"Invalid domain create return.");
                return null;
            }
            Vector vector = new Vector();
            if (!UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector) || vector.size() == 0) {
                UcDDL.logErrorMessage((String)("Invalid return from domain create " + stObjectArray2[0][0].toString()));
                return null;
            }
            String string2 = (String)vector.elementAt(0);
            if (string2.compareTo("createok") != 0) {
                if (string2.compareTo("createduplicate") == 0) {
                    return null;
                }
                if (string2.compareTo("createmax") == 0) {
                    throw new SMTopologyException(5, this.rbundle.getString("UserDomainRequest.ErrorCreatingUserDomain"));
                }
                if (string2.compareTo("createlicense") == 0) {
                    throw new SMTopologyException(6, this.rbundle.getString("UserDomainRequest.ErrorCreatingUserDomain"));
                }
                throw new SMAPIException(this.rbundle.getString("UserDomainRequest.ErrorCreatingUserDomain"));
            }
            return new SMUserDomainData(string, this.handle.getUserId(), (String)vector.elementAt(1));
        }
        catch (SMAPIException sMAPIException) {
            throw sMAPIException;
        }
        catch (SMTopologyException sMTopologyException) {
            throw sMTopologyException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SMAPIException(this.rbundle.getString("UserDomainRequest.UnexpectedErrorCreatingUserDomain"));
        }
    }

    public void deleteDomain(String string) throws SMAPIException, SMTopologyException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "moduleadminaction", null)};
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StString("unload");
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2.length == 1 && stObjectArray2[0].length == 1) {
            if (stObjectArray2[0][0].toString().compareTo("unloadok") == 0) {
                return;
            }
            if (stObjectArray2[0][0].toString().compareTo("unloadpartial") == 0) {
                throw new SMTopologyException(2, this.rbundle.getString("UserDomainRequest.ErrorOccurredWhileDeletingDomain"));
            }
        }
        throw new SMAPIException(this.rbundle.getString("UserDomainRequest.ErrorOccurredWhileDeletingDomain"));
    }

    public SMUserDomainData[] getAllConfiguredDomains() throws SMAPIException {
        try {
            String[] stringArray = new String[]{String.valueOf(this.topoBaseUrl) + "mod/domain-control/domainTable/" + "domainEntry/userDomainList#"};
            StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
            if (stObjectArray == null || stObjectArray.length != 1) {
                UcDDL.logErrorMessage((String)"Invalid user domain list data return.");
                return null;
            }
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            if (!UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector)) {
                UcDDL.logErrorMessage((String)"Invalid user domain list info return.");
                return null;
            }
            SMUserDomainData[] sMUserDomainDataArray = new SMUserDomainData[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                UcListUtil.decomposeList((String)string, vector2);
                if (vector2.size() != 3) {
                    UcDDL.logErrorMessage((String)"Invalid domain list entry data.");
                    return null;
                }
                String string2 = UcListUtil.AsciiToUnicode((String)((String)vector2.elementAt(0)));
                sMUserDomainDataArray[n] = new SMUserDomainData(string2, (String)vector2.elementAt(1), (String)vector2.elementAt(2));
                ++n;
            }
            return sMUserDomainDataArray;
        }
        catch (SMAPIException sMAPIException) {
            throw sMAPIException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SMAPIException(this.rbundle.getString("UserDomainRequest.UnexpectedErrorLoadingUserDomainInformation"));
        }
    }

    public SMUserDomainData getDefaultDomainInfo() throws SMAPIException {
        SMUserDomainData[] sMUserDomainDataArray = this.getAllConfiguredDomains();
        if (sMUserDomainDataArray == null) {
            return null;
        }
        String[] stringArray = new String[]{String.valueOf(this.cfgBaseUrl) + "mod/cfgserver/users/" + "userTable/userEntry/defaultdomain#" + this.handle.getUserId()};
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
        if (stObjectArray.length == 1 && stObjectArray[0].length == 1) {
            String string = stObjectArray[0][0].toString();
            int n = 0;
            while (n < sMUserDomainDataArray.length) {
                String string2 = sMUserDomainDataArray[n].getDomainRootUrl();
                if (UcURL.areURLsEqual((String)string, (String)string2)) {
                    return sMUserDomainDataArray[n];
                }
                ++n;
            }
            return null;
        }
        throw new SMAPIException(this.rbundle.getString("UserDomainRequest.ErrorOccurredObtainingDefaultDomain"));
    }

    public Object getDomainsDataRequest(String string, SMUserDomainResponse sMUserDomainResponse, Object object) throws SMAPIException {
        return this.getUserDomainsRequest("", string, sMUserDomainResponse, object);
    }

    public SMRawDataRequest getHandle() {
        return this.handle;
    }

    public SMUserDomainData[] getRemoteDomains(String string, String string2) throws SMAPIException {
        try {
            String[] stringArray = new String[]{"snmp://" + string + ":" + string2 + "/mod/domain-control" + "/domainTable/domainEntry/userDomainList#"};
            StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
            if (stObjectArray == null || stObjectArray.length != 1) {
                UcDDL.logErrorMessage((String)"Invalid user domain list data return.");
                return null;
            }
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            if (!UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector)) {
                UcDDL.logErrorMessage((String)"Invalid user domain list info return.");
                return null;
            }
            SMUserDomainData[] sMUserDomainDataArray = new SMUserDomainData[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                String string3 = (String)vector.elementAt(n);
                UcListUtil.decomposeList((String)string3, vector2);
                if (vector2.size() != 3) {
                    UcDDL.logErrorMessage((String)"Invalid domain list entry data.");
                    return null;
                }
                String string4 = UcInternationalizer.translateKey((Locale)this.locale, (String)((String)vector2.elementAt(0)));
                string4 = UcListUtil.AsciiToUnicode((String)string4);
                sMUserDomainDataArray[n] = new SMUserDomainData(string4, (String)vector2.elementAt(1), (String)vector2.elementAt(2));
                ++n;
            }
            return sMUserDomainDataArray;
        }
        catch (SMAPIException sMAPIException) {
            throw sMAPIException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SMAPIException(this.rbundle.getString("UserDomainRequest.UnexpectedErrorLoadingUserDomainInformation"));
        }
    }

    private SMUserDomainData[] getUserAndDefaultDomains() throws SMAPIException {
        return this.getAllConfiguredDomains();
    }

    public SMUserDomainData[] getUserConfiguredDomains() throws SMAPIException {
        return this.getAllConfiguredDomains();
    }

    public Object getUserDomainsRequest(String string, String string2, SMUserDomainResponse sMUserDomainResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[]{String.valueOf(this.cfgBaseUrl) + "mod/cfgserver/users/" + "userTable/userEntry/defaultdomain#" + this.handle.getUserId(), String.valueOf(this.topoBaseUrl) + "mod/domain-control/domainTable/" + "domainEntry/userDomainList#" + string};
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMUserDomainTxltr(sMUserDomainResponse, this.locale), object);
    }

    public Vector listTopologies(String string, int n, String string2, String string3) throws SMAPIException {
        StObject[][] stObjectArray;
        String string4 = string;
        int n2 = n == 0 ? 164 : n;
        String[] stringArray = new String[14];
        String string5 = "snmp://" + string4 + ":" + n2 + "/mod/topology+" + string3 + "/entityInfoTable/entityInfoEntry";
        stringArray[0] = String.valueOf(string5) + "/entity";
        stringArray[1] = String.valueOf(string5) + "/entityDesc";
        stringArray[2] = String.valueOf(string5) + "/entityFullDesc";
        stringArray[3] = String.valueOf(string5) + "/entityHostname";
        stringArray[4] = String.valueOf(string5) + "/entityIpAddress";
        stringArray[5] = String.valueOf(string5) + "/entityNetmask";
        stringArray[6] = String.valueOf(string5) + "/entityArch";
        stringArray[7] = String.valueOf(string5) + "/entityFamily";
        stringArray[8] = String.valueOf(string5) + "/entityAttrInfo";
        stringArray[9] = String.valueOf(string5) + "/entityTrapDest";
        stringArray[10] = String.valueOf(string5) + "/entityEventDest";
        stringArray[11] = String.valueOf(string5) + "/entityPolling";
        stringArray[12] = String.valueOf(string5) + "/entityPollType";
        stringArray[13] = String.valueOf(string5) + "/entityTargetUrl";
        try {
            stObjectArray = this.handle.getURLValue(stringArray);
        }
        catch (Exception exception) {
            throw new SMAPIException(this.rbundle.getString("UserDomainRequest.UnableToReadTopologyData"));
        }
        if (stObjectArray == null || stObjectArray.length != 14) {
            throw new SMAPIException(this.rbundle.getString("UserDomainRequest.UnableToReadTopologyData"));
        }
        Vector vector = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector);
        Vector vector2 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[1][0].toString(), vector2);
        Vector vector3 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[2][0].toString(), vector3);
        Vector vector4 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[3][0].toString(), vector4);
        Vector vector5 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[4][0].toString(), vector5);
        Vector vector6 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[13][0].toString(), vector6);
        Vector vector7 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[13][0].toString(), vector7);
        Vector vector8 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[13][0].toString(), vector8);
        Vector vector9 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[13][0].toString(), vector9);
        Vector vector10 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[13][0].toString(), vector10);
        Vector vector11 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[13][0].toString(), vector11);
        Vector vector12 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[13][0].toString(), vector12);
        Vector vector13 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[13][0].toString(), vector13);
        Vector vector14 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[13][0].toString(), vector14);
        Vector<SMTopologyData> vector15 = new Vector<SMTopologyData>();
        SMTopologyData sMTopologyData = new SMTopologyData();
        SMModuleRequest sMModuleRequest = new SMModuleRequest(this.handle);
        Vector vector16 = sMModuleRequest.getModuleData(string4, n2, "Topology Manager");
        SMModuleData sMModuleData = null;
        int n3 = 0;
        while (n3 < vector16.size()) {
            sMModuleData = (SMModuleData)vector16.elementAt(n3);
            if (string3.compareTo(sMModuleData.getModuleInstance()) == 0) break;
            ++n3;
        }
        if (sMModuleData != null) {
            sMTopologyData.setTopologyName(sMModuleData.getModuleName());
            sMTopologyData.setTopologyDescription(sMModuleData.getModuleDescription());
        }
        vector15.addElement(sMTopologyData);
        return vector15;
    }

    public void setDefaultDomainUrl(String string) throws SMAPIException {
        String[] stringArray = new String[]{String.valueOf(this.cfgBaseUrl) + "mod/cfgserver/users/" + "userTable/userEntry/defaultdomain#" + this.handle.getUserId()};
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StString(string);
        this.handle.setURLValue(stringArray, stObjectArray);
    }
}

