/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.util;

import com.sun.symon.tools.migration.util.MuDebug;
import java.util.Vector;

public final class MuUtil {
    private static int testCount = 1;

    private MuUtil() {
    }

    public static String assembleCSV(Object[] objectArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append(objectArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String assembleCSV(Object[] objectArray, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append(c2);
            stringBuffer.append(objectArray[n]);
            stringBuffer.append(c2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        MuUtil.test2(" 'dele, b., t', taylor, X\"y\" ");
        MuUtil.test2(" 'dele, b., t' , 'taylor', X\"y\" ");
        MuUtil.test2(" 'dele, b., t', taylor, X'y' ");
        MuUtil.test2("[3:31],\",Ultra-60\"");
        MuUtil.test2("[3:31],\",Ultra-60");
        MuUtil.test2("[3:31],\" , Ultra-60\"");
        MuUtil.test2("[3:31],\" ,, Ultra-60\"");
        MuUtil.test2("[3:31],\" , , Ultra-60\"");
        MuUtil.test2("[3:31],\" ,, , Ultra-60\"");
        MuUtil.test2("[3:31] ,\" ,, , Ultra-60\"");
        MuUtil.test2("[3:31] , \" ,, , Ultra-60\"");
        MuUtil.test2("[3:31] , \" ,, , Ultra-60\",");
        MuUtil.test2("[3:31],\" ,, , Ultra-60\",,");
        MuUtil.test2("\"[3:31],\" ,, , Ultra-60\"");
        MuUtil.test2("\"[3:31]\",\" ,, , Ultra-60\"");
        MuUtil.test2(",\"[3:31],\" ,, , Ultra-60\"");
        MuUtil.test2(",\"[3:31]\",\" ,, , Ultra-60\"");
        MuUtil.test2(",\"[3:31]\",\" ,, , Ultra-60\"");
        MuUtil.test2(",\"[3:31]\",\"\" ,, , Ultra-60\"");
        MuUtil.test2(",\"[3:31]\",\" ,, , Ultra-60\"\"");
        MuUtil.test2(",\"[3:31]\",\"\" ,, , Ultra-60\"\"");
    }

    public static String[] parseCSV(String string, char c, char c2) {
        if (string == null) {
            return new String[0];
        }
        char[] cArray = string.trim().toCharArray();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < cArray.length) {
            char c3 = cArray[n];
            if (bl) {
                if (c3 == c2) {
                    stringBuffer.append(c3);
                    bl = false;
                } else {
                    stringBuffer.append(c3);
                }
            } else if (c3 == c2) {
                stringBuffer.append(c3);
                bl = true;
            } else if (c3 == c) {
                vector.add(MuUtil.trimQuotes(stringBuffer.toString().trim(), c2));
                stringBuffer.setLength(0);
                stringBuffer.append(' ');
            } else {
                stringBuffer.append(c3);
            }
            ++n;
        }
        if (bl) {
            throw new RuntimeException("Unterminated string in: " + string);
        }
        if (stringBuffer.length() > 0) {
            vector.add(MuUtil.trimQuotes(stringBuffer.toString().trim(), c2));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void test1(String string, char c, char c2) throws Exception {
        MuDebug.println("TEST: " + testCount++);
        MuDebug.println("-----------------------------------------------------");
        try {
            MuDebug.println("line            = " + string);
            MuDebug.println("fieldSeparator  = " + c);
            MuDebug.println("stringDelimeter = " + c2);
            MuDebug.println();
            String[] stringArray = MuUtil.parseCSV(string, c, c2);
            int n = 0;
            while (n < stringArray.length) {
                MuDebug.println("values[" + n + "] = [" + stringArray[n] + "]");
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        MuDebug.println("-----------------------------------------------------");
    }

    public static void test2(String string) throws Exception {
        MuUtil.test1(string, ',', '\"');
        MuUtil.test1(string, ',', '\'');
    }

    public static String trimLeadingSpaces(String string) {
        int n = string.length();
        int n2 = 0;
        char[] cArray = string.toCharArray();
        while (n2 < n && cArray[n2] <= ' ') {
            ++n2;
        }
        return n2 > 0 || n < string.length() ? string.substring(n2, n) : string;
    }

    public static String trimQuotes(String string, char c) {
        int n = string.length();
        if (n > 1 && string.charAt(0) == c && string.charAt(n - 1) == c) {
            return string.substring(1, n - 1);
        }
        return string;
    }

    public static StringBuffer trimQuotes(StringBuffer stringBuffer, char c) {
        int n = stringBuffer.length();
        if (stringBuffer.charAt(0) == c && stringBuffer.charAt(n - 1) == c) {
            stringBuffer.delete(n - 1, n);
            stringBuffer.delete(0, 1);
        }
        return stringBuffer;
    }

    public static String trimTrailingSpaces(String string) {
        int n = string.length();
        int n2 = 0;
        char[] cArray = string.toCharArray();
        while (n2 < n && cArray[n - 1] <= ' ') {
            --n;
        }
        return n2 > 0 || n < string.length() ? string.substring(n2, n) : string;
    }
}

