/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.function;

import com.sun.symon.tools.migration.TmNoSuchObjectException;
import com.sun.symon.tools.migration.function.MfFunction;
import com.sun.symon.tools.migration.function.MfFunctionCallContext;
import com.sun.symon.tools.migration.function.MfFunctionException;
import com.sun.symon.tools.migration.util.MuDebug;
import com.sun.symon.tools.migration.util.MuUtil;
import java.io.Serializable;

public class MfFunctionCall
implements Cloneable,
Serializable {
    private String name;
    private String[] arguments;
    private MfFunctionCallContext context;
    private MfFunction function;

    private MfFunctionCall(String string, String[] stringArray) throws TmNoSuchObjectException {
        this.name = string;
        this.arguments = stringArray;
        this.function = MfFunction.getMfFunction(string);
    }

    public Object clone() {
        try {
            MfFunctionCall mfFunctionCall = (MfFunctionCall)super.clone();
            mfFunctionCall.arguments = (String[])this.arguments.clone();
            mfFunctionCall.context = null;
            return mfFunctionCall;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new InternalError(String.valueOf(String.valueOf(this.getClass())) + " could not be cloned: " + cloneNotSupportedException.getMessage());
        }
    }

    public String execute() throws Exception {
        return this.function.execute(this.context, this.arguments);
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public MfFunctionCallContext getContext() {
        return this.context;
    }

    public static MfFunctionCall getInstance(String string) throws TmNoSuchObjectException, MfFunctionException {
        String[] stringArray;
        String string2;
        if (string == null) {
            throw new TmNoSuchObjectException(string, "expression is null");
        }
        int n = (string = string.trim()).indexOf(40);
        if (n >= 0) {
            if (string.charAt(string.length() - 1) != ')') {
                throw new MfFunctionException("closing bracket missing in function call: " + string);
            }
            string2 = string.substring(0, n).trim();
            stringArray = MuUtil.parseCSV(string.substring(n + 1, string.length() - 1), ',', '\'');
        } else {
            string2 = "";
            stringArray = MuUtil.parseCSV(string, ',', '\'');
        }
        return new MfFunctionCall(string2, stringArray);
    }

    public MfFunction getMfFunction() {
        return this.function;
    }

    public String getName() {
        return this.name;
    }

    public static void main(String[] stringArray) throws Exception {
        MuDebug.println(MfFunctionCall.getInstance(stringArray[0]));
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public void setContext(MfFunctionCallContext mfFunctionCallContext) {
        this.context = mfFunctionCallContext;
    }

    public void setMfFunction(MfFunction mfFunction) {
        this.function = mfFunction;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append('(');
        int n = 0;
        while (n < this.arguments.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.arguments[n]);
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

