/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.datasource;

import com.sun.symon.tools.migration.datasource.MdAttribute;
import com.sun.symon.tools.migration.datasource.MdRecord;
import com.sun.symon.tools.migration.util.MuDebug;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MdValue
implements Serializable {
    private static final SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private MdAttribute attribute;
    private MdRecord record;
    private String value;

    public MdValue(MdAttribute mdAttribute) {
        this.attribute = mdAttribute;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MdValue) {
            MdValue mdValue = (MdValue)object;
            if (mdValue.isNull()) {
                return this.attribute.equals(mdValue.attribute) && this.isNull();
            }
            return this.attribute.equals(mdValue.attribute) && this.value.equals(mdValue.value);
        }
        return false;
    }

    public MdAttribute getMdAttribute() {
        return this.attribute;
    }

    public MdRecord getMdRecord() {
        return this.record;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public static void main(String[] stringArray) throws Exception {
        MdValue mdValue = new MdValue(null);
        Date date = new Date();
        mdValue.set(new Timestamp(date.getTime()));
        MuDebug.println(mdValue);
        MuDebug.println(mdValue.toTimestamp());
        MuDebug.println(mdValue.toDate());
    }

    public void set(double d) {
        this.value = String.valueOf(d);
    }

    public void set(int n) {
        this.value = String.valueOf(n);
    }

    public void set(long l) {
        this.value = String.valueOf(l);
    }

    public void set(Boolean bl) {
        if (bl == null) {
            this.setNull();
        } else {
            this.set((boolean)bl);
        }
    }

    public void set(Double d) {
        if (d == null) {
            this.setNull();
        } else {
            this.set((double)d);
        }
    }

    public void set(Integer n) {
        if (n == null) {
            this.setNull();
        } else {
            this.set((int)n);
        }
    }

    public void set(Long l) {
        if (l == null) {
            this.setNull();
        } else {
            this.set((long)l);
        }
    }

    public void set(String string) {
        this.value = string != null ? string : null;
    }

    public void set(Timestamp timestamp) {
        this.value = timestamp != null ? timestamp.toString() : null;
    }

    public void set(Date date) {
        this.value = date != null ? longDateFormat.format(date) : null;
    }

    public void set(boolean bl) {
        this.value = String.valueOf(bl);
    }

    protected void setMdAttribute(MdAttribute mdAttribute) {
        this.attribute = mdAttribute;
    }

    protected void setMdRecord(MdRecord mdRecord) {
        this.record = mdRecord;
    }

    public void setNull() {
        this.value = null;
    }

    public boolean toBoolean() {
        return this.value != null && (this.value.toLowerCase().equals("true") || this.value.equals("1"));
    }

    public Boolean toBooleanObject() {
        if (this.isNull()) {
            return null;
        }
        return new Boolean(this.toBoolean());
    }

    public Date toDate() {
        if (this.value == null) {
            return null;
        }
        try {
            return longDateFormat.parse(this.value);
        }
        catch (ParseException parseException) {
            MuDebug.println(parseException);
            return null;
        }
    }

    public double toDouble() {
        return Double.parseDouble(this.value);
    }

    public Double toDoubleObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.toDouble());
    }

    public int toInt() {
        return Integer.parseInt(this.value);
    }

    public Integer toIntObject() {
        if (this.isNull()) {
            return null;
        }
        return new Integer(this.toInt());
    }

    public long toLong() {
        return Long.parseLong(this.value);
    }

    public Long toLongObject() {
        if (this.isNull()) {
            return null;
        }
        return new Long(this.toLong());
    }

    public String toString() {
        return this.value;
    }

    public Timestamp toTimestamp() {
        if (this.value == null) {
            return null;
        }
        return Timestamp.valueOf(this.value);
    }
}

