/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import com.visigenic.vbroker.tools.IDLppHelper;
import com.visigenic.vbroker.tools.idl2java;
import com.visigenic.vbroker.tools.ir.RepositoryManager;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingException;
import oracle.aurora.AuroraServices.PublishedObject;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.Chmod;
import oracle.aurora.server.tools.sess_iiop.Mkdir;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;

public class Publish
extends ToolImpl {
    private Name objectName;
    private String className;
    private String schema;
    private String helper;
    private boolean executable = false;
    private boolean force = false;
    private boolean replaceIDL = false;
    private boolean recursiveGrants = false;
    private String[] grants;
    private static final String EXECUTABLE_HELPER = "oracle.aurora.AuroraServices.ExecutableHelper";
    private static final String REP_MANAGER = "/etc/ifrManager";

    public Publish() {
    }

    public Publish(Name objectName_, String className_, String schema_, String helper_, boolean executable_, boolean force_, String grants_) throws ToolsException {
        this.force = force_;
        this.grants = this.parseCommaDelimited(grants_ == null ? "" : grants_);
        if (this.grants.length == 0) {
            this.grants = null;
        }
        this.objectName = objectName_;
        this.schema = schema_;
        this.className = className_;
        this.helper = helper_;
        this.executable = executable_;
        this.invoke();
    }

    public Publish(Name objectName_, String className_, String schema_, String helper_, boolean executable_, boolean force_, String[] grants_) throws ToolsException {
        this.force = force_;
        this.grants = grants_;
        if (this.grants != null && this.grants.length == 0) {
            this.grants = null;
        }
        this.objectName = objectName_;
        this.schema = schema_;
        this.className = className_;
        this.helper = helper_;
        this.executable = executable_;
        this.invoke();
    }

    private void _populateIFR() throws NamingException {
        String source;
        RepositoryManager manager;
        String idlFile = ToolImpl.environment.getProperty("IDL_FILE_NAME");
        if (idlFile != null && (manager = (RepositoryManager)ToolImpl._ic.lookup(String.valueOf(ToolImpl.environment.getProperty("oracle.aurora.sess_iiop.service.url")) + REP_MANAGER)).read_text(idlFile, source = idl2java.readFrom((String)idlFile, (String)"publish"), this.replaceIDL) < 0) {
            throw new INTF_REPOS("Couldn't populate the IFR");
        }
    }

    private void _populateIFR_preprocess() throws NamingException {
        String fileName = ToolImpl.environment.getProperty("IDL_FILE_NAME");
        if (fileName != null) {
            IntHolder result = new IntHolder();
            RepositoryManager manager = (RepositoryManager)ToolImpl._ic.lookup(String.valueOf(ToolImpl.environment.getProperty("oracle.aurora.sess_iiop.service.url")) + REP_MANAGER);
            String source = IDLppHelper.preprocess33compatAPI((String)"publish", new Vector(), (String)fileName, (IntHolder)result);
            if (result.value >= 0) {
                if (manager.read_text(fileName, source, this.replaceIDL) < 0) {
                    throw new INTF_REPOS("Couldn't populate the IFR, interface name may already exist in the IFR");
                }
            } else {
                throw new INTF_REPOS("Couldn't preprocess the IDL");
            }
        }
    }

    public String description() throws ToolsException {
        return this.msg("PUBLISH_DESCRIPTION", null);
    }

    private SessionCtx dir() throws ToolsException {
        try {
            return (SessionCtx)ToolImpl.wd.lookupParent(this.objectName);
        }
        catch (ClassCastException classCastException) {
            this.fail0("NOT_SESSION_CONTEXT");
            return null;
        }
    }

    private void ensureParent(Name parentDir) throws ToolsException {
        Name[] makeDir = new Name[]{parentDir};
        Mkdir mkdir = new Mkdir(makeDir, true, this.recursiveGrants, this.grants);
    }

    public String help() throws ToolsException {
        return this.msg("PUBLISH_HELP", null);
    }

    protected void invoke() throws ToolsException {
        try {
            ToolImpl.wd.lookupParent(this.objectName);
        }
        catch (ToolsException toolsException) {
            this.ensureParent(ToolImpl.wd.lead(this.objectName));
        }
        try {
            if (this.schema == null) {
                try {
                    this.dir().createObject(ToolImpl.wd.last(this.objectName), this.className, this.helper);
                }
                catch (NamingException e) {
                    try {
                        if (!this.force) {
                            throw e;
                        }
                        ((PublishedObject)this.dir().lookup(ToolImpl.wd.last(this.objectName))).republish(this.className, this.helper);
                    }
                    catch (ClassCastException classCastException) {
                        this.fail1("NOT_AN_OBJECT", this.objectName.toString());
                    }
                }
            } else {
                try {
                    this.dir().createObject(ToolImpl.wd.last(this.objectName), this.className, this.schema, this.helper);
                }
                catch (NamingException e) {
                    try {
                        if (!this.force) {
                            throw e;
                        }
                        ((PublishedObject)this.dir().lookup(ToolImpl.wd.last(this.objectName))).republish_in(this.className, this.schema, this.helper);
                    }
                    catch (ClassCastException classCastException) {
                        this.fail1("NOT_AN_OBJECT", this.objectName.toString());
                    }
                }
            }
            if (this.grants != null) {
                new Chmod(this.objectName.toString(), this.grants, null, null, null, this.grants, null);
            }
            this._populateIFR();
        }
        catch (NamingException e) {
            this.fail1("CANNOT_CREATE_OBJECT", e.getMessage());
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            this.fail1("NO_PERMISSION_TO_CREATE_OBJECT", this.objectName.toString());
        }
    }

    public static void main(String[] args) {
        try {
            new Publish().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        if (argv.length == 0) {
            this.error(this.usage());
        }
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-schema")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_SCHEMA");
                }
                this.schema = argv[i];
            } else if (argv[i].equals("-executable") || argv[i].equals("-e")) {
                this.error(this.usage());
            } else if (argv[i].equals("-idl")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_IDL_FILE_NAME");
                }
                ((Hashtable)ToolImpl.environment).put("IDL_FILE_NAME", argv[i]);
            } else if (argv[i].equals("-grant") || argv[i].equals("-g")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_GRANT_SCHEMAS");
                }
                this.grants = this.parseCommaDelimited(argv[i]);
            } else if (argv[i].equals("-recursiveGrant") || argv[i].equals("-rg") || argv[i].equals("-rG")) {
                this.recursiveGrants = true;
                if (++i == argv.length) {
                    this.fail0("MISSING_GRANT_SCHEMAS");
                }
                this.grants = this.parseCommaDelimited(argv[i]);
            } else if (argv[i].equals("-republish")) {
                this.force = true;
            } else if (argv[i].equals("-replaceIDL")) {
                this.replaceIDL = true;
            } else if (this.objectName == null) {
                this.objectName = ToolImpl.wd.parse(argv[i]);
            } else if (this.className == null) {
                this.className = argv[i];
            } else if (this.helper == null) {
                if (this.executable) {
                    this.fail0("CANNOT_SUPPLY_HELPER_WITH_EXECUTABLE");
                }
                this.helper = argv[i];
            } else {
                this.error(this.usage());
            }
            ++i;
        }
        if (this.objectName == null) {
            this.error(this.usage());
        }
        if (this.className == null) {
            this.error(this.usage());
        }
        if (this.executable) {
            this.helper = EXECUTABLE_HELPER;
        }
    }

    public String usage() throws ToolsException {
        return this.msg("PUBLISH_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("PUBLISH_VERSION", null);
    }
}

