/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingException;
import md5.MD5InputStream;
import oracle.aurora.AuroraServices.LoadJava;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import org.omg.CORBA.StringHolder;

public abstract class Loadjava
extends ToolImpl {
    protected LoadJava loader;
    protected Vector classes = new Vector();
    protected Vector resources = new Vector();
    protected boolean verbose = false;
    protected boolean resolve = false;
    protected boolean force = false;
    protected boolean synonyms = false;
    protected String bound = " ";
    protected String resolver = " ";
    protected String schema = " ";
    protected String grantNames = " ";
    protected String encoding = null;
    private static final String LOADJAVA_NAME = "/etc/loadjava";
    protected static final int TRUE = 1;
    protected static final int FALSE = 0;
    protected Name[] fileNames = null;

    protected Loadjava() {
    }

    protected Loadjava(boolean verbose_, boolean resolve_, boolean force_, boolean bound_, boolean synonym_, String schema_, String resolver_, String grant_, String encoding_) throws ToolsException {
        this.verbose = verbose_;
        this.resolve = resolve_;
        this.force = force_;
        this.bound = bound_ ? " bound " : " ";
        this.synonyms = synonym_;
        this.schema = schema_;
        this.resolver = resolver_;
        this.grantNames = grant_;
        this.encoding = encoding_;
    }

    public Loadjava(boolean verbose_, boolean resolve_, boolean force_, boolean bound_, boolean synonym_, String schema_, String resolver_, String grant_, String encoding_, File[] files) throws ToolsException {
        this(verbose_, resolve_, force_, bound_, synonym_, schema_, resolver_, grant_, encoding_);
        this.fileNames = new Name[files.length];
        int i = 0;
        while (i < files.length) {
            this.fileNames[i] = ToolImpl.local_wd.parse(files[i].toString());
            ++i;
        }
        this.invoke();
    }

    public Loadjava(boolean verbose_, boolean resolve_, boolean force_, boolean bound_, boolean synonym_, String schema_, String resolver_, String grant_, String encoding_, String[] files) throws ToolsException {
        this(verbose_, resolve_, force_, bound_, synonym_, schema_, resolver_, grant_, encoding_);
        this.fileNames = new Name[files.length];
        int i = 0;
        while (i < files.length) {
            this.fileNames[i] = ToolImpl.local_wd.parse(files[i]);
            ++i;
        }
        this.invoke();
    }

    protected void create(String fileName, InputStream input) throws ToolsException {
        String name = this.transformName(fileName);
        if (this.isClassFile(fileName)) {
            this.createClass(name, input);
        } else if (this.isSourceFile(fileName)) {
            this.createSource(name, input);
        } else {
            this.createResource(name, input);
        }
    }

    protected boolean createClass(String classname, InputStream bits) throws ToolsException {
        StringHolder errors = new StringHolder();
        byte[] classBits = null;
        try {
            classBits = this.getStreamBytes(bits);
        }
        catch (IOException iOException) {
            this.error("Unable to read class bits from " + classname);
        }
        int rslt = this.loader.create_class(errors, classname, this.resolver, this.schema, this.grantNames, this.bound, classBits);
        if (rslt == 0) {
            this.err(errors.value);
            return false;
        }
        this.out(errors.value);
        this.classes.addElement(classname);
        return true;
    }

    protected boolean createResource(String resourceName, InputStream bits) throws ToolsException {
        StringHolder errors = new StringHolder();
        byte[] resourceBits = null;
        try {
            resourceBits = this.getStreamBytes(bits);
        }
        catch (IOException iOException) {
            this.error("Unable to read resource bytes from " + resourceName);
        }
        int rslt = this.loader.create_resource(errors, resourceName, this.grantNames, resourceBits);
        if (rslt == 0) {
            this.err(errors.value);
            return false;
        }
        this.out(errors.value);
        this.resources.addElement(resourceName);
        return true;
    }

    protected boolean createSource(String classname, InputStream bits) throws ToolsException {
        StringHolder errors = new StringHolder();
        String source = null;
        try {
            byte[] sourceBits = this.getStreamBytes(bits);
            source = new String(sourceBits);
        }
        catch (IOException iOException) {
            this.error("Unable to read class bits from " + classname);
        }
        int rslt = this.loader.create_source(errors, classname, this.encoding, this.resolver, this.schema, this.grantNames, this.bound, 0, source);
        if (rslt == 0) {
            this.err(errors.value);
            return false;
        }
        this.out(errors.value);
        this.classes.addElement(classname);
        return true;
    }

    protected void createSynonym() throws ToolsException {
        if (!this.synonyms) {
            return;
        }
        Enumeration classNames = this.classes.elements();
        StringHolder errors = new StringHolder();
        while (classNames.hasMoreElements()) {
            int rslt = this.loader.create_synonym(errors, (String)classNames.nextElement());
            if (rslt != 0) {
                this.err(errors.value);
                continue;
            }
            this.out(errors.value);
        }
        Enumeration resourceNames = this.resources.elements();
        while (resourceNames.hasMoreElements()) {
            int rslt = this.loader.create_synonym(errors, (String)resourceNames.nextElement());
            if (rslt == 0) {
                this.err(errors.value);
                continue;
            }
            this.out(errors.value);
        }
    }

    protected void err(String msg) {
        this.stdErr.print(msg);
    }

    protected boolean fileIsDifferent(String className, InputStream inputStream) {
        return true;
    }

    byte[] getStreamBytes(InputStream is) throws IOException {
        int read_this_time;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(is.available());
        byte[] buffer = new byte[4000];
        while ((read_this_time = is.read(buffer)) != -1) {
            baos.write(buffer, 0, read_this_time);
        }
        return baos.toByteArray();
    }

    protected void get_loader() throws ToolsException {
        try {
            this.loader = (LoadJava)((SessionCtx)ToolImpl.wd.ic()).activate(LOADJAVA_NAME);
        }
        catch (NamingException e) {
            this.fail1("LOADJAVA_NOT_FOUND", e.getMessage());
        }
    }

    protected boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    protected boolean isSourceFile(String name) {
        return name.endsWith(".java") || name.endsWith(".sqlj");
    }

    protected byte[] md5OfStream(InputStream in) {
        int l;
        MD5InputStream md5in = new MD5InputStream(in);
        do {
            try {
                l = md5in.read();
            }
            catch (IOException iOException) {
                l = -1;
            }
        } while (l >= 0);
        return md5in.hash();
    }

    protected void out(String msg) {
        if (this.verbose) {
            this.stdOut.print(msg);
        }
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-verbose") || argv[i].equals("-v")) {
                this.verbose = true;
            } else if (argv[i].equals("-resolve")) {
                this.resolve = true;
            } else if (argv[i].equals("-force") || argv[i].equals("-f")) {
                this.force = true;
            } else if (argv[i].equals("-bound") || argv[i].equals("-b")) {
                this.bound = " bound ";
            } else if (argv[i].equals("-synonym") || argv[i].equals("-s")) {
                this.synonyms = true;
            } else if (argv[i].equals("-schema")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.schema = argv[i];
            } else if (argv[i].equals("-resolver")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.resolver = argv[i];
            } else if (argv[i].equals("-grant") || argv[i].equals("-g")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.grantNames = argv[i];
            } else {
                if (!argv[i].equals("-encoding") && !argv[i].equals("-e")) break;
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.encoding = argv[i];
            }
            ++i;
        }
        if (argv.length == i) {
            this.error(this.usage());
        }
        this.fileNames = new Name[argv.length - i + 1];
        while (i < argv.length) {
            this.fileNames[i] = ToolImpl.local_wd.parse(argv[i]);
            ++i;
        }
    }

    protected void resolve() throws ToolsException {
        if (!this.resolve) {
            return;
        }
        Enumeration classNames = this.classes.elements();
        StringHolder errors = new StringHolder();
        while (classNames.hasMoreElements()) {
            int rslt = this.loader.compile(errors, (String)classNames.nextElement());
            if (rslt == 0) {
                this.err(errors.value);
                continue;
            }
            this.out(errors.value);
        }
    }

    public String transformName(String name) {
        if (this.isClassFile(name)) {
            name = name.substring(0, name.lastIndexOf(".class"));
            name.replace('.', '/');
        }
        if (this.isSourceFile(name)) {
            name = name.substring(0, name.lastIndexOf(".java"));
            name = name.substring(0, name.lastIndexOf(".sqlj"));
            name.replace('.', '/');
        }
        return name.replace('\\', '/');
    }
}

