/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class DebugProxy
implements Runnable {
    private int proxy_port = 0;
    private String proxy_name;
    private String proxy_address;
    private ServerSocket proxy_socket;
    private int agent_count = 0;
    private String[] command_line;
    private Runtime runtime;
    private PrintStream out;
    static String PSWDCHARS = "23456789abcdefghijkmnpqrstuvwxyz";

    public DebugProxy(int port, String[] command, Runtime run, PrintStream msg) throws Exception {
        this.proxy_port = port;
        this.command_line = command;
        this.runtime = run;
        this.out = msg;
        InetAddress proxy_inetAddress = InetAddress.getLocalHost();
        this.proxy_address = proxy_inetAddress.getHostAddress();
        this.proxy_name = proxy_inetAddress.getHostName();
        this.proxy_socket = new ServerSocket(this.proxy_port);
        this.proxy_port = this.proxy_socket.getLocalPort();
        this.out.println("\nProxy Name:     " + this.proxy_name + "\nProxy Address:  " + this.proxy_address + "\nProxy Port:     " + this.proxy_port);
    }

    static String cookieToString(int cookie) {
        int j;
        int radix = PSWDCHARS.length();
        int digitCount = 0;
        boolean minval = false;
        StringBuffer buf = new StringBuffer(32);
        while (cookie > 0) {
            if (cookie < radix) {
                buf.append(PSWDCHARS.charAt(cookie));
                cookie = 0;
            } else {
                j = cookie % radix;
                cookie /= radix;
                buf.append(PSWDCHARS.charAt(j));
            }
            ++digitCount;
        }
        if (digitCount > 0) {
            j = buf.length();
            char[] tmp = new char[j];
            int i = 0;
            while (j-- > 0) {
                tmp[j] = buf.charAt(i++);
            }
            return String.valueOf(tmp);
        }
        return "0";
    }

    void error(String source, Throwable x) {
        this.out.println("\n" + source + ": " + x.getLocalizedMessage());
    }

    public static void main(String[] argv) throws Exception {
        int proxy_port = 0;
        int n_args_used = 0;
        if (argv.length > 0 && argv[0].charAt(0) == '-') {
            if (argv.length > 1 && argv[0].equals("-port")) {
                proxy_port = Integer.parseInt(argv[1]);
                n_args_used += 2;
            } else {
                System.out.println("Usage: [-port #] [debugger command line]");
                return;
            }
        }
        int n_args = argv.length - n_args_used;
        String[] command_line = new String[argv.length - n_args_used + 1];
        System.arraycopy(argv, n_args_used, command_line, 0, n_args);
        new DebugProxy(proxy_port, command_line, Runtime.getRuntime(), System.out).run();
    }

    static String makePassword(int port) {
        int mask = (int)(Math.round(Math.random() * 2048.0) % 2048L);
        int cookie = 0;
        int slice = 3;
        int i = 0;
        while (i < 8) {
            int portbits = (port & slice) << i + 1;
            int maskbits = (mask & 1 << i) << i * 2;
            cookie |= portbits | maskbits;
            slice <<= 2;
            ++i;
        }
        return DebugProxy.cookieToString(cookie |= (mask & 0x700) << 16);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket agent_socket = this.proxy_socket.accept();
                    Socket async_socket = this.proxy_socket.accept();
                    ServerSocket bridge_socket = new ServerSocket(0);
                    new BridgeMaker(agent_socket, async_socket, bridge_socket).start();
                }
            }
            catch (Throwable x) {
                this.error("Proxy", x);
                continue;
            }
            break;
        }
    }

    private class BridgeMaker
    extends Thread {
        Socket agent_socket;
        Socket redir_socket;
        ServerSocket bridge_socket;

        BridgeMaker(Socket agent, Socket redir, ServerSocket bridge) {
            this.agent_socket = agent;
            this.redir_socket = redir;
            this.bridge_socket = bridge;
        }

        public void run() {
            String agent_name;
            Socket debug_socket = null;
            Socket async_socket = null;
            InetAddress agent_inetAddress = this.agent_socket.getInetAddress();
            String agent_address = agent_inetAddress.getHostAddress();
            String error_source = agent_name = agent_inetAddress.getHostName();
            try {
                try {
                    byte[] protocol_version = new byte[1];
                    this.agent_socket.getInputStream().read(protocol_version);
                    if (protocol_version[0] != 0) {
                        throw new Exception("incompatible protocol");
                    }
                    DebugProxy debugProxy = DebugProxy.this;
                    debugProxy.agent_count = debugProxy.agent_count + 1;
                    int agent_port = this.bridge_socket.getLocalPort();
                    String agent_password = DebugProxy.makePassword(this.bridge_socket.getLocalPort());
                    DebugProxy.this.out.println("\nAgent Number:   " + DebugProxy.this.agent_count + "\nAgent Name:     " + agent_name + "\nAgent Address:  " + agent_address + "\nAgent Port:     " + agent_port + "\nAgent Password: " + agent_password + "\n" + "\nProxy Name:     " + DebugProxy.this.proxy_name + "\nProxy Address:  " + DebugProxy.this.proxy_address + "\nProxy Port:     " + DebugProxy.this.proxy_port);
                    error_source = "Agent Number " + DebugProxy.this.agent_count;
                    if (DebugProxy.this.command_line != null && DebugProxy.this.command_line.length > 1) {
                        ((DebugProxy)DebugProxy.this).command_line[((DebugProxy)DebugProxy.this).command_line.length - 1] = agent_password;
                        DebugProxy.this.runtime.exec(DebugProxy.this.command_line);
                    }
                    debug_socket = this.bridge_socket.accept();
                    Bridge debug_out = new Bridge(error_source, this.agent_socket.getInputStream(), debug_socket.getOutputStream());
                    Bridge debug_in = new Bridge(error_source, debug_socket.getInputStream(), this.agent_socket.getOutputStream());
                    debug_out.start();
                    debug_in.start();
                    async_socket = this.bridge_socket.accept();
                    Bridge async_out = new Bridge(error_source, this.redir_socket.getInputStream(), async_socket.getOutputStream());
                    async_out.start();
                    InetAddress debug_inetAddress = debug_socket.getInetAddress();
                    String debug_address = debug_inetAddress.getHostAddress();
                    String debug_name = debug_inetAddress.getHostName();
                    debug_out.join();
                    debug_in.join();
                    async_out.join();
                }
                catch (Throwable x) {
                    DebugProxy.this.error(error_source, x);
                }
                Object var8_18 = null;
            }
            catch (Throwable throwable) {
                Object var8_19 = null;
                try {
                    this.bridge_socket.close();
                    this.redir_socket.close();
                    this.agent_socket.close();
                    if (async_socket != null) {
                        async_socket.close();
                    }
                    if (debug_socket != null) {
                        debug_socket.close();
                    }
                }
                catch (Throwable x) {
                    DebugProxy.this.error(error_source, x);
                }
                throw throwable;
            }
            try {
                this.bridge_socket.close();
                this.redir_socket.close();
                this.agent_socket.close();
                if (async_socket != null) {
                    async_socket.close();
                }
                if (debug_socket != null) {
                    debug_socket.close();
                }
            }
            catch (Throwable x) {
                DebugProxy.this.error(error_source, x);
            }
        }

        class Bridge
        extends Thread {
            String error_source;
            InputStream in;
            OutputStream out;

            Bridge(String s, InputStream i, OutputStream o) {
                this.error_source = s;
                this.in = i;
                this.out = o;
            }

            public void run() {
                try {
                    try {
                        int length;
                        byte[] buffer = new byte[8192];
                        while ((length = this.in.read(buffer)) > 0) {
                            this.out.write(buffer, 0, length);
                        }
                    }
                    catch (Throwable x) {
                        DebugProxy.this.error(this.error_source, x);
                    }
                    Object var2_5 = null;
                }
                catch (Throwable throwable) {
                    Object var2_6 = null;
                    try {
                        this.in.close();
                        this.out.close();
                    }
                    catch (Throwable x) {
                        DebugProxy.this.error(this.error_source, x);
                    }
                    throw throwable;
                }
                try {
                    this.in.close();
                    this.out.close();
                }
                catch (Throwable x) {
                    DebugProxy.this.error(this.error_source, x);
                }
            }
        }
    }
}

