/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.fscontext;

import com.sun.jndi.fscontext.AggregateNamingEnumeration;
import com.sun.jndi.fscontext.FSContext;
import com.sun.jndi.fscontext.FSNameParser;
import com.sun.jndi.fscontext.ObjectNameClassEnumeration;
import com.sun.jndi.toolkit.chars.BASE64Decoder;
import com.sun.jndi.toolkit.chars.BASE64Encoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;

public class RefFSContext
extends FSContext {
    private static final boolean debug = false;
    private static final String bindingsFileName = ".bindings";
    static final String SEPARATOR = "/";
    static final String CLASS_NAME_PROP = "ClassName";
    private static final String FACTORY_NAME_PROP = "FactoryName";
    private static final String FACTORY_LOC_PROP = "FactoryLocation";
    private static final String REF_ADDR_PROP = "RefAddr";
    private static final String ADDR_TYPE_PROP = "Type";
    private static final String ADDR_ENC_PROP = "Encoding";
    private static final String ADDR_CONTENT_PROP = "Content";
    private static final String STRING_ENC = "String";
    private static final String BASE64_ENC = "Base64";
    private static final String BINDINGS_HEADER = "This file is used by the JNDI FSContext.";
    static /* synthetic */ Class class$com$sun$jndi$fscontext$RefFSContextFactory;

    public RefFSContext(File file, Hashtable hashtable) throws NamingException {
        super(file, hashtable);
    }

    public RefFSContext(String string, Hashtable hashtable) throws NamingException {
        super(string, hashtable);
    }

    private void addObjectToBindings(String string, Name name, Object object, Properties properties) throws NamingException {
        int n;
        Reference reference;
        if ((object = NamingManager.getStateToBind(object, name, this, this.environment)) instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        } else if (object instanceof Reference) {
            reference = (Reference)object;
        } else {
            throw new OperationNotSupportedException("Can only bind References or Referenceable objects");
        }
        String string2 = reference.getClassName();
        if (string2 == null) {
            throw new NamingException("Reference has no class name");
        }
        ((Hashtable)properties).put(String.valueOf(string) + SEPARATOR + CLASS_NAME_PROP, string2);
        string2 = reference.getFactoryClassName();
        if (string2 != null) {
            ((Hashtable)properties).put(String.valueOf(string) + SEPARATOR + FACTORY_NAME_PROP, string2);
        }
        if ((string2 = reference.getFactoryClassLocation()) != null) {
            ((Hashtable)properties).put(String.valueOf(string) + SEPARATOR + FACTORY_LOC_PROP, string2);
        }
        if ((n = reference.size()) > 0) {
            int n2 = 0;
            while (n2 < n) {
                String string3 = String.valueOf(string) + SEPARATOR + REF_ADDR_PROP + SEPARATOR + n2 + SEPARATOR;
                RefAddr refAddr = reference.get(n2);
                ((Hashtable)properties).put(String.valueOf(string3) + ADDR_TYPE_PROP, refAddr.getType());
                if (refAddr instanceof StringRefAddr) {
                    ((Hashtable)properties).put(String.valueOf(string3) + ADDR_ENC_PROP, STRING_ENC);
                    ((Hashtable)properties).put(String.valueOf(string3) + ADDR_CONTENT_PROP, refAddr.getContent());
                } else {
                    ((Hashtable)properties).put(String.valueOf(string3) + ADDR_ENC_PROP, BASE64_ENC);
                    BASE64Encoder bASE64Encoder = new BASE64Encoder();
                    ((Hashtable)properties).put(String.valueOf(string3) + ADDR_CONTENT_PROP, bASE64Encoder.encodeBuffer((byte[])refAddr.getContent()));
                }
                ++n2;
            }
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        this.checkNameNotEmpty(name);
        this.checkDoesntExist(name);
        this.bindObject(name, object);
    }

    private void bindObject(Name name, Object object) throws NamingException {
        String string = this.getLeafName(name);
        Name name2 = this.getPenultimatePrefix(name);
        Properties properties = this.getBindings(name2);
        this.addObjectToBindings(string, name, object, properties);
        this.setBindings(name2, properties);
    }

    protected void checkDoesntExist(Name name) throws NamingException {
        String string = this.getLeafName(name);
        Name name2 = this.getPenultimatePrefix(name);
        Properties properties = this.getBindings(name2);
        String string2 = properties.getProperty(String.valueOf(string) + SEPARATOR + CLASS_NAME_PROP);
        if (string2 != null) {
            throw new NameAlreadyBoundException(name.toString());
        }
        this.checkDoesntExist(new FSContext.FSFile(this.backingDirectory, name.toString()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Context createContext(File file) throws NamingException {
        return new RefFSContext(file, this.environment);
    }

    private Properties getBindings(Name name) throws NamingException {
        File file = null;
        try {
            file = this.getBindingsFile(name, false);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return new Properties();
        }
        try {
            if (!file.canRead()) {
                return new Properties();
            }
        }
        catch (SecurityException securityException) {
            throw this.generateNamingException(securityException);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            throw this.generateNamingException(iOException);
        }
    }

    private File getBindingsFile(Name name, boolean bl) throws NamingException {
        Name name2 = (Name)name.clone();
        name2.add(bindingsFileName);
        try {
            return (File)super.lookup(name2);
        }
        catch (NameNotFoundException nameNotFoundException) {
            if (bl) {
                return new File(this.backingDirectory, name2.toString());
            }
            throw nameNotFoundException;
        }
        catch (ClassCastException classCastException) {
            throw new NameAlreadyBoundException("an object is already bound where the bindings should be stored");
        }
    }

    String getFactoryName() {
        return (class$com$sun$jndi$fscontext$RefFSContextFactory != null ? class$com$sun$jndi$fscontext$RefFSContextFactory : (class$com$sun$jndi$fscontext$RefFSContextFactory = RefFSContext.class$("com.sun.jndi.fscontext.RefFSContextFactory"))).getName();
    }

    protected String getLeafName(Name name) throws NamingException {
        return name.get(name.size() - 1);
    }

    Object getObjectFromBindings(String string, Properties properties, Hashtable hashtable) throws NamingException {
        Object var4_4 = null;
        String string2 = null;
        String string3 = null;
        String string4 = properties.getProperty(String.valueOf(string) + SEPARATOR + CLASS_NAME_PROP);
        if (string4 == null) {
            throw new NameNotFoundException(string);
        }
        string2 = properties.getProperty(String.valueOf(string) + SEPARATOR + FACTORY_NAME_PROP);
        string3 = properties.getProperty(String.valueOf(string) + SEPARATOR + FACTORY_LOC_PROP);
        Reference reference = new Reference(string4, string2, string3);
        int n = 0;
        String string5 = String.valueOf(string) + SEPARATOR + REF_ADDR_PROP + SEPARATOR + n + SEPARATOR;
        String string6 = properties.getProperty(String.valueOf(string5) + ADDR_TYPE_PROP);
        while (string6 != null) {
            String string7 = properties.getProperty(String.valueOf(string5) + ADDR_ENC_PROP);
            String string8 = properties.getProperty(String.valueOf(string5) + ADDR_CONTENT_PROP);
            if (string7 == null || string8 == null) {
                throw new NameNotFoundException(string);
            }
            if (string7.equals(STRING_ENC)) {
                reference.add(new StringRefAddr(string6, string8));
            } else {
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                try {
                    reference.add(new BinaryRefAddr(string6, bASE64Decoder.decodeBuffer(string8)));
                }
                catch (IOException iOException) {
                    throw this.generateNamingException(iOException, string);
                }
            }
            string5 = String.valueOf(string) + SEPARATOR + REF_ADDR_PROP + SEPARATOR + ++n + SEPARATOR;
            string6 = properties.getProperty(String.valueOf(string5) + ADDR_TYPE_PROP);
        }
        return reference;
    }

    protected Name getPenultimatePrefix(Name name) throws NamingException {
        try {
            return name.getPrefix(name.size() - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return FSNameParser.EMPTY_NAME;
        }
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            NamingEnumeration namingEnumeration = super.list(name);
            ObjectNameClassEnumeration objectNameClassEnumeration = new ObjectNameClassEnumeration(this.getBindings(name));
            return new AggregateNamingEnumeration(namingEnumeration, objectNameClassEnumeration);
        }
        Object object = this.lookup(name);
        if (object instanceof Context) {
            return ((Context)object).list(FSNameParser.EMPTY_NAME);
        }
        throw new NotContextException(name.toString());
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            NamingEnumeration namingEnumeration = super.listBindings(name);
            ObjectBindingEnumeration objectBindingEnumeration = new ObjectBindingEnumeration(this, this.getBindings(name));
            return new AggregateNamingEnumeration(namingEnumeration, objectBindingEnumeration);
        }
        Object object = this.lookup(name);
        if (object instanceof Context) {
            return ((Context)object).listBindings(FSNameParser.EMPTY_NAME);
        }
        throw new NotContextException(name.toString());
    }

    public Object lookup(Name name) throws NamingException {
        try {
            return super.lookup(name);
        }
        catch (NameNotFoundException nameNotFoundException) {
            try {
                return NamingManager.getObjectInstance(this.lookupObject(name), name, this, this.environment);
            }
            catch (Exception exception) {
                throw this.generateNamingException(exception, name.toString());
            }
        }
    }

    private Object lookupObject(Name name) throws NamingException {
        String string = this.getLeafName(name);
        Name name2 = this.getPenultimatePrefix(name);
        Properties properties = this.getBindings(name2);
        return this.getObjectFromBindings(string, properties, this.environment);
    }

    public void rebind(Name name, Object object) throws NamingException {
        try {
            this.unbind(name);
        }
        catch (NameNotFoundException nameNotFoundException) {}
        this.bindObject(name, object);
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.checkDoesntExist(name2);
        try {
            super.rename(name, name2);
        }
        catch (NameNotFoundException nameNotFoundException) {
            this.renameObject(name, name2);
        }
    }

    private void renameObject(Name name, Name name2) throws NamingException {
        Object object = this.lookup(name);
        this.unbind(name);
        this.bind(name2, object);
    }

    private void setBindings(Name name, Properties properties) throws NamingException {
        File file = this.getBindingsFile(name, ((Hashtable)properties).isEmpty() ^ true);
        if (((Hashtable)properties).isEmpty() && file.exists()) {
            file.delete();
            return;
        }
        this.checkCanWrite(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.save(fileOutputStream, BINDINGS_HEADER);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw this.generateNamingException(iOException);
        }
    }

    public void unbind(Name name) throws NamingException {
        try {
            super.unbind(name);
        }
        catch (NameNotFoundException nameNotFoundException) {}
        this.checkNameNotEmpty(name);
        this.unbindObject(name);
    }

    private void unbindObject(Name name) throws NamingException {
        String string = this.getLeafName(name);
        Name name2 = this.getPenultimatePrefix(name);
        Properties properties = this.getBindings(name2);
        Enumeration<?> enumeration = properties.propertyNames();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (!string2.startsWith(string)) continue;
            ((Hashtable)properties).remove(string2);
            bl = true;
        }
        if (bl) {
            this.setBindings(name2, properties);
        }
    }

    class ObjectBindingEnumeration
    extends ObjectNameClassEnumeration {
        private Context parentCtx;

        ObjectBindingEnumeration(RefFSContext refFSContext2, Properties properties) {
            super(properties);
            this.parentCtx = refFSContext2;
        }

        protected Object nameToEnumerationObj(String string) throws NamingException {
            Object object = RefFSContext.this.getObjectFromBindings(string, this.bindings, RefFSContext.this.environment);
            try {
                Name name = new CompositeName().add(string);
                object = NamingManager.getObjectInstance(object, name, this.parentCtx, RefFSContext.this.environment);
                return new Binding(name.toString(), object);
            }
            catch (Exception exception) {
                throw RefFSContext.this.generateNamingException(exception, string);
            }
        }
    }
}

