/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.aurora.server.tools.loadjava.ClassFileReader;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.Error;
import oracle.aurora.server.tools.loadjava.SourceFileReader;
import oracle.aurora.server.tools.loadjava.ToolLog;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.sqljdecl.ParseException;
import oracle.jdbc.driver.OracleLog;

public class DropJavaImpl {
    private String flags;
    private boolean verbose = false;
    private boolean debug = false;
    private boolean synonym = false;
    private String encoding = null;
    private String schema = null;
    private Connection conn;
    private Statement stmt;
    private String localPathPrefix = "";
    DatabaseOptions databaseOptions = new DatabaseOptions();
    PrintStream out = System.err;
    ToolLog log = new ToolLog(this.out, false, false);

    String MD5TableName() {
        return String.valueOf(this.schemaAsPrefix()) + "JAVA$CLASS$MD5$TABLE";
    }

    String classNameFrom(String name) {
        String className = name;
        if (name.endsWith(".class")) {
            className = name.substring(0, name.lastIndexOf(".class")).replace('.', '/');
        } else if (name.endsWith(".java")) {
            className = name.substring(0, name.lastIndexOf(".java")).replace('.', '/');
        } else if (name.endsWith(".sqlj")) {
            className = name.substring(0, name.lastIndexOf(".sqlj")).replace('.', '/');
        }
        return className;
    }

    void dropClass(String name) {
        this.dropClass(name, name);
    }

    void dropClass(String fileName, InputStream in) {
        try {
            ClassFileReader r = new ClassFileReader(this.normalizeFilename(fileName), in);
            String className = r.fullyQualifiedClassName();
            if (this.synonym) {
                this.dropSynonym(className);
            }
            this.dropClass(className, className.replace('.', '/'));
        }
        catch (ToolsException ex) {
            this.err(ex, "dropping " + fileName);
        }
        catch (IOException ex) {
            this.err(ex, "dropping " + fileName);
        }
    }

    void dropClass(String className, String MD5Name) {
        className = className.replace('.', '/');
        try {
            this.msg("dropping class   : " + className);
            this.stmt.execute("DROP JAVA CLASS " + this.schemaAsPrefix() + "\"" + className + "\"");
            this.stmt.execute("DELETE FROM " + this.MD5TableName() + " WHERE NAME = '" + MD5Name + "'");
        }
        catch (SQLException e2) {
            if (e2.getErrorCode() == 4043) {
                this.msg(e2.getMessage());
            }
            this.err(e2, "processing " + className);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dropJar(String fileName) {
        try {
            ZipFile jarFile = new ZipFile(this.normalizeFilename(fileName));
            try {
                try {
                    Enumeration<? extends ZipEntry> e = jarFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry currentEntry = e.nextElement();
                        if (!currentEntry.isDirectory()) {
                            String className;
                            if (this.isClassEntry(currentEntry)) {
                                className = this.classNameFrom(currentEntry.getName());
                                this.dropClass(currentEntry.getName(), jarFile.getInputStream(currentEntry));
                            } else if (this.isSourceEntry(currentEntry)) {
                                className = this.classNameFrom(currentEntry.getName());
                                this.dropSource(className);
                            } else {
                                this.dropResource(currentEntry.getName());
                            }
                        }
                        this.conn.commit();
                    }
                }
                catch (SQLException ex) {
                    this.err(ex, "processing " + fileName);
                }
                Object var4_8 = null;
                if (jarFile == null) return;
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                if (jarFile == null) throw throwable;
                jarFile.close();
                throw throwable;
            }
            jarFile.close();
            return;
        }
        catch (IOException ex) {
            this.err(ex, "processing " + fileName);
        }
    }

    void dropName(String name) {
        String[] what = new String[]{"class", "source", "resource"};
        boolean someOk = false;
        SQLException[] errs = new SQLException[what.length];
        if (name.startsWith("/")) {
            name = "ROOT" + name;
        }
        if (this.synonym) {
            this.dropSynonym(name);
        }
        this.msg("dropping         : " + name);
        int x = 0;
        while (x < what.length) {
            try {
                this.stmt.execute("DROP JAVA " + what[x] + " \"" + name + "\"");
                someOk = true;
            }
            catch (SQLException ex) {
                errs[x] = ex;
            }
            ++x;
        }
        if (!someOk) {
            this.err("could not drop " + name);
            String previousError = "";
            int x2 = 0;
            while (x2 < errs.length) {
                String nextError = errs[x2].toString();
                if (!nextError.equals(previousError)) {
                    this.err("    " + nextError.toString());
                }
                previousError = nextError;
                ++x2;
            }
        } else {
            try {
                this.stmt.execute("DELETE FROM JAVA$CLASS$MD5$TABLE WHERE NAME = '" + name + "'");
            }
            catch (SQLException sQLException) {}
        }
    }

    void dropResource(String name) {
        try {
            this.msg("dropping resource: " + name);
            this.stmt.execute("DROP JAVA RESOURCE \"" + name + "\"");
            this.stmt.execute("DELETE FROM JAVA$CLASS$MD5$TABLE WHERE NAME = '" + name + "'");
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 4043) {
                this.msg(ex.getMessage());
            }
            this.err(ex, "processing " + name);
        }
    }

    void dropSomething(String element) {
        try {
            if (element.endsWith(".class")) {
                FileInputStream file = new FileInputStream(this.normalizeFilename(element));
                this.dropClass(element, file);
                file.close();
            } else if (element.endsWith(".jar") || element.endsWith(".zip")) {
                this.dropJar(element);
            } else if (element.endsWith(".java") || element.endsWith(".sqlj")) {
                FileInputStream file = new FileInputStream(this.normalizeFilename(element));
                this.dropSource(element, file);
            } else {
                this.dropName(element);
            }
        }
        catch (IOException ex) {
            this.err(ex, "processing " + element);
        }
    }

    void dropSource(String name) {
        try {
            this.msg("dropping source  : " + name);
            name = name.replace('.', '/');
            this.stmt.execute("DROP JAVA SOURCE " + this.schemaAsPrefix() + "\"" + name + "\"");
            this.stmt.execute("DELETE FROM " + this.MD5TableName() + " WHERE NAME = '" + name + "'");
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 4043) {
                this.msg(ex.getMessage());
            }
            this.err(ex, "processing: " + name);
        }
    }

    void dropSource(String sourceFileName, InputStream in) {
        String name = sourceFileName;
        if (name.endsWith(".sqlj") || name.endsWith(".java")) {
            name = name.substring(0, name.length() - 5).replace('.', '/');
        }
        if (name.startsWith("/")) {
            name = "ROOT" + name;
        }
        try {
            SourceFileReader r = new SourceFileReader(this.normalizeFilename(sourceFileName), in, this.encoding);
            String nameInFile = r.getFirstName();
            if (nameInFile != null) {
                name = nameInFile;
            }
        }
        catch (IOException e) {
            this.err(e, "opening or reading " + sourceFileName);
        }
        catch (ParseException ex) {
            this.err((Exception)((Object)ex), "scanning source file " + sourceFileName);
        }
        if (this.synonym) {
            this.dropSynonym(name);
        }
        this.dropSource(name);
    }

    void dropSynonym(String className) {
        className = className.replace('.', '/');
        try {
            this.msg("dropping synonym   : " + className);
            this.stmt.execute("DROP PUBLIC SYNONYM " + this.schemaAsPrefix() + "\"" + className + "\"");
        }
        catch (SQLException e2) {
            if (e2.getErrorCode() == 4043) {
                this.msg(e2.getMessage());
            }
            this.err(e2, "processing " + className);
        }
    }

    void err(Exception ex, String msg) {
        this.log.err(ex, msg);
    }

    void err(String msg) {
        this.log.err(msg);
    }

    boolean isClassEntry(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }

    boolean isSourceEntry(ZipEntry entry) {
        return entry.getName().endsWith(".java") || entry.getName().endsWith(".sqlj");
    }

    void msg(String msg) {
        this.log.msg(msg);
    }

    String normalizeFilename(String filename) {
        filename = filename.replace('/', File.separatorChar);
        File f = new File(filename);
        String prefix = this.localPathPrefix;
        if (!f.isAbsolute()) {
            filename = String.valueOf(prefix) + filename;
        }
        return filename;
    }

    public void run(String[] args) throws SQLException, ClassNotFoundException, IOException {
        try {
            Vector<String> filenames = new Vector<String>(20, 10);
            args = this.databaseOptions.parseArgs(args);
            this.flags = "";
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-v") || args[i].equals("-verbose")) {
                    this.verbose = true;
                } else if (args[i].equals("-help") || args[i].equals("-h")) {
                    Error.DROP_JAVA_HELP();
                } else if (args[i].equals("-encoding")) {
                    if (++i == args.length) {
                        this.usage();
                    } else {
                        this.encoding = args[i];
                    }
                } else if (args[i].equals("-localpathprefix")) {
                    if (++i == args.length) {
                        this.usage();
                    } else {
                        this.localPathPrefix = args[i];
                    }
                } else if (args[i].equals("-schema")) {
                    if (++i == args.length) {
                        this.usage();
                    } else {
                        this.schema = args[i];
                    }
                } else if (args[i].equals("-debug")) {
                    this.debug = true;
                } else if (args[i].equals("-s") || args[i].equals("-synonym")) {
                    this.synonym = true;
                } else if (args[i].equals("-stdout")) {
                    this.out = System.out;
                } else {
                    filenames.addElement(args[i]);
                }
                ++i;
            }
            this.log = new ToolLog(this.out, this.verbose, this.debug);
            if (this.debug) {
                this.msg("Parsed command-line arguments:");
                this.msg("driver = '" + this.databaseOptions.driver + "'");
                this.msg("username = '" + this.databaseOptions.user + "'");
                this.msg("password = '" + this.databaseOptions.password + "'");
                this.msg("files:");
                i = 0;
                while (i < filenames.size()) {
                    this.msg("    " + (String)filenames.elementAt(i));
                    ++i;
                }
            }
            if (this.debug) {
                DriverManager.setLogStream(this.out);
                OracleLog.setLogStream((PrintStream)System.out);
                OracleLog.config((int)10, (int)1, (int)32);
                OracleLog.setSubmodMask((int)1, (int)20);
            }
            if (filenames.size() == 0) {
                this.usage();
            } else {
                this.conn = this.databaseOptions.connect();
                this.conn.setAutoCommit(false);
                this.stmt = this.conn.createStatement();
                i = 0;
                while (i < filenames.size()) {
                    String element = (String)filenames.elementAt(i);
                    this.dropSomething(element);
                    ++i;
                }
                this.conn.commit();
                this.conn.close();
            }
        }
        catch (ToolsException e) {
            this.err("dropjava: " + e.getMessage());
            return;
        }
        catch (ToolsError e) {
            this.err("dropjava: " + e.getMessage());
            return;
        }
    }

    String schemaAsPrefix() {
        String name = "";
        if (this.schema != null) {
            name = String.valueOf(this.schema) + ".";
        }
        return name;
    }

    void usage() throws ToolsException {
        Error.DROP_JAVA_USAGE();
    }
}

