/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server;

import com.visigenic.vbroker.orb.ServerThreadInfo;
import java.util.MissingResourceException;
import oracle.aurora.AuroraServices.ActivatableObject;
import oracle.aurora.AuroraServices.Locale;
import oracle.aurora.AuroraServices.MinorCodes;
import oracle.aurora.AuroraServices.SecurityContext;
import oracle.aurora.AuroraServices._LoginServerImplBase;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.O3Authenticate;
import oracle.aurora.rdbms.O3LoginProtocol;
import oracle.aurora.rdbms.O3SessionReauth;
import oracle.aurora.rdbms.ReauthHolder;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.server.LoginManager;
import oracle.aurora.server.ORB;
import oracle.aurora.server.Properties;
import oracle.aurora.server.VCIiopConnection;
import oracle.aurora.server.VCListener;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;

public final class LoginServerImpl
extends _LoginServerImplBase
implements ActivatableObject {
    static LoginServerImpl singleton;
    private static LoginManager __loginManager;
    private O3LoginProtocol loginImpl;
    private static boolean sessionAuthenticated;
    private static boolean defaultAuthenticated;
    private String urole;
    private Locale locale;
    private static com.visigenic.vbroker.orb.ORB _orb;

    static {
        sessionAuthenticated = false;
        defaultAuthenticated = false;
        _orb = (com.visigenic.vbroker.orb.ORB)ORB.init();
        __loginManager = new LoginManager();
    }

    public LoginServerImpl() {
        singleton = this;
    }

    public byte[] O3Logon_A(String username) {
        if (LoginServerImpl._orb.AuroraDebug) {
            System.out.println("In O3Logon_A");
        }
        try {
            this.loginImpl = sessionAuthenticated ? new O3Authenticate(username) : new O3SessionReauth(username);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NO_PERMISSION(MinorCodes.getMessage(4), 4, CompletionStatus.COMPLETED_NO);
        }
        try {
            return this.loginImpl.getChallengeBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NO_PERMISSION(MinorCodes.getMessage(4), 4, CompletionStatus.COMPLETED_NO);
        }
    }

    public byte[] O3Logon_A_Locale(String username, Locale l) {
        java.util.Locale default_locale;
        this.locale = l;
        if (this.locale != null && !(default_locale = new java.util.Locale(this.locale.language, this.locale.country, this.locale.variant)).equals(java.util.Locale.getDefault())) {
            if (LoginServerImpl._orb.AuroraDebug) {
                java.util.Locale def = java.util.Locale.getDefault();
                System.out.println("Default Locale: ");
                System.out.println("  language: " + def.getLanguage());
                System.out.println("  country: " + def.getCountry());
                System.out.println("  vairant: " + def.getVariant());
                System.out.println("Session set to Locale:");
                System.out.println("  language: " + this.locale.language);
                System.out.println("  country: " + this.locale.country);
                System.out.println("  vairant: " + this.locale.variant);
            }
            java.util.Locale.setDefault(default_locale);
            if (LoginServerImpl._orb.AuroraDebug) {
                System.out.println("Locale set");
            }
        }
        return this.O3Logon_A(username);
    }

    public byte[] O3Logon_A_Role(String username, String role) {
        this.urole = role.toUpperCase();
        return this.O3Logon_A(username);
    }

    public byte[] O3Logon_A_Role_Locale(String username, String role, Locale l) {
        java.util.Locale default_locale;
        this.locale = l;
        if (this.locale != null && !(default_locale = new java.util.Locale(this.locale.language, this.locale.country, this.locale.variant)).equals(java.util.Locale.getDefault())) {
            if (LoginServerImpl._orb.AuroraDebug) {
                java.util.Locale def = java.util.Locale.getDefault();
                System.out.println("Default Locale: ");
                System.out.println("  language: " + def.getLanguage());
                System.out.println("  country: " + def.getCountry());
                System.out.println("  vairant: " + def.getVariant());
                System.out.println("Session set to Locale:");
                System.out.println("  language: " + this.locale.language);
                System.out.println("  country: " + this.locale.country);
                System.out.println("  vairant: " + this.locale.variant);
            }
            java.util.Locale.setDefault(default_locale);
            if (LoginServerImpl._orb.AuroraDebug) {
                System.out.println("Locale set");
            }
        }
        this.urole = role;
        return this.O3Logon_A(username);
    }

    public boolean O3Logon_B(byte[] response) {
        boolean success = false;
        if (LoginServerImpl._orb.AuroraDebug) {
            System.out.println("In O3Logon_B");
        }
        try {
            success = this.loginImpl.authenticate(null, response);
        }
        catch (Exception exception) {}
        if (!success) {
            this.cleanup();
            throw new NO_PERMISSION(MinorCodes.getMessage(4), 4, CompletionStatus.COMPLETED_NO);
        }
        sessionAuthenticated = true;
        ServerThreadInfo tls = ServerThreadInfo.instance((com.visigenic.vbroker.orb.ORB)_orb);
        ((VCIiopConnection)tls.connection).authenticate(Schema.lookup((String)this.loginImpl.username).ownerNumber());
        if (LoginServerImpl._orb.AuroraDebug) {
            System.out.println("Setting role: " + this.urole);
        }
        if (this.urole != null && !this.urole.equals("") && !DbmsJava.setRole((String)this.urole.toUpperCase())) {
            throw new NO_PERMISSION(MinorCodes.getMessage(9), 9, CompletionStatus.COMPLETED_NO);
        }
        this.cleanup();
        return true;
    }

    public Object _initializeAuroraObject() {
        singleton = this;
        return this;
    }

    static boolean authenticate(String username, String password) {
        boolean success;
        O3Authenticate impl = null;
        if (username.equals("") || password.equals("")) {
            return false;
        }
        if (LoginServerImpl._orb.AuroraDebug) {
            System.out.println("Authenticating:");
            System.out.println("   username: " + username);
            System.out.println("   password: " + password);
        }
        if (sessionAuthenticated) {
            if (LoginServerImpl._orb.AuroraDebug) {
                System.out.println("Session authenticated, verifying username and password");
            }
            success = false;
            try {
                impl = new O3Authenticate(username);
                success = impl.authenticate(password);
            }
            catch (Exception exception) {}
            if (!success) {
                if (LoginServerImpl._orb.AuroraDebug) {
                    System.out.println("Verification failed");
                }
                return false;
            }
        } else {
            if (LoginServerImpl._orb.AuroraDebug) {
                System.out.println("Session not authenticated, reauthorized the session");
            }
            success = false;
            try {
                impl = new O3SessionReauth(username);
                success = impl.authenticate(password);
            }
            catch (Exception exception) {}
            if (!success) {
                if (LoginServerImpl._orb.AuroraDebug) {
                    System.out.println("Reauthorization failed");
                }
                return false;
            }
            sessionAuthenticated = true;
        }
        try {
            if (LoginServerImpl._orb.AuroraDebug) {
                System.out.println("Authentication successful, marking socket as authenticated to: " + Schema.lookup((String)impl.username).ownerNumber());
            }
            ServerThreadInfo tls = ServerThreadInfo.instance((com.visigenic.vbroker.orb.ORB)_orb);
            ((VCIiopConnection)tls.connection).authenticate(Schema.lookup((String)impl.username).ownerNumber());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean authenticate(SecurityContext context) {
        if (!sessionAuthenticated) {
            java.util.Locale locale;
            if (LoginServerImpl._orb.AuroraDebug) {
                System.out.println("Session not authenticated, setting up Locale");
            }
            if (!(locale = new java.util.Locale(context.language, context.country, context.variant)).equals(java.util.Locale.getDefault())) {
                if (LoginServerImpl._orb.AuroraDebug) {
                    java.util.Locale def = java.util.Locale.getDefault();
                    System.out.println("Default Locale: ");
                    System.out.println("  language: " + def.getLanguage());
                    System.out.println("  country: " + def.getCountry());
                    System.out.println("  vairant: " + def.getVariant());
                    System.out.println("Session set to Locale:");
                    System.out.println("  language: " + context.language);
                    System.out.println("  country: " + context.country);
                    System.out.println("  vairant: " + context.variant);
                }
                java.util.Locale.setDefault(locale);
                if (LoginServerImpl._orb.AuroraDebug) {
                    System.out.println("Locale set");
                }
            }
        }
        if (!LoginServerImpl.authenticate(context.username, context.password)) {
            return false;
        }
        if (LoginServerImpl._orb.AuroraDebug) {
            System.out.println("Setting role: " + context.role);
        }
        if (context.role != null && !context.role.equals("") && !DbmsJava.setRole((String)context.role.toUpperCase())) {
            throw new NO_PERMISSION(MinorCodes.getMessage(9), 9, CompletionStatus.COMPLETED_MAYBE);
        }
        return true;
    }

    static void authenticateDefault() {
        if (sessionAuthenticated || defaultAuthenticated) {
            return;
        }
        if (LoginServerImpl._orb.AuroraDebug) {
            System.out.println("Attempting to login as the unauthorized user");
            try {
                System.out.println(Properties.properties().getString("UNAUTHENTICATED_USERNAME"));
                System.out.println(Properties.properties().getString("UNAUTHENTICATED_PASSWORD"));
            }
            catch (MissingResourceException e) {
                System.out.println("Missing resource: " + e.getMessage());
            }
        }
        try {
            String un = Properties.properties().getString("UNAUTHENTICATED_USERNAME");
            String pwd = Properties.properties().getString("UNAUTHENTICATED_PASSWORD");
            try {
                if (new O3SessionReauth(un).authenticate(pwd)) {
                    defaultAuthenticated = true;
                    return;
                }
            }
            catch (Exception exception) {}
            if (LoginServerImpl._orb.AuroraDebug) {
                System.out.println("Reauthorization to unauthenticated user failed");
            }
            return;
        }
        catch (MissingResourceException missingResourceException) {
            return;
        }
    }

    private void cleanup() {
        this.loginImpl = null;
        this.urole = null;
        this.locale = null;
    }

    public boolean clear_text_login(String username, String password, String role) {
        String prop = System.getProperty("ALLOW_NON_SSL_CREDENTIAL");
        if (prop != null && prop.equalsIgnoreCase("TRUE") || VCListener.isSSLConnection()) {
            if (!LoginServerImpl.authenticate(username, password)) {
                return false;
            }
            if (LoginServerImpl._orb.AuroraDebug) {
                System.out.println("Setting role: " + role);
            }
            if (role != null && !role.equals("") && !DbmsJava.setRole((String)role.toUpperCase())) {
                throw new NO_PERMISSION(MinorCodes.getMessage(9), 9, CompletionStatus.COMPLETED_MAYBE);
            }
            return true;
        }
        return false;
    }

    static int gblAuthenticate(ReauthHolder holder, int type, int mode) {
        return __loginManager.reauthorize(holder, type, mode);
    }

    public short getCharSet() {
        return 0;
    }

    private static byte[] getEncryptedPassword(String uname) {
        return DbmsJava._native_getEncryptedPassword((String)uname);
    }

    private static boolean verifyPasswd(String userName, byte[] password) {
        try {
            byte[] epw = LoginServerImpl.getEncryptedPassword(userName.toUpperCase());
            String realPasswd = new String(epw);
            String recvPasswd = new String(password);
            int error = realPasswd.compareTo(new String(password));
            if (LoginServerImpl._orb.AuroraDebug) {
                System.out.println("realPasswd = " + realPasswd + " received passwd = " + recvPasswd);
            }
            return error == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean verifyPwd(String userName, String pwd) {
        try {
            return new O3Authenticate(userName).authenticate(pwd);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

