/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jts.server;

import com.visigenic.vbroker.orb.AnyImpl;
import com.visigenic.vbroker.orb.ORB;
import java.util.Enumeration;
import java.util.Vector;
import oracle.aurora.jndi.orb_dep.Orb;
import oracle.aurora.jts.AuroraJTS._RootCoordinatorImplBase;
import oracle.aurora.jts.server.RecoveryCoordinatorImpl;
import oracle.aurora.jts.server.TransactionFactoryImpl;
import oracle.aurora.jts.server.XA_JTSResource;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;

public class RootCoordinatorImpl
extends _RootCoordinatorImplBase {
    private TransIdentity tid;
    private Vector synchronizedObjects = new Vector();
    private Vector resources = new Vector();
    private RecoveryCoordinator recoveryCoordinator = RecoveryCoordinatorImpl.singleton;
    private Status status;
    private int hash;
    private static final boolean DEBUG = false;
    private int timeout = 60;

    private RootCoordinatorImpl() {
    }

    private RootCoordinatorImpl(String name) {
        super(name);
    }

    RootCoordinatorImpl(TransIdentity ctxt, int timeout) {
        this();
        Orb.init().BOA_init().obj_is_ready((Object)this);
        this.tid = ctxt;
        this.tid.coord = this;
        this.tid.term = this;
        this.status = Status.StatusActive;
        this.hash = XA_JTSResource.gtridKeyOf(this.tid.otid.tid).hashCode();
    }

    private void after_completion() {
        Enumeration elements = this.synchronizedObjects.elements();
        while (elements.hasMoreElements()) {
            ((Synchronization)elements.nextElement()).after_completion(this.status);
        }
    }

    private void before_completion() {
        Enumeration elements = this.synchronizedObjects.elements();
        while (elements.hasMoreElements()) {
            ((Synchronization)elements.nextElement()).before_completion();
        }
    }

    public void commit(boolean report_heuristics) throws HeuristicMixed, HeuristicHazard {
        if (this.status.equals(Status.StatusMarkedRollback)) {
            this.rollback();
            throw new TRANSACTION_ROLLEDBACK();
        }
        this.before_completion();
        if (this.resources.size() == 1) {
            this.onePhaseCommit(report_heuristics);
        } else {
            this.twoPhaseCommit(report_heuristics);
        }
        this.after_completion();
        this.status = Status.StatusNoTransaction;
        TransactionFactoryImpl.releaseTxn(this.tid);
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        throw new SubtransactionsUnavailable();
    }

    void deactivate() {
        Orb.init().BOA_init().deactivate_obj((Object)this);
    }

    public Coordinator get_coordinator() throws Unavailable {
        return this;
    }

    public Status get_parent_status() {
        return this.status;
    }

    public Status get_status() {
        return this.status;
    }

    public Terminator get_terminator() throws Unavailable {
        return this;
    }

    public Status get_top_level_status() {
        return this.status;
    }

    public String get_transaction_name() {
        return XA_JTSResource.gtridKeyOf(this.tid.otid.tid);
    }

    public PropagationContext get_txcontext() throws Unavailable {
        PropagationContext ctxt = new PropagationContext();
        ctxt.current = this.tid;
        ctxt.timeout = this.timeout;
        ctxt.parents = new TransIdentity[0];
        AnyImpl any = new AnyImpl();
        java.lang.Object[] obj = new java.lang.Object[1];
        any.init((ORB)org.omg.CORBA.ORB.init(), obj);
        ctxt.implementation_specific_data = any;
        ctxt.implementation_specific_data.insert_short((short)35);
        return ctxt;
    }

    public int hash_top_level_tran() {
        return this.hash;
    }

    public int hash_transaction() {
        return this.hash;
    }

    public boolean is_ancestor_transaction(Coordinator tc) {
        return false;
    }

    public boolean is_descendant_transaction(Coordinator tc) {
        return false;
    }

    public boolean is_related_transaction(Coordinator tc) {
        return false;
    }

    public boolean is_same_transaction(Coordinator tc) {
        return this._is_equivalent((Object)tc);
    }

    public boolean is_top_level_transaction() {
        return true;
    }

    private void onePhaseCommit(boolean report_heuristics) throws HeuristicMixed, HeuristicHazard {
        this.status = Status.StatusCommitting;
        java.lang.Object o = this.resources.firstElement();
        ((XA_JTSResource)o).commit_one_phase();
        this.status = Status.StatusCommitted;
    }

    public RecoveryCoordinator register_resource(Resource r) throws Inactive {
        if (!this.status.equals(Status.StatusActive)) {
            throw new Inactive();
        }
        this.resources.addElement(r);
        return this.recoveryCoordinator;
    }

    public void register_subtran_aware(SubtransactionAwareResource r) throws Inactive, NotSubtransaction {
        throw new NotSubtransaction();
    }

    public void register_synchronization(Synchronization sync) throws Inactive, SynchronizationUnavailable {
        if (!this.status.equals(Status.StatusActive)) {
            throw new Inactive();
        }
        this.synchronizedObjects.addElement(sync);
    }

    public void rollback() {
        if (this.status.equals(Status.StatusRolledBack)) {
            return;
        }
        this.before_completion();
        this.status = Status.StatusRollingBack;
        Enumeration elements = this.resources.elements();
        while (elements.hasMoreElements()) {
            try {
                XA_JTSResource xjr = (XA_JTSResource)elements.nextElement();
                xjr.rollback();
                xjr.forget();
            }
            catch (HeuristicMixed heuristicMixed) {
            }
            catch (HeuristicCommit heuristicCommit) {
            }
            catch (HeuristicHazard heuristicHazard) {}
        }
        this.status = Status.StatusRolledBack;
        this.after_completion();
        this.status = Status.StatusNoTransaction;
        TransactionFactoryImpl.releaseTxn(this.tid);
    }

    public void rollback_only() throws Inactive {
        if (!this.status.equals(Status.StatusActive)) {
            throw new Inactive();
        }
        this.status = Status.StatusMarkedRollback;
    }

    private void twoPhaseCommit(boolean report_heuristics) throws HeuristicMixed, HeuristicHazard {
        this.status = Status.StatusPreparing;
        Enumeration elements = this.resources.elements();
        while (elements.hasMoreElements()) {
            ((XA_JTSResource)elements.nextElement()).prepare();
        }
        this.status = Status.StatusPrepared;
        this.status = Status.StatusCommitting;
        elements = this.resources.elements();
        while (elements.hasMoreElements()) {
            try {
                ((XA_JTSResource)elements.nextElement()).commit();
            }
            catch (NotPrepared notPrepared) {
            }
            catch (HeuristicRollback heuristicRollback) {}
        }
        this.status = Status.StatusCommitted;
    }
}

