/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment.server;

import oracle.aurora.ejb.deployment.server.BeanGenerator;
import oracle.aurora.ejb.deployment.server.EjbBinaryClassProcessorConfiguration;
import oracle.aurora.ejb.deployment.server.EjbRuntimeGenerator;
import oracle.aurora.ejb.deployment.server.JasperGenerationError;
import oracle.aurora.ncomp.jasper.binary.BinaryBatchClassProcessor;
import oracle.aurora.ncomp.jasper.binary.BinaryClassInspector;
import oracle.aurora.ncomp.java.BinaryClass;
import oracle.aurora.ncomp.java.ClassDefinition;
import oracle.aurora.ncomp.java.Environment;
import oracle.aurora.ncomp.javac.BatchEnvironment;
import oracle.aurora.ncomp.javadoc.Configuration;
import oracle.aurora.rdbms.Resolver;

class EjbBinaryClassProcessor
extends BinaryBatchClassProcessor {
    private BeanGenerator generationContext = null;

    public EjbBinaryClassProcessor(Resolver resolver, String[] argv) {
        super((Configuration)new EjbBinaryClassProcessorConfiguration(resolver, argv));
    }

    protected void applyClassTransformer(String transformerClassName, ClassDefinition definition) {
        BatchEnvironment env = this.getEnv();
        BinaryClassInspector mapper = (BinaryClassInspector)env.newClosureInstance(transformerClassName);
        ((EjbRuntimeGenerator)mapper).setGenerationContext(this.generationContext);
        mapper.init((Environment)env).run((BinaryClass)definition);
    }

    public void exit() {
    }

    public BeanGenerator getGenerationContext() {
        return this.generationContext;
    }

    public void run() {
        long tm = System.currentTimeMillis();
        this.getConfiguration().parseCommandLine();
        this.getConfiguration().findEnvironment();
        this.getConfiguration().findDocumentationGenerator();
        try {
            this.processTasks();
        }
        catch (Error ee) {
            ee.printStackTrace();
            throw new JasperGenerationError(ee.getMessage());
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw new JasperGenerationError(ee.getMessage());
        }
        if (this.getEnv().verbose()) {
            tm = System.currentTimeMillis() - tm;
            System.out.println("[done in " + tm + "ms]");
        }
        this.exit();
    }

    public void setGenerationContext(BeanGenerator generationContext_newValue) {
        this.generationContext = generationContext_newValue;
    }
}

