/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.interceptor;

import com.visigenic.vbroker.GIOP.ReplyHeader;
import com.visigenic.vbroker.GIOP.ReplyHeaderHolder;
import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.IORHolder;
import com.visigenic.vbroker.interceptor.ChainServerInterceptorClosure;
import com.visigenic.vbroker.interceptor.Closure;
import com.visigenic.vbroker.interceptor.ServerInterceptor;
import com.visigenic.vbroker.interceptor.ServerInterceptorPackage.ShutdownReason;
import com.visigenic.vbroker.orb.ORB;
import java.util.Vector;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHolder;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class ChainServerInterceptor
implements ServerInterceptor {
    private Vector _interceptors = new Vector();
    private ORB _orb;

    ChainServerInterceptor(ORB orb) {
        this._orb = orb;
    }

    void add(ServerInterceptor interceptor) {
        this._interceptors.addElement(interceptor);
    }

    public void exception_occurred(RequestHeader request, Environment env, Closure closure) {
        if (closure.object == null) {
            throw new INTERNAL();
        }
        ChainServerInterceptorClosure[] list = (ChainServerInterceptorClosure[])closure.object;
        int i = list.length - 1;
        while (i >= 0) {
            if (list[i].interceptor != null) {
                try {
                    list[i].interceptor.exception_occurred(request, env, list[i].closure);
                }
                catch (RuntimeException e) {
                    env.exception((Exception)e);
                }
            }
            --i;
        }
    }

    public IOR locate(int req_id, byte[] object_key, Closure closure) {
        int size = this._interceptors.size();
        if (size == 0) {
            return null;
        }
        ChainServerInterceptorClosure[] list = new ChainServerInterceptorClosure[size];
        int i = 0;
        while (i < size) {
            list[i] = new ChainServerInterceptorClosure();
            ++i;
        }
        closure.object = list;
        int i2 = 0;
        while (i2 < size) {
            list[i2].interceptor = (ServerInterceptor)this._interceptors.elementAt(i2);
            IOR ior = null;
            try {
                ior = list[i2].interceptor.locate(req_id, object_key, list[i2].closure);
            }
            catch (RuntimeException runtimeException) {}
            if (ior != null) {
                return ior;
            }
            ++i2;
        }
        return null;
    }

    public IOR locate_failed(int req_id, byte[] object_key, Closure closure) {
        if (closure.object == null) {
            throw new INTERNAL();
        }
        ChainServerInterceptorClosure[] list = (ChainServerInterceptorClosure[])closure.object;
        int i = list.length - 1;
        while (i >= 0) {
            if (list[i].interceptor != null) {
                IOR ior = null;
                try {
                    ior = list[i].interceptor.locate_failed(req_id, object_key, list[i].closure);
                }
                catch (RuntimeException runtimeException) {}
                if (ior != null) {
                    return ior;
                }
            }
            --i;
        }
        return null;
    }

    public void locate_forwarded(int req_id, IORHolder forward_ior, Closure closure) {
        if (closure.object == null) {
            throw new INTERNAL();
        }
        ChainServerInterceptorClosure[] list = (ChainServerInterceptorClosure[])closure.object;
        int i = list.length - 1;
        while (i >= 0) {
            if (list[i].interceptor != null) {
                try {
                    list[i].interceptor.locate_forwarded(req_id, forward_ior, list[i].closure);
                }
                catch (RuntimeException runtimeException) {}
            }
            --i;
        }
    }

    public void locate_succeeded(int req_id, Closure closure) {
        if (closure.object == null) {
            throw new INTERNAL();
        }
        ChainServerInterceptorClosure[] list = (ChainServerInterceptorClosure[])closure.object;
        int i = list.length - 1;
        while (i >= 0) {
            if (list[i].interceptor != null) {
                try {
                    list[i].interceptor.locate_succeeded(req_id, list[i].closure);
                }
                catch (RuntimeException runtimeException) {}
            }
            --i;
        }
    }

    public void prepare_reply(RequestHeader hdr, ReplyHeaderHolder reply, Object target, Closure closure) {
        if (closure != null && closure.object != null) {
            ChainServerInterceptorClosure[] list = (ChainServerInterceptorClosure[])closure.object;
            int i = list.length - 1;
            while (i >= 0) {
                if (list[i].interceptor != null) {
                    try {
                        list[i].interceptor.prepare_reply(hdr, reply, target, list[i].closure);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                --i;
            }
        }
    }

    public InputStream receive_request(RequestHeader hdr, ObjectHolder object, InputStream buf, Closure closure) {
        InputStream ret = null;
        int size = this._interceptors.size();
        if (size == 0) {
            return null;
        }
        ChainServerInterceptorClosure[] list = new ChainServerInterceptorClosure[size];
        int i = 0;
        while (i < size) {
            list[i] = new ChainServerInterceptorClosure();
            ++i;
        }
        closure.object = list;
        InputStream curr = null;
        int i2 = 0;
        while (i2 < size) {
            list[i2].interceptor = (ServerInterceptor)this._interceptors.elementAt(i2);
            curr = list[i2].interceptor.receive_request(hdr, object, buf, list[i2].closure);
            if (curr != null) {
                buf = ret = curr;
            }
            ++i2;
        }
        return ret;
    }

    public void request_completed(RequestHeader hdr, Object target, Closure closure) {
        if (closure != null && closure.object != null) {
            ChainServerInterceptorClosure[] list = (ChainServerInterceptorClosure[])closure.object;
            int i = list.length - 1;
            while (i >= 0) {
                if (list[i].interceptor != null) {
                    try {
                        list[i].interceptor.request_completed(hdr, target, list[i].closure);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                --i;
            }
        }
    }

    public OutputStream send_reply(RequestHeader reqHdr, ReplyHeader hdr, Object target, OutputStream buf, Environment env, Closure closure) {
        OutputStream ret = null;
        if (closure != null && closure.object != null) {
            ChainServerInterceptorClosure[] list = (ChainServerInterceptorClosure[])closure.object;
            OutputStream curr = null;
            int i = list.length - 1;
            while (i >= 0) {
                if (list[i].interceptor != null && (curr = list[i].interceptor.send_reply(reqHdr, hdr, target, buf, env, list[i].closure)) != null) {
                    buf = ret = curr;
                }
                --i;
            }
        }
        return ret;
    }

    public void send_reply_failed(RequestHeader reqHdr, ReplyHeader hdr, Object target, Environment env, Closure closure) {
        if (closure.object == null) {
            throw new INTERNAL();
        }
        ChainServerInterceptorClosure[] list = (ChainServerInterceptorClosure[])closure.object;
        int i = list.length - 1;
        while (i >= 0) {
            if (list[i].interceptor != null) {
                try {
                    list[i].interceptor.send_reply_failed(reqHdr, hdr, target, env, list[i].closure);
                }
                catch (RuntimeException runtimeException) {}
            }
            --i;
        }
    }

    public void shutdown(ShutdownReason reason) {
        int size = this._interceptors.size();
        int i = 0;
        while (i < size) {
            try {
                ((ServerInterceptor)this._interceptors.elementAt(i)).shutdown(reason);
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
    }
}

