Rem
Rem $Header: utljavrm.sql 01-nov-99.17:25:37 mjungerm Exp $
Rem
Rem utljavarm.sql
Rem
Rem  Copyright (c) Oracle Corporation 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      utljavarm.sql - Remove all java objects
Rem
Rem    DESCRIPTION
Rem      This removes all the java objects from the data dictionary.
Rem
Rem    NOTES
Rem      WARNING:  This script is highly destructive.  It should
Rem		only be run if you upgrading to or downgrading 
Rem		from 8.1.6 to 8.1.4 or below.
Rem             Once this script is run all of your
Rem		java objects will be gone unless you have a backup!!!
Rem
Rem      This script requires a significant amount of rollback
Rem      to execute.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mjungerm    11/01/99 - modify for 8.1.6
Rem    rshaikh     01/12/99 - Created (for mjungerm)
Rem

REM Java objects have a format change between 8.1.4 and 8.1.5.
REM We have to remove all java objects between these releases 
REM because they are not compatible.

variable jvmrmaction varchar2(30)
execute :jvmrmaction := 'FULL_REMOVAL';

-- inline relevant portions of javavm/install/jvmrm.sql and its subscripts

-- Remove some portion of the Java related data dictionary objects

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all java related objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

print jvmrmaction

set serveroutput on

begin

--
initjvmaux.drp('drop role javauserpriv');
initjvmaux.drp('drop role javaidpriv');
initjvmaux.drp('drop role javasyspriv');
initjvmaux.drp('drop role javadebugpriv');

--
initjvmaux.drp('drop view javasnm');
initjvmaux.drp('drop public synonym javasnm');

--
initjvmaux.drp('drop table aurora$startup$classes$');
initjvmaux.drp('drop table aurora$shutdown$classes$');

--
initjvmaux.drp('drop package get_error$');
initjvmaux.drp('drop public synonym get_error$');

--
initjvmaux.drp('drop trigger AURORA$SERVER$SHUTDOWN');
initjvmaux.drp('drop trigger AURORA$SERVER$STARTUP');

-- initsql
initjvmaux.drp('drop package sqljutl');


-- inline relevant portion of jvmrm_dbj (subscript of jvmrm)

-- Remove some portion of the dictionary objects created by initdbj.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

initjvmaux.drp('drop package dbms_java');
initjvmaux.drp('drop PUBLIC SYNONYM dbms_java');
initjvmaux.drp('drop FUNCTION dbj_long_name');
initjvmaux.drp('drop function "NameFromLastDDL"');
initjvmaux.drp('drop PUBLIC SYNONYM "NameFromLastDDL"');
initjvmaux.drp('drop FUNCTION dbj_short_name');
initjvmaux.drp('drop PUBLIC SYNONYM dbj_short_name');

-- end inline of relevant portion of jvmrm_dbj (subscript of jvmrm)

-- inline relevant portion of jvmrm_security (subscript of jvmrm)

-- Remove some portion of the dictionary objects created by init_security.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

initjvmaux.drp('drop TABLE java$policy$');
initjvmaux.drp('drop SEQUENCE java$policy$sequence$');
initjvmaux.drp('drop VIEW dba_java_policy');
initjvmaux.drp('drop PUBLIC SYNONYM dba_java_policy');
initjvmaux.drp('drop VIEW user_java_policy');
initjvmaux.drp('drop PUBLIC SYNONYM user_java_policy');
initjvmaux.drp('drop ROLE java_admin');

-- end inline of relevant portion of jvmrm_security (subscript of jvmrm)

-- inline relevant portion of jvmrm_orb (subscript of jvmrm)

-- Remove some portion of the dictionary objects created by init_orb.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

initjvmaux.drp('drop view ALL_IDS');
initjvmaux.drp('drop public synonym ALL_IDS');
initjvmaux.drp('drop table AURORA$IIOP$SYSTEM$PROPERTIES');
initjvmaux.drp('drop public synonym AURORA$IIOP$SYSTEM$PROPERTIES');
initjvmaux.drp('drop user AURORA$ORB$UNAUTHENTICATED');

-- end inline of relevant portion of jvmrm_orb (subscript of jvmrm)

-- inline relevant portion of jvmrm_namespace (subscript of jvmrm)

-- Remove some portion of the dictionary objects created by init_namespace.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

initjvmaux.drp('drop sequence aurora$sns$node_number$');
initjvmaux.drp('drop table aurora$sns$bindings$');
initjvmaux.drp('drop table aurora$sns$inode$');
initjvmaux.drp('drop index aurora$sns$node_index');
initjvmaux.drp('drop table aurora$sns$attributes$');
initjvmaux.drp('drop table aurora$sns$refaddr$');
initjvmaux.drp('drop table aurora$sns$permissions$');
initjvmaux.drp('drop index aurora$sns$perm_index');

initjvmaux.drp('drop package dbms_orb_context');


-- end inline of relevant portion of jvmrm_namespace (subscript of jvmrm)

-- inline relevant portion of jvmrm_xa (subscript of jvmrm)

-- Remove some portion of the dictionary objects created by initxa.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

initjvmaux.drp('drop package JAVA_XA');
initjvmaux.drp('drop PUBLIC SYNONYM JAVA_XA');


-- end inline of relevant portion of jvmrm_xa (subscript of jvmrm)

-- inline relevant portion of jvmrm_http (subscript of jvmrm)

-- Remove some portion of the dictionary objects created by init_http.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all objects
--  UPGRADE:             remove all system objects appropriate prior to
--                       upgrading to the current revision
--  DOWNGRADE:           remove all system objects appropriate prior to
--                       downgrading to previous revision
--  NONE:                do nothing

initjvmaux.drp('drop sequence sns$node_number$');
initjvmaux.drp('drop table sns$bindings$');
initjvmaux.drp('drop table sns$inode$');
initjvmaux.drp('drop index sns$node_index');
initjvmaux.drp('drop table sns$attributes$');
initjvmaux.drp('drop table sns$refaddr$');
initjvmaux.drp('drop index sns$refaddr_index');
initjvmaux.drp('drop table sns$permissions$');
initjvmaux.drp('drop index sns$perm_index');
initjvmaux.drp('drop sequence sns$shared$obj$seq$');
initjvmaux.drp('drop table sns$shared$obj$');
initjvmaux.drp('drop index sns$shared$obj_index');

initjvmaux.drp('drop package sns_context');

end;
/

-- end inline of relevant portion of jvmrm_http (subscript of jvmrm)

-- end of inline of javavm/install/jvmrm.sql and its subscripts

execute rmjvm.run(true);

REM 
REM end java object removal
REM
