rem 
rem $Header: otrcprvt.sql,v 1.1 95/03/28 14:36:51 drady: Exp $ 
rem 
Rem  Copyright (c) 1995 by Oracle Corporation 
Rem    NAME
Rem      otrcprvt.sql - <one-line expansion of the name>
Rem    DESCRIPTION
Rem      This file provides client callable interfaces to the Oracle TRACE
Rem      instrumentation within the Oracle7 Server (rdbms).
Rem    RETURNS
Rem 
Rem    NOTES
Rem      Package  dbms_oracle_trace_agent  should only be granted to DBA
Rem      or the Oracle TRACE collection agent.
Rem    MODIFIED   (MM/DD/YY)
Rem     drady      02/09/95 -  Creation


CREATE OR REPLACE PACKAGE BODY dbms_oracle_trace_agent IS
  ------------
  --  OVERVIEW
  --
  --  This package provides some system level utilities.
  --
  --  SECURITY
  --
  --  This package is only accessible to user SYS by default.  You can control
  --  access to these routines by only granting execute to privileged users.
  --
  ----------------------------
  --  PROCEDURES AND FUNCTIONS
  --
  PROCEDURE set_otrace_ev_icd
            ( sid BINARY_INTEGER,
              ser BINARY_INTEGER,
              evt BINARY_INTEGER,
              lvl BINARY_INTEGER,
              fdf VARCHAR2,
              cdf VARCHAR2
            );
    PRAGMA INTERFACE (C, set_otrace_ev_icd);                 -- 1 (see kvot.c)
  --
  --
  PROCEDURE set_otrace( sid BINARY_INTEGER DEFAULT 0,
              ser BINARY_INTEGER DEFAULT 0,
              evt BINARY_INTEGER DEFAULT 0,
              lvl BINARY_INTEGER DEFAULT 0,
              fdf VARCHAR2 DEFAULT '',
              cdf VARCHAR2 DEFAULT '') IS
    BEGIN
      set_otrace_ev_icd(sid, ser, evt, lvl, fdf, cdf);
    END set_otrace;
  --
  ----------------------------
  --
  PROCEDURE set_oracle_trace_in_session
            ( sid NUMBER DEFAULT 0,
              serial# NUMBER DEFAULT 0,
              on_off IN BOOLEAN  DEFAULT false,
              collection_name IN VARCHAR2 DEFAULT '',
              facility_name IN VARCHAR2 DEFAULT ''
            ) IS
  BEGIN
    IF on_off THEN
      set_otrace(sid, serial#, 10146, 1, facility_name, collection_name);
    ELSE
      set_otrace(sid, serial#, 10146, 0, facility_name, collection_name);
    END IF;
  END set_oracle_trace_in_session;
  --
  --
END dbms_oracle_trace_agent;
/

CREATE OR REPLACE PACKAGE BODY dbms_oracle_trace_user IS
  ------------
  --  OVERVIEW
  --
  --  This package provides public access to the Oracle7 Server (rdbms)
  --  Oracle TRACE instrumentation for the calling user.
  --
  ----------------------------
  --  PROCEDURES AND FUNCTIONS
  --
  PROCEDURE set_oracle_trace
            ( on_off IN BOOLEAN DEFAULT false,
              collection_name IN VARCHAR2 DEFAULT '',
              facility_name IN VARCHAR2 DEFAULT ''
            ) IS
  BEGIN
    IF on_off THEN
      sys.dbms_oracle_trace_agent.set_otrace(0, 0, 10146, 1,
                                              facility_name, collection_name);
    ELSE
      sys.dbms_oracle_trace_agent.set_otrace(0, 0, 10146, 0,
                                              facility_name, collection_name);
    END IF;
  END;
END dbms_oracle_trace_user;
/

