# Entering precomp.mk
# Entering /vobs/oracle/buildtools/mkfile/prefix.mk

# Entering /vobs/oracle/buildtools/mkfile/defs.mk

SHELL=/bin/sh

AS_EXT=s
LIB_EXT=a
OBJ_EXT=o
PLB_EXT=plb
SO_EXT=so
LOCK_EXT=lk
SQL_EXT=sql
SYM_EXT=sym
JAVA_EXT=java
CLASS_EXT=class
JAR_EXT=jar
ZIP_EXT=zip

LIB_PREFIX=lib
LDLIBFLAG=-l
LDPATHFLAG=-L
PATHSEP= :

AR=ar
AS=as
AWK=awk
CAT=cat
CC=cc
CD=cd
CHMOD=chmod
CP=cp
CPP=cpp
DATE=date
ECHO=echo
ECHON=echo -n
EXEC=exec
FIND=find
FOLLOW=-follow
NOLEAF=-noleaf
GREP=grep
KILL=kill
SLEEP=sleep
LD=ld
LMAKE=make
LN=ln
LNS=ln -s
MKDIR=mkdir
MKDIRP=mkdir -p
MV=mv
NM=nm
PERL=perl
RM=rm
RMF=rm -f
RMRF=rm -rf
SED=sed
SORT=sort
TOUCH=touch
XARGS=xargs
LS=ls

NULL_DEVICE=/dev/null

BINHOME=$(ORACLE_HOME)/bin/
LIBHOME=$(ORACLE_HOME)/lib/

PRODHOME=$(ORACLE_HOME)/$(PRODUCT)/
PRODLIBHOME=$(PRODHOME)lib/
PRODSOHOME=$(PRODLIBHOME)

ECHODO=$(BINHOME)echodo
GENSYSLIB=$(BINHOME)gensyslib
GENCLNTSH=$(BINHOME)genclntsh
GENAGTSH=$(BINHOME)genagtsh
GENNAFLG=$(BINHOME)gennaflg
GENAUTAB=$(BINHOME)genautab

ARCHIVE_OBJ=$(AR) r $@ $*.$(OBJ_EXT)
ARCREATE=$(AR) cr$(ARLOCAL)
ARDELETE=$(AR) d$(ARLOCAL)
AREXTRACT=$(AR) x 
ARPRINT=$(AR) t
ARREPLACE=$(AR) r 
DOAR=$(ARCREATE) $@ $? $(RANLIB)

JARCHIVE_OBJ=$(JAR) cv0f $@ $(JPKG_FILES) $(EXTRA_CLASS_FILES)
JARCREATE=$(JAR) cv0f
JARDELETE=$(ECHO) "no such thing"
JAREXTRACT=$(JAR) xf
JARPRINT=$(JAR) tvf
JARREPLACE=$(JAR) uf

MAKE=$(LMAKE)
QUIET=>/dev/null 2>&1
QUIETE=2>/dev/null
SILENT=@
CTSMAKEFLAGS=$(SILENT:@=--no-print-directory -s)

CFLAGS=$(GFLAG) $(OPTIMIZE) $(CDEBUG) $(CCFLAGS) $(QACCFLAGS) $(PFLAGS)\
	$(SHARED_CFLAG) $(USRFLAGS)
PFLAGS=$(INCLUDE) $(SPFLAGS) $(LPFLAGS)

LDCCOM=$(PURECMDS) $(CC) $(GFLAG) $(CCFLAGS) $(EXOSFLAGS) $(LDFLAGS)
PURECMDS=$(PURELINK) $(PURIFY) $(PURECOV) $(QUANTIFY)
LINK=$(LDCCOM)
LDFLAGS=-o $@ $(LDPATHFLAG)$(PRODLIBHOME) $(LDPATHFLAG)$(LIBHOME)
LDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(EXSYSLIBS) $(MATHLIB) $(USRLIBS)
MATHLIB=-lm
LINKLDLIBS=$(LDLIBS)
COBLDLIBS=$(LDLIBS)

SYSLIBLIST=$(LIBHOME)sysliblist
SYSLIBS=`$(CAT) $(SYSLIBLIST)`

NAETTOBJS=$(NAUTAB) $(NAETAB) $(NAEDHS)
TTLIBD=$(NETLIBD) $(LIBRDBMS_CLT) $(LIBMM) $(CORELIBD) $(LIBEPC) $(LIBCLNTSH)
ORACLETTLIBS=$(NTZEOBJ) $(NETLIBS) $(LLIBRDBMS_CLT) $(LLIBWTC) $(LLIBMM) $(CORELIBS)\
       $(NETLIBS) $(LLIBRDBMS_CLT) $(LIBPLS_CLT) $(LLIBEPC) $(CORELIBS) \
       $(LLIBRDBMS_CLT) $(CORELIBS)
STATICTTLIBS=$(ORACLETTLIBS) $(LDLIBS)
TTLIBS=$(LLIBCLNTSH) $(STATICTTLIBS)
DEVTTLIBS=$(TTLIBS)
LINKTTLIBS=$(LLIBCLNTSH) $(ORACLETTLIBS) $(LINKLDLIBS)
COBTTLIBS=$(ORACLETTLIBS) $(COBLDLIBS)

ORACLESTLIBS=$(SGL_ON) $(CONFIG) $(LLIBSERVER) $(LLIBSKGXP) $(LLIBPLSF) \
       $(LLIBSLAX) \
       $(LIBGENERIC) $(LLIBCLIENT) $(LLIBWTC) $(LLIBMM) $(LLIBKNLOPT) $(LLIBPLSB)\
       $(LLIBSERVER) $(LLIBEXTP) $(NAUTAB) $(NAETAB) $(NAEDHS) $(NTZEOBJ) \
       $(NETLIBS) $(LLIBCLIENT) \
       $(LLIBPLSF) $(LLIBICX) $(LLIBOWSUTL) \
       $(LLIBJAVAVMORJOX) \
       $(NETLIBS) $(LLIBEPC) $(SDOLIBS) $(LLIBCORE) $(LLIBVSN) $(LLIBCOMMON)\
       $(LIBGENERIC) $(LLIBKNLOPT) $(NMLIBS) $(CARTLIBS) $(CORELIBS)
STLIBS=$(ORACLESTLIBS) $(LDLIBS)
LINKSTLIBS=$(ORACLESTLIBS) $(LINKLDLIBS)

# Exiting /vobs/oracle/buildtools/mkfile/defs.mk
# Entering /vobs/oracle/buildtools/mkfile/platform.mk

FAMILY=unix
PLATFORM=solaris

MOTIFHOME=/usr/dt/
OPENWINHOME=/usr/openwin/
GUILIBHOME=$(OPENWINHOME)lib/

DIRSEP=/

CLUSTERDIR=/opt/SUNWcluster


GMAKE=make -r
LMAKE=/usr/ccs/bin/make
FIND=/usr/local/bin/find # gnu find!
PS=ps -feda

ARCHIVE=@`if echo ${LIB} | grep lib > /dev/null 2>&1;then $(ARCREATE) $(LIB) $? $(RANLIB); else echo ""; fi`

JARCHIVE=@`if echo ${JLIB} | egrep '\.jar' > /dev/null 2>&1;then $(JARCREATE) $(JLIB) $? ; else echo ""; fi`

GROUP=/etc/group

LINK=$(PURECMDS) $(LD) $(LDFLAGS) -dy $(COMPOBJS)

LLIBTHREAD=

MOTIFLIBS=-L$(MOTIFHOME)lib -lXm -lgen -L$(GUILIBHOME) -R$(GUILIBHOME)\
	-lXt -lX11 -lw -lm
XLIBS=-L$(GUILIBHOME) -R$(GUILIBHOME) $(GUILIBHHOME)libXaw.so.4 -lXt -lXmu\
	-lXext -lX11 -lm

EXOSFLAGS=-L$(CLUSTERDIR)/lib -R$(CLUSTERDIR)/lib

CCVER=SC4.2
COMPOBJ=$(ORACLE_HOME)/lib/$(CCVER)
COMPOBJS=$(COMPOBJ)/crti.o $(COMPOBJ)/crt1.o $(COMPOBJ)/crtn.o

SHAREDLIBPATH = -R$(ORACLE_HOME)/lib
EXSYSLIBS= $(SHAREDLIBPATH) $(LLAIO) $(THREADLIBS) $(LLIBPOSIX4) $(LLIBKSTAT)

LLPPATH=$(LD_LIBRARYPATH):
LINKEXSYSLIBS= -R $(CLUSTERDIR)/lib:$(ORACLE_HOME)/lib \
	-Y P,$(LLPPATH)$(CLUSTERDIR)/lib:/usr/ccs/lib:/usr/lib \
	-Qy -lc -laio $(LLIBPOSIX4) $(LLIBKSTAT)

LINKLDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(LINKEXSYSLIBS) $(MATHLIB) $(USRLIBS)

COBEXSYSLIBS= $(LLAIO) $(THREADLIBS) $(LLIBPOSIX4) $(LLIBKSTAT)
COBLDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(COBEXSYSLIBS) $(MATHLIB) $(USRLIBS)

OPTIMIZE2=-xO2
OPTIMIZE4=-xO4
OPTIMIZE=$(OPTIMIZE2)

ROFLAGS=-c -xMerge
SPFLAGS=-DSLMXMX_ENABLE -DSLTS_ENABLE -D_SVID_GETTOD

AR=/usr/ccs/bin/ar
AS=/usr/ccs/bin/as
CPP=$(CC) -E $(ANSI)
CHMOD=/bin/chmod
CHGRP=/bin/chgrp
CHOWN=/bin/chown

KPIC_OPTION=-K PIC
ASPFLAGS=-P $(PFLAGS)
NOKPIC_ASFLAGS=-P
ASFLAGS=$(NOKPIC_ASFLAGS) $(KPIC_OPTION)
ASRO=$(AS) $(ASROFLAGS) $(MAKERO) $<
ASROFLAGS=$(ASFLAGS)
CXC=-Xc
CXA=-Xa
ANSI=$(CXC)


MR=-mr
NOKPIC_CCFLAGS= -Xa $(PROFILE) -xstrconst -xF $(XS) $(MR) \
        -xarch=v8 -xcache=16/32/1:1024/64/1 -xchip=ultra -D_REENTRANT
CCFLAGS= $(NOKPIC_CCFLAGS) $(KPIC_OPTION)
FASTCCFLAGS= $(NOKPIC_CCFLAGS)

SHARED_LDFLAG=-G -L$(ORACLE_HOME)/lib -R$(ORACLE_HOME)/lib -o
SHARED_CFLAG=

# Exiting /vobs/oracle/buildtools/mkfile/platform.mk
# Entering /vobs/oracle/buildtools/mkfile/rules.mk
 
# Exiting /vobs/oracle/buildtools/mkfile/rules.mk
# Exiting /vobs/oracle/buildtools/mkfile/prefix.mk
# Entering /vobs/oracle/network/exports.mk
# Entering /vobs/oracle/network/s_exports.mk


NAETAB64	= $(LIBHOME)naeet.$(OBJ_EXT) $(LIBHOME)naect.$(OBJ_EXT)
NAEDHS64	= $(LIBHOME)naedhs.$(OBJ_EXT)
NAUTAB64	= $(LIBHOME)nautab.$(OBJ_EXT)


# Exiting /vobs/oracle/network/s_exports.mk

# Entering /vobs/oracle/network/libnames.mk


VER         =8
BASENAME    =n
NETWORKHOME = $(ORACLE_HOME)/network/
NETWORKLIB  = $(NETWORKHOME)lib/
NETWORKJLIB  = $(NETWORKHOME)jlib/

COMMONNAME=${BASENAME}${VER}
NLNAME=${BASENAME}l${VER}
TCPNAME=${BASENAME}tcp${VER}
DECNETNAME=${BASENAME}dec${VER}
LU62NAME=${BASENAME}lu62${VER}
MBNAME=${BASENAME}mb${VER}
DCENAME=${BASENAME}dce${VER}
BEQNAME=${BASENAME}beq${VER}
IPCNAME=${BASENAME}ipc${VER}
SPXNAME=${BASENAME}spx${VER}
TLINAME=${BASENAME}tli${VER}
TLITNAME=${BASENAME}tlit${VER}
TLISNAME=${BASENAME}tlis${VER}
TLIDNAME=${BASENAME}tlid${VER}
USNAME=${BASENAME}us${VER}
SHMNAME=${BASENAME}shm${VER}
TCPSNAME=${BASENAME}tcps${VER}
ENTRUSTNAME=${BASENAME}ent${VER}
NSGRNAME=${BASENAME}sgr${VER}
LSNRNAME=${BASENAME}lsnr${VER}
LSNRCNAME=${BASENAME}lsnrc${VER}
K5NAME=${BASENAME}k5${VER}
RADNAME=${BASENAME}rad${VER}
IDXNAME=${BASENAME}idx${VER}
GSSNAME=${BASENAME}gss${VER}
SIDNAME=${BASENAME}sid${VER}
OSSNAME=${BASENAME}oss${VER}
NTSNAME=${BASENAME}nts${VER}
NSSNAME=${BASENAME}nss${VER}
ONNAME=${BASENAME}on${VER}
ONDNAME=${BASENAME}ond${VER}
ONCNAME=${BASENAME}onc${VER}
ONCJNAME=${BASENAME}oncj${VER}
RONAME=${BASENAME}ro${VER}
ROCNAME=${BASENAME}roc${VER}
ROXNAME=${BASENAME}rox${VER}
ROTNAME=${BASENAME}rot${VER}
CMNAME=${BASENAME}cm${VER}
NHOSTNAME=${BASENAME}host${VER}
TNSNAME=${BASENAME}tns${VER}
ORACLENAME=${BASENAME}oname${VER}
NISNAME=${BASENAME}nis${VER}
CDSNAME=${BASENAME}cds${VER}
NDSNAME=${BASENAME}nds${VER}
LDAPNAME=${BASENAME}ldap${VER}
LDAPJNAME=${BASENAME}ldapj${VER}
SSLBNAME=${BASENAME}sslb${VER}
NUJNINAME=${BASENAME}jni${VER}
NZJSNAME=${BASENAME}zjs${VER}
JSSLNAME=${BASENAME}jssl${VER}

NMPNAME=${BASENAME}nmp${VER}

TANAME=${BASENAME}ta${VER}
TALNAME=${BASENAME}tal${VER}
TNSAPINAME=tnsapi${VER}

LDAPCLNTNAME=ldapclnt${VER}

NZRNAME=nzr



SNLPTDUM         =  $(NETWORKLIB)snlptdum.$(OBJ_EXT) 
OSNTABST         = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT            = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

LIBNETWORK	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBTHINNCR       =  $(NETWORKLIB)$(LIB_PREFIX)$(ROTNAME).$(LIB_EXT)

LIBONCJ          =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCJNAME).$(SO_EXT)
LIBNUJNI         =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(SO_EXT)
LIBJSSL          =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(SO_EXT)

LIBNCR           =  $(NETWORKLIB)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LIBNFP           =  $(NETWORKLIB)$(LIB_PREFIX)$(CMNAME).$(LIB_EXT)
LIBNI            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCC          =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCNAME).$(LIB_EXT)
LIBNND           =  $(NETWORKLIB)$(LIB_PREFIX)$(ONDNAME).$(LIB_EXT)
LIBNNO           =  $(NETWORKLIB)$(LIB_PREFIX)$(ONNAME).$(LIB_EXT)
LIBNSGR          =  $(NETWORKLIB)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LIBNSGL          =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRNAME).$(LIB_EXT)
LIBNSGLC         =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRCNAME).$(LIB_EXT)

LLIBNCR           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)
LLIBNFP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CMNAME)$(ILIB_SUFFIX)
LLIBNI            =  $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)
LLIBNNCC          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONCNAME)$(ILIB_SUFFIX)
LLIBNND           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONDNAME)$(ILIB_SUFFIX)
LLIBNNO           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONNAME)$(ILIB_SUFFIX)
LLIBNSGR          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)
LLIBNSGL          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRNAME)$(ILIB_SUFFIX)
LLIBNSGLC         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRCNAME)$(ILIB_SUFFIX)

LIBNAUK5         =  $(NETWORKLIB)$(LIB_PREFIX)$(K5NAME).$(LIB_EXT)
LIBNAUS          =  $(NETWORKLIB)$(LIB_PREFIX)$(SIDNAME).$(LIB_EXT)
LIBNAUR          =  $(NETWORKLIB)$(LIB_PREFIX)$(RADNAME).$(LIB_EXT)
LIBNAUI          =  $(NETWORKLIB)$(LIB_PREFIX)$(IDXNAME).$(LIB_EXT)
LIBNAUG          =  $(NETWORKLIB)$(LIB_PREFIX)$(GSSNAME).$(LIB_EXT)
LIBNAUZ          =  $(NETWORKLIB)$(LIB_PREFIX)$(OSSNAME).$(LIB_EXT)
LIBNAUNTS        =  $(NETWORKLIB)$(LIB_PREFIX)$(NTSNAME).$(LIB_EXT)

LLIBNAUK5         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(K5NAME)$(ILIB_SUFFIX)
LLIBNAUS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(SIDNAME)$(ILIB_SUFFIX)
LLIBNAUR          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(RADNAME)$(ILIB_SUFFIX)
LLIBNAUI          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(IDXNAME)$(ILIB_SUFFIX)
LLIBNAUG          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(GSSNAME)$(ILIB_SUFFIX)
LLIBNAUZ          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(OSSNAME)$(ILIB_SUFFIX)
LLIBNAUNTS        =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NTSNAME)$(ILIB_SUFFIX)



LIBNTT           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LIBNTZ           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME).$(LIB_EXT)
LIBNTZSTUB       =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME)_std.$(LIB_EXT)
LIBNTZE          =  $(NETWORKLIB)$(LIB_PREFIX)$(ENTRUSTNAME).$(LIB_EXT)
LIBNTS           =  $(NETWORKLIB)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LIBNTD           =  $(NETWORKLIB)$(LIB_PREFIX)$(DECNETNAME).$(LIB_EXT)
LIBNTOD          =  $(NETWORKLIB)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LIBCDS           =  $(NETWORKLIB)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LIBNTLU62        =  $(NETWORKLIB)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LIBNTTLI	 =  $(NETWORKLIB)$(LIB_PREFIX)$(TLINAME).$(LIB_EXT)
LIBNTUS          =  $(NETWORKLIB)$(LIB_PREFIX)$(USNAME).$(LIB_EXT)
LIBNTSHM         =  $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME).$(LIB_EXT)
LIBNTP           =  $(NETWORKLIB)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNTNP          =  $(NETWORKLIB)$(LIB_PREFIX)$(NMPNAME).$(LIB_EXT)

LLIBNTT           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)
LLIBNTZ           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPSNAME)$(ILIB_SUFFIX)
LLIBNTZE          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ENTRUSTNAME)$(ILIB_SUFFIX)
LLIBNTS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)
LLIBNTD           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DECNETNAME)$(ILIB_SUFFIX)
LLIBNTOD          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)
LLIBCDS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)
LLIBNTLU62        =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)
LLIBNTTLI	 =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TLINAME)$(ILIB_SUFFIX)
LLIBNTUS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(USNAME)$(ILIB_SUFFIX)
LLIBNTSHM        = $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME)$(ILIB_SUFFIX)
LLIBNTP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(BEQNAME)$(ILIB_SUFFIX)
LLIBNTNP          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NMPNAME)$(ILIB_SUFFIX)

LIBNL1           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LIBNL2           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LIBNL            =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LLIBNL           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NLNAME)$(ILIB_SUFFIX)


LIBNUAPI         =  $(NETWORKLIB)$(LIB_PREFIX)$(TANAME).$(LIB_EXT)
LIBNULOCAL       =  $(NETWORKLIB)$(LIB_PREFIX)$(TALNAME).$(LIB_EXT)

LLIBNUAPI         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL       =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)


LLIBTNSAPI       = $(LDLIBFLAG)$(ILIB_PREFIX)$(TNSAPINAME)$(ILIB_SUFFIX)
LLIBNUAPI	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)
LLIBSSL          = #$(LDLIBFLAG)$(ILIB_PREFIX)sslref-bsafe$(ILIB_SUFFIX)
LLIBSSLB         = $(LDLIBFLAG)$(ILIB_PREFIX)$(SSLBNAME)$(ILIB_SUFFIX)
LLIBNZJS 	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(NZJSNAME)$(ILIB_SUFFIX)


LIBNA            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAE           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAU           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNLNV          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMP           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCI          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNFG          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNG           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNPL           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNR            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNS            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNTR           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNZ            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMS0          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBSSLREF 	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)


LIBTNSAPI        =  $(NETWORKLIB)$(LIB_PREFIX)$(TNSAPINAME).$(LIB_EXT)

LIBSSLB          =  $(NETWORKLIB)$(LIB_PREFIX)$(SSLBNAME).$(LIB_EXT)

LIBNZJS          =  $(NETWORKLIB)$(LIB_PREFIX)$(NZJSNAME).$(LIB_EXT)

LDAPSYSLIBD = $(LIBHOME)$(LIB_PREFIX)$(LDAPCLNTNAME).$(LIB_EXT)
LDAPSYSLIBS = $(LDLIBFLAG)$(ILIB_PREFIX)$(LDAPCLNTNAME)$(ILIB_SUFFIX)

JREGRESSNAME=regress$(JDKVER)
JOWMNAME=owm-2_1$(JDKVER)
JOWMHELPNAME=owm-help-2_1
JLIOHELPNAME=lio-help-1_1
JDIROSMNAME=dirosm-1.0$(JDKVER)
JNETTHINNAME=netthin$(JDKVER)
JNETRADIUSNAME=netradius$(JDKVER)
JNETCFGNAME=netcfg$(JDKVER)
JNETCANAME=netca$(JDKVER)
JNETCAMESGNAME=netcam$(JDKVER)
JNETASSTNAME=netasst$(JDKVER)
JNETASSTMESGNAME=netasstm$(JDKVER)
JTNSADDRNAME=tnsaddr$(JDKVER)
JTNSADDRESSNAME=tnsaddress$(JDKVER)
JNETENTRUSTNAME=netentrust$(JDKVER)

JLDAPNAME=ldap
JSYSMANMAFNAME=sysmanmaf
JOEMDBAPPNAME=OEM_DBAPP
JJNDINAME=jndi

JREGRESSJAR=$(NETWORKJLIB)$(JREGRESSNAME).$(JAR_EXT)
JOWMJAR=$(NETWORKJLIB)$(JOWMNAME).$(JAR_EXT)
JDIROSMJAR=$(NETWORKJLIB)$(JDIROSMNAME).$(JAR_EXT)
JNETTHINJAR=$(NETWORKJLIB)$(JNETTHINNAME).$(JAR_EXT)
JNETRADIUSJAR=$(NETWORKJLIB)$(JNETRADIUSNAME).$(JAR_EXT)
JNETCFGJAR=$(NETWORKJLIB)$(JNETCFGNAME).$(JAR_EXT)
JNETCAJAR=$(NETWORKJLIB)$(JNETCANAME).$(JAR_EXT)
JNETCAMESGJAR=$(NETWORKJLIB)$(JNETCAMESGNAME).$(JAR_EXT)
JNETASSTJAR=$(NETWORKJLIB)$(JNETASSTNAME).$(JAR_EXT)
JNETASSTMESGJAR=$(NETWORKJLIB)$(JNETASSTMESGNAME).$(JAR_EXT)
JTNSADDRESSJAR=$(NETWORKJLIB)$(JTNSADDRESSNAME).$(JAR_EXT)
JTNSADDRJAR=$(NETWORKJLIB)$(JTNSADDRNAME).$(JAR_EXT)
JLDAPJAR=$(NETWORKJLIB)$(JLDAPNAME).$(JAR_EXT)
JSYSMANMAFJAR=$(NETWORKJLIB)$(JSYSMANMAFNAME).$(JAR_EXT)
JOEMDBAPPJAR=$(NETWORKJLIB)$(JOEMDBAPPNAME).$(JAR_EXT)
JJNDIJAR=$(NETWORKJLIB)$(JJNDINAME).$(JAR_EXT)
JNETENTRUSTJAR=$(NETWORKJLIB)$(JNETENTRUSTNAME).$(JAR_EXT)


# Exiting /vobs/oracle/network/libnames.mk

# Entering /vobs/oracle/buildtools/mkfile/prefix.mk

# Entering /vobs/oracle/buildtools/mkfile/defs.mk

SHELL=/bin/sh

AS_EXT=s
LIB_EXT=a
OBJ_EXT=o
PLB_EXT=plb
SO_EXT=so
LOCK_EXT=lk
SQL_EXT=sql
SYM_EXT=sym
JAVA_EXT=java
CLASS_EXT=class
JAR_EXT=jar
ZIP_EXT=zip

LIB_PREFIX=lib
LDLIBFLAG=-l
LDPATHFLAG=-L
PATHSEP= :

AR=ar
AS=as
AWK=awk
CAT=cat
CC=cc
CD=cd
CHMOD=chmod
CP=cp
CPP=cpp
DATE=date
ECHO=echo
ECHON=echo -n
EXEC=exec
FIND=find
FOLLOW=-follow
NOLEAF=-noleaf
GREP=grep
KILL=kill
SLEEP=sleep
LD=ld
LMAKE=make
LN=ln
LNS=ln -s
MKDIR=mkdir
MKDIRP=mkdir -p
MV=mv
NM=nm
PERL=perl
RM=rm
RMF=rm -f
RMRF=rm -rf
SED=sed
SORT=sort
TOUCH=touch
XARGS=xargs
LS=ls

NULL_DEVICE=/dev/null

BINHOME=$(ORACLE_HOME)/bin/
LIBHOME=$(ORACLE_HOME)/lib/

PRODHOME=$(ORACLE_HOME)/$(PRODUCT)/
PRODLIBHOME=$(PRODHOME)lib/
PRODSOHOME=$(PRODLIBHOME)

ECHODO=$(BINHOME)echodo
GENSYSLIB=$(BINHOME)gensyslib
GENCLNTSH=$(BINHOME)genclntsh
GENAGTSH=$(BINHOME)genagtsh
GENNAFLG=$(BINHOME)gennaflg
GENAUTAB=$(BINHOME)genautab

ARCHIVE_OBJ=$(AR) r $@ $*.$(OBJ_EXT)
ARCREATE=$(AR) cr$(ARLOCAL)
ARDELETE=$(AR) d$(ARLOCAL)
AREXTRACT=$(AR) x 
ARPRINT=$(AR) t
ARREPLACE=$(AR) r 
DOAR=$(ARCREATE) $@ $? $(RANLIB)

JARCHIVE_OBJ=$(JAR) cv0f $@ $(JPKG_FILES) $(EXTRA_CLASS_FILES)
JARCREATE=$(JAR) cv0f
JARDELETE=$(ECHO) "no such thing"
JAREXTRACT=$(JAR) xf
JARPRINT=$(JAR) tvf
JARREPLACE=$(JAR) uf

MAKE=$(LMAKE)
QUIET=>/dev/null 2>&1
QUIETE=2>/dev/null
SILENT=@
CTSMAKEFLAGS=$(SILENT:@=--no-print-directory -s)

CFLAGS=$(GFLAG) $(OPTIMIZE) $(CDEBUG) $(CCFLAGS) $(QACCFLAGS) $(PFLAGS)\
	$(SHARED_CFLAG) $(USRFLAGS)
PFLAGS=$(INCLUDE) $(SPFLAGS) $(LPFLAGS)

LDCCOM=$(PURECMDS) $(CC) $(GFLAG) $(CCFLAGS) $(EXOSFLAGS) $(LDFLAGS)
PURECMDS=$(PURELINK) $(PURIFY) $(PURECOV) $(QUANTIFY)
LINK=$(LDCCOM)
LDFLAGS=-o $@ $(LDPATHFLAG)$(PRODLIBHOME) $(LDPATHFLAG)$(LIBHOME)
LDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(EXSYSLIBS) $(MATHLIB) $(USRLIBS)
MATHLIB=-lm
LINKLDLIBS=$(LDLIBS)
COBLDLIBS=$(LDLIBS)

SYSLIBLIST=$(LIBHOME)sysliblist
SYSLIBS=`$(CAT) $(SYSLIBLIST)`

NAETTOBJS=$(NAUTAB) $(NAETAB) $(NAEDHS)
TTLIBD=$(NETLIBD) $(LIBRDBMS_CLT) $(LIBMM) $(CORELIBD) $(LIBEPC) $(LIBCLNTSH)
ORACLETTLIBS=$(NTZEOBJ) $(NETLIBS) $(LLIBRDBMS_CLT) $(LLIBWTC) $(LLIBMM) $(CORELIBS)\
       $(NETLIBS) $(LLIBRDBMS_CLT) $(LIBPLS_CLT) $(LLIBEPC) $(CORELIBS) \
       $(LLIBRDBMS_CLT) $(CORELIBS)
STATICTTLIBS=$(ORACLETTLIBS) $(LDLIBS)
TTLIBS=$(LLIBCLNTSH) $(STATICTTLIBS)
DEVTTLIBS=$(TTLIBS)
LINKTTLIBS=$(LLIBCLNTSH) $(ORACLETTLIBS) $(LINKLDLIBS)
COBTTLIBS=$(ORACLETTLIBS) $(COBLDLIBS)

ORACLESTLIBS=$(SGL_ON) $(CONFIG) $(LLIBSERVER) $(LLIBSKGXP) $(LLIBPLSF) \
       $(LLIBSLAX) \
       $(LIBGENERIC) $(LLIBCLIENT) $(LLIBWTC) $(LLIBMM) $(LLIBKNLOPT) $(LLIBPLSB)\
       $(LLIBSERVER) $(LLIBEXTP) $(NAUTAB) $(NAETAB) $(NAEDHS) $(NTZEOBJ) \
       $(NETLIBS) $(LLIBCLIENT) \
       $(LLIBPLSF) $(LLIBICX) $(LLIBOWSUTL) \
       $(LLIBJAVAVMORJOX) \
       $(NETLIBS) $(LLIBEPC) $(SDOLIBS) $(LLIBCORE) $(LLIBVSN) $(LLIBCOMMON)\
       $(LIBGENERIC) $(LLIBKNLOPT) $(NMLIBS) $(CARTLIBS) $(CORELIBS)
STLIBS=$(ORACLESTLIBS) $(LDLIBS)
LINKSTLIBS=$(ORACLESTLIBS) $(LINKLDLIBS)

# Exiting /vobs/oracle/buildtools/mkfile/defs.mk
# Entering /vobs/oracle/buildtools/mkfile/platform.mk

FAMILY=unix
PLATFORM=solaris

MOTIFHOME=/usr/dt/
OPENWINHOME=/usr/openwin/
GUILIBHOME=$(OPENWINHOME)lib/

DIRSEP=/

CLUSTERDIR=/opt/SUNWcluster


GMAKE=make -r
LMAKE=/usr/ccs/bin/make
FIND=/usr/local/bin/find # gnu find!
PS=ps -feda

ARCHIVE=@`if echo ${LIB} | grep lib > /dev/null 2>&1;then $(ARCREATE) $(LIB) $? $(RANLIB); else echo ""; fi`

JARCHIVE=@`if echo ${JLIB} | egrep '\.jar' > /dev/null 2>&1;then $(JARCREATE) $(JLIB) $? ; else echo ""; fi`

GROUP=/etc/group

LINK=$(PURECMDS) $(LD) $(LDFLAGS) -dy $(COMPOBJS)

LLIBTHREAD=

MOTIFLIBS=-L$(MOTIFHOME)lib -lXm -lgen -L$(GUILIBHOME) -R$(GUILIBHOME)\
	-lXt -lX11 -lw -lm
XLIBS=-L$(GUILIBHOME) -R$(GUILIBHOME) $(GUILIBHHOME)libXaw.so.4 -lXt -lXmu\
	-lXext -lX11 -lm

EXOSFLAGS=-L$(CLUSTERDIR)/lib -R$(CLUSTERDIR)/lib

CCVER=SC4.2
COMPOBJ=$(ORACLE_HOME)/lib/$(CCVER)
COMPOBJS=$(COMPOBJ)/crti.o $(COMPOBJ)/crt1.o $(COMPOBJ)/crtn.o

SHAREDLIBPATH = -R$(ORACLE_HOME)/lib
EXSYSLIBS= $(SHAREDLIBPATH) $(LLAIO) $(THREADLIBS) $(LLIBPOSIX4) $(LLIBKSTAT)

LLPPATH=$(LD_LIBRARYPATH):
LINKEXSYSLIBS= -R $(CLUSTERDIR)/lib:$(ORACLE_HOME)/lib \
	-Y P,$(LLPPATH)$(CLUSTERDIR)/lib:/usr/ccs/lib:/usr/lib \
	-Qy -lc -laio $(LLIBPOSIX4) $(LLIBKSTAT)

LINKLDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(LINKEXSYSLIBS) $(MATHLIB) $(USRLIBS)

COBEXSYSLIBS= $(LLAIO) $(THREADLIBS) $(LLIBPOSIX4) $(LLIBKSTAT)
COBLDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(COBEXSYSLIBS) $(MATHLIB) $(USRLIBS)

OPTIMIZE2=-xO2
OPTIMIZE4=-xO4
OPTIMIZE=$(OPTIMIZE2)

ROFLAGS=-c -xMerge
SPFLAGS=-DSLMXMX_ENABLE -DSLTS_ENABLE -D_SVID_GETTOD

AR=/usr/ccs/bin/ar
AS=/usr/ccs/bin/as
CPP=$(CC) -E $(ANSI)
CHMOD=/bin/chmod
CHGRP=/bin/chgrp
CHOWN=/bin/chown

KPIC_OPTION=-K PIC
ASPFLAGS=-P $(PFLAGS)
NOKPIC_ASFLAGS=-P
ASFLAGS=$(NOKPIC_ASFLAGS) $(KPIC_OPTION)
ASRO=$(AS) $(ASROFLAGS) $(MAKERO) $<
ASROFLAGS=$(ASFLAGS)
CXC=-Xc
CXA=-Xa
ANSI=$(CXC)


MR=-mr
NOKPIC_CCFLAGS= -Xa $(PROFILE) -xstrconst -xF $(XS) $(MR) \
        -xarch=v8 -xcache=16/32/1:1024/64/1 -xchip=ultra -D_REENTRANT
CCFLAGS= $(NOKPIC_CCFLAGS) $(KPIC_OPTION)
FASTCCFLAGS= $(NOKPIC_CCFLAGS)

SHARED_LDFLAG=-G -L$(ORACLE_HOME)/lib -R$(ORACLE_HOME)/lib -o
SHARED_CFLAG=

# Exiting /vobs/oracle/buildtools/mkfile/platform.mk
# Entering /vobs/oracle/buildtools/mkfile/rules.mk
 
# Exiting /vobs/oracle/buildtools/mkfile/rules.mk
# Exiting /vobs/oracle/buildtools/mkfile/prefix.mk

# Entering /vobs/oracle/network/adapters.mk


# Entering /vobs/oracle/network/libnames.mk


VER         =8
BASENAME    =n
NETWORKHOME = $(ORACLE_HOME)/network/
NETWORKLIB  = $(NETWORKHOME)lib/
NETWORKJLIB  = $(NETWORKHOME)jlib/

COMMONNAME=${BASENAME}${VER}
NLNAME=${BASENAME}l${VER}
TCPNAME=${BASENAME}tcp${VER}
DECNETNAME=${BASENAME}dec${VER}
LU62NAME=${BASENAME}lu62${VER}
MBNAME=${BASENAME}mb${VER}
DCENAME=${BASENAME}dce${VER}
BEQNAME=${BASENAME}beq${VER}
IPCNAME=${BASENAME}ipc${VER}
SPXNAME=${BASENAME}spx${VER}
TLINAME=${BASENAME}tli${VER}
TLITNAME=${BASENAME}tlit${VER}
TLISNAME=${BASENAME}tlis${VER}
TLIDNAME=${BASENAME}tlid${VER}
USNAME=${BASENAME}us${VER}
SHMNAME=${BASENAME}shm${VER}
TCPSNAME=${BASENAME}tcps${VER}
ENTRUSTNAME=${BASENAME}ent${VER}
NSGRNAME=${BASENAME}sgr${VER}
LSNRNAME=${BASENAME}lsnr${VER}
LSNRCNAME=${BASENAME}lsnrc${VER}
K5NAME=${BASENAME}k5${VER}
RADNAME=${BASENAME}rad${VER}
IDXNAME=${BASENAME}idx${VER}
GSSNAME=${BASENAME}gss${VER}
SIDNAME=${BASENAME}sid${VER}
OSSNAME=${BASENAME}oss${VER}
NTSNAME=${BASENAME}nts${VER}
NSSNAME=${BASENAME}nss${VER}
ONNAME=${BASENAME}on${VER}
ONDNAME=${BASENAME}ond${VER}
ONCNAME=${BASENAME}onc${VER}
ONCJNAME=${BASENAME}oncj${VER}
RONAME=${BASENAME}ro${VER}
ROCNAME=${BASENAME}roc${VER}
ROXNAME=${BASENAME}rox${VER}
ROTNAME=${BASENAME}rot${VER}
CMNAME=${BASENAME}cm${VER}
NHOSTNAME=${BASENAME}host${VER}
TNSNAME=${BASENAME}tns${VER}
ORACLENAME=${BASENAME}oname${VER}
NISNAME=${BASENAME}nis${VER}
CDSNAME=${BASENAME}cds${VER}
NDSNAME=${BASENAME}nds${VER}
LDAPNAME=${BASENAME}ldap${VER}
LDAPJNAME=${BASENAME}ldapj${VER}
SSLBNAME=${BASENAME}sslb${VER}
NUJNINAME=${BASENAME}jni${VER}
NZJSNAME=${BASENAME}zjs${VER}
JSSLNAME=${BASENAME}jssl${VER}

NMPNAME=${BASENAME}nmp${VER}

TANAME=${BASENAME}ta${VER}
TALNAME=${BASENAME}tal${VER}
TNSAPINAME=tnsapi${VER}

LDAPCLNTNAME=ldapclnt${VER}

NZRNAME=nzr



SNLPTDUM         =  $(NETWORKLIB)snlptdum.$(OBJ_EXT) 
OSNTABST         = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT            = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

LIBNETWORK	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBTHINNCR       =  $(NETWORKLIB)$(LIB_PREFIX)$(ROTNAME).$(LIB_EXT)

LIBONCJ          =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCJNAME).$(SO_EXT)
LIBNUJNI         =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(SO_EXT)
LIBJSSL          =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(SO_EXT)

LIBNCR           =  $(NETWORKLIB)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LIBNFP           =  $(NETWORKLIB)$(LIB_PREFIX)$(CMNAME).$(LIB_EXT)
LIBNI            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCC          =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCNAME).$(LIB_EXT)
LIBNND           =  $(NETWORKLIB)$(LIB_PREFIX)$(ONDNAME).$(LIB_EXT)
LIBNNO           =  $(NETWORKLIB)$(LIB_PREFIX)$(ONNAME).$(LIB_EXT)
LIBNSGR          =  $(NETWORKLIB)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LIBNSGL          =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRNAME).$(LIB_EXT)
LIBNSGLC         =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRCNAME).$(LIB_EXT)

LLIBNCR           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)
LLIBNFP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CMNAME)$(ILIB_SUFFIX)
LLIBNI            =  $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)
LLIBNNCC          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONCNAME)$(ILIB_SUFFIX)
LLIBNND           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONDNAME)$(ILIB_SUFFIX)
LLIBNNO           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONNAME)$(ILIB_SUFFIX)
LLIBNSGR          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)
LLIBNSGL          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRNAME)$(ILIB_SUFFIX)
LLIBNSGLC         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRCNAME)$(ILIB_SUFFIX)

LIBNAUK5         =  $(NETWORKLIB)$(LIB_PREFIX)$(K5NAME).$(LIB_EXT)
LIBNAUS          =  $(NETWORKLIB)$(LIB_PREFIX)$(SIDNAME).$(LIB_EXT)
LIBNAUR          =  $(NETWORKLIB)$(LIB_PREFIX)$(RADNAME).$(LIB_EXT)
LIBNAUI          =  $(NETWORKLIB)$(LIB_PREFIX)$(IDXNAME).$(LIB_EXT)
LIBNAUG          =  $(NETWORKLIB)$(LIB_PREFIX)$(GSSNAME).$(LIB_EXT)
LIBNAUZ          =  $(NETWORKLIB)$(LIB_PREFIX)$(OSSNAME).$(LIB_EXT)
LIBNAUNTS        =  $(NETWORKLIB)$(LIB_PREFIX)$(NTSNAME).$(LIB_EXT)

LLIBNAUK5         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(K5NAME)$(ILIB_SUFFIX)
LLIBNAUS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(SIDNAME)$(ILIB_SUFFIX)
LLIBNAUR          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(RADNAME)$(ILIB_SUFFIX)
LLIBNAUI          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(IDXNAME)$(ILIB_SUFFIX)
LLIBNAUG          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(GSSNAME)$(ILIB_SUFFIX)
LLIBNAUZ          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(OSSNAME)$(ILIB_SUFFIX)
LLIBNAUNTS        =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NTSNAME)$(ILIB_SUFFIX)



LIBNTT           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LIBNTZ           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME).$(LIB_EXT)
LIBNTZSTUB       =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME)_std.$(LIB_EXT)
LIBNTZE          =  $(NETWORKLIB)$(LIB_PREFIX)$(ENTRUSTNAME).$(LIB_EXT)
LIBNTS           =  $(NETWORKLIB)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LIBNTD           =  $(NETWORKLIB)$(LIB_PREFIX)$(DECNETNAME).$(LIB_EXT)
LIBNTOD          =  $(NETWORKLIB)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LIBCDS           =  $(NETWORKLIB)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LIBNTLU62        =  $(NETWORKLIB)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LIBNTTLI	 =  $(NETWORKLIB)$(LIB_PREFIX)$(TLINAME).$(LIB_EXT)
LIBNTUS          =  $(NETWORKLIB)$(LIB_PREFIX)$(USNAME).$(LIB_EXT)
LIBNTSHM         =  $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME).$(LIB_EXT)
LIBNTP           =  $(NETWORKLIB)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNTNP          =  $(NETWORKLIB)$(LIB_PREFIX)$(NMPNAME).$(LIB_EXT)

LLIBNTT           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)
LLIBNTZ           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPSNAME)$(ILIB_SUFFIX)
LLIBNTZE          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ENTRUSTNAME)$(ILIB_SUFFIX)
LLIBNTS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)
LLIBNTD           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DECNETNAME)$(ILIB_SUFFIX)
LLIBNTOD          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)
LLIBCDS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)
LLIBNTLU62        =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)
LLIBNTTLI	 =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TLINAME)$(ILIB_SUFFIX)
LLIBNTUS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(USNAME)$(ILIB_SUFFIX)
LLIBNTSHM        = $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME)$(ILIB_SUFFIX)
LLIBNTP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(BEQNAME)$(ILIB_SUFFIX)
LLIBNTNP          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NMPNAME)$(ILIB_SUFFIX)

LIBNL1           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LIBNL2           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LIBNL            =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LLIBNL           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NLNAME)$(ILIB_SUFFIX)


LIBNUAPI         =  $(NETWORKLIB)$(LIB_PREFIX)$(TANAME).$(LIB_EXT)
LIBNULOCAL       =  $(NETWORKLIB)$(LIB_PREFIX)$(TALNAME).$(LIB_EXT)

LLIBNUAPI         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL       =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)


LLIBTNSAPI       = $(LDLIBFLAG)$(ILIB_PREFIX)$(TNSAPINAME)$(ILIB_SUFFIX)
LLIBNUAPI	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)
LLIBSSL          = #$(LDLIBFLAG)$(ILIB_PREFIX)sslref-bsafe$(ILIB_SUFFIX)
LLIBSSLB         = $(LDLIBFLAG)$(ILIB_PREFIX)$(SSLBNAME)$(ILIB_SUFFIX)
LLIBNZJS 	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(NZJSNAME)$(ILIB_SUFFIX)


LIBNA            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAE           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAU           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNLNV          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMP           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCI          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNFG          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNG           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNPL           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNR            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNS            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNTR           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNZ            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMS0          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBSSLREF 	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)


LIBTNSAPI        =  $(NETWORKLIB)$(LIB_PREFIX)$(TNSAPINAME).$(LIB_EXT)

LIBSSLB          =  $(NETWORKLIB)$(LIB_PREFIX)$(SSLBNAME).$(LIB_EXT)

LIBNZJS          =  $(NETWORKLIB)$(LIB_PREFIX)$(NZJSNAME).$(LIB_EXT)

LDAPSYSLIBD = $(LIBHOME)$(LIB_PREFIX)$(LDAPCLNTNAME).$(LIB_EXT)
LDAPSYSLIBS = $(LDLIBFLAG)$(ILIB_PREFIX)$(LDAPCLNTNAME)$(ILIB_SUFFIX)

JREGRESSNAME=regress$(JDKVER)
JOWMNAME=owm-2_1$(JDKVER)
JOWMHELPNAME=owm-help-2_1
JLIOHELPNAME=lio-help-1_1
JDIROSMNAME=dirosm-1.0$(JDKVER)
JNETTHINNAME=netthin$(JDKVER)
JNETRADIUSNAME=netradius$(JDKVER)
JNETCFGNAME=netcfg$(JDKVER)
JNETCANAME=netca$(JDKVER)
JNETCAMESGNAME=netcam$(JDKVER)
JNETASSTNAME=netasst$(JDKVER)
JNETASSTMESGNAME=netasstm$(JDKVER)
JTNSADDRNAME=tnsaddr$(JDKVER)
JTNSADDRESSNAME=tnsaddress$(JDKVER)
JNETENTRUSTNAME=netentrust$(JDKVER)

JLDAPNAME=ldap
JSYSMANMAFNAME=sysmanmaf
JOEMDBAPPNAME=OEM_DBAPP
JJNDINAME=jndi

JREGRESSJAR=$(NETWORKJLIB)$(JREGRESSNAME).$(JAR_EXT)
JOWMJAR=$(NETWORKJLIB)$(JOWMNAME).$(JAR_EXT)
JDIROSMJAR=$(NETWORKJLIB)$(JDIROSMNAME).$(JAR_EXT)
JNETTHINJAR=$(NETWORKJLIB)$(JNETTHINNAME).$(JAR_EXT)
JNETRADIUSJAR=$(NETWORKJLIB)$(JNETRADIUSNAME).$(JAR_EXT)
JNETCFGJAR=$(NETWORKJLIB)$(JNETCFGNAME).$(JAR_EXT)
JNETCAJAR=$(NETWORKJLIB)$(JNETCANAME).$(JAR_EXT)
JNETCAMESGJAR=$(NETWORKJLIB)$(JNETCAMESGNAME).$(JAR_EXT)
JNETASSTJAR=$(NETWORKJLIB)$(JNETASSTNAME).$(JAR_EXT)
JNETASSTMESGJAR=$(NETWORKJLIB)$(JNETASSTMESGNAME).$(JAR_EXT)
JTNSADDRESSJAR=$(NETWORKJLIB)$(JTNSADDRESSNAME).$(JAR_EXT)
JTNSADDRJAR=$(NETWORKJLIB)$(JTNSADDRNAME).$(JAR_EXT)
JLDAPJAR=$(NETWORKJLIB)$(JLDAPNAME).$(JAR_EXT)
JSYSMANMAFJAR=$(NETWORKJLIB)$(JSYSMANMAFNAME).$(JAR_EXT)
JOEMDBAPPJAR=$(NETWORKJLIB)$(JOEMDBAPPNAME).$(JAR_EXT)
JJNDIJAR=$(NETWORKJLIB)$(JJNDINAME).$(JAR_EXT)
JNETENTRUSTJAR=$(NETWORKJLIB)$(JNETENTRUSTNAME).$(JAR_EXT)


# Exiting /vobs/oracle/network/libnames.mk

# Entering /vobs/oracle/network/s_adapters.mk

# Exiting /vobs/oracle/network/s_adapters.mk

# Exiting /vobs/oracle/network/adapters.mk


LIBNTTCP     = $(LIBHOME)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LLIBNTTCP    = $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)

LIBNTOD      = $(LIBHOME)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LLIBNTOD     = $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)

LIBCDS      = $(LIBHOME)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LLIBCDS     = $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)

LIBNTLU62    = $(LIBHOME)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LLIBNTLU62   = $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)

LIBNTS       = $(LIBHOME)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LLIBNTS      = $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)

LIBNETWORK   = $(LIBHOME)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LLIBNETWORK  = $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)

LIBNSGR      = $(LIBHOME)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LLIBNSGR     = $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)

LIBSQLNET  = $(LDFLAGSLIST) $(ANOLIBD) $(PROTOCOLLIBD) $(NATIVELIBD) $(NATIVESYSLIBD) $(LIBNSGR) $(LIBNZJS) $(LIBNETWORK) $(LIBNL)
LLIBSQLNET = $(LDFLAGSLIST) $(ANOLIBS) $(PROTOCOLLIBS) $(NATIVELIBS) $(NATIVESYSLIBS) $(LLIBNSGR) $(LLIBNZJS) $(LLIBNETWORK) $(LLIBNL)

LIBRPC       = $(LIBHOME)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LLIBRPC      = $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)

TNSLSNR	     = $(BINHOME)tnslsnr$(EXE_SUFFIX)
LSNRCTL	     = $(BINHOME)lsnrctl$(EXE_SUFFIX)
NAMES	     = $(BINHOME)names$(EXE_SUFFIX)
NAMESCTL     = $(BINHOME)namesctl$(EXE_SUFFIX)

NIGTAB       = $(LIBHOME)nigtab.$(OBJ_EXT)
NIGCON       = $(LIBHOME)nigcon.$(OBJ_EXT) 
NTCONTAB     = $(LIBHOME)ntcontab.$(OBJ_EXT)
MTS_NCR	     = $(LIBHOME)ncrstab.$(OBJ_EXT)

OSNTABST     = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT        = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

NAETAB       = $(LIBHOME)naeet.$(OBJ_EXT) $(LIBHOME)naect.$(OBJ_EXT)
NAEDHS	     = $(LIBHOME)naedhs.$(OBJ_EXT)
NAUTAB	     = $(LIBHOME)nautab.$(OBJ_EXT)

NETLIBS      = $(LLIBSQLNET) $(LLIBRPC) $(LLIBSQLNET)
NETLIBD      = $(LIBSQLNET) $(LIBRPC)

LDFLAGSFILE=$(LIBHOME)ldflags
LDFLAGSLIST=`$(CAT) $(LDFLAGSFILE)`

LIBNTP       = $(LIBHOME)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNL        = $(LIBHOME)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LIBSSLB      = $(LIBHOME)$(LIB_PREFIX)$(SSLBNAME).$(LIB_EXT)

NETWORKHOME  = $(ORACLE_HOME)/network/
NETWORKADMIN = $(NETWORKHOME)admin/
NETWORKINSTALL	= $(NETWORKHOME)install/
NETWORKDEMO     = $(NETWORKHOME)demo/

# Exiting /vobs/oracle/network/exports.mk
# Entering /vobs/oracle/oracore/exports.mk

COREHOME    = $(ORACLE_HOME)/oracore/
ORACOREHOME = $(COREHOME)



CORE_LIB_VER = 8
CORE_LIB_NAME = core
LIBCORE  = $(LIBHOME)$(LIB_PREFIX)$(CORE_LIB_NAME)$(CORE_LIB_VER).$(LIB_EXT)
LLIBCORE = $(LDLIBFLAG)$(CORE_LIB_NAME)$(CORE_LIB_VER)

LIBCORE_ARC_LIB=$(LIBHOME)$(LIB_PREFIX)$(CORE_LIB_NAME)$(CORE_LIB_VER).$(LIB_EXT)

LIBCORE_SHARE_LIB=$(LIBHOME)$(LIB_PREFIX)$(CORE_LIB_NAME)$(CORE_LIB_VER).$(SO_EXT)


SLTS_LIB_VER = 8
SLTS_LIB_NAME = slts
LIBSLTS  = $(LIBHOME)$(LIB_PREFIX)$(SLTS_LIB_NAME)$(SLTS_LIB_VER).$(LIB_EXT)
LLIBSLTS = $(LDLIBFLAG)$(SLTS_LIB_NAME)$(SLTS_LIB_VER)

LIBSLTS_ARC_LIB         = $(LIBHOME)$(LIB_PREFIX)$(SLTS_LIB_NAME)$(SLTS_LIB_VER).$(LIB_EXT)

LIBSLTS_SHARE_LIB       = $(LIBHOME)$(LIB_PREFIX)$(SLTS_LIB_NAME)$(SLTS_LIB_VER).$(SO_EXT)


SLF_LIB_VER = 8
SLF_LIB_NAME = slf
LIBSLF  = $(LIBHOME)$(LIB_PREFIX)$(SLF_LIB_NAME)$(SLF_LIB_VER).$(LIB_EXT)
LLIBSLF = $(LDLIBFLAG)$(SLF_LIB_NAME)$(SLF_LIB_VER)

LIBSLF_ARC_LIB         = $(LIBHOME)$(LIB_PREFIX)$(SLF_LIB_NAME)$(SLF_LIB_VER).$(LIB_EXT)

LIBSLF_SHARE_LIB       = $(LIBHOME)$(LIB_PREFIX)$(SLF_LIB_NAME)$(SLF_LIB_VER).$(SO_EXT)


XB8_LIB_VER = 8
XB8_LIB_NAME = xb8
LIBXB8  = $(LIBHOME)$(LIB_PREFIX)$(XB8_LIB_NAME)$(XB8_LIB_VER).$(LIB_EXT)
LLIBXB8 = $(LDLIBFLAG)$(XB8_LIB_NAME)$(XB8_LIB_VER)

LIBXB8_ARC_LIB         = $(LIBHOME)$(LIB_PREFIX)$(XB8_LIB_NAME)$(XB8_LIB_VER).$(LIB_EXT)

LIBXB8_SHARE_LIB       = $(LIBHOME)$(LIB_PREFIX)$(XB8_LIB_NAME)$(XB8_LIB_VER).$(SO_EXT)


LEH_LIB_VER = 8
LEH_LIB_NAME = leh
LIBLEH  = $(LIBHOME)$(LIB_PREFIX)$(LEH_LIB_NAME)$(LEH_LIB_VER).$(LIB_EXT)
LLIBLEH = $(LDLIBFLAG)$(LEH_LIB_NAME)$(LEH_LIB_VER)

LIBLEH_ARC_LIB         = $(LIBHOME)$(LIB_PREFIX)$(LEH_LIB_NAME)$(LEH_LIB_VER).$(LIB_EXT)

LIBLEH_SHARE_LIB       = $(LIBHOME)$(LIB_PREFIX)$(LEH_LIB_NAME)$(LEH_LIB_VER).$(SO_EXT)


S0MAIN   = $(LIBHOME)s0main.$(OBJ_EXT)
S1MAIN_C = $(COREHOME)src/corehl/lpm/sosd/main/s1main.c
SCOREPT  = $(LIBHOME)scorept.$(OBJ_EXT)
SSCOREED = $(LIBHOME)sscoreed.$(OBJ_EXT)



COREPUBLIC=$(COREHOME)include $(COREHOME)public/

ORACOREPUBH=$(I_SYM)$(COREHOME)include $(I_SYM)$(COREHOME)public $(I_SYM)$(COREHOME)port/include


CORELIBD = $(LIBNLSRTL) $(LIBCV6) $(LIBCORE) $(LIBNLSRTL) $(LIBCORE) \
             $(LIBNLSRTL) 
CORELIBS = $(LLIBNLSRTL) $(LLIBCV6) $(LLIBCORE) $(LLIBNLSRTL) $(LLIBCORE) \
             $(LLIBNLSRTL) 




# Entering /vobs/oracle/oracore/s_exports.mk
 
# Exiting /vobs/oracle/oracore/s_exports.mk
# Exiting /vobs/oracle/oracore/exports.mk
# Entering /vobs/oracle/nlsrtl/exports.mk

NLSRTLHOME= $(ORACLE_HOME)/nlsrtl/


ORA_NLS = $(ORACLE_HOME)/ocommon/nls/admin/data/
ORA_NLS33 = $(ORACLE_HOME)/ocommon/nls/admin/data/

LIBNLSRTLNAME = nls8
LIBNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)
LLIBNLSRTL= $(LDLIBFLAG)$(LIBNLSRTLNAME)$(LIB_SUFFIX)

NLSRTLPUBH = $(I_SYM)$(NLSRTLHOME)include

JNLSHOME = $(ORACLE_HOME)/nlsrtl3/java
JNLSCLASSES = $(ORACLE_HOME)/nlsrtl/lib/jnls.zip
JNLSCHARSET = $(ORACLE_HOME)/nlsrtl/lib/jnls_charset.zip

# Entering /vobs/oracle/nlsrtl/s_exports.mk


# Exiting /vobs/oracle/nlsrtl/s_exports.mk
# Exiting /vobs/oracle/nlsrtl/exports.mk
# Entering /vobs/oracle/rdbms/exports.mk


RDBMS_VERSION = 8
LIBSERVERNAME=server$(RDBMS_VERSION)
LIBSERVER=$(LIBHOME)$(LIB_PREFIX)$(LIBSERVERNAME).$(LIB_EXT)
LLIBSERVER=$(LDLIBFLAG)$(LIBSERVERNAME)$(LIB_SUFFIX)

LIBCLIENTNAME=client$(RDBMS_VERSION)
LIBCLIENT=$(LIBHOME)$(LIB_PREFIX)$(LIBCLIENTNAME).$(LIB_EXT)
LLIBCLIENT=$(LDLIBFLAG)$(LIBCLIENTNAME)

LIBGENERICNAME=generic$(RDBMS_VERSION)
LIBGENERIC=$(LIBHOME)$(LIB_PREFIX)$(LIBGENERICNAME).$(LIB_EXT)
LLIBGENERIC=$(LDLIBFLAG)$(LIBGENERICNAME)

LIBDSBTSHNAME=dsbtsh$(RDBMS_VERSION)
LIBDSBTSH=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDSBTSHNAME).$(SO_EXT)

LIBSKGXPNAME=skgxp$(RDBMS_VERSION)
LIBSKGXP=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXPNAME).$(SKGXP_EXT)
LLIBSKGXP=$(LDLIBFLAG)$(LIBSKGXPNAME)

LIBSKGXP_CLT=
LLIBSKGXP_CLT=

LIBCOMMONNAME=common$(RDBMS_VERSION)
LIBCOMMON=$(LIBHOME)$(LIB_PREFIX)$(LIBCOMMONNAME).$(LIB_EXT)
LLIBCOMMON=$(LDLIBFLAG)$(LIBCOMMONNAME)

LIBVSNNAME=vsn$(RDBMS_VERSION)
LIBVSN=$(LIBHOME)$(LIB_PREFIX)$(LIBVSNNAME).$(LIB_EXT)
LLIBVSN=$(LDLIBFLAG)$(LIBVSNNAME)

LIBAGENTNAME=agent$(RDBMS_VERSION)
LIBAGENT=$(LIBHOME)$(LIB_PREFIX)$(LIBAGENTNAME).$(LIB_EXT)
LLIBAGENT=$(LDLIBFLAG)$(LIBAGENTNAME)

LIBDBTOOLSNAME=dbtools$(RDBMS_VERSION)
LIBDBTOOLS=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDBTOOLSNAME).$(LIB_EXT)
LLIBDBTOOLS=$(LDLIBFLAG)$(LIBDBTOOLSNAME)

LIBWTCNAME=wtc$(RDBMS_VERSION)
LIBWTC=$(RDBMSLIB)$(LIB_PREFIX)$(LIBWTCNAME).$(LIB_EXT)
LLIBWTC=$(LDLIBFLAG)$(LIBWTCNAME)

DLMHOME=$(ORACLE_HOME)/odlm/

SKGXNS=$(RDBMSLIB)skgxns.$(OBJ_EXT)
SKGXND=$(RDBMSLIB)skgxnd.$(OBJ_EXT)
SKGXN=$(RDBMSLIB)skgxn.$(OBJ_EXT)

LIBDLMNAME=udlm
LIBDLM=$(SKGXN) $(LIBHOME)$(LIB_PREFIX)$(LIBDLMNAME).$(LIB_EXT)
LLIBDLM=$(SKGXN) $(LDLIBFLAG)$(LIBDLMNAME)

LIBNM=$(LIBDLM)
LLIBNM=$(LLIBDLM)
NMLIBLIST=$(RDBMSLIB)nmliblist
NMLIBS=`$(CAT) $(NMLIBLIST) | $(SED) "s%ORACLE_HOME%\$$SRCHOME%"`

LIBMMNAME=mm
LIBMM=$(LIBHOME)$(LIB_PREFIX)$(LIBMMNAME).$(LIB_EXT)
LLIBMM=$(LDLIBFLAG)$(LIBMMNAME)


LIBRDBMS_CLT=$(LIBCLIENT) $(LIBSKGXP_CLT) $(LIBVSN) $(LIBWTC) $(LIBCOMMON) $(LIBGENERIC)
LLIBRDBMS_CLT=$(LLIBCLIENT) $(LLIBSKGXP_CLT) $(LLIBVSN) $(LLIBWTC) $(LLIBCOMMON)\
	$(LLIBGENERIC)

LIBCLNTSHNAME=clntsh
LIBCLNTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBCLNTSHNAME).$(SO_EXT)
LLIBCLNTSH=$(LDLIBFLAG)$(LIBCLNTSHNAME)

LIBAGTSHNAME=agtsh
LIBAGTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBAGTSHNAME).$(SO_EXT)
LLIBAGTSH=$(LDLIBFLAG)$(LIBAGTSHNAME)

LIBSHWTC=$(RDBMSLIB)$(LIB_PREFIX)$(LIBWTCNAME).$(SO_EXT)
LLIBSHWTC=$(LDLIBFLAG)$(LIBWTCNAME)

LIBKNLOPTNAME=knlopt
LIBKNLOPT=$(RDBMSLIB)$(LIB_PREFIX)$(LIBKNLOPTNAME).$(LIB_EXT)
LLIBKNLOPT=$(LDLIBFLAG)$(LIBKNLOPTNAME)

CONFIG = $(RDBMSLIB)config.$(OBJ_EXT)

HSALLMAI = $(RDBMSLIB)horm.$(OBJ_EXT)			# hs all modules main
HSSQLMAI = $(RDBMSLIB)horms.$(OBJ_EXT)			# hs SQL main
HSDEPMAI = $(RDBMSLIB)hormd.$(OBJ_EXT)			# hs DEP main
HSOTSMAI = $(RDBMSLIB)hormt.$(OBJ_EXT)			# hs OTS main
HSAGTSHC = $(RDBMSLIB)homts.$(OBJ_EXT)                  # multi-threaded agent 
                                                        # shutdown callback



LLIBORDSDO=$(LDLIBFLAG)$(LIBORDSDONAME)$(LIB_SUFFIX)
SDOLIBS = `if ${AR} tv ${ORACLE_HOME}/rdbms/lib/$(LIB_PREFIX)$(LIBKNLOPTNAME).$(LIB_EXT) | $(GREP) "kxmnsd.o" > /dev/null 2>&1 ; then echo " " ; else echo "${LLIBORDSDO}"; fi`

DEF_ON= $(RDBMSLIB)kpudfo.$(OBJ_EXT)
DEF_OFF= $(RDBMSLIB)kpundf.$(OBJ_EXT)
DEF_OPT= $(RDBMSLIB)defopt.$(OBJ_EXT)

LIBSVRMGRLNAME=svrmgrl
LIBSLPMNAME=slpm
LIBSVRM= $(LIBHOME)smalmain.$(OBJ_EXT) $(LIBHOME)$(LIB_PREFIX)$(LIBSVRMGRLNAME).$(LIB_EXT) $(LIBHOME)$(LIB_PREFIX)$(LIBSLPMNAME).$(LIB_EXT)
LLIBSVRM= $(LIBHOME)smalmain.$(OBJ_EXT) $(LDLIBFLAG)$(LIBSVRMGRLNAME) $(LDLIBFLAG)$(LIBSLPMNAME)

RDBMSHOME=$(ORACLE_HOME)/rdbms/
RDBMSLIB=$(RDBMSHOME)lib/
RDBMSADMIN=$(RDBMSHOME)admin/

# Entering /vobs/oracle/rdbms/s_exports.mk


SKGXP_EXT=$(SO_EXT)



# Exiting /vobs/oracle/rdbms/s_exports.mk
# Exiting /vobs/oracle/rdbms/exports.mk
# Entering /vobs/oracle/otrace/exports.mk

LIBTRACENAME=trace8
LIBTRACE=$(LIBHOME)$(LIB_PREFIX)$(LIBTRACENAME).$(LIB_EXT)
LLIBTRACE=$(LDLIBFLAG)$(LIBTRACENAME)$(LIB_SUFFIX)
LIBEPC=$(LIBHOME)$(LIB_PREFIX)$(LIBTRACENAME).$(LIB_EXT)
LLIBEPC=$(LDLIBFLAG)$(LIBTRACENAME)$(LIB_SUFFIX)

LIBTRACEPTNAME=tracept8
LIBTRACEPT=$(LIBHOME)$(LIB_PREFIX)$(LIBTRACEPTNAME).$(LIB_EXT)
LLIBTRACEPT=$(LDLIBFLAG)$(LIBTRACEPTNAME)$(LIB_SUFFIX)
LIBEPCPT=$(LIBHOME)$(LIB_PREFIX)$(LIBTRACEPTNAME).$(LIB_EXT)
LLIBEPCPT=$(LDLIBFLAG)$(LIBTRACEPTNAME)$(LIB_SUFFIX)

LIBTRACEFENAME=tracefe8
LIBTRACEFE=$(LIBHOME)$(LIB_PREFIX)$(LIBTRACEFENAME).$(LIB_EXT)
LLIBTRACEFE=$(LDLIBFLAG)$(LIBTRACEFENAME)$(LIB_SUFFIX)
LIBEPCFE=$(LIBHOME)$(LIB_PREFIX)$(LIBTRACEFENAME).$(LIB_EXT)
LLIBEPCFE=$(LDLIBFLAG)$(LIBTRACEFENAME)$(LIB_SUFFIX)

# Entering /vobs/oracle/otrace/s_exports.mk

# Exiting /vobs/oracle/otrace/s_exports.mk
# Exiting /vobs/oracle/otrace/exports.mk
# Entering /vobs/oracle/plsql/exports.mk

VERSION=8

WRAP=$(BINHOME)wrap

LIBPLSNAME=pls
LIBPLSN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(VERSION).$(LIB_EXT)
LLIBPLS=$(LDLIBFLAG)$(LIBPLSNAME)$(VERSION) 
LIBPLSNSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLSNAME).$(SO_EXT)
ILIBPLSN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLSNAME).$(ILIB_EXT)
LIBPLPNAME=plp
LIBPLPN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLPNAME)$(VERSION).$(LIB_EXT)
LLIBPLP=$(LDLIBFLAG)$(LIBPLPNAME)$(VERSION)
LIBPLPNSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLPNAME).$(SO_EXT)
ILIBPLPN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLPNAME).$(ILIB_EXT)
LIBPLCNAME=plc
LIBPLCN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLCNAME)$(VERSION).$(LIB_EXT)
LLIBPLC=$(LDLIBFLAG)$(LIBPLCNAME)$(VERSION)
LIBPLCSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLCNAME).$(SO_EXT)
ILIBPLCN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLCNAME).$(ILIB_EXT)

LIBEXTP=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(VERSION).$(LIB_EXT)
LLIBEXTP=$(LDLIBFLAG)$(LIBPLSNAME)$(VERSION)

LIBPLSF=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(VERSION).$(LIB_EXT) 
LLIBPLSF=$(LDLIBFLAG)$(LIBPLSNAME)$(VERSION) $(LDLIBFLAG)$(LIBPLPNAME)$(VERSION)

LIBPLSB=$(LIBHOME)$(LIBPLSNAME)$(VERSION)
LLIBPLSB=$(LDLIBFLAG)$(LIBPLSNAME)$(VERSION)

PLSQLLIBS=$(LIBPLSN) $(LIBPLPN)
LPLSQLLIBS=$(LLIBPLS)


LLIBPLSQL= $(LPLSQLLIBS) $(LLIBPLP)

LIBPSANAME=psa
LIBICD=$(LIBHOME)$(LIB_PREFIX)$(LIBPLPNAME)$(VERSION).$(LIB_EXT)
LLIBICD=$(LDLIBFLAG)$(LIBPLPNAME)$(VERSION)
LIBPSD=$(LIBHOME)$(LIB_PREFIX)$(LIBPLCNAME)$(VERSION).$(LIB_EXT)
LLIBPSD=$(LDLIBFLAG)$(LIBPLCNAME)$(VERSION)
LIBPSA=$(LIBHOME)$(LIB_PREFIX)$(LIBPSANAME)$(VERSION).$(LIB_EXT)
LLIBPSA=$(LDLIBFLAG)$(LIBPSANAME)$(VERSION)

PLSQLHOME=$(ORACLE_HOME)/plsql/

# Entering /vobs/oracle/plsql/s_exports.mk
 
# Exiting /vobs/oracle/plsql/s_exports.mk
# Exiting /vobs/oracle/plsql/exports.mk
# Entering /vobs/oracle/slax/exports.mk
TOP = $(ORACLE_HOME)/slax

LIBSLAXNAME=slax8
LLIBSLAX=$(LDLIBFLAG)$(LIBSLAXNAME)$(LIB_SUFFIX)
LIBSLAX=$(LIBHOME)$(LIB_PREFIX)$(LIBSLAXNAME).$(LIB_EXT)

SLAX_PRD=slax
SLAXHOME=$(ORACLE_HOME)/slax/
SLAXADMIN=$(SLAXHOME)admin/
SLAXLIB=$(SLAXHOME)lib/
 
SLAXPUBH=$(I_SYM)$(SLAXHOME)include
 
# Entering /vobs/oracle/slax/s_exports.mk
 
# Exiting /vobs/oracle/slax/s_exports.mk
# Exiting /vobs/oracle/slax/exports.mk
 
# Entering /vobs/oracle/precomp/exports.mk
TOP=$(ORACLE_HOME)/precomp

LIBSQLNAME=sql8
LLIBSQL=$(LDLIBFLAG)$(LIBSQLNAME)$(LIB_SUFFIX)
LIBSQL=$(LIBHOME)$(LIB_PREFIX)$(LIBSQLNAME).$(LIB_EXT)

PRECOMP_PRD=precomp
PRECOMPHOME=$(ORACLE_HOME)/precomp/
PRECOMPADMIN=$(PRECOMPHOME)admin/
PRECOMPLIB=$(PRECOMPHOME)lib/
 
PRECOMPPUBH=$(I_SYM)$(PRECOMPHOME)public $(I_SYM)$(PRECOMPHOME)include
 
# Entering /vobs/oracle/precomp/s_exports.mk
 
# Exiting /vobs/oracle/precomp/s_exports.mk
# Exiting /vobs/oracle/precomp/exports.mk

PRODUCT=precomp

PRODHOME=$(PRECOMPHOME)

I_SYM=-I

PRECOMPADALIB=$(PRECOMPHOME)pubsrc/adalib/
PRECOMPBIN=$(PRECOMPHOME)bin/
PRECOMPDEMO=$(PRECOMPHOME)demo/
PRECOMPINCLUDE=$(PRECOMPHOME)include/
PRECOMPINSTALL=$(PRECOMPHOME)install/
PRECOMPMESG=$(PRECOMPHOME)mesg/
PRECOMPSRC=$(PRECOMPHOME)src/
PRECOMPUTL=$(PRECOMPHOME)utl/

PRODLIBHOME=$(PRECOMPLIB)


LIBFIDLNAME=fidl
LIBMODNAME=mod
LIBOTTNAME=ots2c
LIBPCNAME=pc
LIBPCCNAME=pcc
LIBPCDNAME=pcd
LIBPCONAME=pco
LIBPDCNAME=pdc
LIBPFONAME=pfo
LIBPGPNAME=pgp
LIBPPLNAME=ppl
LIBPROC2NAME=proc2
LIBPROCOB2NAME=procob2
LIBSQXNAME=sqx8

LIBFIDL=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBFIDLNAME).$(LIB_EXT)
LIBMOD=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBMODNAME).$(LIB_EXT)
LIBOTT=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBOTTNAME).$(LIB_EXT)
LIBPC=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPCNAME).$(LIB_EXT)
LIBPCC=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPCCNAME).$(LIB_EXT)
LIBPCD=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPCDNAME).$(LIB_EXT)
LIBPCO=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPCONAME).$(LIB_EXT)
LIBPDC=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPDCNAME).$(LIB_EXT)
LIBPFO=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPFONAME).$(LIB_EXT)
LIBPGP=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPGPNAME).$(LIB_EXT)
LIBPPL=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPPLNAME).$(LIB_EXT)
LIBPROC2=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPROC2NAME).$(LIB_EXT)
LIBPROCOB2=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPROCOB2NAME).$(LIB_EXT)
LIBSQX=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBSQXNAME).$(LIB_EXT)

LOC_LIBSQL=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBSQLNAME).$(LIB_EXT)

PRECOMP_LIBS=$(LIBFIDL) $(LIBMOD) $(LIBOTT) $(LIBPC) $(LIBPCC) $(LIBPCD) \
             $(LIBPCO) $(LIBPDC) $(LIBPFO) $(LIBPGP) $(LIBPPL) $(LIBPROC2) \
             $(LIBPROCOB2) $(LOC_LIBSQL)
 
FIDLOBJS=ilmain.$(OBJ_EXT)
MODOBJS=
OTTOBJS=o2m.$(OBJ_EXT) so2ed.$(OBJ_EXT) so2pt.$(OBJ_EXT)
PC0DRV=pc0drv.$(OBJ_EXT)
PC1DRV=pc1drv.$(OBJ_EXT)
PC2DRV=pc2drv.$(OBJ_EXT)
PC3DRV=pc3drv.$(OBJ_EXT)
PMSAPR=pmsapr.$(OBJ_EXT)
PMSCPR=pmscpr.$(OBJ_EXT)
PROC2OBJS=main.$(OBJ_EXT) sspced.$(OBJ_EXT) spcpt.$(OBJ_EXT) pcprnt.$(OBJ_EXT)
PROCOB2OBJS=pcbd.$(OBJ_EXT) pcbrnt.$(OBJ_EXT)

CMAIN=$(PRECOMPLIB)$(PC2DRV)
COBMAIN=$(PRECOMPLIB)$(PC0DRV)
COB2MAIN=$(PRECOMPLIB)pcbd.$(OBJ_EXT) $(PRECOMPLIB)pcbrnt.$(OBJ_EXT)
FIDLMAIN=$(PRECOMPLIB)$(FIDLOBJS)
FORMAIN=$(PRECOMPLIB)$(PC1DRV)
MAINOBJS=$(PRECOMPLIB)main.$(OBJ_EXT) $(PRECOMPLIB)sspced.$(OBJ_EXT) \
	$(PRECOMPLIB)spcpt.$(OBJ_EXT) $(PRECOMPLIB)pcprnt.$(OBJ_EXT)
MODADAMAIN=$(PRECOMPLIB)$(PMSAPR)
MODCMAIN=$(PRECOMPLIB)$(PMSCPR)
O2MAIN=$(PRECOMPLIB)o2m.$(OBJ_EXT) $(PRECOMPLIB)so2ed.$(OBJ_EXT) \
		$(PRECOMPLIB)so2pt.$(OBJ_EXT)
PLIMAIN=$(PRECOMPLIB)$(PC3DRV)
 
PD1OBJ=pd1.$(OBJ_EXT)
PDAOBJ=pda.$(OBJ_EXT)
PDBOBJ=pdb.$(OBJ_EXT)
PDCOBJ=pdc.$(OBJ_EXT)
PDFOBJ=pdf.$(OBJ_EXT)
PDPOBJ=pdp.$(OBJ_EXT)
PDSOBJ=pds.$(OBJ_EXT)
CODEGENOBJS=$(PD1OBJ) $(PDAOBJ) $(PDCOBJ) $(PDBOBJ) $(PDFOBJ) $(PDPOBJ) \
	    $(PDSOBJ)

ADAPDC=$(PRECOMPLIB)$(PDAOBJ) $(PRECOMPLIB)$(PDSOBJ)
CPDC=$(PRECOMPLIB)$(PDCOBJ) $(PRECOMPLIB)$(PDSOBJ)
COBPDC=$(PRECOMPLIB)$(PDBOBJ) $(PRECOMPLIB)$(PDSOBJ)
FORPDC=$(PRECOMPLIB)$(PDFOBJ) $(PRECOMPLIB)$(PDSOBJ)
PASPDC=$(PRECOMPLIB)$(PDPOBJ) $(PRECOMPLIB)$(PDSOBJ)
PLIPDC=$(PRECOMPLIB)$(PD1OBJ) $(PRECOMPLIB)$(PDSOBJ)

PRECOMP_OBJFILES= $(ADAPDC) $(CPDC) $(COBPDC) $(FORPDC) $(PASPDC) $(PLIPDC) \
		  $(PRECOMPLIB)$(PDSOBJ) \
		  $(CMAIN) $(COBMAIN) $(COB2MAIN) $(FIDLMAIN) $(FORMAIN) \
		  $(MAINOBJS) $(MODCMAIN) $(MODADAMAIN) $(O2MAIN)

PRECOMPH=$(I_SYM)$(PRECOMPHOME)hdrs
PRECOMPSH=$(PRECOMPH) $(PRECOMPPUBH)

INCLUDE=$(PRECOMPSH) $(PLSQLPUBH) $(RDBMSPUBH) $(ORACOREPUBH) $(NLSRTLPUBH) \
	$(OTRACEPUBH) $(NETWORKPUBH) $(SLAXPUBH) $(OTHER_H) $(I_SYM).


XAONDY=$(RDBMSLIB)xaondy.$(OBJ_EXT)

STATICPROLDLIBS=$(LLIBCLIENT) $(LIBSQL) $(SCOREPT) $(SSCOREED) $(DEF_ON) $(STATICTTLIBS) $(NAETTOBJS) $(LLIBTHREAD) $(XAONDY)
DYNAMICPROLDLIBS=$(LLIBCLNTSH) $(LDLIBS) $(LLIBTHREAD)
PROLDLIBS=$(DYNAMICPROLDLIBS)

STATICCPPLDLIBS=$(SCOREPT) $(SSCOREED) $(DEF_ON) $(LLIBCLIENT) $(LLIBSQL) $(STATICTTLIBS)
DYNAMICCPPLDLIBS=$(LLIBCLNTSH) $(LDLIBS)
CPPLDLIBS=$(DYNAMICCPPLDLIBS)

LIBPLS_CLT=$(LPLSQLLIBS)


MODADA=modada$(EXE_SUFFIX)
OTT=ott$(EXE_SUFFIX)
PROC=proc$(EXE_SUFFIX)
PROCOB=procob$(EXE_SUFFIX)
PROCOB18=procob18$(EXE_SUFFIX)
PROFOR=profor$(EXE_SUFFIX)
PROPLI=propli$(EXE_SUFFIX)
RTSORA=rtsora$(EXE_SUFFIX)

LOC_MODADA=$(PRECOMPBIN)modada$(EXE_SUFFIX)
LOC_OTT=$(PRECOMPBIN)ott$(EXE_SUFFIX)
LOC_PROC=$(PRECOMPBIN)proc$(EXE_SUFFIX)
LOC_PROCOB=$(PRECOMPBIN)procob$(EXE_SUFFIX)
LOC_PROCOB18=$(PRECOMPBIN)procob18$(EXE_SUFFIX)
LOC_PROFOR=$(PRECOMPBIN)profor$(EXE_SUFFIX)
LOC_PROPLI=$(PRECOMPBIN)propli$(EXE_SUFFIX)
LOC_RTSORA=$(PRECOMPBIN)rtsora$(EXE_SUFFIX)

MODADA_LINKLINE=$(LINK) $(MODADAMAIN) $(MODOBJS) $(LIBMOD) \
		$(ADAPDC) $(LIBSLAX)  $(LIBPGP) $(LIBOTT) $(LLIBPLSQL) \
		$(DEF_ON) $(SSCOREED) $(LINKTTLIBS)

OTT_LINKLINE=$(LINK) $(S0MAIN) $(O2MAIN) $(LIBOTT) \
		     $(LIBPGP) $(DEF_ON) $(LLIBPLSQL) $(LINKTTLIBS)

PROC_LINKLINE=$(LINK) $(S0MAIN) $(MAINOBJS) $(CPDC) $(LIBPROC2) $(LIBSLAX) \
	      $(LIBPGP) $(LIBOTT) $(LLIBPLSQL) $(DEF_ON) $(LINKTTLIBS)

PROCOB_LINKLINE=$(LINK) $(COB2MAIN) $(LIBPROCOB2) $(LIBSLAX) $(COBPDC) \
	        $(LIBPGP) $(DEF_ON) $(LLIBPLSQL) $(LIBPROCOB2) $(LLIBPLSQL) \
	        $(SSCOREED) $(LINKTTLIBS)

PROCOB18_LINKLINE=$(LINK) $(COBMAIN) $(COBPDC) \
		  $(LIBPCO) $(LIBPCC)  $(LIBPGP) $(LLIBPLSQL) $(LIBSLAX) \
	  	  $(LIBPCD) $(LLIBPLSQL) $(LIBPCD) $(DEF_ON) $(SSCOREED) \
	      $(LINKTTLIBS)

PROFOR_LINKLINE=$(LINK) $(FORMAIN) $(FORPDC) $(LIBPFO) \
		$(LIBPCC) $(LIBPGP) $(LLIBPLSQL) $(LIBPCD) $(LIBSLAX) \
		$(LLIBPLSQL) $(LIBPCD) $(DEF_ON) $(SSCOREED) $(LINKTTLIBS)

PROPLI_LINKLINE=$(LINK) $(PLIMAIN) $(PLIPDC) $(LIBPPL) $(LIBPCC) \
		$(LIBPGP) $(LLIBPLSQL) $(LIBSLAX) $(LIBPCD) $(LLIBPLSQL) \
		$(LIBPCD) $(DEF_ON) $(SSCOREED) $(LINKTTLIBS)

RTSORA_LINKLINE=$(COB) -o $(LOC_RTSORA) -t -xe "" $(RTSPORTFLAGS) $(COBSQLINTF) \
		$(SCOREPT) $(SSCOREED) $(DEF_ON) -L $(LIBHOME) $(LLIBCLNTSH)

EXE_PROT=755

# Entering /vobs/oracle/precomp/s_precomp.mk
 
LLAIO=-laio
LLIBTHREAD=-lthread

CCFLAGS= $(NOKPIC_CCFLAGS) -K PIC -DPRECOMP

SYS_INCLUDE='sys_include=(/usr/include)'

CPLUSPLUS=CC -mt
CPLUS_SYS_INCLUDE='sys_include=(/opt/SUNWspro4.2/SUNWspro/SC4.2/include/CC,/usr/include)'
CPLUS_INCLUDE= $(I_SYM)$(PRECOMPDEMO)proc $(INCLUDE)
CPLUS_CFLAGS=$(OPTIMIZE) $(INCLUDE) -DSLTS_ENABLE -D_REENTRANT

ADAPORT=verdix
ADACC=ada -e
ADALD=a.ld
ADACLEAN= a.rmlib -f

COB=cob
COBFLAGS=-C IBMCOMP -C NESTCALL -t -x
COBGNTFLAGS=-C IBMCOMP -C NESTCALL -C REENTRANT -t -u
GNT=.gnt
COBSQLINTF=$(PRECOMPLIB)cobsqlintf.o
SHAREDLIBPATH = -R $(ORACLE_HOME)/lib


FC=/opt/SUNWspro4.2/SUNWspro/bin/f77
FCFLAGS=

PL1=lpipl1
PL1LD=ldpl1
PL1FLAGS=-lowercase

# Exiting /vobs/oracle/precomp/s_precomp.mk
# Exiting precomp.mk
# Entering /vobs/oracle/buildtools/mkfile/libclntsh.mk
$(LIBCLNTSH):	${ORACLE_HOME}/lib/libclient8.a	${ORACLE_HOME}/lib/libsql8.a \
		${ORACLE_HOME}/lib/libntcp8.a	${ORACLE_HOME}/lib/libn8.a \
                ${ORACLE_HOME}/lib/libnl8.a	${ORACLE_HOME}/lib/libnldap8.a \
                ${ORACLE_HOME}/lib/libnhost8.a	${ORACLE_HOME}/lib/libntns8.a \
                ${ORACLE_HOME}/lib/libnoname8.a	${ORACLE_HOME}/lib/libnus8.a \
                ${ORACLE_HOME}/lib/libntcps8.a  ${ORACLE_HOME}/lib/libnro8.a \
	        ${ORACLE_HOME}/lib/libnsslb8.a	${ORACLE_HOME}/lib/libcommon8.a\
	        ${ORACLE_HOME}/lib/libgeneric8.a ${ORACLE_HOME}/lib/libmm.a\
	        ${ORACLE_HOME}/lib/libnls8.a	${ORACLE_HOME}/lib/libcore8.a\
		${ORACLE_HOME}/lib/libtrace8.a  ${ORACLE_HOME}/lib/libwtc8.so\
		${ORACLE_HOME}/rdbms/lib/xaondy.o
	$(SILENT)$(ECHO) "Building client shared library libclntsh.so ..."
	$(SILENT)$(ECHO) "Call script $$ORACLE_HOME/bin/genclntsh ..."
	$(GENCLNTSH)
	$(SILENT)$(ECHO) "Built $$ORACLE_HOME/lib/libclntsh.so ... DONE"

# Exiting /vobs/oracle/buildtools/mkfile/libclntsh.mk
