#!/bin/sh 
# 
#  @(#)hd-server.sh	1.38 01/04/10
#
#  Copyright (c) 04/10/01 Sun Microsystems, Inc.  All Rights Reserved
#
#  @version 1.38 01/04/10 11:25:40
#
#


##jdk/jre
# All the L10N variables will be exported from start-diag
set -k
unset TEST
TEST=thisTest

# Let's see if an other server runs. If yes exit
PWD=`/bin/pwd`

thisIsme=`/usr/ucb/whoami`
if [ "root" != $thisIsme ] ; then
	# sunmc reason
	/bin/gettext "Hardware Diagnostic Suite can be started only by root"
	echo ""
	exit 1
fi

#-A- Let's see if /var/opt/SUNWhwdiag/logs/hwdserver.pid exists 
#    and if the pid is the pid of a runing process

if [ -f "/var/opt/SUNWhwdiag/logs/hwdserver.pid" ]; then
	EDS_PID=`cat /var/opt/SUNWhwdiag/logs/hwdserver.pid`
	if [ ! ${TEST} = ${TEST}${EDS_PID} ] ; then
		EDS_PID_A=`/bin/ps -efo pid | /bin/grep ${EDS_PID}`
		if [ ! ${TEST} = ${TEST}${EDS_PID_A} ] ; then
			## server already runs. exit.
			/bin/gettext "Hardware Diagnostic Suite Server is already running."
			echo ""
			exit 0;
		else
			# the pid in /var/opt/SUNWhwdiag/logs/hwdserver.pid is useless
			/bin/rm -f /var/opt/SUNWhwdiag/logs/hwdserver.pid
		fi
 	fi
fi

#-B-HWDS Server is not running or /var/opt/SUNWhwdiag/logs/hwdserver.pid 
#	  is not present. Need to double check.
#     Figure out if HWDS Server is running and 
#     /var/opt/SUNWhwdiag/logs/hwdserver is not present
EDS_PID=`/bin/ps -ef | /bin/fgrep jre | /bin/fgrep "DHWDS" | /bin/fgrep -v fgrep | /bin/awk '{ print $2 }'`

if [ ! ${TEST} = ${TEST}${EDS_PID} ] ; then
	## server already runs. 
	## Update the /var/opt/SUNWhwdiag/logs/hwdserver.pid & exit.
	/bin/echo ${EDS_PID} > /var/opt/SUNWhwdiag/logs/hwdserver.pid
	/bin/gettext "Hardware Diagnostic Suite Server is already running."
	echo ""
	exit 0;
fi

unset JAVA_HOME
PATH=""
unset LD_LIBRARY_PATH
unset CLASSPATH
unset JAVA_COMPILER
unset THREADS_FLAG
LANGHWD2=$LANG
JAVA_HOME=/usr/java1.2

/bin/gettext  "Hardware Diagnostic Suite Server Start Procedure"
echo ""
SCRIPT_DIR=`/bin/dirname $0`
DEV_CLASSES=${SCRIPT_DIR}/../../classes
PRO_CLASSES=${SCRIPT_DIR}/../../../../apps/classes
if [ -d "${DEV_CLASSES}" ]; then
    # Working in developement environment
    CLASSES_DIR=${DEV_CLASSES}
    cd ${CLASSES_DIR}
elif [ -d "${PRO_CLASSES}" ]; then
    # Working in production environment
    CLASSES_DIR=${PRO_CLASSES}
else
    echo "ERROR: can not find HWDS classes directory. "
    echo ""
    exit 1
fi

OS_V=`/usr/bin/uname -r | /usr/bin/sed -e 1,1s/5/2/`

whereIsSunMC=`/usr/bin/pkginfo -r SUNWessmn`
if [ ${TEST}${whereIsSunMC} = ${TEST} ]; then
	/bin/gettext  "Hardware Diagnostic Suite Server can not find where
	SunMC Advanced Server Monitoring SUNWessmn is installed. Exit"
	echo ""
	exit 1	# ERROR

elif [ -d ${whereIsSunMC} ]; then
	SunMC_CLASSES=${whereIsSunMC}/SUNWsymon/classes
else
	/bin/gettext  "Hardware Diagnostic Suite Server can not find where
	SunMC Advanced Server Monitoring SUNWessmn is installed. Exit"
	echo ""
	exit 2	# ERROR
fi

###SunMC_CLASSES=${CLASSES_DIR}/../../classes

PATH=${JAVA_HOME}/bin:/bin:/etc:$PATH

LD_LIBRARY_PATH=${SunMC_CLASSES}/../base/lib/sparc-sun-solaris${OS_V}:${SunMC_CLASSES}/../util/lib/sparc-sun-solaris${OS_V}:${JAVA_HOME}/lib

INTERFACE_PATH=/var/opt/SUNWsymon/cfg:/var/opt/SUNWsymon/classes:${SunMC_CLASSES}/base/server/cfg:${SunMC_CLASSES}
export INTERFACE_PATH

CLASSPATH1=${JAVA_HOME}/lib/classes.zip:${CLASSES_DIR}:${CLASSES_DIR}/hdsrv.jar
CLASSPATH2=${SunMC_CLASSES}/essrv.jar:${SunMC_CLASSES}/esjrm.jar
CLASSPATH3=${SunMC_CLASSES}/essfx.jar:${SunMC_CLASSES}/escom.jar:${SunMC_CLASSES}/esclt.jar:${SunMC_CLASSES}/escom.jar
CLASSPATH4=${SunMC_CLASSES}/escon.jar:${SunMC_CLASSES}/esmigrate.jar:${SunMC_CLASSES}/esmsg.jar
CLASSPATH=${CLASSPATH1}:${CLASSPATH2}:${CLASSPATH3}:${CLASSPATH4}

JAVA_COMPILER=NONE
export JAVA_COMPILER 
export PATH
export CLASSPATH
export LD_LIBRARY_PATH

THREADS_FLAG=native
export THREADS_FLAG
/bin/rm -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log

if [ ! -f $BASE_PATH/lib/server/hdserversec.policy ]; then
	echo "grant { permission java.security.AllPermission;};" > $BASE_PATH/lib/server/hdserversec.policy
fi

unset LANG
reply=`java  -DHWDS -Djava.compiler=NONE -Djava.security.policy=$BASE_PATH/lib/server/hdserversec.policy -DINTERFACE_PATH=${INTERFACE_PATH} -classpath ${CLASSPATH}  com.sun.entdiag.server.EDServerRMIServer > /tmp/edserver1099   & `

sleep 5
/usr/bin/chmod 666 /tmp/edserver1099

## fix bugid 4350403
LANG=$LANGHWD2
export LANG

if [ ! -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log ]; then
	sleep 10
	if [ ! -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log ]; then
		sleep 15
	fi
	if [ ! -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log ]; then
		echo "*********************************"
		/bin/gettext  "ERROR in Hardware Diagnostic Suite Server start procedure"
		echo ""
		echo "*********************************"
		exit 1
	fi
fi


/bin/chmod -f 666 /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log
set muErr=
muErr=`/bin/grep ERROR /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log | /bin/awk '{ print $1 }'`
if [ $muErr ] ; then
	echo "*********************************"
	/bin/gettext  "ERROR in Hardware Diagnostic Suite Server start procedure"
	echo ""
	echo "*********************************"
	/bin/cat /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log 
	/bin/gettext  "EXIT"
	echo ""
	$BASE_PATH/sbin/ed-stop > /dev/null
	exit 1
else
	## Store the ED Server pid in /var/opt/SUNWhwdiag/logs/hwdserver.pid
	/bin/rm -f /var/opt/SUNWhwdiag/logs/hwdserver.pid
	EDS_PID2=`/usr/ucb/ps -gww | /bin/fgrep EDServ | /bin/fgrep -v fgrep | /bin/awk '{ print $1 }'`
	# Work around for the case when EDS_PID2 is null at boot time.
	EDS_PID3=`/usr/bin/ps -ef | /bin/fgrep "AdvancedMonitoring/classes/./jre2/bin" | /bin/fgrep -v fgrep | /bin/awk '{ print $2 }'`
	if [ ${EDS_PID2} ]; then
		/bin/echo ${EDS_PID2} > /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/chmod 666 /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/gettext  "Hardware Diagnostic Suite Server started OK"
	elif [ ${EDS_PID3} ]; then
		/bin/echo ${EDS_PID3} > /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/chmod 666 /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/gettext  "Hardware Diagnostic Suite Server started OK"
	else
		/bin/gettext  "ERROR in Hardware Diagnostic Suite Server start procedure"
	fi
	echo ""
	exit 0
fi

